/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es2;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLBufferStorage;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.test.junit.jogl.demos.GearsObject;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.nio.FloatBuffer;

public class GearsObjectES2
extends GearsObject {
    final PMVMatrix pmvMatrix;
    final GLUniformData pmvMatrixUniform;
    final GLUniformData colorUniform;
    final ShaderState st;

    public GearsObjectES2(GL gL, boolean bl, ShaderState shaderState, FloatBuffer floatBuffer, float f, float f2, float f3, int n, float f4, PMVMatrix pMVMatrix, GLUniformData gLUniformData, GLUniformData gLUniformData2, boolean bl2) {
        super(gL, bl, floatBuffer, f, f2, f3, n, f4, bl2);
        this.pmvMatrix = pMVMatrix;
        this.pmvMatrixUniform = gLUniformData;
        this.colorUniform = gLUniformData2;
        this.st = shaderState;
        this.associate(shaderState);
    }

    public GearsObjectES2(GearsObjectES2 gearsObjectES2, ShaderState shaderState, PMVMatrix pMVMatrix, GLUniformData gLUniformData, GLUniformData gLUniformData2) {
        super(gearsObjectES2);
        this.pmvMatrix = pMVMatrix;
        this.pmvMatrixUniform = gLUniformData;
        this.colorUniform = gLUniformData2;
        this.st = shaderState;
        this.associate(shaderState);
    }

    private void associate(ShaderState shaderState) {
        this.frontFace.associate(shaderState, true);
        this.frontSide.associate(shaderState, true);
        this.backFace.associate(shaderState, true);
        this.backSide.associate(shaderState, true);
        this.outwardFace.associate(shaderState, true);
        this.insideRadiusCyl.associate(shaderState, true);
    }

    @Override
    public GLArrayDataServer createInterleaved(boolean bl, int n, int n2, boolean bl2, int n3, int n4) {
        if (bl) {
            return GLArrayDataServer.createGLSLInterleavedMapped(n, n2, bl2, n3, n4);
        }
        return GLArrayDataServer.createGLSLInterleaved(n, n2, bl2, n3, n4);
    }

    @Override
    public void addInterleavedVertexAndNormalArrays(GLArrayDataServer gLArrayDataServer, int n) {
        gLArrayDataServer.addGLSLSubArray("vertices", n, 34962);
        gLArrayDataServer.addGLSLSubArray("normals", n, 34962);
    }

    private void draw(GL2ES2 gL2ES2, GLArrayDataServer gLArrayDataServer, int n, int n2) {
        if (!this.isShared || gL2ES2.glIsBuffer(gLArrayDataServer.getVBOName())) {
            if (this.validateBuffers) {
                boolean bl;
                gLArrayDataServer.bindBuffer(gL2ES2, true);
                int n3 = gLArrayDataServer.getVBOTarget();
                int n4 = gLArrayDataServer.getVBOName();
                long l = gLArrayDataServer.getSizeInBytes();
                int n5 = gL2ES2.getBoundBuffer(n3);
                GLBufferStorage gLBufferStorage = gL2ES2.getBufferStorage(n5);
                boolean bl2 = bl = n4 == n5 && n4 == gLBufferStorage.getName() && l == gLBufferStorage.getSize();
                if (!bl) {
                    throw new GLException("GLBufferStorage Validation Error: Target[exp 0x" + Integer.toHexString(n3) + ", has 0x" + Integer.toHexString(n3) + ", Name[exp " + n4 + ", has " + n5 + ", Size exp " + l + ", Storage " + gLBufferStorage + "]");
                }
            }
            gLArrayDataServer.enableBuffer(gL2ES2, true);
            gL2ES2.glDrawArrays(n, 0, gLArrayDataServer.getElementCount());
            gLArrayDataServer.enableBuffer(gL2ES2, false);
        }
    }

    @Override
    public void draw(GL gL, float f, float f2, float f3) {
        GL2ES2 gL2ES2 = gL.getGL2ES2();
        this.pmvMatrix.glPushMatrix();
        this.pmvMatrix.glTranslatef(f, f2, 0.0f);
        this.pmvMatrix.glRotatef(f3, 0.0f, 0.0f, 1.0f);
        if (!this.pmvMatrix.update()) {
            throw new InternalError("PMVMatrix.update() returns false after mutable operations");
        }
        this.st.uniform(gL2ES2, this.pmvMatrixUniform);
        this.colorUniform.setData(this.gearColor);
        this.st.uniform(gL2ES2, this.colorUniform);
        this.draw(gL2ES2, this.frontFace, 5, 0);
        this.draw(gL2ES2, this.frontSide, 4, 1);
        this.draw(gL2ES2, this.backFace, 5, 2);
        this.draw(gL2ES2, this.backSide, 4, 3);
        this.draw(gL2ES2, this.outwardFace, 5, 4);
        this.draw(gL2ES2, this.insideRadiusCyl, 5, 5);
        this.pmvMatrix.glPopMatrix();
    }
}

