/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es1.newt;

import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.OlympicES1;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestOlympicES1NEWT
extends UITestCase {
    static int width;
    static int height;
    static boolean forceES2;
    static boolean forceFFPEmu;
    static boolean verboseFFPEmu;
    static int swapInterval;
    static boolean exclusiveContext;
    static long duration;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
    }

    @AfterClass
    public static void releaseClass() {
    }

    protected void runTestGL(GLCapabilities gLCapabilities) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("Olympic NEWT Test");
        OlympicES1 olympicES1 = new OlympicES1(swapInterval);
        olympicES1.setForceFFPEmu(forceFFPEmu, verboseFFPEmu, false, false);
        gLWindow.addGLEventListener(olympicES1);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        Animator animator = new Animator();
        animator.setModeBits(false, 1);
        animator.setExclusiveContext(exclusiveContext);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        animator.add(gLWindow);
        animator.start();
        animator.setUpdateFPSFrames(60, System.err);
        Assert.assertTrue(animator.isStarted());
        Assert.assertTrue(animator.isAnimating());
        Assert.assertEquals(exclusiveContext ? animator.getThread() : null, gLWindow.getExclusiveContextThread());
        snapshotGLEventListener.setMakeSnapshot();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        Assert.assertEquals(exclusiveContext ? animator.getThread() : null, gLWindow.getExclusiveContextThread());
        animator.stop();
        Assert.assertFalse(animator.isAnimating());
        Assert.assertFalse(animator.isStarted());
        Assert.assertEquals(null, gLWindow.getExclusiveContextThread());
        gLWindow.destroy();
    }

    @Test
    public void test00() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES1());
        this.runTestGL(gLCapabilities);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (stringArray[i].equals("-vsync")) {
                swapInterval = MiscUtils.atoi(stringArray[++i], swapInterval);
                continue;
            }
            if (stringArray[i].equals("-exclctx")) {
                exclusiveContext = true;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-ffpemu")) {
                forceFFPEmu = true;
                continue;
            }
            if (!stringArray[i].equals("-verbose")) continue;
            verboseFFPEmu = true;
        }
        System.err.println("forceES2 " + forceES2);
        System.err.println("forceFFPEmu " + forceFFPEmu);
        System.err.println("swapInterval " + swapInterval);
        System.err.println("exclusiveContext " + exclusiveContext);
        JUnitCore.main(TestOlympicES1NEWT.class.getName());
    }

    static {
        forceES2 = false;
        forceFFPEmu = false;
        verboseFFPEmu = false;
        swapInterval = 1;
        exclusiveContext = false;
        duration = 500L;
    }
}

