/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.demos.es1;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseAdapter;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES1;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRendererQuirks;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.test.junit.jogl.demos.GearsObject;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsObjectES1;
import com.jogamp.opengl.util.glsl.fixedfunc.FixedFuncUtil;
import com.jogamp.opengl.util.glsl.fixedfunc.ShaderSelectionMode;
import java.awt.Component;
import java.nio.FloatBuffer;

public class GearsES1
implements GLEventListener {
    private boolean debugFFPEmu = false;
    private boolean verboseFFPEmu = false;
    private boolean traceFFPEmu = false;
    private boolean forceFFPEmu = false;
    private boolean debug = false;
    private boolean trace = false;
    private final float[] pos = new float[]{5.0f, 5.0f, 10.0f, 0.0f};
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private final float view_rotz = 0.0f;
    private GearsObject gear1 = null;
    private GearsObject gear2 = null;
    private GearsObject gear3 = null;
    private FloatBuffer gear1Color = GearsObject.red;
    private FloatBuffer gear2Color = GearsObject.green;
    private FloatBuffer gear3Color = GearsObject.blue;
    private GearsES1 sharedGears;
    private Object syncObjects;
    private volatile boolean usesSharedGears = false;
    private boolean useMappedBuffers = false;
    private boolean validateBuffers = false;
    private float angle = 0.0f;
    private final int swapInterval;
    private final MouseListener gearsMouse = new GearsMouseAdapter();
    private final KeyListener gearsKeys = new GearsKeyAdapter();
    private volatile boolean isInit = false;
    private int prevMouseX;
    private int prevMouseY;

    public GearsES1(int n) {
        this.swapInterval = n;
    }

    public GearsES1() {
        this.swapInterval = 1;
    }

    public void setForceFFPEmu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.forceFFPEmu = bl;
        this.verboseFFPEmu = bl2;
        this.debugFFPEmu = bl3;
        this.traceFFPEmu = bl4;
    }

    public void setGearsColors(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.gear1Color = floatBuffer;
        this.gear2Color = floatBuffer2;
        this.gear3Color = floatBuffer3;
    }

    public void setSharedGears(GearsES1 gearsES1) {
        this.sharedGears = gearsES1;
    }

    public GearsObject getGear1() {
        return this.gear1;
    }

    public GearsObject getGear2() {
        return this.gear2;
    }

    public GearsObject getGear3() {
        return this.gear3;
    }

    public boolean usesSharedGears() {
        return this.usesSharedGears;
    }

    public void setUseMappedBuffers(boolean bl) {
        this.useMappedBuffers = bl;
    }

    public void setValidateBuffers(boolean bl) {
        this.validateBuffers = bl;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        if (null != this.sharedGears && !this.sharedGears.isInit()) {
            System.err.println(Thread.currentThread() + " GearsES1.init.0: pending shared Gears .. re-init later XXXXX");
            gLAutoDrawable.setGLEventListenerInitState(this, false);
            return;
        }
        System.err.println(Thread.currentThread() + " GearsES1.init ...");
        GL gL = gLAutoDrawable.getGL();
        if (this.debugFFPEmu) {
            gL = gL.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", GL2ES2.class, gL, null));
            this.debug = false;
        }
        if (this.traceFFPEmu) {
            gL = gL.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", GL2ES2.class, gL, new Object[]{System.err}));
            this.trace = false;
        }
        GL2ES1 gL2ES1 = FixedFuncUtil.wrapFixedFuncEmul(gL, ShaderSelectionMode.AUTO, null, this.forceFFPEmu, this.verboseFFPEmu);
        if (this.debug) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", GL2ES1.class, gL2ES1, null));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.trace) {
            try {
                gL2ES1 = (GL2ES1)gL2ES1.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", GL2ES1.class, gL2ES1, new Object[]{System.err}));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.err.println("GearsES1 init on " + Thread.currentThread());
        System.err.println("Chosen GLCapabilities: " + gLAutoDrawable.getChosenGLCapabilities());
        System.err.println("INIT GL IS: " + gL2ES1.getClass().getName());
        System.err.println(JoglVersion.getGLStrings(gL2ES1, null, false).toString());
        gL2ES1.glLightfv(16384, 4611, this.pos, 0);
        gL2ES1.glEnable(2884);
        gL2ES1.glEnable(2896);
        gL2ES1.glEnable(16384);
        gL2ES1.glEnable(2929);
        if (null != this.sharedGears) {
            this.gear1 = new GearsObjectES1(this.sharedGears.getGear1());
            this.gear2 = new GearsObjectES1(this.sharedGears.getGear2());
            this.gear3 = new GearsObjectES1(this.sharedGears.getGear3());
            this.usesSharedGears = true;
            System.err.println("gear1 reuse: " + this.gear1);
            System.err.println("gear2 reuse: " + this.gear2);
            System.err.println("gear3 reuse: " + this.gear3);
            if (gL2ES1.getContext().hasRendererQuirk(20)) {
                this.syncObjects = this.sharedGears;
                System.err.println("Shared GearsES1: Synchronized Objects due to quirk " + GLRendererQuirks.toString(20));
            } else {
                this.syncObjects = new Object();
                System.err.println("Shared GearsES1: Unsynchronized Objects");
            }
        } else {
            this.gear1 = new GearsObjectES1(gL2ES1, this.useMappedBuffers, this.gear1Color, 1.0f, 4.0f, 1.0f, 20, 0.7f, this.validateBuffers);
            System.err.println("gear1 created: " + this.gear1);
            this.gear2 = new GearsObjectES1(gL2ES1, this.useMappedBuffers, this.gear2Color, 0.5f, 2.0f, 2.0f, 10, 0.7f, this.validateBuffers);
            System.err.println("gear2 created: " + this.gear2);
            this.gear3 = new GearsObjectES1(gL2ES1, this.useMappedBuffers, this.gear3Color, 1.3f, 2.0f, 0.5f, 10, 0.7f, this.validateBuffers);
            System.err.println("gear3 created: " + this.gear3);
            this.syncObjects = new Object();
        }
        gL2ES1.glEnable(2977);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            Window window = (Window)object;
            window.addMouseListener(this.gearsMouse);
            window.addKeyListener(this.gearsKeys);
        } else if (GLProfile.isAWTAvailable() && object instanceof Component) {
            Component component = (Component)object;
            new AWTMouseAdapter(this.gearsMouse, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
            new AWTKeyAdapter(this.gearsKeys, (NativeSurfaceHolder)gLAutoDrawable).addTo(component);
        }
        this.isInit = true;
        System.err.println(Thread.currentThread() + " GearsES1.init FIN");
    }

    public final boolean isInit() {
        return this.isInit;
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (!this.isInit) {
            return;
        }
        System.err.println(Thread.currentThread() + " GearsES1.reshape " + n + "/" + n2 + " " + n3 + "x" + n4 + ", swapInterval " + this.swapInterval);
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        gL2ES1.setSwapInterval(this.swapInterval);
        gL2ES1.glMatrixMode(5889);
        gL2ES1.glLoadIdentity();
        if (n4 > n3) {
            float f = (float)n4 / (float)n3;
            gL2ES1.glFrustumf(-1.0f, 1.0f, -f, f, 5.0f, 60.0f);
        } else {
            float f = (float)n3 / (float)n4;
            gL2ES1.glFrustumf(-f, f, -1.0f, 1.0f, 5.0f, 60.0f);
        }
        gL2ES1.glMatrixMode(5888);
        gL2ES1.glLoadIdentity();
        gL2ES1.glTranslatef(0.0f, 0.0f, -40.0f);
        System.err.println(Thread.currentThread() + " GearsES1.reshape FIN");
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object;
        if (!this.isInit) {
            return;
        }
        this.isInit = false;
        System.err.println(Thread.currentThread() + " GearsES1.dispose ... ");
        Object object2 = gLAutoDrawable.getUpstreamWidget();
        if (object2 instanceof Window) {
            object = (Window)object2;
            object.removeMouseListener(this.gearsMouse);
            object.removeKeyListener(this.gearsKeys);
        }
        object = gLAutoDrawable.getGL();
        this.gear1.destroy((GL)object);
        this.gear1 = null;
        this.gear2.destroy((GL)object);
        this.gear2 = null;
        this.gear3.destroy((GL)object);
        this.gear3 = null;
        this.sharedGears = null;
        this.syncObjects = null;
        System.err.println(Thread.currentThread() + " GearsES1.dispose FIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        if (!this.isInit) {
            return;
        }
        this.angle += 0.5f;
        GL2ES1 gL2ES1 = gLAutoDrawable.getGL().getGL2ES1();
        Object object = gLAutoDrawable.getUpstreamWidget();
        boolean bl = object instanceof NativeWindow ? ((NativeWindow)object).hasFocus() : true;
        if (bl) {
            gL2ES1.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            gL2ES1.glClearColor(0.2f, 0.2f, 0.2f, 0.0f);
        }
        if (GLProfile.isAWTAvailable() && gLAutoDrawable instanceof GLJPanel && !((GLJPanel)gLAutoDrawable).isOpaque() && ((GLJPanel)gLAutoDrawable).shouldPreserveColorBufferIfTranslucent()) {
            gL2ES1.glClear(256);
        } else {
            gL2ES1.glClear(16640);
        }
        gL2ES1.glNormal3f(0.0f, 0.0f, 1.0f);
        gL2ES1.glPushMatrix();
        gL2ES1.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        gL2ES1.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        gL2ES1.glRotatef(0.0f, 0.0f, 0.0f, 1.0f);
        Object object2 = this.syncObjects;
        synchronized (object2) {
            this.gear1.draw(gL2ES1, -3.0f, -2.0f, this.angle);
            this.gear2.draw(gL2ES1, 3.1f, -2.0f, -2.0f * this.angle - 9.0f);
            this.gear3.draw(gL2ES1, -3.1f, 4.2f, -2.0f * this.angle - 25.0f);
        }
        gL2ES1.glPopMatrix();
    }

    class GearsMouseAdapter
    extends MouseAdapter {
        GearsMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            GearsES1.this.prevMouseX = mouseEvent.getX();
            GearsES1.this.prevMouseY = mouseEvent.getY();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Object object;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            int n4 = 0;
            Object object2 = mouseEvent.getSource();
            if (object2 instanceof Window) {
                object = (Window)object2;
                n3 = object.getSurfaceWidth();
                n4 = object.getSurfaceHeight();
            } else if (object2 instanceof GLAutoDrawable) {
                object = (GLAutoDrawable)object2;
                n3 = object.getSurfaceWidth();
                n4 = object.getSurfaceHeight();
            } else if (GLProfile.isAWTAvailable() && object2 instanceof Component) {
                object = (Component)object2;
                n3 = ((Component)object).getWidth();
                n4 = ((Component)object).getHeight();
            } else {
                throw new RuntimeException("Event source neither Window nor Component: " + object2);
            }
            float f = 360.0f * ((float)(n - GearsES1.this.prevMouseX) / (float)n3);
            float f2 = 360.0f * ((float)(GearsES1.this.prevMouseY - n2) / (float)n4);
            GearsES1.this.prevMouseX = n;
            GearsES1.this.prevMouseY = n2;
            GearsES1.this.view_rotx = GearsES1.this.view_rotx + f2;
            GearsES1.this.view_roty = GearsES1.this.view_roty + f;
        }
    }

    class GearsKeyAdapter
    extends KeyAdapter {
        GearsKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            short s = keyEvent.getKeyCode();
            if (149 == s) {
                GearsES1.this.view_roty = GearsES1.this.view_roty - 1.0f;
            } else if (151 == s) {
                GearsES1.this.view_roty = GearsES1.this.view_roty + 1.0f;
            } else if (150 == s) {
                GearsES1.this.view_rotx = GearsES1.this.view_rotx - 1.0f;
            } else if (152 == s) {
                GearsES1.this.view_rotx = GearsES1.this.view_rotx + 1.0f;
            }
        }
    }
}

