/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.caps;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.caps.MultisampleChooser01;
import com.jogamp.opengl.test.junit.jogl.demos.es1.MultisampleDemoES1;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestMultisampleES1AWT
extends UITestCase {
    static long durationPerTest = 60L;
    private GLCanvas canvas;

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = MiscUtils.atoi(stringArray[++i], 500);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestMultisampleES1AWT.class.getName();
        JUnitCore.main(string);
    }

    @Test
    public void testOnscreenMultiSampleAA0() throws InterruptedException, InvocationTargetException {
        this.testMultiSampleAAImpl(0);
    }

    @Test
    public void testOnscreenMultiSampleAA4() throws InterruptedException, InvocationTargetException {
        this.testMultiSampleAAImpl(4);
    }

    @Test
    public void testOnscreenMultiSampleAA8() throws InterruptedException, InvocationTargetException {
        this.testMultiSampleAAImpl(8);
    }

    private void testMultiSampleAAImpl(int n) throws InterruptedException, InvocationTargetException {
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        GLProfile gLProfile = GLProfile.getMaxFixedFunc(true);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        MultisampleChooser01 multisampleChooser01 = new MultisampleChooser01();
        if (n > 0) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n);
        }
        this.canvas = new GLCanvas(gLCapabilities, multisampleChooser01, null);
        this.canvas.addGLEventListener(new MultisampleDemoES1(n > 0));
        this.canvas.addGLEventListener(new GLEventListener(){
            int displayCount = 0;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                TestMultisampleES1AWT.this.snapshot(this.displayCount++, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        final Frame frame = new Frame("Multi Samples " + n);
        frame.setLayout(new BorderLayout());
        this.canvas.setSize(512, 512);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.add((Component)TestMultisampleES1AWT.this.canvas, "Center");
                frame.pack();
                frame.setVisible(true);
                TestMultisampleES1AWT.this.canvas.requestFocus();
                TestMultisampleES1AWT.this.canvas.display();
            }
        });
        Thread.sleep(durationPerTest);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
                frame.remove(TestMultisampleES1AWT.this.canvas);
                frame.dispose();
            }
        });
    }
}

