/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.TraceWindowAdapter;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug816OSXCALayerPos03bB849AWT
extends UITestCase {
    static long duration = 1600L;
    static int width = 640;
    static int height = 480;

    @Test
    public void test() throws InterruptedException, InvocationTargetException {
        long l;
        GLCapabilities gLCapabilities = new GLCapabilities(TestBug816OSXCALayerPos03bB849AWT.getGLP());
        final Frame frame = new Frame("TestBug816OSXCALayerPos03bAWT");
        Assert.assertNotNull(frame);
        final GLCanvas gLCanvas = new GLCanvas(gLCapabilities);
        Assert.assertNotNull(gLCanvas);
        gLCanvas.addGLEventListener(new GearsES2(1));
        final Panel panel = new Panel(new GridLayout(1, 1));
        panel.add(gLCanvas);
        Animator animator = new Animator();
        animator.add(gLCanvas);
        QuitAdapter quitAdapter = new QuitAdapter();
        new AWTWindowAdapter((WindowListener)new TraceWindowAdapter(quitAdapter), (NativeSurfaceHolder)gLCanvas).addTo(frame);
        final Checkbox checkbox = new Checkbox("Visible canvas", true);
        checkbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = checkbox.getState();
                System.err.println("XXXX Panel setVisible " + bl);
                panel.setVisible(bl);
                System.err.println("XXXX Visible: [panel " + panel.isVisible() + ", canvas " + gLCanvas.isVisible() + "]; Displayable: [panel " + panel.isDisplayable() + ", canvas " + gLCanvas.isDisplayable() + "]");
                if (panel.isVisible()) {
                    frame.validate();
                }
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)panel, "Center");
        frame.add((Component)checkbox, "North");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setSize(width, height);
                frame.setVisible(true);
            }
        });
        Assert.assertEquals(true, AWTRobotUtil.waitForVisible(frame, true));
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLCanvas, true));
        animator.start();
        Assert.assertTrue(animator.isStarted());
        Assert.assertTrue(animator.isAnimating());
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertNotNull(frame);
        Assert.assertNotNull(gLCanvas);
        Assert.assertNotNull(animator);
        animator.stop();
        Assert.assertFalse(animator.isAnimating());
        Assert.assertFalse(animator.isStarted());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(false);
            }
        });
        Assert.assertEquals(false, frame.isVisible());
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                frame.remove(panel);
                frame.dispose();
            }
        });
    }

    static GLProfile getGLP() {
        return GLProfile.getMaxProgrammableCore(true);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main(TestBug816OSXCALayerPos03bB849AWT.class.getName());
    }
}

