/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestAWT02WindowClosing
extends UITestCase {
    static long durationPerTest = 200L;

    @Test
    public void test01WindowClosing() throws InterruptedException {
        final Frame frame = new Frame();
        ClosingWindowAdapter closingWindowAdapter = new ClosingWindowAdapter(frame);
        frame.addWindowListener(closingWindowAdapter);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.setSize(500, 500);
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
        Thread.sleep(durationPerTest);
        if (!closingWindowAdapter.closingCalled) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            EventQueue eventQueue = toolkit.getSystemEventQueue();
            eventQueue.postEvent(new WindowEvent(frame, 201));
            Thread.sleep(200L);
        }
        Assert.assertEquals(true, closingWindowAdapter.closingCalled);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestAWT02WindowClosing.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        JUnitCore.main(TestAWT02WindowClosing.class.getName());
    }

    static class ClosingWindowAdapter
    extends WindowAdapter {
        boolean closingCalled = false;
        Frame frame;

        public ClosingWindowAdapter(Frame frame) {
            this.frame = frame;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            System.out.println("windowClosing() called ..");
            this.closingCalled = true;
            this.frame.dispose();
        }
    }
}

