/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLDrawableUtil;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLContextDrawableSwitch01NEWT
extends UITestCase {
    static int width;
    static int height;
    static long duration;
    static long period;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    private GLAutoDrawable createGLAutoDrawable(GLCapabilities gLCapabilities, int n, int n2, int n3, int n4, WindowListener windowListener) throws InterruptedException {
        final Window window = NewtFactory.createWindow(gLCapabilities);
        Assert.assertNotNull(window);
        window.setPosition(n, n2);
        window.setSize(n3, n4);
        window.setVisible(true);
        Assert.assertTrue(AWTRobotUtil.waitForVisible(window, true));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(window, true));
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable(window);
        Assert.assertNotNull(gLDrawable);
        gLDrawable.setRealized(true);
        Assert.assertTrue(gLDrawable.isRealized());
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull(gLContext);
        final GLAutoDrawableDelegate gLAutoDrawableDelegate = new GLAutoDrawableDelegate(gLDrawable, gLContext, window, false, null){

            @Override
            protected void destroyImplInLock() {
                super.destroyImplInLock();
                window.destroy();
            }
        };
        window.setWindowDestroyNotifyAction(new Runnable(){

            @Override
            public void run() {
                gLAutoDrawableDelegate.windowDestroyNotifyOp();
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                gLAutoDrawableDelegate.windowRepaintOp();
            }

            @Override
            public void windowResized(WindowEvent windowEvent) {
                gLAutoDrawableDelegate.windowResizedOp(window.getSurfaceWidth(), window.getSurfaceHeight());
            }
        });
        window.addWindowListener(windowListener);
        return gLAutoDrawableDelegate;
    }

    @Test(timeout=30000L)
    public void testSwitch2WindowSingleContextGL2ES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch01NEWT.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2WindowSingleContextImpl(gLCapabilities);
    }

    @Test(timeout=30000L)
    public void testSwitch2WindowSingleContextGLES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch01NEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2WindowSingleContextImpl(gLCapabilities);
    }

    private void testSwitch2WindowSingleContextImpl(GLCapabilities gLCapabilities) throws InterruptedException {
        long l;
        QuitAdapter quitAdapter = new QuitAdapter();
        GLAutoDrawable gLAutoDrawable = this.createGLAutoDrawable(gLCapabilities, 64, 64, width, height, quitAdapter);
        GLAutoDrawable gLAutoDrawable2 = this.createGLAutoDrawable(gLCapabilities, 128 + width, 64, width + 100, height + 100, quitAdapter);
        Object object = gLAutoDrawable.createContext(null);
        Assert.assertNotNull(object);
        Object object2 = gLAutoDrawable.setContext((GLContext)object, true);
        Assert.assertNotNull(object2);
        Assert.assertFalse(((GLContext)object2).isCreated());
        int n = ((GLContext)object).makeCurrent();
        Assert.assertTrue(2 == n || 1 == n);
        ((GLContext)object).release();
        object = new UITestCase.SnapshotGLEventListener(this);
        object2 = new GearsES2(1);
        gLAutoDrawable.addGLEventListener((GLEventListener)object2);
        gLAutoDrawable.addGLEventListener((GLEventListener)object);
        ((UITestCase.SnapshotGLEventListener)object).setMakeSnapshot();
        Animator animator = new Animator();
        animator.add(gLAutoDrawable);
        animator.add(gLAutoDrawable2);
        animator.start();
        int n2 = 0;
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            if ((l2 - l) / period > (long)n2) {
                System.err.println(++n2 + " - switch - START " + (l2 - l));
                GLDrawableUtil.swapGLContextAndAllGLEventListener(gLAutoDrawable, gLAutoDrawable2);
                System.err.println(n2 + " - switch - END " + (l2 - l));
            }
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        animator.stop();
        gLAutoDrawable.destroy();
        gLAutoDrawable2.destroy();
    }

    @Test(timeout=30000L)
    public void testSwitch2GLWindowOneDemoGL2ES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch01NEWT.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2GLWindowOneDemoImpl(gLCapabilities);
    }

    @Test(timeout=30000L)
    public void testSwitch2GLWindowOneDemoGLES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch01NEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2GLWindowOneDemoImpl(gLCapabilities);
    }

    private void testSwitch2GLWindowOneDemoImpl(GLCapabilities gLCapabilities) throws InterruptedException {
        long l;
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        GearsES2 gearsES2 = new GearsES2(1);
        QuitAdapter quitAdapter = new QuitAdapter();
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("win1");
        gLWindow.setSize(width, height);
        gLWindow.setPosition(64, 64);
        gLWindow.addGLEventListener(0, gearsES2);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        gLWindow.addWindowListener(quitAdapter);
        GLWindow gLWindow2 = GLWindow.create(gLCapabilities);
        gLWindow2.setTitle("win2");
        gLWindow2.setSize(width + 100, height + 100);
        gLWindow2.setPosition(128 + width, 64);
        gLWindow2.addWindowListener(quitAdapter);
        Animator animator = new Animator();
        animator.add(gLWindow);
        animator.add(gLWindow2);
        animator.start();
        gLWindow.setVisible(true);
        gLWindow2.setVisible(true);
        snapshotGLEventListener.setMakeSnapshot();
        int n = 0;
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            if ((l2 - l) / period > (long)n) {
                System.err.println(++n + " - switch - START " + (l2 - l));
                System.err.println(n + " - A w1-h 0x" + Long.toHexString(gLWindow.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow.getContext().getHandle()));
                System.err.println(n + " - A w2-h 0x" + Long.toHexString(gLWindow2.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow2.getContext().getHandle()));
                GLDrawableUtil.swapGLContextAndAllGLEventListener(gLWindow, gLWindow2);
                System.err.println(n + " - B w1-h 0x" + Long.toHexString(gLWindow.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow.getContext().getHandle()));
                System.err.println(n + " - B w2-h 0x" + Long.toHexString(gLWindow2.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow2.getContext().getHandle()));
                System.err.println(n + " - switch - END " + (l2 - l));
                snapshotGLEventListener.setMakeSnapshot();
            }
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
    }

    @Test(timeout=30000L)
    public void testSwitch2GLWindowEachWithOwnDemoGL2ES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch01NEWT.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2GLWindowEachWithOwnDemoImpl(gLCapabilities);
    }

    @Test(timeout=30000L)
    public void testSwitch2GLWindowEachWithOwnDemoGLES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch01NEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testSwitch2GLWindowEachWithOwnDemoImpl(gLCapabilities);
    }

    public void testSwitch2GLWindowEachWithOwnDemoImpl(GLCapabilities gLCapabilities) throws InterruptedException {
        long l;
        GearsES2 gearsES2 = new GearsES2(1);
        RedSquareES2 redSquareES2 = new RedSquareES2(1);
        QuitAdapter quitAdapter = new QuitAdapter();
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener2 = new UITestCase.SnapshotGLEventListener(this);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("win1");
        gLWindow.setSize(width, height);
        gLWindow.setPosition(64, 64);
        gLWindow.addGLEventListener(0, gearsES2);
        gLWindow.addGLEventListener(snapshotGLEventListener);
        gLWindow.addWindowListener(quitAdapter);
        GLWindow gLWindow2 = GLWindow.create(gLCapabilities);
        gLWindow2.setTitle("win2");
        gLWindow2.setSize(width + 100, height + 100);
        gLWindow2.setPosition(128 + width, 64);
        gLWindow2.addGLEventListener(0, redSquareES2);
        gLWindow2.addGLEventListener(snapshotGLEventListener2);
        gLWindow2.addWindowListener(quitAdapter);
        Animator animator = new Animator();
        animator.add(gLWindow);
        animator.add(gLWindow2);
        animator.start();
        gLWindow.setVisible(true);
        gLWindow2.setVisible(true);
        snapshotGLEventListener.setMakeSnapshot();
        snapshotGLEventListener2.setMakeSnapshot();
        int n = 0;
        long l2 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l2 - l < duration) {
            if ((l2 - l) / period > (long)n) {
                System.err.println(++n + " - switch - START " + (l2 - l));
                System.err.println(n + " - A w1-h 0x" + Long.toHexString(gLWindow.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow.getContext().getHandle()));
                System.err.println(n + " - A w2-h 0x" + Long.toHexString(gLWindow2.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow2.getContext().getHandle()));
                GLDrawableUtil.swapGLContextAndAllGLEventListener(gLWindow, gLWindow2);
                System.err.println(n + " - B w1-h 0x" + Long.toHexString(gLWindow.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow.getContext().getHandle()));
                System.err.println(n + " - B w2-h 0x" + Long.toHexString(gLWindow2.getHandle()) + ",-ctx 0x" + Long.toHexString(gLWindow2.getContext().getHandle()));
                System.err.println(n + " - switch - END " + (l2 - l));
                snapshotGLEventListener.setMakeSnapshot();
                snapshotGLEventListener2.setMakeSnapshot();
            }
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                ++i;
                try {
                    duration = Integer.parseInt(stringArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (!stringArray[i].equals("-period")) continue;
            ++i;
            try {
                period = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestGLContextDrawableSwitch01NEWT.class.getName());
    }

    static {
        duration = 2200L;
        period = 1000L;
    }
}

