/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.newt.Screen;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLSharedContextSetter;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;

public abstract class GLContextDrawableSwitchBase1
extends UITestCase {
    static long duration = 1000L;
    static int width;
    static int height;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    static void setGLCanvasSize(final GLCanvas gLCanvas, final Dimension dimension) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    gLCanvas.setMinimumSize(dimension);
                    gLCanvas.setPreferredSize(dimension);
                    gLCanvas.setSize(dimension);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    static void setFrameVisible(final Frame frame) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    static void destroyFrame(final Frame frame) throws InterruptedException {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException(throwable);
        }
    }

    private GLOffscreenAutoDrawable createGLOffscreenAutoDrawable(GLCapabilities gLCapabilities, int n, int n2) throws InterruptedException {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        return gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, n, n2);
    }

    protected static boolean validateOnOffscreenLayer(GLADType gLADType, GLADType gLADType2) {
        boolean bl;
        boolean bl2 = GLADType.GLCanvasOffscreen == gLADType || GLADType.GLCanvasOffscreen == gLADType2;
        boolean bl3 = bl = GLADType.GLCanvasOnscreen == gLADType || GLADType.GLCanvasOnscreen == gLADType2;
        if (bl2) {
            if (!JAWTUtil.isOffscreenLayerSupported()) {
                System.err.println("Platform doesn't support offscreen rendering.");
                return false;
            }
        } else if (bl && JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Platform requires offscreen rendering.");
            return false;
        }
        return true;
    }

    protected void testGLADOneLifecycle(Screen screen, GLCapabilities gLCapabilities, GLADType gLADType, int n, int n2, GLEventListenerCounter gLEventListenerCounter, UITestCase.SnapshotGLEventListener snapshotGLEventListener, GLEventListenerState gLEventListenerState, GLEventListenerState[] gLEventListenerStateArray, GLAnimatorControl gLAnimatorControl) throws InterruptedException {
        long l;
        GLSharedContextSetter gLSharedContextSetter;
        Frame frame;
        System.err.println("GLAD Lifecycle.0 " + (Object)((Object)gLADType) + ", restoring " + (null != gLEventListenerState) + ", preserving " + (null != gLEventListenerStateArray));
        if (GLADType.GLCanvasOnscreen == gLADType) {
            if (JAWTUtil.isOffscreenLayerRequired()) {
                throw new InternalError("Platform requires offscreen rendering, but onscreen requested: " + (Object)((Object)gLADType));
            }
            frame = new Frame("AWT GLCanvas");
            gLSharedContextSetter = new GLCanvas(gLCapabilities);
            GLContextDrawableSwitchBase1.setGLCanvasSize((GLCanvas)gLSharedContextSetter, new Dimension(n, n2));
            frame.add((Component)((Object)gLSharedContextSetter));
        } else if (GLADType.GLCanvasOffscreen == gLADType) {
            if (!JAWTUtil.isOffscreenLayerSupported()) {
                throw new InternalError("Platform doesn't support offscreen rendering: " + (Object)((Object)gLADType));
            }
            frame = new Frame("AWT GLCanvas");
            gLSharedContextSetter = new GLCanvas(gLCapabilities);
            ((GLCanvas)gLSharedContextSetter).setShallUseOffscreenLayer(true);
            GLContextDrawableSwitchBase1.setGLCanvasSize((GLCanvas)gLSharedContextSetter, new Dimension(n, n2));
            frame.add((GLCanvas)gLSharedContextSetter);
        } else if (GLADType.GLWindow == gLADType) {
            frame = null;
            gLSharedContextSetter = null != screen ? GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities) : GLWindow.create(gLCapabilities);
            ((GLWindow)gLSharedContextSetter).setTitle("Newt GLWindow");
            ((GLWindow)gLSharedContextSetter).setSize(n, n2);
        } else if (GLADType.GLOffscreen == gLADType) {
            frame = null;
            gLSharedContextSetter = this.createGLOffscreenAutoDrawable(gLCapabilities, n, n2);
        } else {
            throw new InternalError("Unsupported: " + (Object)((Object)gLADType));
        }
        if (null == gLEventListenerState) {
            if (null != gLAnimatorControl) {
                gLAnimatorControl.add(gLSharedContextSetter);
            }
            gLSharedContextSetter.addGLEventListener(gLEventListenerCounter);
            gLSharedContextSetter.addGLEventListener(new GearsES2(1));
            gLSharedContextSetter.addGLEventListener(snapshotGLEventListener);
        }
        snapshotGLEventListener.setMakeSnapshot();
        if (GLADType.GLCanvasOnscreen == gLADType || GLADType.GLCanvasOffscreen == gLADType) {
            GLContextDrawableSwitchBase1.setFrameVisible(frame);
            Assert.assertEquals(true, AWTRobotUtil.waitForVisible(frame, true));
        } else if (GLADType.GLWindow == gLADType) {
            ((GLWindow)gLSharedContextSetter).setVisible(true);
        }
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLSharedContextSetter, true));
        Assert.assertNotNull(gLSharedContextSetter.getContext());
        Assert.assertTrue(gLSharedContextSetter.isRealized());
        if (null != gLEventListenerState) {
            Assert.assertEquals(0L, gLSharedContextSetter.getGLEventListenerCount());
            System.err.println(".. restoring.0");
            gLEventListenerState.moveTo(gLSharedContextSetter);
            System.err.println(".. restoring.X");
            Assert.assertEquals(1L, gLEventListenerCounter.initCount);
            Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
            Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
            Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
            Assert.assertEquals(3L, gLSharedContextSetter.getGLEventListenerCount());
            Assert.assertEquals(gLEventListenerState.context, gLSharedContextSetter.getContext());
            Assert.assertEquals(gLEventListenerState.listenerCount(), gLSharedContextSetter.getGLEventListenerCount());
            Assert.assertEquals(gLEventListenerState.context.getGLReadDrawable(), gLSharedContextSetter.getDelegatedDrawable());
            Assert.assertEquals(gLEventListenerState.context.getGLDrawable(), gLSharedContextSetter.getDelegatedDrawable());
            Assert.assertEquals(false, gLEventListenerState.isOwner());
        }
        for (int i = 0; i < 20 && (1 > gLEventListenerCounter.initCount || 1 > gLEventListenerCounter.reshapeCount || 1 > gLEventListenerCounter.displayCount); ++i) {
            Thread.sleep(100L);
        }
        long l2 = l = System.currentTimeMillis();
        while (l2 - l < duration) {
            Thread.sleep(100L);
            l2 = System.currentTimeMillis();
        }
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
        if (null != gLEventListenerStateArray) {
            GLContext gLContext = gLSharedContextSetter.getContext();
            System.err.println(".. preserving.0");
            gLEventListenerStateArray[0] = GLEventListenerState.moveFrom(gLSharedContextSetter);
            System.err.println(".. preserving.X");
            Assert.assertEquals(gLContext, gLEventListenerStateArray[0].context);
            Assert.assertNull(gLContext.getGLReadDrawable());
            Assert.assertNull(gLContext.getGLDrawable());
            Assert.assertEquals(3L, gLEventListenerStateArray[0].listenerCount());
            Assert.assertEquals(true, gLEventListenerStateArray[0].isOwner());
            Assert.assertEquals(null, gLSharedContextSetter.getContext());
            Assert.assertEquals(0L, gLSharedContextSetter.getGLEventListenerCount());
        }
        if (GLADType.GLCanvasOnscreen == gLADType || GLADType.GLCanvasOffscreen == gLADType) {
            GLContextDrawableSwitchBase1.destroyFrame(frame);
            Assert.assertEquals(true, AWTRobotUtil.waitForVisible(frame, false));
        } else if (GLADType.GLWindow == gLADType) {
            gLSharedContextSetter.destroy();
        } else if (GLADType.GLOffscreen == gLADType) {
            gLSharedContextSetter.destroy();
        }
        Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLSharedContextSetter, false));
        Assert.assertEquals(1L, gLEventListenerCounter.initCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.reshapeCount);
        Assert.assertTrue(1 <= gLEventListenerCounter.displayCount);
        if (null != gLEventListenerStateArray) {
            Assert.assertEquals(0L, gLEventListenerCounter.disposeCount);
        } else {
            Assert.assertEquals(1L, gLEventListenerCounter.disposeCount);
        }
        System.err.println("GLAD Lifecycle.X " + (Object)((Object)gLADType));
    }

    protected static enum GLADType {
        GLCanvasOnscreen,
        GLCanvasOffscreen,
        GLWindow,
        GLOffscreen;

    }
}

