/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.Threading;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLDrawableUtil;
import java.lang.reflect.InvocationTargetException;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class GLContextDrawableSwitchBase0
extends UITestCase {
    static int width;
    static int height;
    static boolean testEvenUnsafeSwapGLContext;
    static long duration;
    static long period;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    public abstract GLAutoDrawable createGLAutoDrawable(QuitAdapter var1, GLCapabilitiesImmutable var2, int var3, int var4) throws InterruptedException, InvocationTargetException;

    public abstract void destroyGLAutoDrawable(GLAutoDrawable var1) throws InterruptedException, InvocationTargetException;

    @Test(timeout=30000L)
    public void test01aSwitch2Onscreen2OnscreenGL2ES2_Def() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, true);
    }

    @Test(timeout=30000L)
    public void test01bSwitch2Onscreen2OffscreenGL2ES2_Def() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testImpl(gLCapabilities, false);
    }

    @Test(timeout=30000L)
    public void test01cSwitch2Offscreen2OffscreenGL2ES2_Def() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.testImpl(gLCapabilities, false);
    }

    @Test(timeout=30000L)
    public void test01dSwitch2Offscreen2OnscreenGL2ES2_Def() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.testImpl(gLCapabilities, true);
    }

    @Test(timeout=30000L)
    public void test02aSwitch2Onscreen2OnscreenGL2ES2_MSAA() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.testImpl(gLCapabilities, true);
    }

    @Test(timeout=30000L)
    public void test02bSwitch2Onscreen2OffscreenGL2ES2_MSAA() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.testImpl(gLCapabilities, false);
    }

    @Test(timeout=30000L)
    public void test02cSwitch2Offscreen2OffscreenGL2ES2_MSAA() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.testImpl(gLCapabilities, false);
    }

    @Test(timeout=30000L)
    public void test02dSwitch2Offscreen2OnscreenGL2ES2_MSAA() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setSampleBuffers(true);
        this.testImpl(gLCapabilities, true);
    }

    @Test(timeout=30000L)
    public void test03aSwitch2Onscreen2OnscreenGL2ES2_Accu() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setAccumRedBits(1);
        gLCapabilities.setAccumGreenBits(1);
        gLCapabilities.setAccumBlueBits(1);
        this.testImpl(gLCapabilities, true);
    }

    @Test(timeout=30000L)
    public void test03bSwitch2Onscreen2OffscreenGL2ES2_Accu() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setAccumRedBits(1);
        gLCapabilities.setAccumGreenBits(1);
        gLCapabilities.setAccumBlueBits(1);
        this.testImpl(gLCapabilities, false);
    }

    @Test(timeout=30000L)
    public void test03cSwitch2Offscreen2OffscreenGL2ES2_Accu() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setAccumRedBits(1);
        gLCapabilities.setAccumGreenBits(1);
        gLCapabilities.setAccumBlueBits(1);
        this.testImpl(gLCapabilities, false);
    }

    @Test(timeout=30000L)
    public void test03dSwitch2Offscreen2OnscreenGL2ES2_Accu() throws InterruptedException, InvocationTargetException {
        GLCapabilities gLCapabilities = GLContextDrawableSwitchBase0.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setAccumRedBits(1);
        gLCapabilities.setAccumGreenBits(1);
        gLCapabilities.setAccumBlueBits(1);
        this.testImpl(gLCapabilities, true);
    }

    private void testImpl(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl) throws InterruptedException, InvocationTargetException {
        long l;
        QuitAdapter quitAdapter = new QuitAdapter();
        final GLAutoDrawable gLAutoDrawable = this.createGLAutoDrawable(quitAdapter, gLCapabilitiesImmutable, width, height);
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = gLAutoDrawable.getChosenGLCapabilities();
        GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable2.cloneMutable();
        gLCapabilities.setOnscreen(bl);
        boolean bl2 = GLDrawableUtil.isSwapGLContextSafe(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilities);
        System.err.println("Source Caps Requested: " + gLCapabilitiesImmutable);
        System.err.println("Source Caps Chosen   : " + gLCapabilitiesImmutable2);
        System.err.println("Dest   Caps Requested: " + gLCapabilities);
        System.err.println("Is SwapGLContext safe: " + bl2);
        if (!bl2 && !testEvenUnsafeSwapGLContext) {
            System.err.println("Supressing unsafe tests ...");
            this.destroyGLAutoDrawable(gLAutoDrawable);
            return;
        }
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        GearsES2 gearsES2 = new GearsES2(1);
        gearsES2.setVerbose(false);
        gLAutoDrawable.addGLEventListener(gearsES2);
        gLAutoDrawable.addGLEventListener(snapshotGLEventListener);
        snapshotGLEventListener.setMakeSnapshot();
        Animator animator = new Animator();
        animator.add(gLAutoDrawable);
        animator.start();
        int n = 0;
        long l2 = l = System.currentTimeMillis();
        final GLAutoDrawable gLAutoDrawable2 = this.createGLAutoDrawable(quitAdapter, gLCapabilities, width, height);
        RuntimeException runtimeException = null;
        try {
            while (!quitAdapter.shouldQuit() && l2 - l < duration) {
                if ((l2 - l) / period > (long)n) {
                    System.err.println(++n + " - switch - START " + (l2 - l));
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            GLDrawableUtil.swapGLContextAndAllGLEventListener(gLAutoDrawable, gLAutoDrawable2);
                        }
                    };
                    if (gLAutoDrawable.isThreadGLCapable() && gLAutoDrawable2.isThreadGLCapable()) {
                        runnable.run();
                    } else {
                        Threading.invokeOnOpenGLThread(true, runnable);
                    }
                    snapshotGLEventListener.setMakeSnapshot();
                    System.err.println(n + " - switch - END " + (l2 - l));
                }
                Thread.sleep(100L);
                l2 = System.currentTimeMillis();
            }
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        animator.stop();
        this.destroyGLAutoDrawable(gLAutoDrawable2);
        this.destroyGLAutoDrawable(gLAutoDrawable);
        if (null != runtimeException) {
            throw runtimeException;
        }
    }

    static {
        testEvenUnsafeSwapGLContext = false;
        duration = 2900L;
        period = 1000L;
    }
}

