/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.ect;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.AnimatorBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class ExclusiveContextBase00
extends UITestCase {
    static boolean testExclusiveWithAWT = false;
    static final int durationParts = 9;
    static long duration = 2880L;
    static boolean showFPS = false;
    static int showFPSRate = 100;
    static final int demoWinSize = 128;
    static InsetsImmutable insets = null;
    static int num_x;
    static int num_y;
    static int swapInterval;

    @BeforeClass
    public static void initClass00() {
        Window window = NewtFactory.createWindow(new Capabilities());
        window.setSize(128, 128);
        window.setVisible(true);
        Assert.assertEquals(true, window.isVisible());
        Assert.assertEquals(true, window.isNativeValid());
        insets = window.getInsets();
        int n = window.getScreen().getHeight();
        int n2 = window.getScreen().getWidth();
        int[] nArray = window.convertToPixelUnits(new int[]{128, 128});
        int[] nArray2 = window.convertToPixelUnits(new int[]{insets.getTotalWidth(), insets.getTotalHeight()});
        num_x = n2 / (nArray[0] + nArray2[0]) - 2;
        num_y = n / (nArray[1] + nArray2[1]) - 2;
        window.destroy();
    }

    @AfterClass
    public static void releaseClass00() {
    }

    protected abstract boolean isAWTTestCase();

    protected abstract Thread getAWTRenderThread();

    protected abstract AnimatorBase createAnimator();

    protected abstract GLAutoDrawable createGLAutoDrawable(String var1, int var2, int var3, int var4, int var5, GLCapabilitiesImmutable var6);

    protected abstract void setGLAutoDrawableVisible(GLAutoDrawable[] var1);

    protected abstract void destroyGLAutoDrawableVisible(GLAutoDrawable var1);

    protected void runTestGL(GLCapabilitiesImmutable gLCapabilitiesImmutable, int n, boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        int n2;
        int n3;
        boolean bl4 = this.isAWTTestCase();
        if (bl4 && bl) {
            if (testExclusiveWithAWT) {
                System.err.println("Warning: Testing AWT + Exclusive -> Not advised!");
            } else {
                System.err.println("Info: Skip test: AWT + Exclusive!");
                return;
            }
        }
        if (bl4 && bl && !testExclusiveWithAWT) {
            System.err.println("Skip test: AWT + Exclusive -> Not advised!");
            return;
        }
        Thread thread = this.getAWTRenderThread();
        AnimatorBase animatorBase = this.createAnimator();
        if (!bl4) {
            animatorBase.setModeBits(false, 1);
        }
        GLAutoDrawable[] gLAutoDrawableArray = new GLAutoDrawable[n];
        for (n3 = 0; n3 < n; ++n3) {
            n2 = n3 % num_x * (128 + insets.getTotalHeight()) + insets.getLeftWidth();
            int n4 = n3 / num_x % num_y * (128 + insets.getTotalHeight()) + insets.getTopHeight();
            gLAutoDrawableArray[n3] = this.createGLAutoDrawable("Win #" + n3, n2, n4, 128, 128, gLCapabilitiesImmutable);
            Assert.assertNotNull(gLAutoDrawableArray[n3]);
            GearsES2 gearsES2 = new GearsES2(swapInterval);
            gearsES2.setVerbose(false);
            gLAutoDrawableArray[n3].addGLEventListener(gearsES2);
        }
        if (bl2) {
            for (n3 = 0; n3 < n; ++n3) {
                animatorBase.add(gLAutoDrawableArray[n3]);
            }
            if (bl) {
                if (bl4) {
                    Assert.assertEquals(null, animatorBase.setExclusiveContext(thread));
                } else {
                    Assert.assertEquals(false, animatorBase.setExclusiveContext(true));
                }
            }
        }
        Assert.assertFalse(animatorBase.isAnimating());
        Assert.assertFalse(animatorBase.isStarted());
        Assert.assertTrue(animatorBase.start());
        Assert.assertTrue(animatorBase.isStarted());
        if (bl2) {
            Assert.assertTrue(animatorBase.isAnimating());
        } else {
            Assert.assertFalse(animatorBase.isAnimating());
            if (bl) {
                if (bl4) {
                    Assert.assertEquals(null, animatorBase.setExclusiveContext(thread));
                } else {
                    Assert.assertEquals(false, animatorBase.setExclusiveContext(true));
                }
            }
            for (n3 = 0; n3 < n; ++n3) {
                animatorBase.add(gLAutoDrawableArray[n3]);
            }
            Assert.assertTrue(animatorBase.isAnimating());
        }
        Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
        Thread thread2 = animatorBase.getExclusiveContextThread();
        if (bl) {
            if (bl4) {
                Assert.assertEquals(thread, thread2);
            } else {
                Assert.assertEquals(animatorBase.getThread(), thread2);
            }
        } else {
            Assert.assertEquals(null, thread2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            Assert.assertEquals(thread2, gLAutoDrawableArray[n2].getExclusiveContextThread());
        }
        this.setGLAutoDrawableVisible(gLAutoDrawableArray);
        animatorBase.setUpdateFPSFrames(showFPSRate, showFPS ? System.err : null);
        Thread.sleep(duration / 9L);
        if (!bl3) {
            int n5;
            if (bl) {
                thread2 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals(thread, thread2);
                } else {
                    Assert.assertEquals(animatorBase.getThread(), thread2);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    Thread thread3 = gLAutoDrawableArray[n2].setExclusiveContextThread(null);
                    Assert.assertEquals(thread2, thread3);
                }
                Thread.sleep(duration / 9L);
                for (n2 = 0; n2 < n; ++n2) {
                    int n6;
                    boolean bl5 = null == gLAutoDrawableArray[n2].getExclusiveContextThread();
                    for (n6 = 0; !bl5 && n6 < 250; ++n6) {
                        Thread.sleep(20L);
                        bl5 = null == gLAutoDrawableArray[n2].getExclusiveContextThread();
                    }
                    if (n6 > 0) {
                        System.err.println("Clearing drawable ECT was done 'later' @ " + n6 * 20 + "ms, ok " + bl5);
                    }
                    Assert.assertEquals(true, bl5);
                    Thread thread4 = gLAutoDrawableArray[n2].setExclusiveContextThread(thread2);
                    Assert.assertEquals(null, thread4);
                }
                Thread.sleep(duration / 9L);
            }
            if (bl) {
                thread2 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals(thread, thread2);
                } else {
                    Assert.assertEquals(animatorBase.getThread(), thread2);
                }
                Assert.assertEquals(true, animatorBase.setExclusiveContext(false));
                Assert.assertFalse(animatorBase.isExclusiveContextEnabled());
                for (n2 = 0; n2 < n; ++n2) {
                    Assert.assertEquals(null, gLAutoDrawableArray[n2].getExclusiveContextThread());
                }
                Thread.sleep(duration / 9L);
                Assert.assertEquals(null, animatorBase.setExclusiveContext(thread2));
                Assert.assertTrue(animatorBase.isExclusiveContextEnabled());
                Assert.assertEquals(thread2, animatorBase.getExclusiveContextThread());
                for (n2 = 0; n2 < n; ++n2) {
                    Assert.assertEquals(thread2, gLAutoDrawableArray[n2].getExclusiveContextThread());
                }
                Thread.sleep(duration / 9L);
            }
            Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
            Assert.assertTrue(animatorBase.isStarted());
            Assert.assertTrue(animatorBase.isAnimating());
            Assert.assertFalse(animatorBase.isPaused());
            Assert.assertTrue(animatorBase.pause());
            Assert.assertTrue(animatorBase.isStarted());
            Assert.assertFalse(animatorBase.isAnimating());
            Assert.assertTrue(animatorBase.isPaused());
            Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
            if (bl) {
                thread2 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals(thread, thread2);
                } else {
                    Assert.assertEquals(animatorBase.getThread(), thread2);
                }
            } else {
                Assert.assertEquals(null, animatorBase.getExclusiveContextThread());
            }
            for (n5 = 0; n5 < n; ++n5) {
                Assert.assertEquals(null, gLAutoDrawableArray[n5].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            Assert.assertTrue(animatorBase.resume());
            Assert.assertTrue(animatorBase.isStarted());
            Assert.assertTrue(animatorBase.isAnimating());
            Assert.assertFalse(animatorBase.isPaused());
            Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
            if (bl) {
                Thread thread5 = animatorBase.getExclusiveContextThread();
                if (bl4) {
                    Assert.assertEquals(thread, thread5);
                } else {
                    Assert.assertEquals(animatorBase.getThread(), thread5);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    Assert.assertEquals(thread5, gLAutoDrawableArray[n2].getExclusiveContextThread());
                }
            } else {
                Assert.assertEquals(null, animatorBase.getExclusiveContextThread());
                for (n5 = 0; n5 < n; ++n5) {
                    Assert.assertEquals(null, gLAutoDrawableArray[n5].getExclusiveContextThread());
                }
            }
            Thread.sleep(duration / 9L);
            Assert.assertTrue(animatorBase.stop());
            Assert.assertFalse(animatorBase.isAnimating());
            Assert.assertFalse(animatorBase.isStarted());
            Assert.assertFalse(animatorBase.isPaused());
            Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
            Assert.assertEquals(null, animatorBase.getExclusiveContextThread());
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals(null, gLAutoDrawableArray[i].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            Assert.assertTrue(animatorBase.start());
            Assert.assertTrue(animatorBase.isStarted());
            Assert.assertTrue(animatorBase.isAnimating());
            Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
            Thread thread6 = animatorBase.getExclusiveContextThread();
            if (bl) {
                if (bl4) {
                    Assert.assertEquals(thread, thread6);
                } else {
                    Assert.assertEquals(animatorBase.getThread(), thread6);
                }
            } else {
                Assert.assertEquals(null, thread6);
            }
            for (n2 = 0; n2 < n; ++n2) {
                Assert.assertEquals(thread6, gLAutoDrawableArray[n2].getExclusiveContextThread());
            }
            Thread.sleep(duration / 9L);
            for (int i = 0; i < n; ++i) {
                GLAutoDrawable gLAutoDrawable = gLAutoDrawableArray[i];
                animatorBase.remove(gLAutoDrawable);
                Assert.assertEquals(null, gLAutoDrawable.getExclusiveContextThread());
            }
            Assert.assertTrue(animatorBase.isStarted());
            Assert.assertFalse(animatorBase.isAnimating());
        }
        Assert.assertTrue(animatorBase.stop());
        Assert.assertFalse(animatorBase.isAnimating());
        Assert.assertFalse(animatorBase.isStarted());
        Assert.assertFalse(animatorBase.isPaused());
        Assert.assertEquals(bl, animatorBase.isExclusiveContextEnabled());
        Assert.assertEquals(null, animatorBase.getExclusiveContextThread());
        for (int i = 0; i < n; ++i) {
            this.destroyGLAutoDrawableVisible(gLAutoDrawableArray[i]);
            Assert.assertEquals(true, AWTRobotUtil.waitForRealized(gLAutoDrawableArray[i], false));
        }
    }

    @Test
    public void test01NormalPre_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 1, false, true, false);
    }

    @Test
    public void test02NormalPost_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 1, false, false, true);
    }

    @Test
    public void test03ExclPre_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 1, true, true, false);
    }

    @Test
    public void test04ExclPost_1Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 1, true, false, true);
    }

    @Test
    public void test05NormalPre_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 4, false, true, false);
    }

    @Test
    public void test06NormalPost_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 4, false, false, true);
    }

    @Test
    public void test07ExclPre_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 4, true, true, false);
    }

    @Test
    public void test08ExclPost_4Win() throws InterruptedException {
        GLProfile gLProfile = GLProfile.getGL2ES2();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.runTestGL(gLCapabilities, 4, true, false, true);
    }

    static {
        swapInterval = 0;
    }
}

