/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionNumberString;
import com.jogamp.junit.util.SingletonJunitCase;
import com.jogamp.junit.util.VersionSemanticsUtil;
import com.jogamp.opengl.JoglVersion;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;
import org.osjava.jardiff.DiffCriteria;
import org.osjava.jardiff.SimpleDiffCriteria;
import org.semver.Delta;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestVersionSemanticsNOUI
extends SingletonJunitCase {
    static final String jarFile = "jogl-all.jar";
    static final DiffCriteria diffCriteria = new SimpleDiffCriteria();
    static final JogampVersion curVersion = JoglVersion.getInstance();
    static final VersionNumberString curVersionNumber = new VersionNumberString(curVersion.getImplementationVersion());
    static final Set<String> excludesDefault = new HashSet<String>();
    static final Set<String> excludesStereoPackageAndAppletUtils;

    public void testVersionV212V213() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(diffCriteria, Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.2", "2.1.3", excludesDefault);
    }

    public void testVersionV213V214() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(diffCriteria, Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.3", "2.1.4", excludesDefault);
    }

    public void testVersionV214V215() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(diffCriteria, Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.4", "2.1.5", excludesDefault);
    }

    public void testVersionV215V220() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(diffCriteria, Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.1.5", "2.2.0", excludesDefault);
    }

    @Test
    public void testVersionV220V221() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(diffCriteria, Delta.CompatibilityType.BACKWARD_COMPATIBLE_USER, "2.2.0", "2.2.1", excludesDefault);
    }

    @Test
    public void testVersionV221V230() throws IllegalArgumentException, IOException, URISyntaxException {
        this.testVersions(diffCriteria, Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE, "2.2.1", "2.3.0", excludesDefault);
    }

    void testVersions(DiffCriteria diffCriteria, Delta.CompatibilityType compatibilityType, String string, String string2, Set<String> set) throws IllegalArgumentException, IOException, URISyntaxException {
        VersionNumberString versionNumberString = new VersionNumberString(string);
        File file = new File("lib/v" + string + "/" + jarFile);
        VersionNumberString versionNumberString2 = new VersionNumberString(string2);
        File file2 = new File("lib/v" + string2 + "/" + jarFile);
        VersionSemanticsUtil.testVersion(diffCriteria, compatibilityType, file, versionNumberString, file2, versionNumberString2, set);
    }

    @Test
    public void testVersionV230V23x_00std() throws IllegalArgumentException, IOException, URISyntaxException {
        Delta.CompatibilityType compatibilityType = Delta.CompatibilityType.NON_BACKWARD_COMPATIBLE;
        VersionNumberString versionNumberString = new VersionNumberString("2.3.0");
        File file = new File("lib/v" + versionNumberString.getVersionString() + "/" + jarFile);
        ClassLoader classLoader = TestVersionSemanticsNOUI.class.getClassLoader();
        VersionSemanticsUtil.testVersion(diffCriteria, compatibilityType, file, versionNumberString, curVersion.getClass(), classLoader, curVersionNumber, excludesDefault);
    }

    @Test
    public void testVersionV230V23x_01patch() throws IllegalArgumentException, IOException, URISyntaxException {
        Delta.CompatibilityType compatibilityType = Delta.CompatibilityType.BACKWARD_COMPATIBLE_BINARY;
        VersionNumberString versionNumberString = new VersionNumberString("2.3.0");
        File file = new File("lib/v" + versionNumberString.getVersionString() + "/" + jarFile);
        ClassLoader classLoader = TestVersionSemanticsNOUI.class.getClassLoader();
        VersionSemanticsUtil.testVersion(diffCriteria, compatibilityType, file, versionNumberString, curVersion.getClass(), classLoader, curVersionNumber, excludesStereoPackageAndAppletUtils);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestVersionSemanticsNOUI.class.getName();
        JUnitCore.main(string);
    }

    static {
        excludesDefault.add("^\\Qjogamp/\\E.*$");
        excludesStereoPackageAndAppletUtils = new HashSet<String>(excludesDefault);
        excludesStereoPackageAndAppletUtils.add("^\\Qcom/jogamp/opengl/util/stereo/\\E.*$");
        excludesStereoPackageAndAppletUtils.add("^\\Qcom/jogamp/newt/util/applet/\\E.*$");
    }
}

