/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es1.GearsES1;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextVBOES1NEWT
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLAutoDrawable sharedDrawable;
    GearsES1 sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2ES1")) {
            glp = GLProfile.get("GL2ES1");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextVBOES1NEWT.setTestSupported(false);
        }
    }

    private void initShared() throws InterruptedException {
        GLDrawable gLDrawable = GLDrawableFactory.getFactory(glp).createDummyDrawable(null, true, caps, null);
        gLDrawable.setRealized(true);
        this.sharedDrawable = new GLAutoDrawableDelegate(gLDrawable, null, null, true, null){};
        Assert.assertNotNull(this.sharedDrawable);
        Assert.assertTrue(AWTRobotUtil.waitForRealized(this.sharedDrawable, true));
        this.sharedGears = new GearsES1();
        Assert.assertNotNull(this.sharedGears);
        this.sharedDrawable.addGLEventListener(this.sharedGears);
        this.sharedDrawable.display();
        GLContext gLContext = this.sharedDrawable.getContext();
        Assert.assertTrue("Master ctx not created", AWTRobotUtil.waitForContextCreated(this.sharedDrawable, true));
        Assert.assertTrue("Master Ctx is shared before shared creation", !gLContext.isShared());
        Assert.assertTrue("Master Gears is shared", !this.sharedGears.usesSharedGears());
    }

    private void releaseShared() {
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedDrawable.destroy();
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setPosition(n, n2);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(this.sharedDrawable);
        }
        gLWindow.setSize(width, height);
        GearsES1 gearsES1 = new GearsES1(bl2 ? 1 : 0);
        if (bl) {
            gearsES1.setSharedGears(this.sharedGears);
        }
        gLWindow.addGLEventListener(gearsES1);
        animator.add(gLWindow);
        gLWindow.setVisible(true);
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLWindow, true));
        Assert.assertTrue(AWTRobotUtil.waitForContextCreated(gLWindow, true));
        MiscUtils.dumpSharedGLContext("Master Context", this.sharedDrawable.getContext());
        MiscUtils.dumpSharedGLContext("New    Context", gLWindow.getContext());
        if (bl) {
            Assert.assertEquals("Master Context not shared as expected", true, this.sharedDrawable.getContext().isShared());
            Assert.assertEquals("Master Context is different", this.sharedDrawable.getContext(), gLWindow.getContext().getSharedMaster());
        }
        Assert.assertEquals("New    Context not shared as expected", bl, gLWindow.getContext().isShared());
        Assert.assertEquals("Gears is not shared as expected", bl, gearsES1.usesSharedGears());
        return gLWindow;
    }

    @Test
    public void test01() throws InterruptedException {
        this.initShared();
        Animator animator = new Animator();
        GLWindow gLWindow = this.runTestGL(animator, 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(animator, gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(animator, gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), false, true);
        animator.setUpdateFPSFrames(1, null);
        animator.start();
        while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        this.releaseShared();
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextVBOES1NEWT.class.getName());
    }

    static {
        duration = 500L;
    }
}

