/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jogamp.opengl.GLAutoDrawableBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextNewtAWTBug523
extends UITestCase {
    static long durationPerTest = 1000L;
    private static int initializationCounter;
    private static Semaphore disposalCompleteSemaphore;
    private static AtomicInteger sharedVertexBufferObjects;
    private static AtomicInteger sharedIndexBufferObjects;
    private static final Set<String> errorSet;

    @BeforeClass
    public static void initClass() {
        if (!GLProfile.isAvailable("GL2")) {
            TestSharedContextNewtAWTBug523.setTestSupported(false);
        }
    }

    private static GLOffscreenAutoDrawable initShared(GLCapabilities gLCapabilities) {
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile()).createOffscreenAutoDrawable(null, gLCapabilities, null, 64, 64);
        Assert.assertNotNull(gLOffscreenAutoDrawable);
        gLOffscreenAutoDrawable.display();
        GLContext gLContext = gLOffscreenAutoDrawable.getContext();
        Assert.assertNotNull("Shared drawable's ctx is null", gLContext);
        Assert.assertTrue("Shared drawable's ctx is not created", gLContext.isCreated());
        return gLOffscreenAutoDrawable;
    }

    private static void releaseShared(GLOffscreenAutoDrawable gLOffscreenAutoDrawable) {
        if (null != gLOffscreenAutoDrawable) {
            gLOffscreenAutoDrawable.destroy();
        }
    }

    public static void logAnyErrorCodes(Object object, GL gL, String string) {
        String string2;
        int n;
        String string3;
        int n2 = gL.glGetError();
        if (n2 != 0 && errorSet.add(string3 = "GL-Error: " + string + " on obj 0x" + Integer.toHexString(object.hashCode()) + ", OpenGL error: 0x" + Integer.toHexString(n2))) {
            System.err.println(string3);
            ExceptionUtils.dumpStack(System.err);
        }
        if ((n = gL.glCheckFramebufferStatus(36160)) != 36053 && errorSet.add(string2 = "GL-Error: " + string + " on obj 0x" + Integer.toHexString(object.hashCode()) + ", glCheckFramebufferStatus: 0x" + Integer.toHexString(n))) {
            System.err.println(string2);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public static float setupViewFrustum(GL2 gL2, int n, int n2, float f, float f2, float f3) {
        assert (f > 0.0f);
        assert (f2 > 0.0f);
        assert (f3 > 0.0f);
        GLU gLU = new GLU();
        float f4 = (float)n / (float)n2;
        float f5 = f / f2;
        float f6 = f4 > 1.0f ? f3 : f4 * f3;
        float f7 = (float)((double)f5 / Math.sin((double)f6 / 2.0 * (Math.PI / 180)));
        gL2.glMatrixMode(5889);
        gL2.glLoadIdentity();
        gLU.gluPerspective((double)f3, (double)f4, 0.1 * (double)f7, (double)(f7 + f5));
        return f7;
    }

    @Test
    public void test01UseAWTNotShared() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(false, false);
    }

    @Test
    public void test02UseAWTSharedContext() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(false, true);
    }

    @Test
    public void test10UseNEWTNotShared() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(true, false);
    }

    @Test
    public void test11UseNEWTSharedContext() throws InterruptedException, InvocationTargetException {
        this.testContextSharingCreateVisibleDestroy(true, true);
    }

    public void testContextSharingCreateVisibleDestroy(final boolean bl, boolean bl2) throws InterruptedException, InvocationTargetException {
        boolean bl3;
        Object object;
        Object object2;
        Canvas canvas;
        Object object3;
        Component component;
        Object object4;
        Component component2;
        Object object5;
        final JFrame jFrame = new JFrame("Simple JOGL App for testing context sharing");
        AWTRobotUtil.WindowClosingListener windowClosingListener = AWTRobotUtil.addClosingListener(jFrame);
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.get("GL2"));
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = bl2 ? TestSharedContextNewtAWTBug523.initShared(gLCapabilities) : null;
        final TwoTriangles twoTriangles = new TwoTriangles(640, 480, bl2);
        final TwoTriangles twoTriangles2 = new TwoTriangles(320, 480, bl2);
        if (bl) {
            object5 = GLWindow.create(gLCapabilities);
            if (bl2) {
                ((GLAutoDrawableBase)object5).setSharedAutoDrawable(gLOffscreenAutoDrawable);
            }
            component2 = new NewtCanvasAWT((Window)object5);
            component2.setPreferredSize(new Dimension(twoTriangles.canvasWidth, twoTriangles.canvasHeight));
            ((GLAutoDrawableBase)object5).addGLEventListener(twoTriangles);
            object4 = GLWindow.create(gLCapabilities);
            if (bl2) {
                ((GLAutoDrawableBase)object4).setSharedAutoDrawable(gLOffscreenAutoDrawable);
            }
            component = new NewtCanvasAWT((Window)object4);
            component.setPreferredSize(new Dimension(twoTriangles2.canvasWidth, twoTriangles2.canvasHeight));
            ((GLAutoDrawableBase)object4).addGLEventListener(twoTriangles2);
            object3 = component2;
            canvas = component;
            object2 = object5;
            object = object4;
        } else {
            if (bl2) {
                object5 = new GLCanvas(gLCapabilities);
                ((GLCanvas)object5).setSharedAutoDrawable(gLOffscreenAutoDrawable);
                component2 = new GLCanvas(gLCapabilities);
                ((GLCanvas)component2).setSharedAutoDrawable(gLOffscreenAutoDrawable);
            } else {
                object5 = new GLCanvas(gLCapabilities);
                component2 = new GLCanvas(gLCapabilities);
            }
            ((Component)object5).setSize(twoTriangles.canvasWidth, twoTriangles.canvasHeight);
            ((GLCanvas)object5).addGLEventListener(twoTriangles);
            component2.setSize(twoTriangles2.canvasWidth, twoTriangles2.canvasHeight);
            ((GLCanvas)component2).addGLEventListener(twoTriangles2);
            object3 = object5;
            canvas = component2;
            object2 = object5;
            object = component2;
        }
        object5 = new JSlider(1, -180, 180, 1);
        ((JSlider)object5).setPaintTicks(false);
        ((JSlider)object5).setPaintLabels(false);
        ((JSlider)object5).setSnapToTicks(false);
        ((JSlider)object5).addChangeListener(new ChangeListener((JSlider)object5, twoTriangles2){
            final /* synthetic */ JSlider val$xAxisRotationSlider;
            final /* synthetic */ TwoTriangles val$eventListener2;
            {
                this.val$xAxisRotationSlider = jSlider;
                this.val$eventListener2 = twoTriangles2;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setXAxisRotation(this.val$xAxisRotationSlider.getValue());
                this.val$eventListener2.setXAxisRotation(this.val$xAxisRotationSlider.getValue());
            }
        });
        component2 = new JLabel("X-Axis Rotation");
        object4 = new JSlider(0, -180, 180, 1);
        ((JSlider)object4).setPaintTicks(false);
        ((JSlider)object4).setPaintLabels(false);
        ((JSlider)object4).setSnapToTicks(false);
        ((JSlider)object4).addChangeListener(new ChangeListener((JSlider)object4, twoTriangles2){
            final /* synthetic */ JSlider val$yAxisRotationSlider;
            final /* synthetic */ TwoTriangles val$eventListener2;
            {
                this.val$yAxisRotationSlider = jSlider;
                this.val$eventListener2 = twoTriangles2;
            }

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setYAxisRotation(this.val$yAxisRotationSlider.getValue());
                this.val$eventListener2.setYAxisRotation(this.val$yAxisRotationSlider.getValue());
            }
        });
        component = new JLabel("Y-Axis Rotation");
        final JSlider jSlider = new JSlider(0, 0, 100, 10);
        jSlider.setPaintTicks(false);
        jSlider.setPaintLabels(false);
        jSlider.setSnapToTicks(false);
        jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                twoTriangles.setViewDistanceFactor((float)jSlider.getValue() / 10.0f);
                twoTriangles2.setViewDistanceFactor((float)jSlider.getValue() / 10.0f);
            }
        });
        JLabel jLabel = new JLabel("View Distance Factor");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jSlider);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add((Component)object3);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(canvas);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 3));
        jPanel3.add(jPanel2);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add((Component)object4);
        jPanel3.add(component);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel4.add((Component)object5);
        jPanel4.add(component2);
        JPanel jPanel5 = (JPanel)jFrame.getContentPane();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel5.add(jPanel);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel3);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jPanel4);
        Animator animator = new Animator(Thread.currentThread().getThreadGroup());
        animator.setUpdateFPSFrames(1, null);
        animator.add((GLAutoDrawable)object2);
        animator.add((GLAutoDrawable)object);
        final Semaphore semaphore = new Semaphore(0);
        final Semaphore semaphore2 = new Semaphore(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                semaphore2.release();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jFrame.pack();
                jFrame.setVisible(true);
                semaphore.release();
            }
        });
        try {
            bl3 = semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals(true, bl3);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        animator.start();
        try {
            while (animator.isAnimating() && animator.getTotalFPSDuration() < durationPerTest) {
                Thread.sleep(100L);
            }
            AWTRobotUtil.closeWindow(jFrame, true, windowClosingListener);
            bl3 = semaphore2.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals(true, bl3);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        animator.stop();
        SwingUtilities.invokeLater(new Runnable((Component)object3, canvas, semaphore2){
            final /* synthetic */ Component val$openGLComponent1;
            final /* synthetic */ Component val$openGLComponent2;
            final /* synthetic */ Semaphore val$closingSemaphore;
            {
                this.val$openGLComponent1 = component;
                this.val$openGLComponent2 = component2;
                this.val$closingSemaphore = semaphore;
            }

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.dispose();
                if (bl) {
                    ((NewtCanvasAWT)this.val$openGLComponent1).destroy();
                    ((NewtCanvasAWT)this.val$openGLComponent2).destroy();
                }
                this.val$closingSemaphore.release();
            }
        });
        try {
            boolean bl4 = semaphore2.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals(true, bl4);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Closing wait interrupted: " + interruptedException.getMessage());
        }
        int n = 0;
        try {
            boolean bl5 = disposalCompleteSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS);
            if (bl5) {
                ++n;
            }
            if (bl5 = disposalCompleteSemaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS)) {
                ++n;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Clean exit interrupted: " + interruptedException.getMessage());
        }
        Assert.assertEquals(true, n == 2);
        TestSharedContextNewtAWTBug523.releaseShared(gLOffscreenAutoDrawable);
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time") || ++i >= stringArray.length) continue;
            durationPerTest = TestSharedContextNewtAWTBug523.atoi(stringArray[i]);
        }
        JUnitCore.main(TestSharedContextNewtAWTBug523.class.getName());
    }

    static {
        disposalCompleteSemaphore = new Semaphore(0);
        sharedVertexBufferObjects = new AtomicInteger(0);
        sharedIndexBufferObjects = new AtomicInteger(0);
        errorSet = new HashSet<String>();
    }

    static class TwoTriangles
    implements GLEventListener {
        boolean useShared;
        int canvasWidth;
        int canvasHeight;
        private static final float boundsRadius = 2.0f;
        private float viewDistance;
        private static float viewDistanceFactor = 1.0f;
        private float xAxisRotation;
        private float yAxisRotation;
        private static final float viewFovDegrees = 15.0f;
        private final int[] privateVertexBufferObjects = new int[]{0};
        private final int[] privateIndexBufferObjects = new int[]{0};

        public static int createVertexBuffer(GL2 gL2) {
            FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(18);
            floatBuffer.put(new float[]{1.0f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 1.5f, -0.5f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f});
            floatBuffer.position(0);
            int[] nArray = new int[]{0};
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, floatBuffer.capacity() * 4, floatBuffer, 35044);
            gL2.glBindBuffer(34962, 0);
            return nArray[0];
        }

        public static int createVertexIndexBuffer(GL2 gL2) {
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(3);
            intBuffer.put(new int[]{0, 1, 2});
            intBuffer.position(0);
            int[] nArray = new int[]{0};
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34963, nArray[0]);
            gL2.glBufferData(34963, intBuffer.capacity() * 4, intBuffer, 35044);
            gL2.glBindBuffer(34963, 0);
            return nArray[0];
        }

        TwoTriangles(int n, int n2, boolean bl) {
            this.canvasWidth = n;
            this.canvasHeight = n2;
            this.useShared = bl;
        }

        public void setXAxisRotation(float f) {
            this.xAxisRotation = f;
        }

        public void setYAxisRotation(float f) {
            this.yAxisRotation = f;
        }

        public void setViewDistanceFactor(float f) {
            viewDistanceFactor = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void init(GLAutoDrawable gLAutoDrawable) {
            GL2 gL2 = gLAutoDrawable.getGL().getGL2();
            System.err.println("INIT GL IS: " + gL2.getClass().getName());
            gL2.setSwapInterval(0);
            gL2.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                if (this.useShared) {
                    System.err.println("Using shared VBOs on slave 0x" + Integer.toHexString(this.hashCode()));
                    this.privateVertexBufferObjects[0] = sharedVertexBufferObjects.get();
                    this.privateIndexBufferObjects[0] = sharedIndexBufferObjects.get();
                } else {
                    System.err.println("Using local VBOs on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                int[] nArray = this.privateVertexBufferObjects;
                int[] nArray2 = this.privateIndexBufferObjects;
                if (nArray[0] == 0) {
                    System.err.println("Creating vertex VBO on slave 0x" + Integer.toHexString(this.hashCode()));
                    nArray[0] = TwoTriangles.createVertexBuffer(gL2);
                    if (this.useShared) {
                        sharedVertexBufferObjects.set(nArray[0]);
                    }
                }
                if (gL2.glIsBuffer(nArray[0])) {
                    gL2.glBindBuffer(34962, nArray[0]);
                    gL2.glEnableClientState(32884);
                    gL2.glVertexPointer(3, 5126, 24, 0L);
                    gL2.glEnableClientState(32885);
                    gL2.glNormalPointer(5126, 24, 12L);
                } else {
                    System.err.println("Vertex VBO is not a buffer on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                if (nArray2[0] == 0) {
                    System.err.println("Creating index VBO on slave 0x" + Integer.toHexString(this.hashCode()));
                    nArray2[0] = TwoTriangles.createVertexIndexBuffer(gL2);
                    if (this.useShared) {
                        sharedIndexBufferObjects.set(nArray2[0]);
                    }
                }
                if (gL2.glIsBuffer(nArray2[0])) {
                    gL2.glBindBuffer(34963, nArray2[0]);
                } else {
                    System.err.println("Index VBO is not a buffer on slave 0x" + Integer.toHexString(this.hashCode()));
                }
                gL2.glBindBuffer(34963, 0);
                gL2.glBindBuffer(34962, 0);
                gL2.glDisableClientState(32884);
                gL2.glDisableClientState(32885);
                initializationCounter++;
            }
            this.viewDistance = TestSharedContextNewtAWTBug523.setupViewFrustum(gL2, this.canvasWidth, this.canvasHeight, 2.0f, 1.0f, 15.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose(GLAutoDrawable gLAutoDrawable) {
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                initializationCounter--;
                GL2 gL2 = gLAutoDrawable.getGL().getGL2();
                if (initializationCounter == 0 || !this.useShared) {
                    if (this.useShared) {
                        this.privateVertexBufferObjects[0] = sharedVertexBufferObjects.get();
                        this.privateIndexBufferObjects[0] = sharedIndexBufferObjects.get();
                        sharedVertexBufferObjects.set(0);
                        sharedIndexBufferObjects.set(0);
                    }
                    int[] nArray = this.privateVertexBufferObjects;
                    int[] nArray2 = this.privateIndexBufferObjects;
                    gL2.glDeleteBuffers(1, nArray, 0);
                    TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, gL2, "dispose.2");
                    gL2.glDeleteBuffers(1, nArray2, 0);
                    TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, gL2, "dispose.3");
                    nArray[0] = 0;
                    nArray2[0] = 0;
                }
                disposalCompleteSemaphore.release();
            }
        }

        @Override
        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void display(GLAutoDrawable gLAutoDrawable) {
            Object object = this;
            synchronized (object) {
                if (initializationCounter != 2) {
                    return;
                }
            }
            object = gLAutoDrawable.getGL().getGL2();
            GLU gLU = new GLU();
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)object, "display.0");
            object.glClear(16640);
            object.glViewport(0, 0, this.canvasWidth, this.canvasHeight);
            object.glMatrixMode(5889);
            object.glLoadIdentity();
            gLU.gluPerspective(15.0f, (float)this.canvasWidth / (float)this.canvasHeight, this.viewDistance * viewDistanceFactor - 2.0f, this.viewDistance * viewDistanceFactor + 2.0f);
            object.glMatrixMode(5888);
            object.glLoadIdentity();
            object.glPushAttrib(1048575);
            object.glPushMatrix();
            gLU.gluLookAt(0.0f, 0.0f, 0.0f + this.viewDistance * viewDistanceFactor, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            object.glRotatef(this.xAxisRotation, 1.0f, 0.0f, 0.0f);
            object.glRotatef(this.yAxisRotation, 0.0f, 1.0f, 0.0f);
            object.glDisable(2884);
            object.glEnable(2929);
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)object, "display.1");
            this.drawTwoTriangles((GL2)object);
            object.glPopMatrix();
            object.glPopAttrib();
            object.glFlush();
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, (GL)object, "display.X");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drawTwoTriangles(GL2 gL2) {
            boolean bl;
            int[] nArray;
            int[] nArray2;
            gL2.glColor3f(1.0f, 0.0f, 0.0f);
            gL2.glBegin(4);
            gL2.glVertex3d(-1.5, -0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glVertex3d(-0.5, -0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glVertex3d(-0.75, 0.5, 0.0);
            gL2.glNormal3d(0.0, 0.0, 1.0);
            gL2.glEnd();
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, gL2, "drawTwoTriangles.1");
            boolean bl2 = false;
            TwoTriangles twoTriangles = this;
            synchronized (twoTriangles) {
                if (this.useShared) {
                    this.privateVertexBufferObjects[0] = sharedVertexBufferObjects.get();
                    this.privateIndexBufferObjects[0] = sharedIndexBufferObjects.get();
                }
                nArray2 = this.privateVertexBufferObjects;
                nArray = this.privateIndexBufferObjects;
            }
            boolean bl3 = gL2.glIsBuffer(nArray[0]);
            boolean bl4 = gL2.glIsBuffer(nArray2[0]);
            boolean bl5 = bl = bl3 && bl4;
            if (bl) {
                gL2.glBindBuffer(34962, nArray2[0]);
                gL2.glBindBuffer(34963, nArray[0]);
                gL2.glEnableClientState(32884);
                gL2.glEnableClientState(32885);
                bl2 = true;
            }
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, gL2, "drawTwoTriangles.2");
            if (bl2) {
                gL2.glColor3f(0.0f, 0.0f, 1.0f);
                gL2.glDrawElements(4, 3, 5125, 0L);
                gL2.glBindBuffer(34962, 0);
                gL2.glBindBuffer(34963, 0);
                gL2.glDisableClientState(32884);
                gL2.glDisableClientState(32885);
            }
            TestSharedContextNewtAWTBug523.logAnyErrorCodes(this, gL2, "drawTwoTriangles.3");
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }
    }
}

