/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSharedContextListNEWT2
extends UITestCase {
    static GLProfile glp;
    static GLCapabilities caps;
    static int width;
    static int height;
    GLWindow sharedDrawable;
    Gears sharedGears;
    static long duration;

    @BeforeClass
    public static void initClass() {
        if (GLProfile.isAvailable("GL2")) {
            glp = GLProfile.get("GL2");
            Assert.assertNotNull(glp);
            caps = new GLCapabilities(glp);
            Assert.assertNotNull(caps);
            width = 256;
            height = 256;
        } else {
            TestSharedContextListNEWT2.setTestSupported(false);
        }
    }

    private void initShared() {
        this.sharedDrawable = GLWindow.create(caps);
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedGears = new Gears(0);
        Assert.assertNotNull(this.sharedGears);
        this.sharedDrawable.addGLEventListener(this.sharedGears);
        this.sharedDrawable.setSize(width, height);
        this.sharedDrawable.setVisible(true);
        this.sharedDrawable.display();
    }

    private void releaseShared() {
        Assert.assertNotNull(this.sharedDrawable);
        this.sharedDrawable.destroy();
        this.sharedDrawable = null;
    }

    protected GLWindow runTestGL(Animator animator, int n, int n2, boolean bl, boolean bl2) throws InterruptedException {
        GLWindow gLWindow = GLWindow.create(caps);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle("Shared Gears NEWT Test: " + n + "/" + n2 + " shared " + bl);
        if (bl) {
            gLWindow.setSharedAutoDrawable(this.sharedDrawable);
        }
        gLWindow.setSize(width, height);
        Gears gears = new Gears(bl2 ? 1 : 0);
        if (bl) {
            gears.setSharedGears(this.sharedGears);
        }
        gLWindow.addGLEventListener(gears);
        animator.add(gLWindow);
        animator.start();
        gLWindow.setVisible(true);
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLWindow, true));
        gLWindow.setPosition(n, n2);
        return gLWindow;
    }

    @Test(timeout=10000L)
    public void test01() throws InterruptedException {
        this.initShared();
        GLWindow gLWindow = this.runTestGL(new Animator(), 0, 0, true, false);
        InsetsImmutable insetsImmutable = gLWindow.getInsets();
        GLWindow gLWindow2 = this.runTestGL(new Animator(), gLWindow.getX() + width + insetsImmutable.getTotalWidth(), gLWindow.getY() + 0, true, false);
        GLWindow gLWindow3 = this.runTestGL(new Animator(), gLWindow.getX() + 0, gLWindow.getY() + height + insetsImmutable.getTotalHeight(), true, false);
        try {
            Thread.sleep(duration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gLWindow.destroy();
        gLWindow2.destroy();
        gLWindow3.destroy();
        this.releaseShared();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main(TestSharedContextListNEWT2.class.getName());
    }

    static {
        duration = 2000L;
    }
}

