/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDebugListener;
import com.jogamp.opengl.GLDebugMessage;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLDebug00NEWT
extends UITestCase {
    static String dbgTstMsg0 = "Hello World";
    static int dbgTstId0 = 42;

    static GLProfile getGLProfile(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return GLProfile.get(string);
    }

    WindowContext createWindow(GLProfile gLProfile, boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull(display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull(screen);
        Window window = NewtFactory.createWindow(screen, (CapabilitiesImmutable)gLCapabilities);
        Assert.assertNotNull(window);
        window.setSize(128, 128);
        window.setVisible(true);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLProfile);
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable(window);
        Assert.assertNotNull(gLDrawable);
        gLDrawable.setRealized(true);
        GLContext gLContext = gLDrawable.createContext(null);
        Assert.assertNotNull(gLContext);
        gLContext.enableGLDebugMessage(bl);
        int n = gLContext.makeCurrent();
        Assert.assertTrue(2 == n || 1 == n);
        return new WindowContext(window, gLContext);
    }

    void destroyWindow(WindowContext windowContext) {
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        Assert.assertNotNull(windowContext.context);
        windowContext.context.destroy();
        Assert.assertNotNull(gLDrawable);
        gLDrawable.setRealized(false);
        Assert.assertNotNull(windowContext.window);
        windowContext.window.destroy();
    }

    void testX1GLDebugEnableDisable(GLProfile gLProfile, boolean bl) throws InterruptedException {
        WindowContext windowContext = this.createWindow(gLProfile, bl);
        String string = windowContext.context.getGLDebugMessageExtension();
        System.err.println("glDebug extension: " + string);
        System.err.println("glDebug enabled: " + windowContext.context.isGLDebugMessageEnabled());
        System.err.println("glDebug sync: " + windowContext.context.isGLDebugSynchronous());
        System.err.println("context version: " + windowContext.context.getGLVersion());
        Assert.assertEquals(null == string ? false : bl, windowContext.context.isGLDebugMessageEnabled());
        this.destroyWindow(windowContext);
    }

    @Test
    public void test01GL2GL3DebugDisabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, false);
    }

    @Test
    public void test02GL2GL3DebugEnabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, true);
    }

    @Test
    public void test11GLES2DebugDisabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, false);
    }

    @Test
    public void test12GLES2DebugEnabled() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX1GLDebugEnableDisable(gLProfile, true);
    }

    void testX2GLDebugError(GLProfile gLProfile) throws InterruptedException {
        WindowContext windowContext = this.createWindow(gLProfile, true);
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(33350, 33356, 37190);
        windowContext.context.addGLDebugListener(myGLDebugListener);
        GL gL = windowContext.context.getGL();
        gL.glBindFramebuffer(-1, -1);
        if (windowContext.context.isGLDebugMessageEnabled()) {
            Assert.assertEquals(true, myGLDebugListener.received());
        }
        this.destroyWindow(windowContext);
    }

    @Test
    public void test03GL2GL3DebugError() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX2GLDebugError(gLProfile);
    }

    @Test
    public void test13GLES2DebugError() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX2GLDebugError(gLProfile);
    }

    void testX3GLDebugInsert(GLProfile gLProfile) throws InterruptedException {
        WindowContext windowContext = this.createWindow(gLProfile, true);
        MyGLDebugListener myGLDebugListener = new MyGLDebugListener(dbgTstMsg0, dbgTstId0);
        windowContext.context.addGLDebugListener(myGLDebugListener);
        String string = windowContext.context.getGLDebugMessageExtension();
        Assert.assertEquals(null != string, windowContext.context.isGLDebugMessageEnabled());
        if (windowContext.context.isGLDebugMessageEnabled()) {
            windowContext.context.glDebugMessageInsert(33354, 33361, dbgTstId0, 37191, dbgTstMsg0);
            Assert.assertEquals(true, myGLDebugListener.received());
        }
        this.destroyWindow(windowContext);
    }

    @Test
    public void test04GL2GL3DebugInsert() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GL2GL3");
        if (null == gLProfile) {
            return;
        }
        this.testX3GLDebugInsert(gLProfile);
    }

    @Test
    public void test14GLES2DebugInsert() throws InterruptedException {
        GLProfile gLProfile = TestGLDebug00NEWT.getGLProfile("GLES2");
        if (null == gLProfile) {
            return;
        }
        this.testX3GLDebugInsert(gLProfile);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestGLDebug00NEWT.class.getName();
        JUnitCore.main(string);
    }

    public static class MyGLDebugListener
    implements GLDebugListener {
        int recSource;
        int recType;
        int recSeverity;
        String recMsg;
        int recId;
        boolean received = false;

        public MyGLDebugListener(int n, int n2, int n3) {
            this.recSource = n;
            this.recType = n2;
            this.recSeverity = n3;
            this.recMsg = null;
            this.recId = -1;
        }

        public MyGLDebugListener(String string, int n) {
            this.recSource = -1;
            this.recType = -1;
            this.recSeverity = -1;
            this.recMsg = string;
            this.recId = n;
        }

        public boolean received() {
            return this.received;
        }

        @Override
        public void messageSent(GLDebugMessage gLDebugMessage) {
            System.err.println("XXX: " + gLDebugMessage);
            if (null != this.recMsg && this.recMsg.equals(gLDebugMessage.getDbgMsg()) && this.recId == gLDebugMessage.getDbgId()) {
                this.received = true;
            } else if (0 <= this.recSource && this.recSource == gLDebugMessage.getDbgSource() && this.recType == gLDebugMessage.getDbgType() && this.recSeverity == gLDebugMessage.getDbgSeverity()) {
                this.received = true;
            }
        }
    }

    public static class WindowContext {
        public final Window window;
        public final GLContext context;

        public WindowContext(Window window, GLContext gLContext) {
            this.window = window;
            this.context = gLContext;
        }
    }
}

