/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.Gears;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableFactoryGLnBitmapCapsNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull(gLOffscreenAutoDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLOffscreenAutoDrawable.getClass().getName() + ", " + gLOffscreenAutoDrawable.getNativeSurface().getClass().getName());
        Assert.assertTrue(gLOffscreenAutoDrawable.isRealized());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        System.out.println("Drawable Caps Pre_GL : " + gLCapabilitiesImmutable3);
        Assert.assertNotNull(gLCapabilitiesImmutable3);
        Assert.assertTrue(gLCapabilitiesImmutable3.getGreenBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable3.getBlueBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable3.getRedBits() > 4);
        gLOffscreenAutoDrawable.display();
        GLCapabilitiesImmutable gLCapabilitiesImmutable4 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        System.out.println("Chosen     GL CTX (1): " + gLOffscreenAutoDrawable.getContext().getGLVersion());
        System.out.println("Chosen     GL Caps(1): " + gLCapabilitiesImmutable4);
        System.out.println("Chosen     GL Caps(2): " + gLOffscreenAutoDrawable.getNativeSurface().getGraphicsConfiguration().getChosenCapabilities());
        Assert.assertNotNull(gLCapabilitiesImmutable4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getGreenBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getBlueBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getRedBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getDepthBits() > 4);
        Assert.assertEquals(gLCapabilitiesImmutable2.isOnscreen(), gLCapabilitiesImmutable4.isOnscreen());
        Assert.assertEquals(gLCapabilitiesImmutable2.isFBO(), gLCapabilitiesImmutable4.isFBO());
        Assert.assertEquals(gLCapabilitiesImmutable2.isPBuffer(), gLCapabilitiesImmutable4.isPBuffer());
        Assert.assertEquals(gLCapabilitiesImmutable2.isBitmap(), gLCapabilitiesImmutable4.isBitmap());
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListener);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLOffscreenAutoDrawable.addGLEventListener(snapshotGLEventListener);
        gLOffscreenAutoDrawable.display();
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        this.szStep = 1;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        this.szStep = 4;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        Thread.sleep(50L);
        gLOffscreenAutoDrawable.destroy();
        System.out.println("Fin Drawable: " + gLOffscreenAutoDrawable);
    }

    @Test
    public void testAvailableInfo() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        if (null != gLDrawableFactory) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getEGLFactory())) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
    }

    @Test
    public void testGL2OffScreenBitmapDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setBitmap(true);
        this.doTest(gLCapabilities, new Gears(1));
    }

    @Test
    public void testGL2OffScreenBitmapDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(GLProfile.getDefault());
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setBitmap(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new Gears(1));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main(TestGLAutoDrawableFactoryGLnBitmapCapsNEWT.class.getName());
    }
}

