/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import java.io.IOException;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLAutoDrawableFactoryES2OffscrnCapsNEWT
extends UITestCase {
    static final int widthStep = 200;
    static final int heightStep = 150;
    volatile int szStep = 2;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    void doTest(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLEventListener gLEventListener) throws InterruptedException {
        System.out.println("Requested  GL Caps: " + gLCapabilitiesImmutable);
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
        GLCapabilitiesImmutable gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixGLCapabilities(gLCapabilitiesImmutable, gLDrawableFactory, null);
        System.out.println("Expected   GL Caps: " + gLCapabilitiesImmutable2);
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 200 * this.szStep, 150 * this.szStep);
        Assert.assertNotNull(gLOffscreenAutoDrawable);
        System.out.println("Drawable    Pre-GL(0): " + gLOffscreenAutoDrawable.getClass().getName() + ", " + gLOffscreenAutoDrawable.getNativeSurface().getClass().getName());
        Assert.assertTrue(gLOffscreenAutoDrawable.isRealized());
        GLCapabilitiesImmutable gLCapabilitiesImmutable3 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        System.out.println("Drawable Caps Pre_GL : " + gLCapabilitiesImmutable3);
        Assert.assertNotNull(gLCapabilitiesImmutable3);
        Assert.assertTrue(gLCapabilitiesImmutable3.getGreenBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable3.getBlueBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable3.getRedBits() > 4);
        gLOffscreenAutoDrawable.display();
        GLCapabilitiesImmutable gLCapabilitiesImmutable4 = gLOffscreenAutoDrawable.getChosenGLCapabilities();
        System.out.println("Chosen     GL CTX (1): " + gLOffscreenAutoDrawable.getContext().getGLVersion());
        System.out.println("Chosen     GL Caps(1): " + gLCapabilitiesImmutable4);
        System.out.println("Chosen     GL Caps(2): " + gLOffscreenAutoDrawable.getNativeSurface().getGraphicsConfiguration().getChosenCapabilities());
        Assert.assertNotNull(gLCapabilitiesImmutable4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getGreenBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getBlueBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getRedBits() > 4);
        Assert.assertTrue(gLCapabilitiesImmutable4.getDepthBits() > 4);
        Assert.assertEquals(gLCapabilitiesImmutable2.isOnscreen(), gLCapabilitiesImmutable4.isOnscreen());
        Assert.assertEquals(gLCapabilitiesImmutable2.isFBO(), gLCapabilitiesImmutable4.isFBO());
        Assert.assertEquals(gLCapabilitiesImmutable2.isPBuffer(), gLCapabilitiesImmutable4.isPBuffer());
        Assert.assertEquals(gLCapabilitiesImmutable2.isBitmap(), gLCapabilitiesImmutable4.isBitmap());
        gLOffscreenAutoDrawable.addGLEventListener(gLEventListener);
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        gLOffscreenAutoDrawable.addGLEventListener(snapshotGLEventListener);
        gLOffscreenAutoDrawable.display();
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        this.szStep = 1;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        this.szStep = 4;
        gLOffscreenAutoDrawable.setSurfaceSize(200 * this.szStep, 150 * this.szStep);
        Assert.assertTrue("Size not reached: Expected " + 200 * this.szStep + "x" + 150 * this.szStep + ", Is " + gLOffscreenAutoDrawable.getSurfaceWidth() + "x" + gLOffscreenAutoDrawable.getSurfaceHeight(), AWTRobotUtil.waitForSize(gLOffscreenAutoDrawable, 200 * this.szStep, 150 * this.szStep));
        snapshotGLEventListener.setMakeSnapshot();
        gLOffscreenAutoDrawable.display();
        Thread.sleep(50L);
        gLOffscreenAutoDrawable.destroy();
        System.out.println("Fin Drawable: " + gLOffscreenAutoDrawable);
    }

    @Test
    public void testAvailableInfo() {
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getDesktopFactory();
        if (null != gLDrawableFactory) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
        if (null != (gLDrawableFactory = GLDrawableFactory.getEGLFactory())) {
            System.err.println(JoglVersion.getDefaultOpenGLInfo(gLDrawableFactory.getDefaultDevice(), null, true).toString());
        }
    }

    @Test
    public void testES2OffScreenAutoDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBOSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenFBODblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setFBO(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferSglBuf() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setDoubleBuffered(false);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBufStencil() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setStencilBits(1);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBufMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    @Test
    public void testES2OffScreenPbufferDblBufStencilMSAA() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        gLCapabilities.setOnscreen(false);
        gLCapabilities.setPBuffer(true);
        gLCapabilities.setStencilBits(1);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        this.doTest(gLCapabilities, new GearsES2(1));
    }

    public static void main(String[] stringArray) throws IOException {
        JUnitCore.main(TestGLAutoDrawableFactoryES2OffscrnCapsNEWT.class.getName());
    }
}

