/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.JoglVersion;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class GLProfile0XBase
extends UITestCase {
    protected static void validateGLProfileGL4bc(GLProfile gLProfile) {
        Assert.assertTrue(gLProfile.isGL4bc());
        Assert.assertTrue(gLProfile.isGL4());
        Assert.assertTrue(gLProfile.isGL3bc());
        Assert.assertTrue(gLProfile.isGL3());
        Assert.assertTrue(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertFalse(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertTrue(gLProfile.isGL2GL3());
        Assert.assertTrue(gLProfile.isGL4ES3());
        Assert.assertTrue(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertTrue(gLProfile.isGL2ES1());
    }

    protected static void validateGL4bc(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertTrue(gL.isGL4bc());
        Assert.assertTrue(gL.isGL4());
        Assert.assertTrue(gL.isGL3bc());
        Assert.assertTrue(gL.isGL3());
        Assert.assertTrue(gL.isGL2());
        Assert.assertTrue(gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gL.isGL4ES3());
        } else {
            Assert.assertFalse(gL.isGL4ES3());
        }
        Assert.assertTrue(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertTrue(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertFalse(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertTrue(gLContext.isGL4bc());
        Assert.assertTrue(gLContext.isGL4());
        Assert.assertTrue(gLContext.isGL3bc());
        Assert.assertTrue(gLContext.isGL3());
        Assert.assertTrue(gLContext.isGL2());
        Assert.assertTrue(gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gLContext.isGL4ES3());
        } else {
            Assert.assertFalse(gLContext.isGL4ES3());
        }
        Assert.assertTrue(gLContext.isGL3ES3());
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertTrue(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertFalse(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGL4(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertTrue(gLProfile.isGL4());
        Assert.assertFalse(gLProfile.isGL3bc());
        Assert.assertTrue(gLProfile.isGL3());
        Assert.assertFalse(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertFalse(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertTrue(gLProfile.isGL2GL3());
        Assert.assertTrue(gLProfile.isGL4ES3());
        Assert.assertTrue(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertFalse(gLProfile.isGL2ES1());
    }

    protected static void validateGL4(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertTrue(gL.isGL4());
        Assert.assertFalse(gL.isGL3bc());
        Assert.assertTrue(gL.isGL3());
        Assert.assertFalse(gL.isGL2());
        Assert.assertTrue(gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gL.isGL4ES3());
        } else {
            Assert.assertFalse(gL.isGL4ES3());
        }
        Assert.assertTrue(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertFalse(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertFalse(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertTrue(gLContext.isGL4());
        Assert.assertFalse(gLContext.isGL3bc());
        Assert.assertTrue(gLContext.isGL3());
        Assert.assertFalse(gLContext.isGL2());
        Assert.assertTrue(gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gLContext.isGL4ES3());
        } else {
            Assert.assertFalse(gLContext.isGL4ES3());
        }
        Assert.assertTrue(gLContext.isGL3ES3());
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertFalse(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertFalse(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGL3bc(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertFalse(gLProfile.isGL4());
        Assert.assertTrue(gLProfile.isGL3bc());
        Assert.assertTrue(gLProfile.isGL3());
        Assert.assertTrue(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertFalse(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertTrue(gLProfile.isGL2GL3());
        Assert.assertFalse(gLProfile.isGL4ES3());
        Assert.assertTrue(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertTrue(gLProfile.isGL2ES1());
    }

    protected static void validateGL3bc(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertFalse(gL.isGL4());
        Assert.assertTrue(gL.isGL3bc());
        Assert.assertTrue(gL.isGL3());
        Assert.assertTrue(gL.isGL2());
        Assert.assertTrue(gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gL.isGL4ES3());
        } else {
            Assert.assertFalse(gL.isGL4ES3());
        }
        Assert.assertTrue(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertTrue(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertFalse(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertFalse(gLContext.isGL4());
        Assert.assertTrue(gLContext.isGL3bc());
        Assert.assertTrue(gLContext.isGL3());
        Assert.assertTrue(gLContext.isGL2());
        Assert.assertTrue(gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gLContext.isGL4ES3());
        } else {
            Assert.assertFalse(gLContext.isGL4ES3());
        }
        Assert.assertTrue(gLContext.isGL3ES3());
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertTrue(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertFalse(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGL3(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertFalse(gLProfile.isGL4());
        Assert.assertFalse(gLProfile.isGL3bc());
        Assert.assertTrue(gLProfile.isGL3());
        Assert.assertFalse(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertFalse(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertTrue(gLProfile.isGL2GL3());
        Assert.assertFalse(gLProfile.isGL4ES3());
        Assert.assertTrue(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertFalse(gLProfile.isGL2ES1());
    }

    protected static void validateGL3(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertFalse(gL.isGL4());
        Assert.assertFalse(gL.isGL3bc());
        Assert.assertTrue(gL.isGL3());
        Assert.assertFalse(gL.isGL2());
        Assert.assertTrue(gL.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gL.isGL4ES3());
        } else {
            Assert.assertFalse(gL.isGL4ES3());
        }
        Assert.assertTrue(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertFalse(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertFalse(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertFalse(gLContext.isGL4());
        Assert.assertFalse(gLContext.isGL3bc());
        Assert.assertTrue(gLContext.isGL3());
        Assert.assertFalse(gLContext.isGL2());
        Assert.assertTrue(gLContext.isGL2GL3());
        if (bl) {
            Assert.assertTrue(gLContext.isGL4ES3());
        } else {
            Assert.assertFalse(gLContext.isGL4ES3());
        }
        Assert.assertTrue(gLContext.isGL3ES3());
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertFalse(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertFalse(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGL2(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertFalse(gLProfile.isGL4());
        Assert.assertFalse(gLProfile.isGL3bc());
        Assert.assertFalse(gLProfile.isGL3());
        Assert.assertTrue(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertFalse(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertTrue(gLProfile.isGL2GL3());
        Assert.assertFalse(gLProfile.isGL4ES3());
        Assert.assertFalse(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertTrue(gLProfile.isGL2ES1());
    }

    protected static void validateGL2(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertFalse(gL.isGL4());
        Assert.assertFalse(gL.isGL3bc());
        Assert.assertFalse(gL.isGL3());
        Assert.assertTrue(gL.isGL2());
        Assert.assertTrue(gL.isGL2GL3());
        Assert.assertFalse(gL.isGL4ES3());
        Assert.assertFalse(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertTrue(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertFalse(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertFalse(gLContext.isGL4());
        Assert.assertFalse(gLContext.isGL3bc());
        Assert.assertFalse(gLContext.isGL3());
        Assert.assertTrue(gLContext.isGL2());
        Assert.assertTrue(gLContext.isGL2GL3());
        Assert.assertFalse(gLContext.isGL4ES3());
        Assert.assertFalse(gLContext.isGL3ES3());
        Assert.assertFalse(bl);
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertTrue(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertFalse(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGLES3(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertFalse(gLProfile.isGL4());
        Assert.assertFalse(gLProfile.isGL3bc());
        Assert.assertFalse(gLProfile.isGL3());
        Assert.assertFalse(gLProfile.isGL2());
        Assert.assertTrue(gLProfile.isGLES3());
        Assert.assertTrue(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertFalse(gLProfile.isGL2GL3());
        Assert.assertTrue(gLProfile.isGL4ES3());
        Assert.assertTrue(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertFalse(gLProfile.isGL2ES1());
    }

    protected static void validateGLES3(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertFalse(gL.isGL4());
        Assert.assertFalse(gL.isGL3bc());
        Assert.assertFalse(gL.isGL3());
        Assert.assertFalse(gL.isGL2());
        Assert.assertFalse(gL.isGL2GL3());
        Assert.assertTrue(gL.isGL4ES3());
        Assert.assertTrue(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertFalse(gL.isGL2ES1());
        Assert.assertTrue(gL.isGLES3());
        Assert.assertTrue(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertFalse(gLContext.isGL4());
        Assert.assertFalse(gLContext.isGL3bc());
        Assert.assertFalse(gLContext.isGL3());
        Assert.assertFalse(gLContext.isGL2());
        Assert.assertFalse(gLContext.isGL2GL3());
        Assert.assertTrue(gLContext.isGL4ES3());
        Assert.assertTrue(gLContext.isGL3ES3());
        Assert.assertTrue(bl);
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertFalse(gLContext.isGL2ES1());
        Assert.assertTrue(gLContext.isGLES3());
        Assert.assertTrue(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGLES2(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertFalse(gLProfile.isGL4());
        Assert.assertFalse(gLProfile.isGL3bc());
        Assert.assertFalse(gLProfile.isGL3());
        Assert.assertFalse(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertTrue(gLProfile.isGLES2());
        Assert.assertFalse(gLProfile.isGLES1());
        Assert.assertFalse(gLProfile.isGL2GL3());
        Assert.assertFalse(gLProfile.isGL4ES3());
        Assert.assertFalse(gLProfile.isGL3ES3());
        Assert.assertTrue(gLProfile.isGL2ES2());
        Assert.assertFalse(gLProfile.isGL2ES1());
    }

    protected static void validateGLES2(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertFalse(gL.isGL4());
        Assert.assertFalse(gL.isGL3bc());
        Assert.assertFalse(gL.isGL3());
        Assert.assertFalse(gL.isGL2());
        Assert.assertFalse(gL.isGL2GL3());
        Assert.assertFalse(gL.isGL4ES3());
        Assert.assertFalse(gL.isGL3ES3());
        Assert.assertTrue(gL.isGL2ES2());
        Assert.assertFalse(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertTrue(gL.isGLES2());
        Assert.assertFalse(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertFalse(gLContext.isGL4());
        Assert.assertFalse(gLContext.isGL3bc());
        Assert.assertFalse(gLContext.isGL3());
        Assert.assertFalse(gLContext.isGL2());
        Assert.assertFalse(gLContext.isGL2GL3());
        Assert.assertFalse(gLContext.isGL4ES3());
        Assert.assertFalse(gLContext.isGL3ES3());
        Assert.assertFalse(bl);
        Assert.assertTrue(gLContext.isGL2ES2());
        Assert.assertFalse(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertTrue(gLContext.isGLES2());
        Assert.assertFalse(gLContext.isGLES1());
    }

    protected static void validateGLProfileGLES1(GLProfile gLProfile) {
        Assert.assertFalse(gLProfile.isGL4bc());
        Assert.assertFalse(gLProfile.isGL4());
        Assert.assertFalse(gLProfile.isGL3bc());
        Assert.assertFalse(gLProfile.isGL3());
        Assert.assertFalse(gLProfile.isGL2());
        Assert.assertFalse(gLProfile.isGLES3());
        Assert.assertFalse(gLProfile.isGLES2());
        Assert.assertTrue(gLProfile.isGLES1());
        Assert.assertFalse(gLProfile.isGL2GL3());
        Assert.assertFalse(gLProfile.isGL4ES3());
        Assert.assertFalse(gLProfile.isGL3ES3());
        Assert.assertFalse(gLProfile.isGL2ES2());
        Assert.assertTrue(gLProfile.isGL2ES1());
    }

    protected static void validateGLES1(GL gL) {
        GLContext gLContext = gL.getContext();
        boolean bl = gLContext.isGLES3Compatible();
        Assert.assertFalse(gL.isGL4bc());
        Assert.assertFalse(gL.isGL4());
        Assert.assertFalse(gL.isGL3bc());
        Assert.assertFalse(gL.isGL3());
        Assert.assertFalse(gL.isGL2());
        Assert.assertFalse(gL.isGL2GL3());
        Assert.assertFalse(gL.isGL4ES3());
        Assert.assertFalse(gL.isGL3ES3());
        Assert.assertFalse(gL.isGL2ES2());
        Assert.assertTrue(gL.isGL2ES1());
        Assert.assertFalse(gL.isGLES3());
        Assert.assertFalse(gL.isGLES2());
        Assert.assertTrue(gL.isGLES1());
        Assert.assertFalse(gLContext.isGL4bc());
        Assert.assertFalse(gLContext.isGL4());
        Assert.assertFalse(gLContext.isGL3bc());
        Assert.assertFalse(gLContext.isGL3());
        Assert.assertFalse(gLContext.isGL2());
        Assert.assertFalse(gLContext.isGL2GL3());
        Assert.assertFalse(gLContext.isGL4ES3());
        Assert.assertFalse(gLContext.isGL3ES3());
        Assert.assertFalse(bl);
        Assert.assertFalse(gLContext.isGL2ES2());
        Assert.assertTrue(gLContext.isGL2ES1());
        Assert.assertFalse(gLContext.isGLES3());
        Assert.assertFalse(gLContext.isGLES2());
        Assert.assertTrue(gLContext.isGLES1());
    }

    protected static void validateGLProfileGL2GL3(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGL3()) {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else {
            throw new GLException("GL2GL3 is neither GL4bc, GL3bc, GL2, GL4 nor GL3");
        }
    }

    protected static void validateGL2GL3(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGL3()) {
            GLProfile0XBase.validateGL3(gL);
        } else {
            throw new GLException("GL2GL3 is neither GL4bc, GL3bc, GL2, GL4 nor GL3");
        }
    }

    protected static void validateGLProfileGL4ES3(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGLES3()) {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else {
            throw new GLException("GL4ES3 is neither GL4bc, GL4 nor GLES3");
        }
    }

    protected static void validateGL4ES3(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGLES3()) {
            GLProfile0XBase.validateGLES3(gL);
        } else {
            throw new GLException("GL4ES3 is neither GL4bc, GL4 nor GLES3");
        }
    }

    protected static void validateGLProfileGL2ES2(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGL3()) {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else if (gLProfile.isGLES3()) {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else if (gLProfile.isGLES2()) {
            GLProfile0XBase.validateGLProfileGLES2(gLProfile);
        } else {
            throw new GLException("GL2ES2 is neither GL4bc, GL3bc, GL2, GL4, GL3, GLES3 nor GLES2");
        }
    }

    protected static void validateGL2ES2(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGL3()) {
            GLProfile0XBase.validateGL3(gL);
        } else if (gL.isGLES3()) {
            GLProfile0XBase.validateGLES3(gL);
        } else if (gL.isGLES2()) {
            GLProfile0XBase.validateGLES2(gL);
        } else {
            throw new GLException("GL2ES2 is neither GL4bc, GL3bc, GL2, GL4, GL3, GLES3 nor GLES2");
        }
    }

    protected static void validateGLProfileGL2ES1(GLProfile gLProfile) {
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGLES1()) {
            GLProfile0XBase.validateGLProfileGLES1(gLProfile);
        } else {
            throw new GLException("GL2ES1 is neither GL4bc, GL3bc, GL2 nor GLES1");
        }
    }

    protected static void validateGL2ES1(GL gL) {
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGLES1()) {
            GLProfile0XBase.validateGLES1(gL);
        } else {
            throw new GLException("GL2ES1 is neither GL4bc, GL3bc, GL2 nor GLES1");
        }
    }

    protected static void validateOffline(String string, GLProfile gLProfile) {
        System.err.println("GLProfile Mapping " + string + " -> " + gLProfile);
        boolean bl = GLContext.isGLES3CompatibleAvailable(GLProfile.getDefaultDevice());
        if (gLProfile.getImplName().equals("GL4bc")) {
            Assert.assertTrue(GLProfile.isAvailable("GL4bc"));
            Assert.assertTrue(GLProfile.isAvailable("GL4"));
            Assert.assertTrue(GLProfile.isAvailable("GL3bc"));
            Assert.assertTrue(GLProfile.isAvailable("GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2"));
            Assert.assertTrue(GLProfile.isAvailable("GL2GL3"));
            if (bl) {
                Assert.assertTrue(GLProfile.isAvailable("GL4ES3"));
            } else {
                Assert.assertFalse(GLProfile.isAvailable("GL4ES3"));
            }
            Assert.assertTrue(GLProfile.isAvailable("GL2ES1"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL3bc")) {
            Assert.assertTrue(GLProfile.isAvailable("GL3bc"));
            Assert.assertTrue(GLProfile.isAvailable("GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2"));
            Assert.assertTrue(GLProfile.isAvailable("GL2GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES1"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL2")) {
            Assert.assertTrue(GLProfile.isAvailable("GL2"));
            Assert.assertTrue(GLProfile.isAvailable("GL2GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES1"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL4")) {
            Assert.assertTrue(GLProfile.isAvailable("GL4"));
            Assert.assertTrue(GLProfile.isAvailable("GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2GL3"));
            if (bl) {
                Assert.assertTrue(GLProfile.isAvailable("GL4ES3"));
            } else {
                Assert.assertFalse(GLProfile.isAvailable("GL4ES3"));
            }
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GL3")) {
            Assert.assertTrue(GLProfile.isAvailable("GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2GL3"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GLES3")) {
            Assert.assertTrue(GLProfile.isAvailable("GLES3"));
            if (bl) {
                Assert.assertTrue(GLProfile.isAvailable("GL4ES3"));
            } else {
                Assert.assertFalse(GLProfile.isAvailable("GL4ES3"));
            }
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GLES2")) {
            Assert.assertTrue(GLProfile.isAvailable("GLES2"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES2"));
        } else if (gLProfile.getImplName().equals("GLES1")) {
            Assert.assertTrue(GLProfile.isAvailable("GLES1"));
            Assert.assertTrue(GLProfile.isAvailable("GL2ES1"));
        }
        if (gLProfile.isGL4bc()) {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (gLProfile.isGL3bc()) {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (gLProfile.isGL2()) {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (gLProfile.isGL4()) {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (gLProfile.isGL3()) {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else if (gLProfile.isGLES3()) {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else if (gLProfile.isGLES2()) {
            GLProfile0XBase.validateGLProfileGLES2(gLProfile);
        } else if (gLProfile.isGLES1()) {
            GLProfile0XBase.validateGLProfileGLES1(gLProfile);
        }
        if (string == "GL4bc") {
            GLProfile0XBase.validateGLProfileGL4bc(gLProfile);
        } else if (string == "GL3bc") {
            GLProfile0XBase.validateGLProfileGL3bc(gLProfile);
        } else if (string == "GL2") {
            GLProfile0XBase.validateGLProfileGL2(gLProfile);
        } else if (string == "GL4") {
            GLProfile0XBase.validateGLProfileGL4(gLProfile);
        } else if (string == "GL3") {
            GLProfile0XBase.validateGLProfileGL3(gLProfile);
        } else if (string == "GLES3") {
            GLProfile0XBase.validateGLProfileGLES3(gLProfile);
        } else if (string == "GLES2") {
            GLProfile0XBase.validateGLProfileGLES2(gLProfile);
        } else if (string == "GLES1") {
            GLProfile0XBase.validateGLProfileGLES1(gLProfile);
        } else if (string == "GL2GL3") {
            GLProfile0XBase.validateGLProfileGL2GL3(gLProfile);
        } else if (string == "GL4ES3") {
            GLProfile0XBase.validateGLProfileGL4ES3(gLProfile);
        } else if (string == "GL2ES2") {
            GLProfile0XBase.validateGLProfileGL2ES2(gLProfile);
        } else if (string == "GL2ES1") {
            GLProfile0XBase.validateGLProfileGL2ES1(gLProfile);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void validateOnline(String string, GLProfile gLProfile, GL gL) {
        GLContext gLContext = gL.getContext();
        GLProfile gLProfile2 = gL.getGLProfile();
        System.err.println("GLContext Mapping " + string + " -> " + gLProfile + " -> " + gLProfile2 + " -> " + gLContext.getGLVersion());
        System.err.println("GL impl. class " + gL.getClass().getName());
        if (gL.isGL4()) {
            Assert.assertNotNull(gL.getGL4());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL4");
        }
        if (gL.isGL4bc()) {
            Assert.assertNotNull(gL.getGL4bc());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL4bc");
        }
        if (gL.isGL3()) {
            Assert.assertNotNull(gL.getGL3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL3");
        }
        if (gL.isGL3bc()) {
            Assert.assertNotNull(gL.getGL3bc());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL3bc");
        }
        if (gL.isGL2()) {
            Assert.assertNotNull(gL.getGL2());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2");
        }
        if (gL.isGLES3()) {
            Assert.assertNotNull(gL.getGLES3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GLES3");
        }
        if (gL.isGLES2()) {
            Assert.assertNotNull(gL.getGLES2());
            System.err.println("GL Mapping " + gLProfile2 + " -> GLES2");
        }
        if (gL.isGLES1()) {
            Assert.assertNotNull(gL.getGLES1());
            System.err.println("GL Mapping " + gLProfile2 + " -> GLES1");
        }
        if (gL.isGL4ES3()) {
            Assert.assertNotNull(gL.getGL4ES3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL4ES3");
        }
        if (gL.isGL3ES3()) {
            Assert.assertNotNull(gL.getGL3ES3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL3ES3");
        }
        if (gL.isGL2GL3()) {
            Assert.assertNotNull(gL.getGL2GL3());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2GL3");
        }
        if (gL.isGL2ES2()) {
            Assert.assertNotNull(gL.getGL2ES2());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2ES2");
        }
        if (gL.isGL2ES1()) {
            Assert.assertNotNull(gL.getGL2ES1());
            System.err.println("GL Mapping " + gLProfile2 + " -> GL2ES1");
        }
        if (gL.isGL4bc()) {
            GLProfile0XBase.validateGL4bc(gL);
        } else if (gL.isGL3bc()) {
            GLProfile0XBase.validateGL3bc(gL);
        } else if (gL.isGL2()) {
            GLProfile0XBase.validateGL2(gL);
        } else if (gL.isGL4()) {
            GLProfile0XBase.validateGL4(gL);
        } else if (gL.isGL3()) {
            GLProfile0XBase.validateGL3(gL);
        } else if (gL.isGLES3()) {
            GLProfile0XBase.validateGLES3(gL);
        } else if (gL.isGLES2()) {
            GLProfile0XBase.validateGLES2(gL);
        } else if (gL.isGLES1()) {
            GLProfile0XBase.validateGLES1(gL);
        }
        if (string == "GL4bc") {
            GLProfile0XBase.validateGL4bc(gL);
            return;
        } else if (string == "GL3bc") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else {
                if (!gL.isGL3bc()) throw new GLException("GL3bc is neither GL4bc nor GL3bc");
                GLProfile0XBase.validateGL3bc(gL);
            }
            return;
        } else if (string == "GL2") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else if (gL.isGL3bc()) {
                GLProfile0XBase.validateGL3bc(gL);
                return;
            } else {
                if (!gL.isGL2()) throw new GLException("GL2 is neither GL4bc, GL3bc, GL2");
                GLProfile0XBase.validateGL2(gL);
            }
            return;
        } else if (string == "GL4") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else {
                if (!gL.isGL4()) throw new GLException("GL4 is neither GL4bc, nor GL4");
                GLProfile0XBase.validateGL4(gL);
            }
            return;
        } else if (string == "GL3") {
            if (gL.isGL4bc()) {
                GLProfile0XBase.validateGL4bc(gL);
                return;
            } else if (gL.isGL3bc()) {
                GLProfile0XBase.validateGL3bc(gL);
                return;
            } else if (gL.isGL4()) {
                GLProfile0XBase.validateGL4(gL);
                return;
            } else {
                if (!gL.isGL3()) throw new GLException("GL3 is neither GL4bc, GL3bc, GL4 nor GL3");
                GLProfile0XBase.validateGL3(gL);
            }
            return;
        } else if (string == "GLES3") {
            GLProfile0XBase.validateGLES3(gL);
            return;
        } else if (string == "GLES2") {
            if (gL.isGLES3()) {
                GLProfile0XBase.validateGLES3(gL);
                return;
            } else {
                if (!gL.isGLES2()) throw new GLException("GLES2 is neither GLES3 nor GLES2");
                GLProfile0XBase.validateGLES2(gL);
            }
            return;
        } else if (string == "GLES1") {
            GLProfile0XBase.validateGLES1(gL);
            return;
        } else if (string == "GL2GL3") {
            GLProfile0XBase.validateGL2GL3(gL);
            return;
        } else if (string == "GL4ES3") {
            GLProfile0XBase.validateGL4ES3(gL);
            return;
        } else if (string == "GL2ES2") {
            GLProfile0XBase.validateGL2ES2(gL);
            return;
        } else {
            if (string != "GL2ES1") return;
            GLProfile0XBase.validateGL2ES1(gL);
        }
    }

    protected void validateOnlineOnscreen(final String string, final GLProfile gLProfile) throws InterruptedException {
        boolean bl;
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        Assert.assertNotNull(gLWindow);
        gLWindow.setTitle(this.getSimpleTestName("."));
        gLWindow.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLStrings(gL, null, false));
                GLProfile0XBase.validateOnline(string, gLProfile, gL);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLWindow.setSize(128, 128);
        gLWindow.setVisible(true);
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, true));
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLWindow, true));
        gLWindow.display();
        Thread.sleep(100L);
        boolean bl2 = Platform.OSType.MACOS == Platform.getOSType();
        boolean bl3 = bl = null != System.getProperty("jogl.disable.openglarbcontext") && !bl2;
        if (bl) {
            Assert.assertFalse("Property 'jogl.disable.openglarbcontext' set, but created w/ ARB", gLWindow.getContext().isCreatedWithARBMethod());
        }
        gLWindow.destroy();
        Assert.assertTrue(AWTRobotUtil.waitForVisible(gLWindow, false));
        Assert.assertTrue(AWTRobotUtil.waitForRealized(gLWindow, false));
    }

    protected void validateOnlineOffscreen(final String string, final GLCapabilitiesImmutable gLCapabilitiesImmutable) throws InterruptedException {
        boolean bl;
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilitiesImmutable.getGLProfile());
        GLOffscreenAutoDrawable gLOffscreenAutoDrawable = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilitiesImmutable, null, 128, 128);
        Assert.assertNotNull(gLOffscreenAutoDrawable);
        gLOffscreenAutoDrawable.addGLEventListener(new GLEventListener(){

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
                GL gL = gLAutoDrawable.getGL();
                System.err.println(JoglVersion.getGLStrings(gL, null, false));
                GLProfile0XBase.validateOnline(string, gLCapabilitiesImmutable.getGLProfile(), gL);
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }
        });
        gLOffscreenAutoDrawable.display();
        Thread.sleep(100L);
        boolean bl2 = Platform.OSType.MACOS == Platform.getOSType();
        boolean bl3 = bl = PropertyAccess.isPropertyDefined("jogl.disable.openglarbcontext", true) && !bl2;
        if (bl) {
            Assert.assertFalse("Property 'jogl.disable.openglarbcontext' set, but created w/ ARB", gLOffscreenAutoDrawable.getContext().isCreatedWithARBMethod());
        }
        gLOffscreenAutoDrawable.destroy();
    }
}

