/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;
import jogamp.graph.geom.plane.AffineTransform;

public abstract class RoundButton
extends UIShape {
    public static final float DEFAULT_CORNER = 1.0f;
    protected float width;
    protected float height;
    protected float corner = 1.0f;
    protected final AffineTransform tempT1 = new AffineTransform();
    protected final AffineTransform tempT2 = new AffineTransform();

    protected RoundButton(Vertex.Factory<? extends Vertex> factory, int n, float f, float f2) {
        super(factory, n);
        this.width = f;
        this.height = f2;
    }

    @Override
    protected void clearImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getCorner() {
        return this.corner;
    }

    public void setDimension(float f, float f2) {
        this.width = f;
        this.height = f2;
        this.markShapeDirty();
    }

    protected void createSharpOutline(OutlineShape outlineShape, float f) {
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = f;
        outlineShape.addVertex(0.0f, 0.0f, f4, true);
        outlineShape.addVertex(0.0f + f2, 0.0f, f4, true);
        outlineShape.addVertex(0.0f + f2, 0.0f + f3, f4, true);
        outlineShape.addVertex(0.0f, 0.0f + f3, f4, true);
        outlineShape.closeLastOutline(true);
    }

    protected void createCurvedOutline(OutlineShape outlineShape, float f) {
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        float f4 = 0.5f * this.corner * Math.min(f2, f3);
        float f5 = f;
        outlineShape.addVertex(0.0f, 0.0f + f4, f5, true);
        outlineShape.addVertex(0.0f, 0.0f, f5, false);
        outlineShape.addVertex(0.0f + f4, 0.0f, f5, true);
        outlineShape.addVertex(0.0f + f2 - f4, 0.0f, f5, true);
        outlineShape.addVertex(0.0f + f2, 0.0f, f5, false);
        outlineShape.addVertex(0.0f + f2, 0.0f + f4, f5, true);
        outlineShape.addVertex(0.0f + f2, 0.0f + f3 - f4, f5, true);
        outlineShape.addVertex(0.0f + f2, 0.0f + f3, f5, false);
        outlineShape.addVertex(0.0f + f2 - f4, 0.0f + f3, f5, true);
        outlineShape.addVertex(0.0f + f4, 0.0f + f3, f5, true);
        outlineShape.addVertex(0.0f, 0.0f + f3, f5, false);
        outlineShape.addVertex(0.0f, 0.0f + f3 - f4, f5, true);
        outlineShape.closeLastOutline(true);
    }

    public void setCorner(float f) {
        this.corner = f > 1.0f ? 1.0f : (f < 0.01f ? 0.0f : f);
        this.markShapeDirty();
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", dim " + this.getWidth() + "x" + this.getHeight() + ", corner " + this.corner;
    }
}

