/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;

public class CrossHair
extends UIShape {
    private float width;
    private float height;
    private float lineWidth;

    public CrossHair(Vertex.Factory<? extends Vertex> factory, int n, float f, float f2, float f3) {
        super(factory, n);
        this.width = f;
        this.height = f2;
        this.lineWidth = f3;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getLineWidth() {
        return this.lineWidth;
    }

    public void setDimension(float f, float f2, float f3) {
        this.width = f;
        this.height = f2;
        this.lineWidth = f3;
        this.markShapeDirty();
    }

    @Override
    protected void clearImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    @Override
    protected void addShapeToRegion(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        OutlineShape outlineShape = new OutlineShape(regionRenderer.getRenderState().getVertexFactory());
        float f = this.getWidth();
        float f2 = this.getHeight();
        float f3 = f / 2.0f;
        float f4 = f2 / 2.0f;
        float f5 = this.lineWidth / 2.0f;
        float f6 = 0.0f;
        outlineShape.addVertex(0.0f - f5, 0.0f - f4, f6, true);
        outlineShape.addVertex(0.0f + f5, 0.0f - f4, f6, true);
        outlineShape.addVertex(0.0f + f5, 0.0f + f4, f6, true);
        outlineShape.addVertex(0.0f - f5, 0.0f + f4, f6, true);
        outlineShape.closeLastOutline(true);
        outlineShape.addEmptyOutline();
        outlineShape.addVertex(0.0f - f3, 0.0f - f5, f6 -= 0.05f, true);
        outlineShape.addVertex(0.0f + f3, 0.0f - f5, f6, true);
        outlineShape.addVertex(0.0f + f3, 0.0f + f5, f6, true);
        outlineShape.addVertex(0.0f - f3, 0.0f + f5, f6, true);
        outlineShape.closeLastOutline(true);
        outlineShape.setIsQuadraticNurbs();
        outlineShape.setSharpness(this.shapesSharpness);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        this.box.resize(outlineShape.getBounds());
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", dim " + this.getWidth() + "x" + this.getHeight();
    }
}

