/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos;

import com.jogamp.common.net.Uri;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.SVertex;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.GestureHandler;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.PinchToZoomGesture;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.test.junit.graph.demos.ui.CrossHair;
import com.jogamp.opengl.test.junit.graph.demos.ui.GLEventListenerButton;
import com.jogamp.opengl.test.junit.graph.demos.ui.ImageSeqButton;
import com.jogamp.opengl.test.junit.graph.demos.ui.Label;
import com.jogamp.opengl.test.junit.graph.demos.ui.LabelButton;
import com.jogamp.opengl.test.junit.graph.demos.ui.MediaPlayerButton;
import com.jogamp.opengl.test.junit.graph.demos.ui.RoundButton;
import com.jogamp.opengl.test.junit.graph.demos.ui.SceneUIController;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.GLMediaPlayerFactory;
import com.jogamp.opengl.util.texture.ImageSequence;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GPUUISceneGLListener0A
implements GLEventListener {
    private boolean debug = false;
    private boolean trace = false;
    private final float noAADPIThreshold;
    private final RenderState rs;
    private final SceneUIController sceneUIController;
    private int renderModes;
    private RegionRenderer renderer;
    private final int fontSet = 0;
    private Font font;
    private final float sceneDist = 3000.0f;
    private final float zNear = 0.1f;
    private final float zFar = 7000.0f;
    private final float relTop = 0.8333333f;
    private final float relMiddle = 0.33333334f;
    private final float relLeft = 0.16666667f;
    private final float buttonYSizePVP = 0.084f;
    private final float buttonXSizePVP = 0.105f;
    private final float fontSizePt = 10.0f;
    private final float fontSizeFixedPVP = 0.046f;
    private final float fontSizeFpsPVP = 0.038f;
    private float dpiH = 96.0f;
    public static final float DefaultNoAADPIThreshold = 200.0f;
    private int currentText = 0;
    private String actionText = null;
    private Label[] labels = null;
    private String[] strings = null;
    private final List<RoundButton> buttons = new ArrayList<RoundButton>();
    private int buttonsLeftCount = 0;
    private Label truePtSizeLabel = null;
    private Label jogampLabel = null;
    private Label fpsLabel = null;
    private CrossHair crossHairCtr = null;
    private boolean ioAttached = false;
    private GLAutoDrawable cDrawable;
    private final GLReadBufferUtil screenshot;
    private final String jogamp = "JogAmp - Jogl Graph Module Demo";
    private final String truePtSize = "10.0 pt font size label - true scale!";
    final boolean enableOthers = true;
    private int shotCount = 0;
    float lastWidth = 0.0f;
    float lastHeight = 0.0f;
    private final UIShape.MouseGestureAdapter dragZoomRotateListener = new UIShape.MouseGestureAdapter(){
        float dragFirstX = -1.0f;
        float dragFirstY = -1.0f;
        boolean dragFirst = false;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.dragFirst = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragFirst = false;
            GPUUISceneGLListener0A.this.actionText = null;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getAttachment();
            if (object instanceof UIShape.PointerEventInfo) {
                UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                if (mouseEvent.getPointerCount() == 1) {
                    if (this.dragFirst) {
                        this.dragFirstX = pointerEventInfo.objPos[0];
                        this.dragFirstY = pointerEventInfo.objPos[1];
                        this.dragFirst = false;
                        return;
                    }
                    float f = pointerEventInfo.objPos[0];
                    float f2 = pointerEventInfo.objPos[1];
                    float f3 = f - this.dragFirstX;
                    float f4 = f2 - this.dragFirstY;
                    pointerEventInfo.shape.translate(f3, f4, 0.0f);
                    float[] fArray = pointerEventInfo.shape.getTranslate();
                    GPUUISceneGLListener0A.this.actionText = String.format("Pos %6.2f / %6.2f / %6.2f", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseEvent mouseEvent) {
            Object object = mouseEvent.getAttachment();
            if (object instanceof UIShape.PointerEventInfo) {
                boolean bl;
                UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                boolean bl2 = bl = MouseEvent.PointerClass.Onscreen == mouseEvent.getPointerType(0).getPointerClass();
                if (0 == (0xFFE0001F & mouseEvent.getModifiers()) && !bl) {
                    float f = 8.0f * mouseEvent.getRotation()[1];
                    System.err.println("Rotate.Zoom.W: " + f);
                    pointerEventInfo.shape.translate(0.0f, 0.0f, f);
                } else if (bl || mouseEvent.isControlDown()) {
                    float[] fArray = VectorUtil.scaleVec3(mouseEvent.getRotation(), mouseEvent.getRotation(), (float)Math.PI / 180);
                    if (bl) {
                        System.err.println("XXX: " + mouseEvent);
                        float f = fArray[0];
                        fArray[0] = fArray[1];
                        fArray[1] = f;
                        VectorUtil.scaleVec3(fArray, fArray, 2.0f);
                    }
                    pointerEventInfo.shape.getRotation().rotateByEuler(fArray);
                }
            }
        }

        @Override
        public void gestureDetected(GestureHandler.GestureEvent gestureEvent) {
            Object object = gestureEvent.getAttachment();
            if (object instanceof UIShape.PointerEventInfo) {
                UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                if (gestureEvent instanceof PinchToZoomGesture.ZoomEvent) {
                    PinchToZoomGesture.ZoomEvent zoomEvent = (PinchToZoomGesture.ZoomEvent)gestureEvent;
                    float f = zoomEvent.getDelta() * zoomEvent.getScale();
                    System.err.println("Rotate.Zoom.G: " + f);
                    pointerEventInfo.shape.translate(0.0f, 0.0f, f);
                }
            }
        }
    };

    public GPUUISceneGLListener0A() {
        this(0);
    }

    public GPUUISceneGLListener0A(float f) {
        this(f, false, false);
    }

    public GPUUISceneGLListener0A(int n) {
        this(n, false, false);
    }

    public GPUUISceneGLListener0A(int n, boolean bl, boolean bl2) {
        this(0.0f, n, bl, bl2);
    }

    public GPUUISceneGLListener0A(float f, boolean bl, boolean bl2) {
        this(f, 0, bl, bl2);
    }

    private GPUUISceneGLListener0A(float f, int n, boolean bl, boolean bl2) {
        this.noAADPIThreshold = f;
        this.rs = RenderState.createRenderState(SVertex.factory());
        this.debug = bl;
        this.trace = bl2;
        this.renderModes = n;
        try {
            this.font = FontFactory.get(0).getDefault();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.sceneUIController = new SceneUIController(3000.0f, 0.1f, 7000.0f);
        this.screenshot = new GLReadBufferUtil(false, false);
    }

    private void rotateButtons(float[] fArray) {
        fArray = VectorUtil.scaleVec3(fArray, fArray, (float)Math.PI / 180);
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).getRotation().rotateByEuler(fArray);
        }
    }

    private void translateButtons(float f, float f2, float f3) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).translate(f, f2, f3);
        }
    }

    private void setButtonsSpacing(float f, float f2) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            RoundButton roundButton = this.buttons.get(i);
            if (!(roundButton instanceof LabelButton)) continue;
            LabelButton labelButton = (LabelButton)roundButton;
            float f3 = labelButton.getSpacingX() + f;
            float f4 = labelButton.getSpacingY() + f2;
            System.err.println("Spacing: X " + f3 + ", Y " + f4);
            labelButton.setSpacing(f3, f4);
        }
    }

    private void setButtonsCorner(float f) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            float f2 = this.buttons.get(i).getCorner() + f;
            System.err.println("Corner: " + f2);
            this.buttons.get(i).setCorner(f2);
        }
    }

    private void resetButtons() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            RoundButton roundButton = this.buttons.get(i);
            roundButton.getRotation().setIdentity();
            roundButton.setCorner(1.0f);
            if (!(roundButton instanceof LabelButton)) continue;
            ((LabelButton)roundButton).setSpacing(0.08f, 0.4f);
        }
    }

    private void initButtons(GL2ES2 gL2ES2, int n, int n2, RegionRenderer regionRenderer) {
        boolean bl = Region.isTwoPass(this.renderModes);
        this.buttons.clear();
        float f = 0.105f * (float)n;
        float f2 = f / 2.5f;
        System.err.println("Button Size: 0.105 x 0.084 * " + n + " x " + n2 + " -> " + f + " x " + f2);
        float f3 = 1.2f * f;
        float f4 = 1.5f * f2;
        LabelButton labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "Next Text", f, f2);
        labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (null != GPUUISceneGLListener0A.this.labels[GPUUISceneGLListener0A.this.currentText]) {
                    GPUUISceneGLListener0A.this.labels[GPUUISceneGLListener0A.this.currentText].setEnabled(false);
                }
                GPUUISceneGLListener0A.this.currentText = (GPUUISceneGLListener0A.this.currentText + 1) % GPUUISceneGLListener0A.this.labels.length;
                if (null != GPUUISceneGLListener0A.this.labels[GPUUISceneGLListener0A.this.currentText]) {
                    GPUUISceneGLListener0A.this.labels[GPUUISceneGLListener0A.this.currentText].setEnabled(true);
                }
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "Show FPS", f, f2);
        labelButton.setName(100);
        labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
        labelButton.setToggleable(true);
        labelButton.setToggle(this.fpsLabel.isEnabled());
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GLAnimatorControl gLAnimatorControl = GPUUISceneGLListener0A.this.cDrawable.getAnimator();
                if (null != gLAnimatorControl) {
                    gLAnimatorControl.resetFPSCounter();
                }
                GPUUISceneGLListener0A.this.fpsLabel.setEnabled(!GPUUISceneGLListener0A.this.fpsLabel.isEnabled());
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "v-sync", f, f2);
        labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
        labelButton.setToggleable(true);
        labelButton.setToggle(gL2ES2.getSwapInterval() > 0);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.cDrawable.invoke(false, new GLRunnable(){

                    @Override
                    public boolean run(GLAutoDrawable gLAutoDrawable) {
                        GL gL;
                        gL.setSwapInterval((gL = gLAutoDrawable.getGL()).getSwapInterval() <= 0 ? 1 : 0);
                        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
                        if (null != gLAnimatorControl) {
                            gLAnimatorControl.resetFPSCounter();
                        }
                        return true;
                    }
                });
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "< tilt >", f, f2);
        labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = mouseEvent.getAttachment();
                if (object instanceof UIShape.PointerEventInfo) {
                    UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                    if (pointerEventInfo.objPos[0] < pointerEventInfo.shape.getBounds().getCenter()[0]) {
                        GPUUISceneGLListener0A.this.rotateButtons(new float[]{0.0f, -5.0f, 0.0f});
                    } else {
                        GPUUISceneGLListener0A.this.rotateButtons(new float[]{0.0f, 5.0f, 0.0f});
                    }
                }
            }

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.rotateButtons(new float[]{0.0f, mouseEvent.getRotation()[1], 0.0f});
            }
        });
        this.buttons.add(labelButton);
        if (bl) {
            labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "< samples >", f, f2);
            labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
            labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Object object = mouseEvent.getAttachment();
                    if (object instanceof UIShape.PointerEventInfo) {
                        UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                        int n = GPUUISceneGLListener0A.this.sceneUIController.getSampleCount();
                        n = pointerEventInfo.objPos[0] < pointerEventInfo.shape.getBounds().getCenter()[0] ? --n : ++n;
                        n = GPUUISceneGLListener0A.this.sceneUIController.setSampleCount(n);
                    }
                }
            });
            labelButton.addMouseListener(this.dragZoomRotateListener);
            this.buttons.add(labelButton);
            labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "< quality >", f, f2);
            labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
            labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Object object = mouseEvent.getAttachment();
                    if (object instanceof UIShape.PointerEventInfo) {
                        UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                        int n = pointerEventInfo.shape.getQuality();
                        if (pointerEventInfo.objPos[0] < pointerEventInfo.shape.getBounds().getCenter()[0]) {
                            if (n > 0) {
                                --n;
                            }
                        } else if (n < 1) {
                            ++n;
                        }
                        GPUUISceneGLListener0A.this.sceneUIController.setAllShapesQuality(n);
                    }
                }
            });
            labelButton.addMouseListener(this.dragZoomRotateListener);
            this.buttons.add(labelButton);
        }
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "Quit", f, f2);
        labelButton.translate(0.0f, 0.0f - f4 * (float)this.buttons.size(), 0.0f);
        labelButton.setColor(0.7f, 0.0f, 0.0f, 1.0f);
        labelButton.setLabelColor(1.2f, 1.2f, 1.2f);
        labelButton.setPressedColorMod(1.1f, 0.0f, 0.0f, 1.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                new InterruptSource.Thread(){

                    @Override
                    public void run() {
                        if (null != GPUUISceneGLListener0A.this.cDrawable) {
                            GLAnimatorControl gLAnimatorControl = GPUUISceneGLListener0A.this.cDrawable.getAnimator();
                            if (null != gLAnimatorControl) {
                                gLAnimatorControl.stop();
                            }
                            GPUUISceneGLListener0A.this.cDrawable.destroy();
                        }
                    }
                }.start();
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        int n3 = 0;
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "y flip", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)n3, 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.rotateButtons(new float[]{0.0f, 180.0f, 0.0f});
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "x flip", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)(++n3), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.rotateButtons(new float[]{180.0f, 0.0f, 0.0f});
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "+", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)(++n3), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = mouseEvent.getAttachment();
                if (object instanceof UIShape.PointerEventInfo) {
                    UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                    float f = pointerEventInfo.objPos[0] - pointerEventInfo.shape.getBounds().getCenter()[0];
                    float f2 = pointerEventInfo.objPos[1] - pointerEventInfo.shape.getBounds().getCenter()[1];
                    float f3 = Math.abs(f) / pointerEventInfo.shape.getBounds().getWidth();
                    float f4 = Math.abs(f2) / pointerEventInfo.shape.getBounds().getHeight();
                    float f5 = 0.0f;
                    float f6 = 0.0f;
                    if (f3 > f4) {
                        f5 = f < 0.0f ? -5.0f : 5.0f;
                    } else {
                        f6 = f2 < 0.0f ? -5.0f : 5.0f;
                    }
                    GPUUISceneGLListener0A.this.translateButtons(f5, f6, 0.0f);
                }
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "< space >", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)(++n3), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = mouseEvent.getAttachment();
                if (object instanceof UIShape.PointerEventInfo) {
                    float f;
                    float f2;
                    UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                    if (pointerEventInfo.objPos[0] < pointerEventInfo.shape.getBounds().getCenter()[0]) {
                        f2 = -0.01f;
                        f = -0.005f;
                    } else {
                        f2 = 0.01f;
                        f = 0.005f;
                    }
                    GPUUISceneGLListener0A.this.setButtonsSpacing(f2, f);
                }
            }

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.setButtonsSpacing(mouseEvent.getRotation()[0] / 100.0f, mouseEvent.getRotation()[1] / 200.0f);
            }
        });
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "< corner >", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)(++n3), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = mouseEvent.getAttachment();
                if (object instanceof UIShape.PointerEventInfo) {
                    UIShape.PointerEventInfo pointerEventInfo = (UIShape.PointerEventInfo)object;
                    float f = pointerEventInfo.objPos[0] < pointerEventInfo.shape.getBounds().getCenter()[0] ? -0.1f : 0.1f;
                    GPUUISceneGLListener0A.this.setButtonsCorner(f);
                }
            }

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.setButtonsCorner(mouseEvent.getRotation()[1] / 20.0f);
            }
        });
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "reset", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)(++n3), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.resetButtons();
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        labelButton = new LabelButton(SVertex.factory(), this.renderModes, this.font, "screenshot", f, f2);
        labelButton.translate(0.0f - f3 * 1.0f, 0.0f - f4 * (float)(++n3), 0.0f);
        labelButton.addMouseListener(new UIShape.MouseGestureAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GPUUISceneGLListener0A.this.cDrawable.invoke(false, new GLRunnable(){

                    @Override
                    public boolean run(GLAutoDrawable gLAutoDrawable) {
                        GPUUISceneGLListener0A.this.printScreen(gLAutoDrawable.getGL());
                        return true;
                    }
                });
            }
        });
        labelButton.addMouseListener(this.dragZoomRotateListener);
        this.buttons.add(labelButton);
        ++n3;
        this.buttonsLeftCount = this.buttons.size();
        float f5 = 2.0f * f;
        float f6 = 2.0f * f2;
        float f7 = -f5 - 8.0f;
        int n4 = 1;
        int n5 = 2;
        int n6 = 3;
        Object object = GLMediaPlayerFactory.createDefault();
        object.setTextureUnit(n4);
        Object object2 = new MediaPlayerButton(regionRenderer.getRenderState().getVertexFactory(), this.renderModes, f5, f6, (GLMediaPlayer)object);
        ((MediaPlayerButton)object2).setVerbose(true);
        ((MediaPlayerButton)object2).addDefaultEventListener();
        ((UIShape)object2).translate(f7, 0.0f - f4 * 1.0f, 0.0f);
        ((UIShape)object2).setToggleable(true);
        ((UIShape)object2).setToggle(false);
        ((UIShape)object2).setToggleOffColorMod(0.0f, 1.0f, 0.0f, 1.0f);
        ((UIShape)object2).addMouseListener(this.dragZoomRotateListener);
        ((UIShape)object2).addMouseListener(new UIShape.MouseGestureAdapter((GLMediaPlayer)object, (MediaPlayerButton)object2){
            final /* synthetic */ GLMediaPlayer val$mPlayer;
            final /* synthetic */ MediaPlayerButton val$mPlayerButton;
            {
                this.val$mPlayer = gLMediaPlayer;
                this.val$mPlayerButton = mediaPlayerButton;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.val$mPlayer.setAudioVolume(this.val$mPlayerButton.isToggleOn() ? 1.0f : 0.0f);
            }
        });
        this.buttons.add((RoundButton)object2);
        try {
            Uri uri = Uri.cast("http://archive.org/download/BigBuckBunny_328/BigBuckBunny_512kb.mp4");
            object.initStream(uri, -1, -1, 4);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        object = new ImageSequence(n5, true);
        object2 = new ImageSeqButton(regionRenderer.getRenderState().getVertexFactory(), this.renderModes, f5, f6, (ImageSequence)object);
        try {
            ((ImageSequence)object).addFrame(gL2ES2, GPUUISceneGLListener0A.class, "button-released-145x53.png", "png");
            ((ImageSequence)object).addFrame(gL2ES2, GPUUISceneGLListener0A.class, "button-pressed-145x53.png", "png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ((ImageSequence)object).setManualStepping(true);
        ((UIShape)object2).translate(f7, 0.0f - f4 * 2.5f, 0.0f);
        ((UIShape)object2).addMouseListener(this.dragZoomRotateListener);
        ((UIShape)object2).addMouseListener(new UIShape.MouseGestureAdapter((ImageSeqButton)object2){
            final /* synthetic */ ImageSeqButton val$imgButton;
            {
                this.val$imgButton = imageSeqButton;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.val$imgButton.setCurrentIdx(1);
                System.err.println("XXX: " + this.val$imgButton);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.val$imgButton.setCurrentIdx(0);
            }
        });
        this.buttons.add((RoundButton)object2);
        object2 = new GearsES2(0);
        ((GearsES2)object2).setVerbose(false);
        ((GearsES2)object2).setClearColor(new float[]{0.9f, 0.9f, 0.9f, 1.0f});
        object = object2;
        object2 = new GLEventListenerButton(regionRenderer.getRenderState().getVertexFactory(), this.renderModes, f5, f6, n6, (GLEventListener)object, false, (int)f5, (int)f6);
        ((UIShape)object2).setToggleable(true);
        ((UIShape)object2).setToggle(false);
        ((GLEventListenerButton)object2).setAnimate(false);
        ((UIShape)object2).translate(f7, 0.0f - f4 * 4.0f, 0.0f);
        ((UIShape)object2).addMouseListener(this.dragZoomRotateListener);
        ((UIShape)object2).addMouseListener(new UIShape.MouseGestureAdapter((GLEventListenerButton)object2){
            final /* synthetic */ GLEventListenerButton val$glelButton;
            {
                this.val$glelButton = gLEventListenerButton;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.val$glelButton.setAnimate(this.val$glelButton.isToggleOn());
            }
        });
        this.buttons.add((RoundButton)object2);
    }

    private void initTexts() {
        this.strings = new String[4];
        int n = 0;
        this.strings[n++] = "- Mouse Scroll Over Object\n   - General\n     - Z Translation\n     - Ctrl: Y-Rotation (Shift: X-Rotation)\n   - Tilt, Space and Corner\n     - Their respective action via wheel\n       (shift = other value)\n\n- Mouse Drag On Object\n   - Click on Object and drag mouse\n   - Current postion in status line at bottom\n\n- Tilt Button Rotate Whole Button Group";
        this.strings[n++] = "abcdefghijklmn\nopqrstuvwxyz\nABCDEFGHIJKL\nMNOPQRSTUVWXYZ\n0123456789.:,;(*!?/\\\")$%^&-+@~#<>{}[]";
        this.strings[n++] = "The quick brown fox\njumps over the lazy\ndog";
        this.strings[n++] = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec \nUt purus odio, rhoncus sit amet commodo eget, ullamcorper vel\nquam iaculis urna cursus ornare. Nullam ut felis a ante ultrices\nIn hac habitasse platea dictumst. Vivamus et mi a quam lacinia\nMorbi quis bibendum nibh. Donec lectus orci, sagittis in consequat\nDonec ut dolor et nulla tristique varius. In nulla magna, fermentum\nin lorem. Maecenas in ipsum ac justo scelerisque sollicitudin.\n";
        this.labels = new Label[n];
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        Object object;
        Object object2;
        Object object3 = gLAutoDrawable.getUpstreamWidget();
        if (object3 instanceof Window) {
            object2 = (Window)object3;
            object = object2.getMainMonitor();
            float[] fArray = ((MonitorDevice)object).getPixelsPerMM(new float[2]);
            fArray[0] = fArray[0] * 25.4f;
            fArray[1] = fArray[1] * 25.4f;
            float[] fArray2 = object2.getPixelsPerMM(new float[2]);
            fArray2[0] = fArray2[0] * 25.4f;
            fArray2[1] = fArray2[1] * 25.4f;
            this.dpiH = fArray2[1];
            System.err.println("Monitor detected: " + object);
            System.err.println("Monitor dpi: " + fArray[0] + " x " + fArray[1]);
            System.err.println("Surface scale: native " + Arrays.toString(object2.getMaximumSurfaceScale(new float[2])) + ", current " + Arrays.toString(object2.getCurrentSurfaceScale(new float[2])));
            System.err.println("Surface dpi " + fArray2[0] + " x " + fArray2[1]);
        } else {
            System.err.println("Using default DPI of " + this.dpiH);
        }
        if (0 == this.renderModes && !FloatUtil.isZero(this.noAADPIThreshold, 1.1920929E-7f)) {
            boolean bl = this.dpiH >= this.noAADPIThreshold;
            object = bl ? " >= " : " < ";
            System.err.println("AUTO RenderMode: dpi " + this.dpiH + (String)object + this.noAADPIThreshold + " -> noAA " + bl);
            int n = this.renderModes = bl ? 0 : 2;
        }
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("GPUUISceneGLListener0A: init (1)");
            object2 = (GLWindow)gLAutoDrawable;
            this.attachInputListenerTo((GLWindow)object2);
        } else {
            System.err.println("GPUUISceneGLListener0A: init (0)");
        }
        System.err.println("Chosen: " + gLAutoDrawable.getChosenGLCapabilities());
        this.cDrawable = gLAutoDrawable;
        object2 = gLAutoDrawable.getGL().getGL2ES2();
        if (this.debug) {
            object2 = object2.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Debug", null, (GL)object2, null)).getGL2ES2();
        }
        if (this.trace) {
            object2 = object2.getContext().setGL(GLPipelineFactory.create("com.jogamp.opengl.Trace", null, (GL)object2, new Object[]{System.err})).getGL2ES2();
        }
        try {
            this.font = FontFactory.get(0).getDefault();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.renderer = RegionRenderer.create(this.rs, RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
        this.rs.setHintMask(2);
        object2.setSwapInterval(1);
        object2.glEnable(2929);
        object2.glEnable(3042);
        this.renderer.init((GL2ES2)object2, this.renderModes);
        this.initTexts();
        this.sceneUIController.setRenderer(this.renderer);
        float f = 0.046f * (float)gLAutoDrawable.getSurfaceHeight();
        this.jogampLabel = new Label(this.renderer.getRenderState().getVertexFactory(), this.renderModes, this.font, f, "JogAmp - Jogl Graph Module Demo");
        this.jogampLabel.addMouseListener(this.dragZoomRotateListener);
        this.sceneUIController.addShape(this.jogampLabel);
        this.jogampLabel.setEnabled(true);
        float f2 = this.font.getPixelSize(10.0f, this.dpiH);
        System.err.println("10Pt PixelSize: Display " + this.dpiH + " dpi, fontSize " + 10.0f + " ppi -> " + f2 + " pixel-size");
        this.truePtSizeLabel = new Label(this.renderer.getRenderState().getVertexFactory(), this.renderModes, this.font, f2, "10.0 pt font size label - true scale!");
        this.sceneUIController.addShape(this.truePtSizeLabel);
        this.truePtSizeLabel.setEnabled(true);
        this.truePtSizeLabel.translate(0.0f, -1.5f * this.jogampLabel.getLineHeight(), 0.0f);
        this.truePtSizeLabel.setColor(0.1f, 0.1f, 0.1f, 1.0f);
        float f3 = 0.038f * (float)gLAutoDrawable.getSurfaceHeight();
        this.fpsLabel = new Label(this.renderer.getRenderState().getVertexFactory(), this.renderModes, this.font, f3, "Nothing there yet");
        this.fpsLabel.addMouseListener(this.dragZoomRotateListener);
        this.sceneUIController.addShape(this.fpsLabel);
        this.fpsLabel.setEnabled(true);
        this.fpsLabel.setColor(0.3f, 0.3f, 0.3f, 1.0f);
        this.crossHairCtr = new CrossHair(this.renderer.getRenderState().getVertexFactory(), 0, 100.0f, 100.0f, 2.0f);
        this.crossHairCtr.addMouseListener(this.dragZoomRotateListener);
        this.sceneUIController.addShape(this.crossHairCtr);
        this.crossHairCtr.setEnabled(true);
        this.crossHairCtr.translate(0.0f, 0.0f, -1.0f);
        this.initButtons((GL2ES2)object2, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight(), this.renderer);
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.sceneUIController.addShape(this.buttons.get(i));
        }
        this.sceneUIController.init(gLAutoDrawable);
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        if (null != gLAnimatorControl) {
            gLAnimatorControl.resetFPSCounter();
        }
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        Object object;
        if (gLAutoDrawable instanceof GLWindow) {
            System.err.println("GPUUISceneGLListener0A: dispose (1)");
            object = (GLWindow)gLAutoDrawable;
            this.detachInputListenerFrom((GLWindow)object);
        } else {
            System.err.println("GPUUISceneGLListener0A: dispose (0)");
        }
        this.sceneUIController.dispose(gLAutoDrawable);
        object = gLAutoDrawable.getGL().getGL2ES2();
        this.renderer.destroy((GL2ES2)object);
        this.screenshot.dispose((GL)object);
    }

    public void printScreen(GL gL) {
        String string = Region.getRenderModeString(this.jogampLabel.getRenderModes());
        String string2 = String.format("GraphUIDemo-shot%03d-%03dx%03d-S_%s_%02d.png", this.shotCount++, this.renderer.getWidth(), this.renderer.getHeight(), string, this.sceneUIController.getSampleCount());
        gL.glFinish();
        if (this.screenshot.readPixels(gL, false)) {
            this.screenshot.write(new File(string2));
            System.err.println("Wrote: " + string2);
        }
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        float f;
        float f2;
        float f3;
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        if (null == this.labels[this.currentText]) {
            f3 = 0.046f * (float)gLAutoDrawable.getSurfaceHeight();
            f2 = (float)gLAutoDrawable.getSurfaceHeight() - 2.0f * this.jogampLabel.getLineHeight();
            f = (float)gLAutoDrawable.getSurfaceWidth() * 0.33333334f;
            this.labels[this.currentText] = new Label(this.renderer.getRenderState().getVertexFactory(), this.renderModes, this.font, f3, this.strings[this.currentText]);
            this.labels[this.currentText].setColor(0.1f, 0.1f, 0.1f, 1.0f);
            this.labels[this.currentText].setEnabled(true);
            this.labels[this.currentText].translate(f, f2 - 1.5f * this.jogampLabel.getLineHeight() - 1.5f * this.truePtSizeLabel.getLineHeight(), 0.0f);
            this.labels[this.currentText].addMouseListener(this.dragZoomRotateListener);
            this.sceneUIController.addShape(this.labels[this.currentText]);
            System.err.println("Label[" + this.currentText + "] CTOR: " + this.labels[this.currentText]);
            System.err.println("Label[" + this.currentText + "] CTOR: " + Arrays.toString(this.labels[this.currentText].getTranslate()));
        }
        if (this.fpsLabel.isEnabled()) {
            String string;
            GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
            if (null != gLAnimatorControl) {
                f3 = gLAnimatorControl.getLastFPS();
                f2 = gLAnimatorControl.getTotalFPS();
                f = (float)gLAnimatorControl.getTotalFPSDuration() / 1000.0f;
            } else {
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
            }
            String string2 = Region.getRenderModeString(this.renderModes);
            if (null == this.actionText) {
                String string3 = gL2ES2.isGLES() ? "4.0" : "4.1";
                string = String.format("%03.1f/%03.1f fps, v-sync %d, dpi %.1f, fontSize %.1f, %s-samples %d, q %d, td %" + string3 + "f, blend %b, alpha %d, msaa %d", Float.valueOf(f3), Float.valueOf(f2), gL2ES2.getSwapInterval(), Float.valueOf(this.dpiH), Float.valueOf(0.046f), string2, this.sceneUIController.getSampleCount(), this.fpsLabel.getQuality(), Float.valueOf(f), this.renderer.getRenderState().isHintMaskSet(1), gLAutoDrawable.getChosenGLCapabilities().getAlphaBits(), gLAutoDrawable.getChosenGLCapabilities().getNumSamples());
            } else {
                string = String.format("%03.1f/%03.1f fps, v-sync %d, fontSize %.1f, %s", Float.valueOf(f3), Float.valueOf(f2), gL2ES2.getSwapInterval(), Float.valueOf(0.046f), this.actionText);
            }
            this.fpsLabel.setText(string);
        }
        this.sceneUIController.display(gLAutoDrawable);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        int n5;
        System.err.println("GPUUISceneGLListener0A: reshape");
        float f = (float)n3 - this.lastWidth;
        float f2 = (float)n4 - this.lastHeight;
        float f3 = f2 * 0.8333333f;
        float f4 = f * 0.16666667f;
        float f5 = f;
        for (n5 = 0; n5 < this.buttons.size() && n5 < this.buttonsLeftCount; ++n5) {
            this.buttons.get(n5).translate(f4, f3, 0.0f);
        }
        for (n5 = this.buttonsLeftCount; n5 < this.buttons.size(); ++n5) {
            this.buttons.get(n5).translate(f5, f3, 0.0f);
        }
        float f6 = (float)n3 * 0.33333334f;
        float f7 = (float)gLAutoDrawable.getSurfaceHeight() - 2.0f * this.jogampLabel.getLineHeight();
        this.jogampLabel.setTranslate(f6, f7, 0.0f);
        this.truePtSizeLabel.setTranslate(f6, f7, 0.0f);
        this.truePtSizeLabel.setTranslate(f6, f7 - 1.5f * this.jogampLabel.getLineHeight(), 0.0f);
        this.fpsLabel.translate(0.0f, 0.0f, 0.0f);
        if (null != this.labels[this.currentText]) {
            this.labels[this.currentText].setTranslate(f6, f7 - 1.5f * this.jogampLabel.getLineHeight() - 1.5f * this.truePtSizeLabel.getLineHeight(), 0.0f);
            System.err.println("Label[" + this.currentText + "] MOVE: " + this.labels[this.currentText]);
            System.err.println("Label[" + this.currentText + "] MOVE: " + Arrays.toString(this.labels[this.currentText].getTranslate()));
        }
        this.crossHairCtr.translate(f / 2.0f, f2 / 2.0f, 0.0f);
        this.sceneUIController.reshape(gLAutoDrawable, n, n2, n3, n4);
        this.lastWidth = n3;
        this.lastHeight = n4;
    }

    public void attachInputListenerTo(GLWindow gLWindow) {
        if (!this.ioAttached) {
            this.ioAttached = true;
            this.sceneUIController.attachInputListenerTo(gLWindow);
        }
    }

    public void detachInputListenerFrom(GLWindow gLWindow) {
        if (this.ioAttached) {
            this.ioAttached = false;
            this.sceneUIController.detachInputListenerFrom(gLWindow);
        }
    }
}

