/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.graph.curve.opengl.GLRegion;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.SVertex;
import com.jogamp.newt.Window;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.util.PMVMatrix;
import java.io.IOException;

public abstract class TextRendererGLELBase
implements GLEventListener {
    public final int renderModes;
    protected final int[] vbaaSampleCount;
    protected final float[] staticRGBAColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private boolean exclusivePMVMatrix = true;
    private PMVMatrix sharedPMVMatrix = null;
    private RenderState rs = null;
    private RegionRenderer.GLCallback enableCallback = null;
    private RegionRenderer.GLCallback disableCallback = null;
    protected RegionRenderer renderer = null;
    protected TextRegionUtil textRenderUtil = null;
    protected float pixelScale = 1.0f;
    protected float dpiH = 96.0f;
    boolean flipVerticalInGLOrientation = false;
    int lastRow = -1;

    public static Font getFont(int n, int n2, int n3) {
        try {
            return FontFactory.get(n).get(n2, n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public TextRendererGLELBase(int n, int[] nArray) {
        this.renderModes = n;
        this.vbaaSampleCount = nArray;
    }

    public void setRenderState(RenderState renderState) {
        this.rs = renderState;
    }

    public void setSharedPMVMatrix(PMVMatrix pMVMatrix) {
        this.sharedPMVMatrix = pMVMatrix;
    }

    public void setRendererCallbacks(RegionRenderer.GLCallback gLCallback, RegionRenderer.GLCallback gLCallback2) {
        this.enableCallback = gLCallback;
        this.disableCallback = gLCallback2;
    }

    public void setFlipVerticalInGLOrientation(boolean bl) {
        this.flipVerticalInGLOrientation = bl;
    }

    public final RegionRenderer getRenderer() {
        return this.renderer;
    }

    public final TextRegionUtil getTextRenderUtil() {
        return this.textRenderUtil;
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        if (null == this.rs) {
            this.exclusivePMVMatrix = null == this.sharedPMVMatrix;
            this.rs = RenderState.createRenderState(SVertex.factory(), this.sharedPMVMatrix);
        }
        this.renderer = RegionRenderer.create(this.rs, this.enableCallback, this.disableCallback);
        this.rs.setHintMask(2);
        this.textRenderUtil = new TextRegionUtil(this.renderModes);
        GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
        this.renderer.init(gL2ES2, this.renderModes);
        this.rs.setColorStatic(this.staticRGBAColor[0], this.staticRGBAColor[1], this.staticRGBAColor[2], this.staticRGBAColor[3]);
        this.renderer.enable(gL2ES2, false);
        Object object = gLAutoDrawable.getUpstreamWidget();
        if (object instanceof Window) {
            float[] fArray = ((Window)object).getPixelsPerMM(new float[2]);
            this.dpiH = fArray[1] * 25.4f;
        }
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (null != this.renderer) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.renderer.enable(gL2ES2, true);
            if (this.exclusivePMVMatrix) {
                this.renderer.reshapeOrtho(n3, n4, 0.1f, 1000.0f);
                this.pixelScale = 1.0f;
            } else {
                this.renderer.reshapeNotify(n3, n4);
            }
            this.renderer.enable(gL2ES2, false);
        }
    }

    @Override
    public abstract void display(GLAutoDrawable var1);

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (null != this.renderer) {
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            this.renderer.destroy(gL2ES2);
        }
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, float f2, float f3, float f4, boolean bl) {
        int n2 = this.lastRow + 1;
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, bl, null);
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, float f2, float f3, float f4, GLRegion gLRegion) {
        int n2 = this.lastRow + 1;
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, false, gLRegion);
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, int n2, float f2, float f3, float f4, boolean bl) {
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, bl, null);
    }

    public void renderString(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, int n2, float f2, float f3, float f4, GLRegion gLRegion) {
        this.renderStringImpl(gLAutoDrawable, font, f, string, n, n2, f2, f3, f4, false, gLRegion);
    }

    private void renderStringImpl(GLAutoDrawable gLAutoDrawable, Font font, float f, String string, int n, int n2, float f2, float f3, float f4, boolean bl, GLRegion gLRegion) {
        if (null != this.renderer) {
            int n3;
            float f5;
            GL2ES2 gL2ES2 = gLAutoDrawable.getGL().getGL2ES2();
            float f6 = f2;
            if (!this.exclusivePMVMatrix) {
                f5 = 1.0f - f3;
            } else {
                n3 = gLAutoDrawable.getSurfaceHeight();
                f5 = (float)n3 - f3;
            }
            n3 = TextRegionUtil.getCharCount(string, '\n');
            float f7 = font.getLineHeight(f);
            f6 += this.pixelScale * font.getAdvanceWidth(88, f) * (float)n;
            f5 -= this.pixelScale * f7 * (float)(n2 + 1);
            PMVMatrix pMVMatrix = this.rs.getMatrix();
            pMVMatrix.glMatrixMode(5888);
            if (!this.exclusivePMVMatrix) {
                pMVMatrix.glPushMatrix();
            } else {
                pMVMatrix.glLoadIdentity();
            }
            pMVMatrix.glTranslatef(f6, f5, f4);
            if (this.flipVerticalInGLOrientation && gLAutoDrawable.isGLOriented()) {
                pMVMatrix.glScalef(this.pixelScale, -1.0f * this.pixelScale, 1.0f);
            } else if (1.0f != this.pixelScale) {
                pMVMatrix.glScalef(this.pixelScale, this.pixelScale, 1.0f);
            }
            this.renderer.enable(gL2ES2, true);
            if (bl) {
                this.textRenderUtil.drawString3D(gL2ES2, this.renderer, font, f, string, null, this.vbaaSampleCount);
            } else if (null != gLRegion) {
                TextRegionUtil.drawString3D(gL2ES2, gLRegion, this.renderer, font, f, (CharSequence)string, null, this.vbaaSampleCount, this.textRenderUtil.tempT1, this.textRenderUtil.tempT2);
            } else {
                TextRegionUtil.drawString3D(gL2ES2, this.renderModes, this.renderer, font, f, (CharSequence)string, null, this.vbaaSampleCount, this.textRenderUtil.tempT1, this.textRenderUtil.tempT2);
            }
            this.renderer.enable(gL2ES2, false);
            if (!this.exclusivePMVMatrix) {
                pMVMatrix.glPopMatrix();
            }
            this.lastRow = n2 + n3;
        }
    }
}

