/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph;

import com.jogamp.common.util.IOUtil;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.RenderState;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.geom.SVertex;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.PMVMatrix;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTextRendererNEWT10
extends UITestCase {
    static final boolean DEBUG = false;
    static final boolean TRACE = false;
    static long duration = 100L;
    static boolean forceES2 = false;
    static boolean forceGL3 = false;
    static boolean mainRun = false;
    static boolean useMSAA = true;
    static Font font;
    static float fontSize;
    static String customStr;
    private GLReadBufferUtil screenshot;
    int lastRow = -1;
    private int screenshot_num = 0;

    @BeforeClass
    public static void setup() throws IOException {
        if (null == font) {
            font = FontFactory.get(0).getDefault();
        }
    }

    static int atoi(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        mainRun = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                duration = TestTextRendererNEWT10.atoi(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-noMSAA")) {
                useMSAA = false;
                continue;
            }
            if (stringArray[i].equals("-es2")) {
                forceES2 = true;
                continue;
            }
            if (stringArray[i].equals("-gl3")) {
                forceGL3 = true;
                continue;
            }
            if (stringArray[i].equals("-font")) {
                font = FontFactory.get(IOUtil.getResource(stringArray[++i], TestTextRendererNEWT10.class.getClassLoader(), TestTextRendererNEWT10.class).getInputStream(), true);
                continue;
            }
            if (stringArray[i].equals("-fontSize")) {
                fontSize = MiscUtils.atof(stringArray[++i], fontSize);
                continue;
            }
            if (!stringArray[i].equals("-text")) continue;
            customStr = stringArray[++i];
        }
        String string = TestTextRendererNEWT10.class.getName();
        JUnitCore.main(string);
    }

    static void sleep() {
        try {
            System.err.println("** new frame ** (sleep: " + duration + "ms)");
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void test00TextRendererNONE00() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(0, 0);
    }

    @Test
    public void test01TextRendererMSAA04() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(0, 4);
    }

    @Test
    public void test02TextRendererVBAA04() throws InterruptedException, GLException, IOException {
        this.testTextRendererImpl(2, 4);
    }

    void testTextRendererImpl(int n, int n2) throws InterruptedException, GLException, IOException {
        GLProfile gLProfile = forceGL3 ? GLProfile.get("GL3") : (forceES2 ? GLProfile.get("GLES2") : GLProfile.getGL2ES2());
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(4);
        if (0 < n2 && !Region.isVBAA(n)) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(n2);
        }
        System.err.println("Requested: " + gLCapabilities);
        System.err.println("Requested: " + Region.getRenderModeString(n));
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(gLCapabilities, 800, 400, true);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        Assert.assertEquals(0L, gL2ES2.glGetError());
        System.err.println("Chosen: " + windowContext.window.getChosenCapabilities());
        RenderState renderState = RenderState.createRenderState(SVertex.factory());
        RegionRenderer regionRenderer = RegionRenderer.create(renderState, RegionRenderer.defaultBlendEnable, RegionRenderer.defaultBlendDisable);
        renderState.setHintMask(2);
        TextRegionUtil textRegionUtil = new TextRegionUtil(n);
        gL2ES2.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        regionRenderer.init(gL2ES2, 0);
        renderState.setColorStatic(0.1f, 0.1f, 0.1f, 1.0f);
        this.screenshot = new GLReadBufferUtil(false, false);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        regionRenderer.reshapeOrtho(gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), 0.1f, 1000.0f);
        int[] nArray = new int[]{n2};
        gL2ES2.glClear(16640);
        if (null == customStr) {
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "012345678901234567890123456789", 0, 0, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "Hello World", 0, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "4567890123456", 4, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "I like JogAmp", 4, -1, -1000, nArray);
            int n3 = 0;
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "GlueGen", n3++, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "JOAL", n3++, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "JOGL", n3++, -1, -1000, nArray);
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, "JOCL", n3++, -1, -1000, nArray);
        } else {
            this.renderString(gLDrawable, gL2ES2, regionRenderer, textRegionUtil, customStr, 0, 0, -1000, nArray);
        }
        gLDrawable.swapBuffers();
        this.printScreen(n, gLDrawable, gL2ES2, false, n2);
        TestTextRendererNEWT10.sleep();
        this.screenshot.dispose(gL2ES2);
        regionRenderer.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    void renderString(GLDrawable gLDrawable, GL2ES2 gL2ES2, RegionRenderer regionRenderer, TextRegionUtil textRegionUtil, String string, int n, int n2, int n3, int[] nArray) {
        int n4 = gLDrawable.getSurfaceHeight();
        int n5 = 0;
        int n6 = n4;
        if (0 > n2) {
            n2 = this.lastRow + 1;
        }
        AABBox aABBox = font.getMetricBounds(string, fontSize);
        n5 = (int)((float)n5 + font.getAdvanceWidth(88, fontSize) * (float)n);
        PMVMatrix pMVMatrix = regionRenderer.getMatrix();
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(n5, n6 -= (int)aABBox.getHeight() * (n2 + 1), n3);
        textRegionUtil.drawString3D(gL2ES2, regionRenderer, font, fontSize, string, null, nArray);
        this.lastRow = n2;
    }

    public void printScreen(int n, GLDrawable gLDrawable, GL gL, boolean bl, int n2) throws GLException, IOException {
        String string = this.getSimpleTestName(".") + "-snap" + this.screenshot_num;
        ++this.screenshot_num;
        String string2 = Region.getRenderModeString(n);
        String string3 = String.format("%s-msaa%02d-fontsz%02.1f-%03dx%03d-%s%04d", string, gLDrawable.getChosenGLCapabilities().getNumSamples(), Float.valueOf(fontSize), gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight(), string2, n2);
        String string4 = "./" + string3 + ".png";
        if (this.screenshot.readPixels(gL, false)) {
            this.screenshot.write(new File(string4));
        }
    }

    static {
        fontSize = 24.0f;
        customStr = null;
    }
}

