/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ActivityHandler;
import visad.ConstantMap;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.LocalDisplay;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.java3d.DisplayImplJ3D;
import visad.util.DualRes;

public class ResSwitcher
extends DualRes
implements ActivityHandler {
    private LocalDisplay display;
    private DataRenderer hi_rend;
    private DataRenderer lo_rend;

    public ResSwitcher(LocalDisplay d, DataReferenceImpl ref) throws VisADException, RemoteException {
        this(d, ref, null, null);
    }

    public ResSwitcher(LocalDisplay d, DataReferenceImpl ref, DataRenderer renderer, ConstantMap[] cmaps) throws VisADException, RemoteException {
        super(ref);
        this.display = d;
        if (renderer == null) {
            this.display.addReference(this.lo_ref, cmaps);
        } else {
            this.display.addReferences(renderer, this.lo_ref, cmaps);
        }
        Vector dataRenderers = this.display.getRendererVector();
        int len = dataRenderers == null ? 0 : dataRenderers.size();
        int flags = 0;
        int i = 0;
        while (i < len && flags != 3) {
            DataRenderer rend = (DataRenderer)dataRenderers.elementAt(i);
            DataDisplayLink[] links = rend.getLinks();
            int j = 0;
            while (j < links.length && flags != 3) {
                DataReference jref = links[j].getDataReference();
                if (jref == this.hi_ref) {
                    this.hi_rend = rend;
                    flags &= 1;
                } else if (jref == this.lo_ref) {
                    this.lo_rend = rend;
                    flags &= 2;
                }
                ++j;
            }
            ++i;
        }
        this.display.addActivityHandler(this);
    }

    public void unlink() throws VisADException {
        this.display.removeActivityHandler(this);
    }

    public void busyDisplay(LocalDisplay d) {
        if (this.lo_rend != null && this.hi_rend != null) {
            this.lo_rend.toggle(true);
            this.hi_rend.toggle(false);
        }
    }

    public void idleDisplay(LocalDisplay d) {
        if (this.lo_rend != null && this.hi_rend != null) {
            this.hi_rend.toggle(true);
            this.lo_rend.toggle(false);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Please specify a datafile on the command line.");
            return;
        }
        DefaultFamily loader = new DefaultFamily("loader");
        DataImpl d = loader.open(args[0]);
        DisplayImplJ3D display = new DisplayImplJ3D("display");
        ScalarMap[] maps = d.getType().guessMaps(true);
        if (maps != null) {
            int i = 0;
            while (i < maps.length) {
                display.addMap(maps[i]);
                ++i;
            }
        }
        DataReferenceImpl ref = new DataReferenceImpl("ref");
        ref.setData(d);
        display.addReference(ref);
        ResSwitcher rs = new ResSwitcher(display, ref);
        if (args.length > 1) {
            try {
                rs.setResolutionScale(Double.parseDouble(args[1]));
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        JFrame frame = new JFrame("ResSwitcher test");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setAlignmentY(0.0f);
        p.setAlignmentX(0.0f);
        frame.setContentPane(p);
        p.add(display.getComponent());
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }
}

