/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.ArrayList;
import visad.util.CmdlineConsumer;

public class CmdlineParser {
    private String mainName;
    private ArrayList list;

    public CmdlineParser(Object mainClass) {
        String className = mainClass.getClass().getName();
        int pt = className.lastIndexOf(46);
        int ds = className.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        this.mainName = className.substring(pt == -1 ? 0 : pt + 1);
        this.list = null;
        if (mainClass instanceof CmdlineConsumer) {
            this.addConsumer((CmdlineConsumer)mainClass);
        }
    }

    public void addConsumer(CmdlineConsumer consumer) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(consumer);
    }

    public String getMainClassName() {
        return this.mainName;
    }

    public boolean processArgs(String[] args) {
        boolean usage = false;
        if (this.list == null || args == null) {
            return true;
        }
        CmdlineConsumer[] consumers = new CmdlineConsumer[this.list.size()];
        int c = 0;
        while (c < consumers.length) {
            consumers[c] = (CmdlineConsumer)this.list.get(consumers.length - (c + 1));
            ++c;
        }
        int c2 = 0;
        while (c2 < consumers.length) {
            consumers[c2].initializeArgs();
            ++c2;
        }
        int i = 0;
        while (!usage && i < args.length) {
            if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                String str;
                char ch = args[i].charAt(1);
                boolean strInOption = false;
                if (args[i].length() > 2) {
                    str = args[i].substring(2);
                    strInOption = true;
                } else {
                    str = i + 1 < args.length ? args[i + 1] : null;
                }
                int c3 = 0;
                while (c3 < consumers.length) {
                    int handled = consumers[c3].checkOption(this.mainName, ch, str);
                    if (handled > 0) {
                        if (handled > 1) {
                            handled = strInOption ? 1 : 2;
                        }
                        i += handled - 1;
                        break;
                    }
                    if (handled == 0) {
                        System.err.println(this.mainName + ": Unknown option \"-" + ch + "\"");
                    }
                    usage = true;
                    ++c3;
                }
            } else {
                int c4 = 0;
                while (c4 < consumers.length) {
                    int handled = consumers[c4].checkKeyword(this.mainName, i, args);
                    if (handled > 0) {
                        i += handled - 1;
                        break;
                    }
                    if (handled == 0) {
                        System.err.println(this.mainName + ": Unknown keyword \"" + args[i] + "\"");
                    }
                    usage = true;
                    ++c4;
                }
            }
            ++i;
        }
        int c5 = 0;
        while (!usage && c5 < consumers.length) {
            usage |= !consumers[c5].finalizeArgs(this.mainName);
            ++c5;
        }
        if (usage) {
            StringBuffer buf = new StringBuffer("Usage: " + this.mainName);
            int c6 = 0;
            while (c6 < consumers.length) {
                buf.append(consumers[c6].optionUsage());
                ++c6;
            }
            int c7 = 0;
            while (c7 < consumers.length) {
                buf.append(consumers[c7].keywordUsage());
                ++c7;
            }
            System.err.println(buf.toString());
        }
        return !usage;
    }
}

