/*
 * Decompiled with CFR 0.152.
 */
package visad.paoloa;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.VisADException;
import visad.data.mcidas.BaseMapAdapter;
import visad.data.netcdf.Plain;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.RangeSlider;
import visad.util.VisADSlider;

public class PCS
implements ActionListener,
ScalarMapListener,
DisplayListener {
    public static int WIDTH = 900;
    public static int HEIGHT = 600;
    int ntimes;
    int nbands;
    int npcs;
    int nchannels;
    int nlevels;
    Tuple file_data;
    FieldImpl time_series;
    FlatField eigen_vectors;
    FlatField means;
    FlatField pressures;
    RealType time;
    RealType band;
    RealType band1;
    RealType band2;
    RealType band3;
    RealType noise_band1;
    RealType noise_band2;
    RealType noise_band3;
    RealType latitude;
    RealType longitude;
    RealType levels;
    RealType temperature;
    RealType watervapor;
    RealType numpcs;
    RealType channels;
    RealType princ_comp;
    RealType band1_nu;
    RealType band2_nu;
    RealType band3_nu;
    RealType band1_mean;
    RealType band2_mean;
    RealType band3_mean;
    RealType band1_kur;
    RealType band2_kur;
    RealType band3_kur;
    RealType pressure;
    Linear1DSet time_set;
    Linear1DSet band_set;
    Linear2DSet eigen_set;
    Linear1DSet levels_set;
    Gridded1DSet band1_set;
    Gridded1DSet band2_set;
    Gridded1DSet band3_set;
    DataReferenceImpl time_ref;
    DataReferenceImpl num_eigen_ref;
    DataReferenceImpl b1_ref;
    DataReferenceImpl b1r_ref;
    DataReferenceImpl b1d_ref;
    DataReferenceImpl b2_ref;
    DataReferenceImpl b2r_ref;
    DataReferenceImpl b2d_ref;
    DataReferenceImpl b3_ref;
    DataReferenceImpl b3r_ref;
    DataReferenceImpl b3d_ref;
    DataReferenceImpl n1_ref;
    DataReferenceImpl n1r_ref;
    DataReferenceImpl n2_ref;
    DataReferenceImpl n2r_ref;
    DataReferenceImpl n3_ref;
    DataReferenceImpl n3r_ref;
    DataReferenceImpl ll_ref;
    DataReferenceImpl select_ll_ref;
    DataReferenceImpl map_ref;
    DataReferenceImpl temp_ref;
    DataReferenceImpl wv_ref;
    FunctionType b1_func;
    FunctionType b2_func;
    FunctionType b3_func;
    FunctionType n1_func;
    FunctionType n2_func;
    FunctionType n3_func;
    RealTupleType latlon;
    FunctionType latlon_func;
    FunctionType temp_profile;
    FunctionType wv_profile;
    float[][] eigen_values;
    float[][] mean_values;
    Gridded1DSet pressureSet;
    FlatField ll_field;
    RealTuple[] ll_select;
    FlatField[] tp;
    FlatField[] wvp;
    DisplayImpl displayb1;
    DisplayImpl displayb2;
    DisplayImpl displayb3;
    DisplayImpl displayll;
    Vector sMaps_b1;
    Vector cMaps_b1;
    Vector sMaps_b2;
    Vector cMaps_b2;
    Vector sMaps_b3;
    Vector cMaps_b3;
    int toggle;
    float band1_lo;
    float band1_hi;
    float band2_lo;
    float band2_hi;
    float band3_lo;
    float band3_hi;
    float[][] lls;
    RealTupleType scatter_range_b1;
    RealTupleType scatter_range_b2;
    RealTupleType scatter_range_b3;
    RealType scatter_index;
    FunctionType scatter_type_b1;
    FunctionType scatter_type_b2;
    FunctionType scatter_type_b3;
    final ScalarMap kur1_rgb;
    final ScalarMap kur2_rgb;
    final ScalarMap kur3_rgb;
    DataReferenceImpl zero_b1_ref;
    DataReferenceImpl zero_b2_ref;
    DataReferenceImpl zero_b3_ref;
    ScalarMap lonmap;
    ScalarMap latmap;

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args.length < 1) {
            System.out.println("To run this program, type \"java visad.paoloa.PCS file.nc\"");
            System.out.println("where file.nc is a netCDF file containing GIFTS spectra and eigenvector");
            return;
        }
        PCS pCS = new PCS(args[0]);
    }

    public PCS(String filename) throws VisADException, RemoteException, IOException {
        Plain plain = new Plain();
        this.file_data = (Tuple)plain.open(filename);
        plain = null;
        this.time_series = (FieldImpl)this.file_data.getComponent(0);
        this.eigen_vectors = (FlatField)this.file_data.getComponent(1);
        this.means = (FlatField)this.file_data.getComponent(2);
        this.pressures = (FlatField)this.file_data.getComponent(3);
        FunctionType time_type = (FunctionType)this.time_series.getType();
        FunctionType eigen_type = (FunctionType)this.eigen_vectors.getType();
        FunctionType means_type = (FunctionType)this.means.getType();
        FunctionType pres_type = (FunctionType)this.pressures.getType();
        this.time = (RealType)time_type.getDomain().getComponent(0);
        TupleType time_range = (TupleType)time_type.getRange();
        FunctionType tr0 = (FunctionType)time_range.getComponent(0);
        FunctionType tr1 = (FunctionType)time_range.getComponent(1);
        FunctionType tr2 = (FunctionType)time_range.getComponent(2);
        this.band = (RealType)tr0.getDomain().getComponent(0);
        RealTupleType bands = (RealTupleType)tr0.getRange();
        this.band1 = (RealType)bands.getComponent(0);
        this.band2 = (RealType)bands.getComponent(1);
        this.band3 = (RealType)bands.getComponent(2);
        this.noise_band1 = (RealType)bands.getComponent(3);
        this.noise_band2 = (RealType)bands.getComponent(4);
        this.noise_band3 = (RealType)bands.getComponent(5);
        this.latlon = (RealTupleType)tr1.getRange();
        this.latitude = (RealType)this.latlon.getComponent(0);
        this.longitude = (RealType)this.latlon.getComponent(1);
        this.levels = (RealType)tr2.getDomain().getComponent(0);
        RealTupleType tuplewv = (RealTupleType)tr2.getRange();
        this.temperature = (RealType)tuplewv.getComponent(0);
        this.watervapor = (RealType)tuplewv.getComponent(1);
        RealTupleType ed = eigen_type.getDomain();
        this.numpcs = (RealType)ed.getComponent(0);
        this.channels = (RealType)ed.getComponent(1);
        this.princ_comp = (RealType)eigen_type.getRange();
        RealTupleType mr = (RealTupleType)means_type.getRange();
        this.band1_nu = (RealType)mr.getComponent(0);
        this.band2_nu = (RealType)mr.getComponent(1);
        this.band3_nu = (RealType)mr.getComponent(2);
        this.band1_mean = (RealType)mr.getComponent(3);
        this.band2_mean = (RealType)mr.getComponent(4);
        this.band3_mean = (RealType)mr.getComponent(5);
        this.band1_kur = (RealType)mr.getComponent(6);
        this.band2_kur = (RealType)mr.getComponent(7);
        this.band3_kur = (RealType)mr.getComponent(8);
        this.pressure = (RealType)pres_type.getRange();
        this.scatter_range_b1 = new RealTupleType(this.band, this.band1, this.band1_kur);
        this.scatter_range_b2 = new RealTupleType(this.band, this.band2, this.band2_kur);
        this.scatter_range_b3 = new RealTupleType(this.band, this.band3, this.band3_kur);
        this.scatter_index = RealType.getRealType("scatter_index");
        this.scatter_type_b1 = new FunctionType(this.scatter_index, this.scatter_range_b1);
        this.scatter_type_b2 = new FunctionType(this.scatter_index, this.scatter_range_b2);
        this.scatter_type_b3 = new FunctionType(this.scatter_index, this.scatter_range_b3);
        this.b1_func = new FunctionType(this.band, this.band1);
        this.b2_func = new FunctionType(this.band, this.band2);
        this.b3_func = new FunctionType(this.band, this.band3);
        this.n1_func = new FunctionType(this.band, this.noise_band1);
        this.n2_func = new FunctionType(this.band, this.noise_band2);
        this.n3_func = new FunctionType(this.band, this.noise_band3);
        this.latlon_func = new FunctionType(this.time, this.latlon);
        this.temp_profile = new FunctionType(this.pressure, this.temperature);
        this.wv_profile = new FunctionType(this.pressure, this.watervapor);
        Tuple tt = (Tuple)this.time_series.getSample(0);
        this.time_set = (Linear1DSet)this.time_series.getDomainSet();
        this.band_set = (Linear1DSet)((Field)tt.getComponent(0)).getDomainSet();
        this.eigen_set = (Linear2DSet)this.eigen_vectors.getDomainSet();
        this.levels_set = (Linear1DSet)((Field)tt.getComponent(2)).getDomainSet();
        this.ntimes = this.time_set.getLength();
        this.nbands = this.band_set.getLength();
        int[] lens = this.eigen_set.getLengths();
        this.npcs = lens[0];
        this.nchannels = lens[1];
        if (this.nchannels != 3 * this.nbands) {
            throw new VisADException("nchannels " + this.nchannels + " != 3 * " + this.nbands + " nbands");
        }
        this.nlevels = this.levels_set.getLength();
        float[][] f_array = new float[1][this.nbands];
        int ii = 0;
        while (ii < this.nbands) {
            f_array[0][ii] = 0.0f;
            ++ii;
        }
        FlatField zero_b1 = new FlatField(this.b1_func, this.band_set);
        FlatField zero_b2 = new FlatField(this.b2_func, this.band_set);
        FlatField zero_b3 = new FlatField(this.b3_func, this.band_set);
        zero_b1.setSamples(f_array, false);
        zero_b2.setSamples(f_array, false);
        zero_b3.setSamples(f_array, false);
        double[][] d_array = this.means.getValues();
        double[][] nu_vals = new double[1][this.nbands];
        nu_vals[0] = d_array[0];
        this.band1_set = new Gridded1DSet((MathType)this.band, Set.doubleToFloat(nu_vals), this.nbands);
        this.band1_lo = this.band1_set.getLowX();
        this.band1_hi = this.band1_set.getHiX();
        nu_vals[0] = d_array[1];
        this.band2_set = new Gridded1DSet((MathType)this.band, Set.doubleToFloat(nu_vals), this.nbands);
        this.band2_lo = this.band2_set.getLowX();
        this.band2_hi = this.band2_set.getHiX();
        nu_vals[0] = d_array[2];
        this.band3_set = new Gridded1DSet((MathType)this.band, Set.doubleToFloat(nu_vals), this.nbands);
        this.band3_lo = this.band3_set.getLowX();
        this.band3_hi = this.band3_set.getHiX();
        this.b1_ref = new DataReferenceImpl("b1_ref");
        this.b1r_ref = new DataReferenceImpl("b1r_ref");
        this.b1d_ref = new DataReferenceImpl("b1d_ref");
        this.b2_ref = new DataReferenceImpl("b2_ref");
        this.b2r_ref = new DataReferenceImpl("b2r_ref");
        this.b2d_ref = new DataReferenceImpl("b2d_ref");
        this.b3_ref = new DataReferenceImpl("b3_ref");
        this.b3r_ref = new DataReferenceImpl("b3r_ref");
        this.b3d_ref = new DataReferenceImpl("b3d_ref");
        this.n1_ref = new DataReferenceImpl("n1_ref");
        this.n1r_ref = new DataReferenceImpl("n1r_ref");
        this.n2_ref = new DataReferenceImpl("n2_ref");
        this.n2r_ref = new DataReferenceImpl("n2r_ref");
        this.n3_ref = new DataReferenceImpl("n3_ref");
        this.n3r_ref = new DataReferenceImpl("n3r_ref");
        this.ll_ref = new DataReferenceImpl("ll_ref");
        this.select_ll_ref = new DataReferenceImpl("select_ll_ref");
        this.map_ref = new DataReferenceImpl("map_ref");
        this.wv_ref = new DataReferenceImpl("wv_ref");
        this.temp_ref = new DataReferenceImpl("temp_ref");
        this.time_ref = new DataReferenceImpl("time_ref");
        this.num_eigen_ref = new DataReferenceImpl("num_eigen_ref");
        this.zero_b1_ref = new DataReferenceImpl("zero_b1_ref");
        this.zero_b2_ref = new DataReferenceImpl("zero_b2_ref");
        this.zero_b3_ref = new DataReferenceImpl("zero_b3_ref");
        this.zero_b1_ref.setData(zero_b1);
        this.zero_b2_ref.setData(zero_b2);
        this.zero_b3_ref.setData(zero_b3);
        this.toggle = 0;
        this.sMaps_b1 = new Vector();
        this.cMaps_b1 = new Vector();
        this.kur1_rgb = new ScalarMap(this.band1_kur, Display.RGB);
        this.displayb1 = new DisplayImplJ3D("displayb1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        final ScalarMap bmapb1 = new ScalarMap(this.band, Display.XAxis);
        bmapb1.addScalarMapListener(this);
        this.sMaps_b1.addElement(bmapb1);
        this.displayb1.addMap(bmapb1);
        ScalarMap smap = new ScalarMap(this.band1, Display.YAxis);
        this.sMaps_b1.addElement(smap);
        this.displayb1.addMap(smap);
        GraphicsModeControl modeb1 = this.displayb1.getGraphicsModeControl();
        modeb1.setScaleEnable(true);
        ConstantMap[] yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        ConstantMap[] cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        this.cMaps_b1.addElement(yellow);
        this.cMaps_b1.addElement(cyan);
        this.displayb1.setAlwaysAutoScale(true);
        this.displayb1.addReference(this.b1_ref, yellow);
        this.displayb1.addReference(this.b1r_ref, cyan);
        this.sMaps_b2 = new Vector();
        this.cMaps_b2 = new Vector();
        this.kur2_rgb = new ScalarMap(this.band2_kur, Display.RGB);
        this.displayb2 = new DisplayImplJ3D("displayb2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        final ScalarMap bmapb2 = new ScalarMap(this.band, Display.XAxis);
        this.sMaps_b2.addElement(bmapb2);
        this.displayb2.addMap(bmapb2);
        ScalarMap smap2 = new ScalarMap(this.band2, Display.YAxis);
        this.sMaps_b2.addElement(smap2);
        this.displayb2.addMap(smap2);
        GraphicsModeControl modeb2 = this.displayb2.getGraphicsModeControl();
        modeb2.setScaleEnable(true);
        yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        this.cMaps_b2.addElement(yellow);
        this.cMaps_b2.addElement(cyan);
        this.displayb2.setAlwaysAutoScale(true);
        this.displayb2.addReference(this.b2_ref, yellow);
        this.displayb2.addReference(this.b2r_ref, cyan);
        this.sMaps_b3 = new Vector();
        this.cMaps_b3 = new Vector();
        this.kur3_rgb = new ScalarMap(this.band3_kur, Display.RGB);
        this.displayb3 = new DisplayImplJ3D("displayb3", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        final ScalarMap bmapb3 = new ScalarMap(this.band, Display.XAxis);
        this.sMaps_b3.addElement(bmapb3);
        this.displayb3.addMap(bmapb3);
        ScalarMap smap3 = new ScalarMap(this.band3, Display.YAxis);
        this.sMaps_b3.addElement(smap3);
        this.displayb3.addMap(smap3);
        GraphicsModeControl modeb3 = this.displayb3.getGraphicsModeControl();
        modeb3.setScaleEnable(true);
        yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        this.cMaps_b3.addElement(yellow);
        this.cMaps_b3.addElement(cyan);
        this.displayb3.setAlwaysAutoScale(true);
        this.displayb3.addReference(this.b3_ref, yellow);
        this.displayb3.addReference(this.b3r_ref, cyan);
        DisplayImplJ3D displayn1 = new DisplayImplJ3D("displayn1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        final ScalarMap bmapn1 = new ScalarMap(this.band, Display.XAxis);
        displayn1.addMap(bmapn1);
        displayn1.addMap(new ScalarMap(this.noise_band1, Display.YAxis));
        GraphicsModeControl moden1 = ((DisplayImpl)displayn1).getGraphicsModeControl();
        moden1.setScaleEnable(true);
        yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        displayn1.addReference(this.n1_ref, yellow);
        displayn1.addReference(this.n1r_ref, cyan);
        DisplayImplJ3D displayn2 = new DisplayImplJ3D("displayn2", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        final ScalarMap bmapn2 = new ScalarMap(this.band, Display.XAxis);
        displayn2.addMap(bmapn2);
        displayn2.addMap(new ScalarMap(this.noise_band2, Display.YAxis));
        GraphicsModeControl moden2 = ((DisplayImpl)displayn2).getGraphicsModeControl();
        moden2.setScaleEnable(true);
        yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        displayn2.addReference(this.n2_ref, yellow);
        displayn2.addReference(this.n2r_ref, cyan);
        DisplayImplJ3D displayn3 = new DisplayImplJ3D("displayn3", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        final ScalarMap bmapn3 = new ScalarMap(this.band, Display.XAxis);
        displayn3.addMap(bmapn3);
        displayn3.addMap(new ScalarMap(this.noise_band3, Display.YAxis));
        GraphicsModeControl moden3 = ((DisplayImpl)displayn3).getGraphicsModeControl();
        moden3.setScaleEnable(true);
        yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue)};
        cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red)};
        displayn3.addReference(this.n3_ref, yellow);
        displayn3.addReference(this.n3r_ref, cyan);
        this.displayll = new DisplayImplJ3D("displayll", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        this.displayll.addDisplayListener(this);
        this.lonmap = new ScalarMap(this.longitude, Display.XAxis);
        this.displayll.addMap(this.lonmap);
        this.latmap = new ScalarMap(this.latitude, Display.YAxis);
        this.displayll.addMap(this.latmap);
        GraphicsModeControl modell = this.displayll.getGraphicsModeControl();
        modell.setScaleEnable(true);
        yellow = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(5.0, Display.PointSize)};
        cyan = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap(0.5, Display.Green), new ConstantMap(0.5, Display.Blue), new ConstantMap(5.0, Display.PointSize)};
        this.displayll.addReference(this.select_ll_ref, yellow);
        this.displayll.addReference(this.ll_ref, cyan);
        this.displayll.addReference(this.map_ref);
        DisplayImplJ3D displayprof = new DisplayImplJ3D("displayprof", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        displayprof.addMap(new ScalarMap(this.temperature, Display.XAxis));
        displayprof.addMap(new ScalarMap(this.watervapor, Display.XAxis));
        ScalarMap pmap = new ScalarMap(this.pressure, Display.YAxis);
        pmap.setRange(1050.0, 0.0);
        displayprof.addMap(pmap);
        GraphicsModeControl modeprof = ((DisplayImpl)displayprof).getGraphicsModeControl();
        modeprof.setScaleEnable(true);
        ConstantMap[] red = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(0.0, Display.Green)};
        ConstantMap[] green = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(0.0, Display.Red)};
        displayprof.addReference(this.wv_ref, green);
        displayprof.addReference(this.temp_ref, red);
        JFrame frame = new JFrame("Principal Components");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setSize(WIDTH, HEIGHT);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BoxLayout(big_panel, 1));
        big_panel.setAlignmentY(0.0f);
        big_panel.setAlignmentX(0.0f);
        frame.getContentPane().add(big_panel);
        JPanel sliders = new JPanel();
        sliders.setName("PCS Sliders");
        sliders.setFont(new Font("Dialog", 0, 12));
        sliders.setLayout(new BoxLayout(sliders, 0));
        sliders.setAlignmentY(0.0f);
        sliders.setAlignmentX(0.0f);
        big_panel.add(sliders);
        this.time_ref.setData(new Real(this.time, 1.0));
        sliders.add(new VisADSlider("neigen", 0, this.npcs, 0, 1.0, this.num_eigen_ref, this.numpcs));
        JButton button = new JButton("kurtosis");
        button.addActionListener(this);
        button.setActionCommand("kurtosis");
        sliders.add(button);
        RangeSlider rs = new RangeSlider("band range", 0.0f, this.nbands){

            public void valuesUpdated() {
                float scale1 = (PCS.this.band1_hi - PCS.this.band1_lo) / (float)PCS.this.nbands;
                float scale2 = (PCS.this.band2_hi - PCS.this.band2_lo) / (float)PCS.this.nbands;
                float scale3 = (PCS.this.band3_hi - PCS.this.band3_lo) / (float)PCS.this.nbands;
                float[] minmax = this.getMinMaxValues();
                float min = minmax[0];
                float max = minmax[1];
                try {
                    float b_lo = PCS.this.band1_lo + scale1 * min;
                    float b_hi = PCS.this.band1_hi - scale1 * ((float)PCS.this.nbands - max);
                    bmapb1.setRange(b_lo, b_hi);
                    bmapn1.setRange(b_lo, b_hi);
                    b_lo = PCS.this.band2_lo + scale2 * min;
                    b_hi = PCS.this.band2_hi - scale2 * ((float)PCS.this.nbands - max);
                    bmapb2.setRange(b_lo, b_hi);
                    bmapn2.setRange(b_lo, b_hi);
                    b_lo = PCS.this.band3_lo + scale3 * min;
                    b_hi = PCS.this.band3_hi - scale3 * ((float)PCS.this.nbands - max);
                    bmapb3.setRange(b_lo, b_hi);
                    bmapn3.setRange(b_lo, b_hi);
                }
                catch (VisADException exc) {
                }
                catch (RemoteException exc) {}
            }
        };
        sliders.add(rs);
        JPanel top = new JPanel();
        top.setName("PCS Sliders");
        top.setFont(new Font("Dialog", 0, 12));
        top.setLayout(new BoxLayout(top, 0));
        top.setAlignmentY(0.0f);
        top.setAlignmentX(0.0f);
        big_panel.add(top);
        JPanel panel1 = (JPanel)this.displayb1.getComponent();
        JPanel panel2 = (JPanel)this.displayb2.getComponent();
        JPanel panel3 = (JPanel)this.displayb3.getComponent();
        JPanel panel4 = (JPanel)this.displayll.getComponent();
        CompoundBorder etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        panel1.setBorder(etchedBorder5);
        panel2.setBorder(etchedBorder5);
        panel3.setBorder(etchedBorder5);
        panel4.setBorder(etchedBorder5);
        top.add(panel1);
        top.add(panel2);
        top.add(panel3);
        top.add(panel4);
        JPanel bottom = new JPanel();
        bottom.setName("PCS Sliders");
        bottom.setFont(new Font("Dialog", 0, 12));
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.setAlignmentY(0.0f);
        bottom.setAlignmentX(0.0f);
        big_panel.add(bottom);
        JPanel panel5 = (JPanel)displayn1.getComponent();
        JPanel panel6 = (JPanel)displayn2.getComponent();
        JPanel panel7 = (JPanel)displayn3.getComponent();
        JPanel panel8 = (JPanel)displayprof.getComponent();
        panel5.setBorder(etchedBorder5);
        panel6.setBorder(etchedBorder5);
        panel7.setBorder(etchedBorder5);
        panel8.setBorder(etchedBorder5);
        bottom.add(panel5);
        bottom.add(panel6);
        bottom.add(panel7);
        bottom.add(panel8);
        float[][] values = this.means.getFloats(false);
        this.mean_values = new float[3][this.nbands];
        this.mean_values[0] = values[3];
        this.mean_values[1] = values[4];
        this.mean_values[2] = values[5];
        values = this.eigen_vectors.getFloats(false);
        this.eigen_values = new float[this.npcs][this.nchannels];
        int j = 0;
        while (j < this.npcs) {
            double mag = 0.0;
            double m = 0.0;
            int i = 0;
            while (i < this.nchannels) {
                this.eigen_values[j][i] = values[0][j + this.npcs * i];
                m += (double)this.npcs;
                mag += (double)(this.eigen_values[j][i] * this.eigen_values[j][i]);
                ++i;
            }
            float invmag = (float)(1.0 / Math.sqrt(mag));
            int i2 = 0;
            while (i2 < this.nchannels) {
                float[] fArray = this.eigen_values[j];
                int n = i2++;
                fArray[n] = fArray[n] * invmag;
            }
            ++j;
        }
        values = this.pressures.getFloats(false);
        Gridded1DSet pressureSet = new Gridded1DSet((MathType)this.pressure, values, this.nlevels);
        float latmin = Float.MAX_VALUE;
        float latmax = -3.4028235E38f;
        float lonmin = Float.MAX_VALUE;
        float lonmax = -3.4028235E38f;
        float del_lat = 1.0f;
        float del_lon = 1.0f;
        this.lls = new float[2][this.ntimes];
        this.ll_select = new RealTuple[this.ntimes];
        int i = 0;
        while (i < this.ntimes) {
            Tuple tup = (Tuple)this.time_series.getSample(i);
            FlatField ll = (FlatField)tup.getComponent(1);
            values = ll.getFloats(false);
            this.lls[0][i] = values[0][0];
            this.lls[1][i] = values[1][0];
            if (this.lls[0][i] < latmin) {
                latmin = this.lls[0][i];
            }
            if (this.lls[0][i] > latmax) {
                latmax = this.lls[0][i];
            }
            if (this.lls[1][i] < lonmin) {
                lonmin = this.lls[1][i];
            }
            if (this.lls[1][i] > lonmax) {
                lonmax = this.lls[1][i];
            }
            double[] vals = new double[]{values[0][0], values[1][0]};
            this.ll_select[i] = new RealTuple(this.latlon, vals);
            ++i;
        }
        this.ll_field = new FlatField(this.latlon_func, new Integer1DSet((MathType)this.time, this.ntimes));
        this.ll_field.setSamples(this.lls);
        this.ll_ref.setData(this.ll_field);
        this.lonmap.setRange(lonmax, lonmin);
        this.latmap.setRange(latmin, latmax);
        BaseMapAdapter baseMap = new BaseMapAdapter("OUTLSUPW");
        if (baseMap.isEastPositive()) {
            baseMap.setEastPositive(false);
        }
        baseMap.setLatLonLimits(latmin - del_lat, latmax + del_lat, lonmin - del_lon, lonmax + del_lon);
        UnionSet map = baseMap.getData();
        this.map_ref.setData(map);
        this.tp = new FlatField[this.ntimes];
        this.wvp = new FlatField[this.ntimes];
        int i3 = 0;
        while (i3 < this.ntimes) {
            Tuple tup = (Tuple)this.time_series.getSample(i3);
            FlatField twv = (FlatField)tup.getComponent(2);
            values = twv.getFloats(false);
            float[][] t_values = new float[][]{values[0]};
            this.tp[i3] = new FlatField(this.temp_profile, pressureSet);
            this.tp[i3].setSamples(t_values, false);
            float[][] wv_values = new float[][]{values[1]};
            this.wvp[i3] = new FlatField(this.wv_profile, pressureSet);
            this.wvp[i3].setSamples(wv_values, false);
            ++i3;
        }
        CellImpl slider_cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                int t = (int)((Real)PCS.this.time_ref.getData()).getValue() - 1;
                int ne = (int)((Real)PCS.this.num_eigen_ref.getData()).getValue();
                if (t < 0 || PCS.this.ntimes <= t || ne < 0 || PCS.this.npcs < ne) {
                    System.out.println("time " + t + " or neigens " + ne + " out of bounds");
                    return;
                }
                Tuple tup = (Tuple)PCS.this.time_series.getSample(t);
                FlatField bn = (FlatField)tup.getComponent(0);
                float[][] cvalues = bn.getFloats(false);
                float[] b = new float[PCS.this.nchannels];
                float[] n = new float[PCS.this.nchannels];
                float[] bm = new float[PCS.this.nchannels];
                int k = 0;
                while (k < 3) {
                    int kb = k * PCS.this.nbands;
                    int i = 0;
                    while (i < PCS.this.nbands) {
                        b[kb + i] = cvalues[k][i];
                        n[kb + i] = cvalues[3 + k][i];
                        bm[kb + i] = PCS.this.mean_values[k][i];
                        ++i;
                    }
                    ++k;
                }
                float[] bcoefs = new float[ne];
                float[] ncoefs = new float[ne];
                int j = 0;
                while (j < ne) {
                    double bcoef = 0.0;
                    double ncoef = 0.0;
                    float[] pc = PCS.this.eigen_values[j];
                    int i = 0;
                    while (i < PCS.this.nchannels) {
                        bcoef += (double)(pc[i] * (b[i] - bm[i]));
                        ncoef += (double)(pc[i] * n[i]);
                        ++i;
                    }
                    bcoefs[j] = (float)bcoef;
                    ncoefs[j] = (float)ncoef;
                    ++j;
                }
                float[] rb = new float[PCS.this.nchannels];
                float[] rn = new float[PCS.this.nchannels];
                int i = 0;
                while (i < PCS.this.nchannels) {
                    float bv = bm[i];
                    float nv = 0.0f;
                    int j2 = 0;
                    while (j2 < ne) {
                        bv += bcoefs[j2] * PCS.this.eigen_values[j2][i];
                        nv += ncoefs[j2] * PCS.this.eigen_values[j2][i];
                        ++j2;
                    }
                    rb[i] = bv;
                    rn[i] = nv;
                    ++i;
                }
                float[][] rvalues = new float[6][PCS.this.nbands];
                int k2 = 0;
                while (k2 < 3) {
                    int kb = k2 * PCS.this.nbands;
                    int i2 = 0;
                    while (i2 < PCS.this.nbands) {
                        rvalues[k2][i2] = rb[kb + i2];
                        rvalues[3 + k2][i2] = rn[kb + i2];
                        ++i2;
                    }
                    ++k2;
                }
                FlatField stat_field = (FlatField)PCS.this.file_data.getComponent(2);
                double[][] stats = stat_field.getValues();
                float[][] vals = new float[][]{cvalues[0]};
                FlatField b1 = new FlatField(PCS.this.b1_func, PCS.this.band1_set);
                b1.setSamples(vals, false);
                PCS.this.b1_ref.setData(b1);
                vals = new float[][]{rvalues[0]};
                FlatField b1r = new FlatField(PCS.this.b1_func, PCS.this.band1_set);
                b1r.setSamples(vals, false);
                PCS.this.b1r_ref.setData(b1r);
                double[][] diff_vals = ((FlatField)b1.subtract(b1r)).getValues();
                float[][] new_vals = new float[3][];
                Set set = b1.getDomainSet();
                float[][] samps = set.getSamples();
                new_vals[0] = samps[0];
                new_vals[1] = Set.doubleToFloat(diff_vals)[0];
                new_vals[2] = Set.doubleToFloat(stats)[6];
                Integer1DSet iset = new Integer1DSet((MathType)PCS.this.scatter_index, PCS.this.nbands);
                FlatField scatter_field = new FlatField(PCS.this.scatter_type_b1, iset);
                scatter_field.setSamples(new_vals, false);
                PCS.this.b1d_ref.setData(scatter_field);
                vals = new float[][]{cvalues[1]};
                FlatField b2 = new FlatField(PCS.this.b2_func, PCS.this.band2_set);
                b2.setSamples(vals, false);
                PCS.this.b2_ref.setData(b2);
                vals = new float[][]{rvalues[1]};
                FlatField b2r = new FlatField(PCS.this.b2_func, PCS.this.band2_set);
                b2r.setSamples(vals, false);
                PCS.this.b2r_ref.setData(b2r);
                diff_vals = ((FlatField)b2.subtract(b2r)).getValues();
                new_vals = new float[3][];
                set = b2.getDomainSet();
                samps = set.getSamples();
                new_vals[0] = samps[0];
                new_vals[1] = Set.doubleToFloat(diff_vals)[0];
                new_vals[2] = Set.doubleToFloat(stats)[7];
                iset = new Integer1DSet((MathType)PCS.this.scatter_index, PCS.this.nbands);
                scatter_field = new FlatField(PCS.this.scatter_type_b2, iset);
                scatter_field.setSamples(new_vals, false);
                PCS.this.b2d_ref.setData(scatter_field);
                vals = new float[][]{cvalues[2]};
                FlatField b3 = new FlatField(PCS.this.b3_func, PCS.this.band3_set);
                b3.setSamples(vals, false);
                PCS.this.b3_ref.setData(b3);
                vals = new float[][]{rvalues[2]};
                FlatField b3r = new FlatField(PCS.this.b3_func, PCS.this.band3_set);
                b3r.setSamples(vals, false);
                PCS.this.b3r_ref.setData(b3r);
                diff_vals = ((FlatField)b3.subtract(b3r)).getValues();
                new_vals = new float[3][];
                set = b3.getDomainSet();
                samps = set.getSamples();
                new_vals[0] = samps[0];
                new_vals[1] = Set.doubleToFloat(diff_vals)[0];
                new_vals[2] = Set.doubleToFloat(stats)[8];
                iset = new Integer1DSet((MathType)PCS.this.scatter_index, PCS.this.nbands);
                scatter_field = new FlatField(PCS.this.scatter_type_b3, iset);
                scatter_field.setSamples(new_vals, false);
                PCS.this.b3d_ref.setData(scatter_field);
                vals = new float[][]{cvalues[3]};
                FlatField n1 = new FlatField(PCS.this.n1_func, PCS.this.band1_set);
                n1.setSamples(vals, false);
                PCS.this.n1_ref.setData(n1);
                vals = new float[][]{rvalues[3]};
                FlatField n1r = new FlatField(PCS.this.n1_func, PCS.this.band1_set);
                n1r.setSamples(vals, false);
                PCS.this.n1r_ref.setData(n1r);
                vals = new float[][]{cvalues[4]};
                FlatField n2 = new FlatField(PCS.this.n2_func, PCS.this.band2_set);
                n2.setSamples(vals, false);
                PCS.this.n2_ref.setData(n2);
                vals = new float[][]{rvalues[4]};
                FlatField n2r = new FlatField(PCS.this.n2_func, PCS.this.band2_set);
                n2r.setSamples(vals, false);
                PCS.this.n2r_ref.setData(n2r);
                vals = new float[][]{cvalues[5]};
                FlatField n3 = new FlatField(PCS.this.n3_func, PCS.this.band3_set);
                n3.setSamples(vals, false);
                PCS.this.n3_ref.setData(n3);
                vals = new float[][]{rvalues[5]};
                FlatField n3r = new FlatField(PCS.this.n3_func, PCS.this.band3_set);
                n3r.setSamples(vals, false);
                PCS.this.n3r_ref.setData(n3r);
                PCS.this.select_ll_ref.setData(PCS.this.ll_select[t]);
                PCS.this.temp_ref.setData(PCS.this.tp[t]);
                PCS.this.wv_ref.setData(PCS.this.wvp[t]);
            }
        };
        slider_cell.addReference(this.time_ref);
        slider_cell.addReference(this.num_eigen_ref);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("kurtosis")) {
            if (this.toggle == 0) {
                try {
                    this.displayb1.removeAllReferences();
                    this.displayb1.clearMaps();
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(0));
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(1));
                    this.displayb1.addMap(this.kur1_rgb);
                    this.displayb1.addReference(this.b1d_ref);
                    this.displayb2.removeAllReferences();
                    this.displayb2.clearMaps();
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(0));
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(1));
                    this.displayb2.addMap(this.kur2_rgb);
                    this.displayb2.addReference(this.b2d_ref);
                    this.displayb3.removeAllReferences();
                    this.displayb3.clearMaps();
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(0));
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(1));
                    this.displayb3.addMap(this.kur3_rgb);
                    this.displayb3.addReference(this.b3d_ref);
                }
                catch (VisADException exc) {
                    System.out.println(exc.getMessage());
                }
                catch (RemoteException exc) {
                    System.out.println(exc.getMessage());
                }
                this.toggle = 1;
            } else {
                try {
                    this.displayb1.removeAllReferences();
                    this.displayb1.clearMaps();
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(0));
                    this.displayb1.addMap((ScalarMap)this.sMaps_b1.elementAt(1));
                    this.displayb1.addReference(this.b1_ref, (ConstantMap[])this.cMaps_b1.elementAt(0));
                    this.displayb1.addReference(this.b1r_ref, (ConstantMap[])this.cMaps_b1.elementAt(1));
                    this.displayb2.removeAllReferences();
                    this.displayb2.clearMaps();
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(0));
                    this.displayb2.addMap((ScalarMap)this.sMaps_b2.elementAt(1));
                    this.displayb2.addReference(this.b2_ref, (ConstantMap[])this.cMaps_b2.elementAt(0));
                    this.displayb2.addReference(this.b2r_ref, (ConstantMap[])this.cMaps_b2.elementAt(1));
                    this.displayb3.removeAllReferences();
                    this.displayb3.clearMaps();
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(0));
                    this.displayb3.addMap((ScalarMap)this.sMaps_b3.elementAt(1));
                    this.displayb3.addReference(this.b3_ref, (ConstantMap[])this.cMaps_b3.elementAt(0));
                    this.displayb3.addReference(this.b3r_ref, (ConstantMap[])this.cMaps_b3.elementAt(1));
                }
                catch (VisADException exc) {
                    System.out.println(exc.getMessage());
                }
                catch (RemoteException exc) {
                    System.out.println(exc.getMessage());
                }
                this.toggle = 0;
            }
        }
    }

    public void mapChanged(ScalarMapEvent evt) throws VisADException, RemoteException {
        ScalarMap scalarMap = evt.getScalarMap();
    }

    public void controlChanged(ScalarMapControlEvent evt) {
    }

    public void displayChanged(DisplayEvent evt) throws VisADException, RemoteException {
        if (evt.getId() == 4) {
            double[] scale_offset = new double[2];
            double[] data = new double[2];
            double[] display = new double[2];
            double[] cur = null;
            double del_lon = 3.0;
            double del_lat = 3.0;
            cur = this.displayll.getDisplayRenderer().getCursor();
            this.lonmap.getScale(scale_offset, data, display);
            double lon = (cur[0] - scale_offset[1]) / scale_offset[0];
            this.latmap.getScale(scale_offset, data, display);
            double lat = (cur[1] - scale_offset[1]) / scale_offset[0];
            int tt = 0;
            while (tt < this.ntimes) {
                if ((double)this.lls[1][tt] < lon + del_lon && (double)this.lls[1][tt] > lon - del_lon && (double)this.lls[0][tt] < lat + del_lat && (double)this.lls[0][tt] > lat - del_lat) {
                    this.time_ref.setData(new Real(this.time, (double)(tt + 1)));
                    break;
                }
                ++tt;
            }
        }
    }
}

