/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import visad.install.ChooserList;
import visad.install.ClusterInstaller;
import visad.install.Download;
import visad.install.JavaFile;
import visad.install.Path;
import visad.install.ProgressMonitor;
import visad.install.SplashScreen;
import visad.install.Util;
import visad.util.CmdlineGenericConsumer;
import visad.util.CmdlineParser;

public class Main
extends CmdlineGenericConsumer {
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String ARCH_PROPERTY = "visad.install.arch";
    private static final String HOME_PROPERTY = "visad.install.home";
    private static final String PATH_PROPERTY = "visad.install.path";
    private static final String SPLASH_NAME = "visad-splash.jpg";
    private static final String JAR_NAME = "visad.jar";
    private static final String VISAD_JAR_URL = "ftp://ftp.ssec.wisc.edu/pub/visad-2.0/visad.jar";
    private boolean debug;
    private URL jarURL;
    private ChooserList chooser;
    private Path classpath;
    private Path path;
    private ArrayList jarList;
    private ArrayList javaList;
    private File installerJar;
    private JavaFile installerJava;
    private File installerJavaDir;
    private File installerJavaJar;
    private String archStr;
    private String cPushStr;
    private boolean useSuppliedJava;
    private boolean downloadLatestJar;
    private File javaInstallDir;
    private File jarInstallDir;
    private ClusterInstaller clusterInstaller;

    public Main(String[] args) {
        CmdlineParser cmdline = new CmdlineParser(this);
        if (!cmdline.processArgs(args)) {
            System.exit(1);
            return;
        }
        String ddStr = System.getProperty(HOME_PROPERTY);
        File distDir = ddStr == null ? null : new File(ddStr);
        if (distDir == null || !distDir.exists()) {
            distDir = new File(".");
        }
        SplashScreen ss = null;
        File splashFile = new File(distDir, SPLASH_NAME);
        if (splashFile.exists()) {
            ss = new SplashScreen(Main.getPath(splashFile));
            ss.setVisible(true);
        }
        boolean initResult = this.initialize(distDir);
        if (ss != null) {
            ss.setVisible(false);
        }
        if (!initResult) {
            System.exit(1);
            return;
        }
        if (this.debug) {
            this.dumpInitialState(distDir);
        }
        this.downloadLatestJar = false;
        this.useSuppliedJava = false;
        this.jarInstallDir = null;
        this.javaInstallDir = null;
        this.clusterInstaller = null;
        this.queryUser();
        if (this.debug) {
            this.dumpInstallState();
        }
        this.install();
    }

    private static final void checkJavaVersions(ArrayList list, int major, int minor) {
        int i = 0;
        while (i < list.size()) {
            JavaFile f = new JavaFile((File)list.get(i));
            if (f.matchMinimum(major, minor)) {
                list.set(i++, f);
                continue;
            }
            list.remove(i);
        }
    }

    public int checkOption(String mainName, char ch, String arg) {
        if (ch == 'x') {
            this.debug = true;
            return 1;
        }
        return 0;
    }

    private final void clusterPush(ProgressMonitor mon, String source, String target) {
        Process p;
        try {
            p = this.clusterInstaller.push(source, target);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        try {
            p.getOutputStream().close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        boolean looping = true;
        while (looping) {
            String line;
            block14: {
                if (in != null) {
                    try {
                        line = in.readLine();
                        if (line == null) {
                            in = null;
                            looping = err != null;
                            break block14;
                        }
                        if (mon == null) break block14;
                        mon.setDetail(line);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        break;
                    }
                }
            }
            if (err == null) continue;
            try {
                if (!err.ready() && in != null) continue;
                line = err.readLine();
                if (line == null) {
                    err = null;
                    looping = in != null;
                    continue;
                }
                if (mon == null) continue;
                mon.setDetail(line);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                break;
            }
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    private final void makeJVMBinariesExecutable() {
        Process p;
        if (this.path == null) {
            return;
        }
        ArrayList chmodList = this.path.find("chmod");
        if (chmodList == null || chmodList.size() == 0) {
            return;
        }
        File chmod = (File)chmodList.get(0);
        File jvmBin = new File(this.javaInstallDir, "bin");
        if (!jvmBin.exists()) {
            return;
        }
        String[] binFiles = jvmBin.list();
        if (binFiles == null || binFiles.length == 0) {
            return;
        }
        String[] cmd = new String[2 + binFiles.length];
        cmd[0] = chmod.toString();
        cmd[1] = "555";
        StringBuffer buf = new StringBuffer(jvmBin.toString());
        buf.append('/');
        int len = buf.length();
        int i = 0;
        while (i < binFiles.length) {
            buf.setLength(len);
            buf.append(binFiles[i]);
            cmd[i + 2] = buf.toString();
            ++i;
        }
        try {
            p = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    private static final File chooseDirectory(ChooserList chooser, ArrayList list, String title) {
        Object dList;
        int listLen = list == null ? 0 : list.size();
        boolean allDirs = true;
        int i = 0;
        while (i < listLen) {
            File f = (File)list.get(i);
            if (!f.isDirectory()) {
                allDirs = false;
                break;
            }
            ++i;
        }
        if (!allDirs) {
            dList = new File[listLen];
            int i2 = 0;
            while (i2 < listLen) {
                File f = (File)list.get(i2);
                dList[i2] = f.isDirectory() ? f : new File(f.getParent());
                ++i2;
            }
        } else {
            dList = listLen > 0 ? list.toArray(new File[list.size()]) : null;
        }
        chooser.setList((File[])dList);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(title);
        chooser.setApproveButtonToolTipText("Select directory");
        chooser.setApproveButtonText("Select...");
        int option = chooser.showDialog(null, "Select directory");
        if (option == 1) {
            return null;
        }
        File choice = chooser.getSelectedFile();
        if (!choice.exists()) {
            return choice;
        }
        if (choice.isDirectory()) {
            return choice;
        }
        return new File(choice.getParent());
    }

    private static final File chooseFile(ChooserList chooser, ArrayList list, String title) {
        if (list == null) {
            chooser.setList(null);
        } else {
            chooser.setList(list.toArray(new File[list.size()]));
        }
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        chooser.setApproveButtonToolTipText("Choose file");
        int option = chooser.showDialog(null, "Choose file");
        if (option == 1) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    private final void dumpInitialState(File distDir) {
        int i;
        if (distDir != null && distDir.exists()) {
            System.out.println("Distribution directory: " + distDir);
        } else {
            System.out.println("Distribution directory: UNKNOWN!");
        }
        if (this.installerJavaDir != null) {
            System.out.println("Supplied java directory: " + this.installerJavaDir);
        }
        if (this.installerJavaJar != null) {
            System.out.println("Supplied java jar file: " + this.installerJavaJar);
        }
        if (this.installerJava != null) {
            System.out.println("Supplied java: " + this.installerJava);
        }
        if (this.installerJar != null) {
            System.out.println("Supplied visad.jar: " + this.installerJar);
        }
        if (this.jarList == null || this.jarList.size() == 0) {
            System.err.println("No visad.jar found in " + this.classpath);
        } else {
            System.err.println("== jar file list ==");
            i = 0;
            while (i < this.jarList.size()) {
                System.out.println("#" + i + ": " + Main.getPath((File)this.jarList.get(i)));
                ++i;
            }
        }
        if (this.javaList == null || this.javaList.size() == 0) {
            System.err.println("No java executable found in path " + this.path);
        } else {
            System.err.println("== java executable list ==");
            i = 0;
            while (i < this.javaList.size()) {
                System.out.println("#" + i + ": " + Main.getPath((File)this.javaList.get(i)));
                ++i;
            }
        }
        if (this.cPushStr == null) {
            System.err.println("No cluster executable found in path " + this.path);
        } else {
            System.err.println("== cluster executable ==");
            System.out.println(this.cPushStr);
        }
    }

    private final void dumpInstallState() {
        if (this.useSuppliedJava) {
            System.err.println("Install java in " + this.javaInstallDir);
        }
        if (this.downloadLatestJar) {
            System.err.println("Download latest visad.jar");
        }
        System.err.println("Install visad.jar in " + this.jarInstallDir);
        if (this.clusterInstaller != null) {
            System.err.println("Push installed files out to cluster");
        }
    }

    private static final File extractInstallerFile(File distDir, ArrayList javaList) {
        String distPath = Main.getPath(distDir);
        Iterator iter = javaList.iterator();
        while (iter.hasNext()) {
            File thisFile = (File)iter.next();
            if (!Main.getPath(thisFile).startsWith(distPath)) continue;
            iter.remove();
            return thisFile;
        }
        return null;
    }

    private static final String getPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            return f.getPath();
        }
    }

    private final boolean initialize(File distDir) {
        ArrayList c3List;
        File tmpFile;
        this.chooser = new ChooserList();
        this.path = null;
        this.classpath = null;
        this.jarURL = null;
        this.javaList = null;
        this.jarList = null;
        try {
            this.classpath = new Path(System.getProperty(CLASSPATH_PROPERTY));
        }
        catch (IllegalArgumentException iae) {
            System.err.println(this.getClass().getName() + ": Couldn't get Java class path");
            return false;
        }
        String pathStr = System.getProperty(PATH_PROPERTY);
        if (pathStr == null) {
            this.path = null;
        } else {
            try {
                this.path = new Path(pathStr);
            }
            catch (IllegalArgumentException iae) {
                this.path = null;
            }
        }
        try {
            this.jarURL = new URL(VISAD_JAR_URL);
        }
        catch (MalformedURLException mue) {
            this.jarURL = null;
        }
        this.installerJar = null;
        this.jarList = this.classpath.findMatch(JAR_NAME);
        if (this.jarList != null) {
            Main.loseDuplicates(this.jarList);
            this.installerJar = Main.extractInstallerFile(distDir, this.jarList);
        }
        if (this.installerJar == null && this.jarURL == null) {
            System.err.println("Couldn't find either distributed jar file or jar file URL!");
            System.exit(1);
        }
        this.installerJava = null;
        this.installerJavaDir = null;
        if (this.path == null) {
            this.javaList = null;
        } else {
            this.javaList = this.path.find("java");
            if (this.javaList != null) {
                Main.loseDuplicates(this.javaList);
                Main.checkJavaVersions(this.javaList, 1, 2);
                this.installerJava = (JavaFile)Main.extractInstallerFile(distDir, this.javaList);
                if (this.installerJava != null && this.installerJava.getName().equals("java")) {
                    File canonJava = new File(Main.getPath(this.installerJava));
                    this.installerJavaDir = new File(canonJava.getParent());
                    if (this.installerJavaDir.getName().equals("bin")) {
                        this.installerJavaDir = new File(this.installerJavaDir.getParent());
                    }
                }
            }
        }
        this.archStr = System.getProperty(ARCH_PROPERTY);
        if (this.archStr != null && this.archStr.length() == 0) {
            this.archStr = null;
        }
        this.installerJavaJar = null;
        if (this.installerJavaDir == null && this.archStr != null && (tmpFile = new File(distDir, "jdk-" + this.archStr + ".jar")).exists()) {
            this.installerJavaJar = tmpFile;
        }
        this.cPushStr = null;
        if (this.path != null && (c3List = this.path.find("cpush")) != null) {
            Main.loseDuplicates(c3List);
            if (c3List != null && c3List.size() > 0) {
                this.cPushStr = Main.getPath((File)c3List.get(0));
            }
        }
        return true;
    }

    public void initializeArgs() {
        this.debug = false;
    }

    private final void install() {
        ProgressMonitor mon = new ProgressMonitor();
        mon.setPhase("Starting install");
        mon.setVisible(true);
        if (this.downloadLatestJar) {
            mon.setPhase("Downloading jar file");
            Download.getFile(this.jarURL, this.jarInstallDir, false);
        } else {
            mon.setPhase("Copying jar file");
            Util.copyFile(mon, this.installerJar, this.jarInstallDir, ".old");
        }
        if (this.clusterInstaller != null) {
            mon.setPhase("Pushing jar file to cluster");
            this.clusterPush(null, Main.getPath(new File(this.jarInstallDir, JAR_NAME)), Main.getPath(this.jarInstallDir));
        }
        if (this.useSuppliedJava) {
            mon.setPhase("Copying JVM");
            if (this.installerJavaDir != null) {
                if (this.javaInstallDir.exists()) {
                    this.javaInstallDir = new File(this.javaInstallDir, this.installerJavaDir.getName());
                }
                Util.copyDirectory(mon, this.installerJavaDir, this.javaInstallDir);
            } else {
                String jarTop = this.getJarTopDir(this.installerJavaJar);
                if (jarTop == null && this.archStr != null) {
                    jarTop = "jdk-" + this.archStr;
                }
                if (jarTop != null) {
                    this.javaInstallDir = new File(this.javaInstallDir, jarTop);
                }
                Util.copyJar(mon, this.installerJavaJar, this.javaInstallDir);
            }
            mon.setPhase("Setting JVM executable bits");
            this.makeJVMBinariesExecutable();
            if (this.clusterInstaller != null) {
                mon.setPhase("Pushing JVM to cluster");
                this.clusterPush(mon, this.javaInstallDir.toString(), this.javaInstallDir.getParent().toString());
            }
        }
        mon.setPhase("Install finished!");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {}
    }

    private String getJarTopDir(File source) {
        JarFile jar;
        try {
            jar = new JarFile(source);
        }
        catch (IOException ioe) {
            return null;
        }
        String topDir = null;
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String entryName = entry.getName();
            if ("META-INF/MANIFEST.MF".startsWith(entryName)) continue;
            int dirIdx = entryName.indexOf(File.separatorChar);
            String dirName = dirIdx < 0 ? entryName : entryName.substring(0, dirIdx);
            if (topDir == null) {
                topDir = dirName;
                continue;
            }
            if (topDir.equals(dirName)) continue;
            topDir = null;
            break;
        }
        return topDir;
    }

    private static final void loseDuplicates(ArrayList list) {
        int i = 0;
        while (i < list.size()) {
            Object objI = list.get(i);
            int j = i + 1;
            while (j < list.size()) {
                Object objJ = list.get(j);
                if (!objI.equals(objJ)) {
                    ++j;
                    continue;
                }
                list.remove(j);
            }
            ++i;
        }
    }

    public String optionUsage() {
        return super.optionUsage() + " [-x(debug)]";
    }

    private final void queryUser() {
        boolean STEP_INSTALL_JAR = false;
        boolean STEP_DOWNLOAD_JAR = true;
        int STEP_USE_SUPPLIED = 2;
        int STEP_INSTALL_JAVA = 3;
        int STEP_CLUSTER = 4;
        int STEP_FINISHED = 5;
        int step = 0;
        while (step < 5) {
            switch (step) {
                case 2: {
                    if (this.queryUserUseSuppliedJava()) {
                        ++step;
                        break;
                    }
                    --step;
                    break;
                }
                case 3: {
                    step += this.queryUserInstallJava();
                    break;
                }
                case 0: {
                    step += this.queryUserInstallJar();
                    break;
                }
                case 1: {
                    if (this.queryUserDownloadJar()) {
                        ++step;
                        break;
                    }
                    --step;
                    break;
                }
                case 4: {
                    if (this.queryUserClusterPush()) {
                        ++step;
                        break;
                    }
                    --step;
                }
            }
            if (step >= 0) continue;
            if (this.queryUserCancelInstall()) {
                System.exit(0);
                return;
            }
            step = 0;
        }
    }

    private final boolean queryUserCancelInstall() {
        String canMsg = "Do you want to cancel this install?";
        int n = JOptionPane.showConfirmDialog(null, canMsg, "Cancel install?", 0);
        return n == 0;
    }

    private final boolean queryUserClusterPush() {
        int result = 1;
        if (this.cPushStr != null) {
            String msg = "Would you like to push everything out to the cluster?";
            String title = "Push files to cluster?";
            result = JOptionPane.showConfirmDialog(null, msg, title, 1);
        }
        this.clusterInstaller = result != 0 ? null : new ClusterInstaller(this.cPushStr);
        return result != 2;
    }

    private final boolean queryUserDownloadJar() {
        int result = 0;
        if (this.installerJar != null) {
            String msg = "Would you like to download the latest visad.jar?";
            String title = "Download latest visad.jar?";
            result = JOptionPane.showConfirmDialog(null, msg, title, 1);
        }
        this.downloadLatestJar = result == 0;
        return result != 2;
    }

    private final int queryUserInstallJar() {
        this.jarInstallDir = Main.chooseDirectory(this.chooser, this.jarList, "Select the directory where the VisAD jar file should be installed");
        if (this.jarInstallDir == null) {
            return -1;
        }
        if (!this.jarInstallDir.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write to that directory!", "Bad directory?", 0);
            return 0;
        }
        return 1;
    }

    private final int queryUserInstallJava() {
        this.javaInstallDir = null;
        if (this.useSuppliedJava) {
            this.javaInstallDir = Main.chooseDirectory(this.chooser, null, "Select the directory in which the JDK should be installed");
            if (this.javaInstallDir == null) {
                return -1;
            }
            if (!this.javaInstallDir.canWrite()) {
                JOptionPane.showMessageDialog(null, "Cannot write to that directory!", "Bad directory?", 0);
                return 0;
            }
        }
        return 1;
    }

    private final boolean queryUserUseSuppliedJava() {
        int result = 1;
        if (this.installerJavaDir != null || this.installerJavaJar != null) {
            String msg = this.installerJavaDir != null ? "Would you like to install the supplied  Java Development Kit " + this.installerJava.getMajor() + "." + this.installerJava.getMinor() + " (" + this.installerJava.getVersionString() + ")?" : "Would you like to install the supplied  Java Development Kit?";
            String title = "Install supplied JDK?";
            result = JOptionPane.showConfirmDialog(null, msg, title, 1);
        }
        this.useSuppliedJava = result == 0;
        return result != 2;
    }

    public static final void main(String[] args) {
        new Main(args);
        System.exit(0);
    }
}

