/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Thing;
import visad.ThingReference;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaUtil;
import visad.formula.FormulaVar;

public class FormulaManager {
    String[] bOps;
    int[] bPrec;
    Method[] bMethods;
    String[] uOps;
    int[] uPrec;
    Method[] uMethods;
    String[] funcs;
    Method[] fMethods;
    int iPrec;
    Method[] iMethods;
    Method ppMethod;
    private Vector Vars = new Vector();

    public FormulaManager(String[] binOps, int[] binPrec, String[] binMethods, String[] unaryOps, int[] unaryPrec, String[] unaryMethods, String[] functions, String[] funcMethods, int implicitPrec, String[] implicitMethods, String preParseMethod) throws FormulaException {
        this.bOps = binOps;
        this.bPrec = binPrec;
        this.bMethods = FormulaUtil.stringsToMethods(binMethods);
        this.uOps = unaryOps;
        this.uPrec = unaryPrec;
        this.uMethods = FormulaUtil.stringsToMethods(unaryMethods);
        this.funcs = functions;
        this.fMethods = FormulaUtil.stringsToMethods(funcMethods);
        this.iPrec = implicitPrec;
        this.iMethods = FormulaUtil.stringsToMethods(implicitMethods);
        String[] s = new String[1];
        if (preParseMethod == null) {
            this.ppMethod = null;
        } else {
            String[] pps = new String[]{preParseMethod};
            Method[] ppm = FormulaUtil.stringsToMethods(pps);
            this.ppMethod = ppm[0];
        }
        int l1 = this.bOps.length;
        int l2 = this.bPrec.length;
        int l3 = this.bMethods.length;
        if (l1 != l2 || l1 != l3) {
            throw new FormulaException("Binary arrays must have equal lengths");
        }
        l1 = this.uOps.length;
        l2 = this.uPrec.length;
        l3 = this.uMethods.length;
        if (l1 != l2 || l1 != l3) {
            throw new FormulaException("Unary arrays must have equal lengths");
        }
        l1 = this.funcs.length;
        l2 = this.fMethods.length;
        if (l1 != l2) {
            throw new FormulaException("Function arrays must have equal lengths");
        }
        int i = 0;
        while (i < this.bOps.length) {
            if (this.bOps[i].length() > 1) {
                throw new FormulaException("All operators must be one character in length");
            }
            char c = this.bOps[i].charAt(0);
            if (c == '(' || c == ')' || c == ',' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                throw new FormulaException("The character \"" + c + "\" cannot be " + "used as an operator");
            }
            int j = i + 1;
            while (j < this.bOps.length) {
                if (this.bOps[i].charAt(0) == this.bOps[j].charAt(0) && this.bPrec[i] != this.bPrec[j]) {
                    throw new FormulaException("Duplicate operators must have equal operator precedences");
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.uOps.length) {
            if (this.uOps[i2].length() > 1) {
                throw new FormulaException("All operators must be one character in length");
            }
            char c = this.uOps[i2].charAt(0);
            if (c == '(' || c == ')' || c == ',' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                throw new FormulaException("The character \"" + c + "\" cannot be " + "used as an operator");
            }
            int j = i2 + 1;
            while (j < this.uOps.length) {
                if (this.uOps[i2].charAt(0) == this.uOps[j].charAt(0) && this.uPrec[i2] != this.uPrec[j]) {
                    throw new FormulaException("Duplicate operators must have equal operator precedences");
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < functions.length) {
            char c = functions[i3].charAt(0);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                throw new FormulaException("All functions must begin with a letter");
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.bMethods.length) {
            if (this.bMethods[i4] == null) {
                throw new FormulaException("The method \"" + binMethods[i4] + "\" is not valid");
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < this.uMethods.length) {
            if (this.uMethods[i5] == null) {
                throw new FormulaException("The method \"" + unaryMethods[i5] + "\" is not valid");
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < this.fMethods.length) {
            if (this.fMethods[i6] == null) {
                throw new FormulaException("The method \"" + funcMethods[i6] + "\" is not valid");
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < this.iMethods.length) {
            if (this.iMethods[i7] == null) {
                throw new FormulaException("The method \"" + implicitMethods[i7] + "\" is not valid");
            }
            ++i7;
        }
    }

    public void createVar(String name, ThingReference tr) throws VisADException {
        FormulaVar v;
        try {
            v = this.getVarByName(name);
        }
        catch (FormulaException exc) {
            v = null;
        }
        if (v != null) {
            throw new FormulaException("The variable " + name + " already exists.");
        }
        this.Vars.add(new FormulaVar(name, this, tr));
    }

    public void assignFormula(String name, String formula) throws VisADException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setFormula(formula);
    }

    public void waitForFormula(String name) throws VisADException {
        FormulaVar v = this.getVarByName(name);
        v.waitForFormula();
    }

    public void setTextRef(String name, ThingReference textRef) throws VisADException, RemoteException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setTextRef(textRef);
    }

    public String[] getErrors(String name) {
        try {
            FormulaVar v = this.getVarByNameOrCreate(name);
            String[] s = v.getErrors();
            v.clearErrors();
            return s;
        }
        catch (FormulaException exc) {
            return null;
        }
        catch (VisADException exc) {
            return null;
        }
    }

    public boolean canBeRemoved(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return !v.othersDepend();
    }

    public boolean exists(String name) {
        boolean exists = false;
        try {
            FormulaVar v = this.getVarByName(name);
            exists = true;
        }
        catch (FormulaException exc) {}
        return exists;
    }

    public void remove(String name) throws FormulaException {
        if (!this.canBeRemoved(name)) {
            throw new FormulaException("Cannot remove variable " + name + " " + "because other variables depend on it!");
        }
        this.Vars.remove(this.getVarByName(name));
    }

    public void setThing(String name, Thing t) throws VisADException, RemoteException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setThing(t);
    }

    public void setReference(String name, ThingReference tr) throws VisADException {
        FormulaVar v = this.getVarByNameOrCreate(name);
        v.setReference(tr);
    }

    public Thing getThing(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return v.getThing();
    }

    public ThingReference getReference(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return v.getReference();
    }

    public String getFormula(String name) throws FormulaException {
        FormulaVar v = this.getVarByName(name);
        return v.getFormula();
    }

    FormulaVar getVarByName(String name) throws FormulaException {
        int i = 0;
        while (i < this.Vars.size()) {
            FormulaVar v = (FormulaVar)this.Vars.elementAt(i);
            if (v.name.equalsIgnoreCase(name)) {
                return v;
            }
            ++i;
        }
        throw new FormulaException("The variable " + name + " does not exist.");
    }

    FormulaVar getVarByNameOrCreate(String name) throws VisADException {
        FormulaVar v;
        try {
            v = this.getVarByName(name);
        }
        catch (FormulaException exc) {
            v = new FormulaVar(name, this);
            this.Vars.add(v);
        }
        return v;
    }

    boolean isUnaryOp(String op) {
        int i = 0;
        while (i < this.uOps.length) {
            if (this.uOps[i].equals(op)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isBinaryOp(String op) {
        int i = 0;
        while (i < this.bOps.length) {
            if (this.bOps[i].equals(op)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean isFunction(String token) {
        int i = 0;
        while (i < this.funcs.length) {
            if (this.funcs[i].equalsIgnoreCase(token)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int getUnaryPrec(String op) {
        int i = 0;
        while (i < this.uOps.length) {
            if (this.uOps[i].equals(op)) {
                return this.uPrec[i];
            }
            ++i;
        }
        return -1;
    }

    int getBinaryPrec(String op) {
        if (op.equals("(")) {
            return Integer.MAX_VALUE;
        }
        if (op.equals(",")) {
            return 0x7FFFFFFE;
        }
        int i = 0;
        while (i < this.bOps.length) {
            if (this.bOps[i].equals(op)) {
                return this.bPrec[i];
            }
            ++i;
        }
        return -1;
    }
}

