/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDoubleArray;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryRealTuple
implements BinaryObject {
    static /* synthetic */ Class class$visad$RealTuple;

    public static final int computeBytes(Real[] components, CoordinateSystem cs, boolean trivialTuple) {
        int compsLen;
        if (components == null) {
            compsLen = 0;
        } else if (trivialTuple) {
            compsLen = 5 + components.length * 8;
        } else {
            compsLen = 5;
            int i = 0;
            while (i < components.length) {
                compsLen += BinaryReal.computeBytes(components[i].getUnit(), components[i].getError());
                ++i;
            }
        }
        return 10 + compsLen + (cs == null ? 0 : 5) + 1;
    }

    public static final boolean isTrivialTuple(RealTupleType type, Real[] components) {
        if (components == null) {
            return true;
        }
        int i = 0;
        while (i < components.length) {
            if (components[i] != null) {
                MathType comp;
                try {
                    comp = type.getComponent(i);
                }
                catch (VisADException ve) {
                    return false;
                }
                if (!comp.equals(components[i].getType()) || components[i].getUnit() != null || components[i].getError() != null) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static final RealTuple read(BinaryReader reader) throws IOException, VisADException {
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        RealTupleType rtt = (RealTupleType)typeCache.get(typeIndex);
        Real[] components = null;
        double[] values = null;
        CoordinateSystem cs = null;
        boolean reading = true;
        while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 32: {
                    int index = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(index);
                    break;
                }
                case 9: {
                    components = BinaryRealTuple.readRealArray(reader);
                    break;
                }
                case 10: {
                    values = BinaryDoubleArray.read(reader);
                    break;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown RealTuple directive " + directive);
                }
            }
        }
        if (components != null && values != null) {
            throw new IOException("Found both RealTuple Real[] and double[] values");
        }
        if (values != null) {
            if (cs == null) {
                return new RealTuple(rtt, values);
            }
            components = new Real[values.length];
            int i = 0;
            while (i < values.length) {
                components[i] = new Real((RealType)rtt.getComponent(i), values[i], null, null);
                ++i;
            }
        }
        return new RealTuple(rtt, components, cs);
    }

    private static final Real[] readRealArray(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad Real array length " + len + ")");
        }
        long t = 0L;
        Real[] array = new Real[len];
        int i = 0;
        while (i < len) {
            array[i] = (Real)BinaryGeneric.read(reader);
            ++i;
        }
        return array;
    }

    public static final void writeDependentData(BinaryWriter writer, RealTupleType type, Real[] components, CoordinateSystem cs, RealTuple rt, Object token) throws IOException {
        if (!(rt.getClass().equals(class$visad$RealTuple == null ? (class$visad$RealTuple = BinaryRealTuple.class$("visad.RealTuple")) : class$visad$RealTuple) || rt instanceof RealTuple && rt instanceof Saveable)) {
            return;
        }
        Object dependToken = token == BinaryObject.SAVE_DEPEND_BIG ? token : BinaryObject.SAVE_DEPEND;
        BinaryRealTupleType.write(writer, type, BinaryObject.SAVE_DATA);
        if (cs != null) {
            BinaryCoordinateSystem.write(writer, cs, BinaryObject.SAVE_DATA);
        }
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                BinaryGeneric.write(writer, components[i], dependToken);
                ++i;
            }
        }
    }

    public static final void write(BinaryWriter writer, RealTupleType type, Real[] components, CoordinateSystem cs, RealTuple rt, Object token) throws IOException {
        BinaryRealTuple.writeDependentData(writer, type, components, cs, rt, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(rt.getClass().equals(class$visad$RealTuple == null ? (class$visad$RealTuple = BinaryRealTuple.class$("visad.RealTuple")) : class$visad$RealTuple) || rt instanceof RealTuple && rt instanceof Saveable)) {
            BinaryUnknown.write(writer, rt, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(type);
        if (typeIndex < 0) {
            throw new IOException("RealTupleType " + type + " not cached");
        }
        int csIndex = -1;
        if (cs != null && (csIndex = writer.getCoordinateSystemCache().getIndex(cs)) < 0) {
            throw new IOException("CoordinateSystem " + cs + " not cached");
        }
        boolean trivialTuple = BinaryRealTuple.isTrivialTuple(type, components);
        int objLen = BinaryRealTuple.computeBytes(components, cs, trivialTuple);
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(11);
        file.writeInt(typeIndex);
        if (components != null) {
            if (trivialTuple) {
                file.writeByte(10);
                file.writeInt(components.length);
                int i = 0;
                while (i < components.length) {
                    file.writeDouble(components[i].getValue());
                    ++i;
                }
            } else {
                file.writeByte(9);
                file.writeInt(components.length);
                int i = 0;
                while (i < components.length) {
                    BinaryReal.write(writer, (RealType)components[i].getType(), components[i].getValue(), components[i].getUnit(), components[i].getError(), components[i], token);
                    ++i;
                }
            }
        }
        if (csIndex >= 0) {
            file.writeByte(32);
            file.writeInt(csIndex);
        }
        file.writeByte(80);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

