/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import visad.data.tiff.BitBuffer;

public class TiffTools {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int PHOTOMETRIC_INTERPRETATION_FIELD = 262;
    private static final int IMPOSSIBLE_IFD = 424242;

    public static Hashtable getIFDHash(RandomAccessFile readIn) throws IOException {
        byte[] byteArray = new byte[4];
        readIn.seek(4L);
        readIn.read(byteArray);
        readIn.seek(TiffTools.batoi(byteArray));
        byteArray = new byte[2];
        readIn.read(byteArray);
        Hashtable<Integer, Serializable> ifdEntries = new Hashtable<Integer, Serializable>();
        Integer numEntries = new Integer(TiffTools.batoi(byteArray));
        boolean frames = true;
        int i = 0;
        while (i < numEntries) {
            byteArray = new byte[2];
            readIn.read(byteArray);
            Integer entryTag = new Integer(TiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryType = new Integer(TiffTools.batoi(byteArray));
            byteArray = new byte[4];
            readIn.read(byteArray);
            Integer entrycount = new Integer(TiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryOffset = new Integer(TiffTools.batoi(byteArray));
            Vector<Integer> entryData = new Vector<Integer>();
            entryData.add(entryType);
            entryData.add(entrycount);
            entryData.add(entryOffset);
            ifdEntries.put(entryTag, entryData);
            ++i;
        }
        readIn.read(byteArray);
        int nextOffset = TiffTools.batoi(byteArray);
        ifdEntries.put(new Integer(424242), new Integer(nextOffset));
        return ifdEntries;
    }

    public static Hashtable getIFDHash(RandomAccessFile readIn, int block_id) throws IOException {
        Integer numEntries;
        Hashtable<Integer, Serializable> ifdEntries = new Hashtable<Integer, Serializable>();
        int frames = 0;
        byte[] byteArray = new byte[4];
        readIn.seek(4L);
        readIn.read(byteArray);
        readIn.seek(TiffTools.batoi(byteArray));
        while (frames != block_id) {
            byteArray = new byte[2];
            readIn.read(byteArray);
            numEntries = new Integer(TiffTools.batoi(byteArray));
            readIn.skipBytes(12 * numEntries);
            byteArray = new byte[4];
            readIn.read(byteArray);
            readIn.seek(TiffTools.batoi(byteArray));
            ++frames;
        }
        byteArray = new byte[2];
        readIn.read(byteArray);
        numEntries = new Integer(TiffTools.batoi(byteArray));
        int i = 0;
        while (i < numEntries) {
            byteArray = new byte[2];
            readIn.read(byteArray);
            Integer entryTag = new Integer(TiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryType = new Integer(TiffTools.batoi(byteArray));
            byteArray = new byte[4];
            readIn.read(byteArray);
            Integer entrycount = new Integer(TiffTools.batoi(byteArray));
            readIn.read(byteArray);
            Integer entryOffset = new Integer(TiffTools.batoi(byteArray));
            Vector<Integer> entryData = new Vector<Integer>();
            entryData.add(entryType);
            entryData.add(entrycount);
            entryData.add(entryOffset);
            ifdEntries.put(entryTag, entryData);
            ++i;
        }
        readIn.read(byteArray);
        int nextOffset = TiffTools.batoi(byteArray);
        ifdEntries.put(new Integer(424242), new Integer(nextOffset));
        return ifdEntries;
    }

    public static int[] getIFDArray(RandomAccessFile readIn, Vector v) throws IOException {
        int count = (Integer)v.get(1);
        int type = (Integer)v.get(0);
        if (count == 1) {
            return new int[]{(Integer)v.get(2)};
        }
        readIn.seek(((Integer)v.get(2)).intValue());
        int[] toReturn = new int[count];
        int bytesPerEntry = 1;
        if (type == 1) {
            bytesPerEntry = 1;
        }
        if (type == 2) {
            bytesPerEntry = 1;
        }
        if (type == 3) {
            bytesPerEntry = 2;
        }
        if (type == 4) {
            bytesPerEntry = 4;
        }
        byte[] data = new byte[count * bytesPerEntry];
        readIn.read(data);
        byte[] translate = new byte[bytesPerEntry];
        int i = 0;
        while (i < count) {
            System.arraycopy(data, i * bytesPerEntry, translate, 0, bytesPerEntry);
            toReturn[i] = TiffTools.batoi(translate);
            ++i;
        }
        return toReturn;
    }

    public static double[] getIFDRArray(RandomAccessFile readIn, Vector v) throws IOException {
        int count = (Integer)v.get(1);
        int type = (Integer)v.get(0);
        if (count == 1) {
            return new double[]{-1.0};
        }
        readIn.seek(((Integer)v.get(2)).intValue());
        double[] toReturn = new double[count];
        int bytesPerEntry = 8;
        if (type != 5) {
            return new double[]{-1.0};
        }
        byte[] data = new byte[count * bytesPerEntry];
        readIn.read(data);
        byte[] translate = new byte[bytesPerEntry];
        int i = 0;
        while (i < count) {
            System.arraycopy(data, i * bytesPerEntry, translate, 0, 4);
            int num = TiffTools.batoi(translate);
            System.arraycopy(data, i * bytesPerEntry + 4, translate, 0, 4);
            int denom = TiffTools.batoi(translate);
            toReturn[i] = num / denom;
            ++i;
        }
        return toReturn;
    }

    public static byte[] lzwUncompress(byte[] input) throws IOException {
        int currentCode;
        if (input.length == 0) {
            return new byte[0];
        }
        byte[][] symbolTable = new byte[4096][];
        int bitsToRead = 9;
        int nextSymbol = 258;
        int oldCode = -1;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream symbol = new ByteArrayOutputStream();
        BitBuffer bb = new BitBuffer(new ByteArrayInputStream(input));
        int i = 0;
        while (i < 256) {
            symbolTable[i] = new byte[]{(byte)i};
            ++i;
        }
        boolean firsthandled = false;
        while (!firsthandled) {
            currentCode = bb.getBits(bitsToRead);
            if (currentCode == 257 || currentCode == -1) {
                return out.toByteArray();
            }
            if (currentCode == 256) continue;
            out.write(symbolTable[currentCode], 0, symbolTable[currentCode].length);
            oldCode = currentCode;
            firsthandled = true;
        }
        while ((currentCode = bb.getBits(bitsToRead)) != 257) {
            if (currentCode == 256) {
                symbolTable = new byte[4096][];
                int i2 = 0;
                while (i2 < 256) {
                    symbolTable[i2] = new byte[]{(byte)i2};
                    ++i2;
                }
                nextSymbol = 258;
                bitsToRead = 9;
                currentCode = bb.getBits(bitsToRead);
                if (currentCode == 257 || currentCode == -1) break;
                out.write(symbolTable[currentCode], 0, symbolTable[currentCode].length);
                oldCode = currentCode;
                continue;
            }
            if (currentCode < nextSymbol) {
                out.write(symbolTable[currentCode], 0, symbolTable[currentCode].length);
                int j = 0;
                while (j < symbolTable[currentCode].length) {
                    ++j;
                }
                symbol.reset();
                symbol.write(symbolTable[oldCode], 0, symbolTable[oldCode].length);
                symbol.write(symbolTable[currentCode], 0, 1);
                symbolTable[nextSymbol] = symbol.toByteArray();
                int d = 0;
                while (d < symbolTable[nextSymbol].length) {
                    ++d;
                }
                ++nextSymbol;
                oldCode = currentCode;
            } else {
                out.write(symbolTable[oldCode], 0, symbolTable[oldCode].length);
                out.write(symbolTable[oldCode], 0, 1);
                symbol.reset();
                symbol.write(symbolTable[oldCode], 0, symbolTable[oldCode].length);
                symbol.write(symbolTable[oldCode], 0, 1);
                symbolTable[nextSymbol] = symbol.toByteArray();
                oldCode = currentCode;
                ++nextSymbol;
            }
            if (nextSymbol == 511) {
                bitsToRead = 10;
            }
            if (nextSymbol == 1023) {
                bitsToRead = 11;
            }
            if (nextSymbol != 2047) continue;
            bitsToRead = 12;
        }
        return out.toByteArray();
    }

    public static int getPhotometricInterpretation(RandomAccessFile in) throws IOException {
        Hashtable ifdHash = TiffTools.getIFDHash(in);
        Vector v = (Vector)ifdHash.get(new Integer(262));
        return (Integer)v.get(2);
    }

    public static int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << i * 8;
            ++i;
        }
        return total;
    }

    public static int[] getTIFFDimensions(RandomAccessFile readIn) throws IOException {
        int frames = 1;
        Hashtable ifdEntries = TiffTools.getIFDHash(readIn);
        int nextOffset = (Integer)ifdEntries.get(new Integer(424242));
        while (nextOffset != 0) {
            ++frames;
            try {
                readIn.seek(nextOffset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] byteArray = new byte[2];
            readIn.read(byteArray);
            int numEntries = TiffTools.batoi(byteArray);
            readIn.skipBytes(12 * numEntries);
            byteArray = new byte[4];
            readIn.read(byteArray);
            nextOffset = TiffTools.batoi(byteArray);
        }
        Vector entryData = (Vector)ifdEntries.get(new Integer(256));
        Integer width = (Integer)entryData.get(2);
        entryData = (Vector)ifdEntries.get(new Integer(257));
        Integer length = (Integer)entryData.get(2);
        return new int[]{width, length, frames};
    }

    public static int getIFDValue(Hashtable h, int id) {
        Integer k = new Integer(id);
        Vector v = (Vector)h.get(k);
        if (v == null) {
            return -1;
        }
        Integer i = (Integer)v.get(2);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public static boolean isIFDArray(Hashtable h, int id) {
        return TiffTools.getIFDValue(h, id) == 1;
    }

    public static void main(String[] args) throws IOException {
        RandomAccessFile f = new RandomAccessFile(args[0], "r");
        Hashtable h = new Hashtable();
        int[] d = TiffTools.getTIFFDimensions(f);
        int meh = 0;
        while (meh < d[2]) {
            System.out.println("*** START HASH #" + meh);
            h = TiffTools.getIFDHash(f, meh);
            int i = 0;
            while (i < 65536) {
                Integer k = new Integer(i);
                if (h.containsKey(k)) {
                    Vector v = (Vector)h.get(k);
                    System.out.print(k + ":");
                    System.out.print((Integer)v.get(0) + " ");
                    System.out.print((Integer)v.get(1) + " ");
                    System.out.println((Integer)v.get(2));
                    if ((Integer)v.get(1) != 1) {
                        int j;
                        Object[] a;
                        if ((Integer)v.get(1) != 5) {
                            a = TiffTools.getIFDArray(f, v);
                            System.out.print("  [ ");
                            j = 0;
                            while (j < a.length) {
                                System.out.print(a[j] + " ");
                                ++j;
                            }
                            System.out.println("]");
                        } else {
                            a = TiffTools.getIFDRArray(f, v);
                            System.out.print("  [ ");
                            j = 0;
                            while (j < a.length) {
                                System.out.print(a[j] + " ");
                                ++j;
                            }
                            System.out.println("]");
                        }
                    }
                }
                ++i;
            }
            System.out.println("*** END HASH #" + meh);
            System.out.println(" ");
            ++meh;
        }
        int[] a = TiffTools.getTIFFDimensions(f);
        System.out.println(a[0] + "x" + a[1] + "x" + a[2]);
    }
}

