/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class TiffForm
extends Form
implements FormFileInformer,
FormBlockReader,
FormProgressInformer {
    private static int formCount = 0;
    private static final String[] SUFFIXES = new String[]{"tif", "tiff"};
    private static final String NO_IJ = "This feature requires ImageJ, avialable online at http://rsb.info.nih.gov/ij/download.html";
    private static final String NO_JAI = "This feature requires JAI, available from Sun at http://java.sun.com/products/java-media/jai/";
    private ReflectedUniverse r = new ReflectedUniverse();
    private boolean noImageJ = false;
    private boolean noJai = false;
    private String currentId;
    private int numImages;
    private boolean canUseImageJ;
    private double percent;
    static /* synthetic */ Class class$java$lang$String;

    public TiffForm() {
        super("TiffForm" + formCount++);
        try {
            this.r.exec("import ij.ImagePlus");
            this.r.exec("import ij.ImageStack");
            this.r.exec("import ij.io.FileInfo");
            this.r.exec("import ij.io.FileSaver");
            this.r.exec("import ij.io.Opener");
            this.r.exec("import ij.io.TiffDecoder");
            this.r.exec("import ij.process.ColorProcessor");
            this.r.exec("import ij.process.ImageProcessor");
        }
        catch (VisADException exc) {
            this.noImageJ = true;
        }
        try {
            this.r.exec("import com.sun.media.jai.codec.ImageDecodeParam");
            this.r.exec("import com.sun.media.jai.codec.ImageDecoder");
            this.r.exec("import com.sun.media.jai.codec.ImageCodec");
        }
        catch (VisADException exc) {
            this.noJai = true;
        }
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < SUFFIXES.length) {
            if (name.toLowerCase().endsWith(SUFFIXES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[SUFFIXES.length];
        System.arraycopy(SUFFIXES, 0, s, 0, SUFFIXES.length);
        return s;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        if (this.noImageJ) {
            throw new BadFormException(NO_IJ);
        }
        this.percent = 0.0;
        FlatField[] fields = DataUtility.getImageFields(data);
        if (fields == null) {
            throw new BadFormException("Data type must be image or time sequence of images");
        }
        this.r.setVar("id", id);
        if (fields.length > 1) {
            Object is = null;
            int i = 0;
            while (i < fields.length) {
                this.r.setVar("ips", this.extractImage(fields[i]));
                if (is == null) {
                    this.r.exec("w = ips.getWidth()");
                    this.r.exec("h = ips.getHeight()");
                    this.r.exec("cm = ips.getColorModel()");
                    this.r.exec("is = new ImageStack(w, h, cm)");
                    is = this.r.getVar("is");
                }
                this.r.setVar("si", "" + i);
                try {
                    Class<?> imageStack = Class.forName("ij.ImageStack");
                    Class<?> imageProcessor = Class.forName("ij.process.ImageProcessor");
                    Method addSlice = imageStack.getMethod("addSlice", class$java$lang$String == null ? TiffForm.class$("java.lang.String") : class$java$lang$String, imageProcessor);
                    addSlice.invoke(is, "" + i, this.r.getVar("ips"));
                }
                catch (ClassNotFoundException exc) {
                    throw new BadFormException("Reflection exception: class not found: " + exc.getMessage());
                }
                catch (NoSuchMethodException exc) {
                    throw new BadFormException("Reflection exception: no such method: " + exc.getMessage());
                }
                catch (IllegalAccessException exc) {
                    throw new BadFormException("Reflection exception: illegal access: " + exc.getMessage());
                }
                catch (InvocationTargetException exc) {
                    throw new BadFormException("Reflection exception: " + exc.getTargetException().getMessage());
                }
                this.percent = (double)(i + 1) / (double)fields.length;
                ++i;
            }
            this.r.exec("image = new ImagePlus(id, is)");
            this.r.exec("sav = new FileSaver(image)");
            this.r.exec("sav.saveAsTiffStack(id)");
        } else {
            this.r.setVar("ip", this.extractImage(fields[0]));
            this.r.exec("image = new ImagePlus(id, ip)");
            this.r.exec("sav = new FileSaver(image)");
            this.r.exec("sav.saveAsTiff(id)");
        }
        this.percent = -1.0;
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("TiffForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType time = RealType.getRealType("time");
            FunctionType timeFunction = new FunctionType(time, fields[0].getType());
            Integer1DSet timeSet = new Integer1DSet(nImages);
            FieldImpl timeField = new FieldImpl(timeFunction, timeSet);
            timeField.setSamples(fields, false);
            data = timeField;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("TiffForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        if (block_number < 0 || block_number >= this.numImages) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        Image img = null;
        if (this.canUseImageJ) {
            if (this.noImageJ) {
                throw new BadFormException(NO_IJ);
            }
            this.r.exec("opener = new Opener()");
            this.r.setVar("id", id);
            this.r.exec("image = opener.openImage(id)");
            this.r.exec("stack = image.getStack()");
            this.r.setVar("bn1", block_number + 1);
            this.r.exec("ip = stack.getProcessor(bn1)");
            this.r.exec("img = ip.createImage()");
            img = (Image)this.r.getVar("img");
        } else {
            if (this.noJai) {
                throw new BadFormException(NO_JAI);
            }
            try {
                this.r.setVar("i", block_number);
                RenderedImage ri = (RenderedImage)this.r.exec("id.decodeAsRenderedImage(i)");
                WritableRaster wr = ri.copyData(null);
                ColorModel cm = ri.getColorModel();
                img = new BufferedImage(cm, wr, false, null);
            }
            catch (VisADException exc) {
                throw new BadFormException(exc.getMessage());
            }
        }
        return DataUtility.makeField(img);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.numImages;
    }

    public void close() throws BadFormException, IOException, VisADException {
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private Object extractImage(FlatField field) throws VisADException {
        GriddedSet set = (GriddedSet)field.getDomainSet();
        int[] wh = set.getLengths();
        int w = wh[0];
        int h = wh[1];
        double[][] samples = field.getValues();
        int[] pixels = new int[samples[0].length];
        if (samples.length == 3) {
            int i = 0;
            while (i < samples[0].length) {
                int red = (int)samples[0][i] & 0xFF;
                int green = (int)samples[1][i] & 0xFF;
                int blue = (int)samples[2][i] & 0xFF;
                pixels[i] = red << 16 | green << 8 | blue;
                ++i;
            }
        } else if (samples.length == 1) {
            int i = 0;
            while (i < samples[0].length) {
                int val = (int)samples[0][i] & 0xFF;
                pixels[i] = val << 16 | val << 8 | val;
                ++i;
            }
        }
        this.r.setVar("w", w);
        this.r.setVar("h", h);
        this.r.setVar("pixels", pixels);
        this.r.exec("cp = new ColorProcessor(w, h, pixels)");
        return this.r.getVar("cp");
    }

    private void initFile(String id) throws BadFormException, IOException, VisADException {
        if (this.noImageJ) {
            throw new BadFormException(NO_IJ);
        }
        this.close();
        this.r.setVar("id", id);
        this.r.setVar("empty", "");
        this.r.exec("tdec = new TiffDecoder(empty, id)");
        this.canUseImageJ = true;
        try {
            this.r.exec("info = tdec.getTiffInfo()");
        }
        catch (VisADException exc) {
            this.canUseImageJ = false;
        }
        if (this.canUseImageJ) {
            this.r.exec("opener = new Opener()");
            this.r.exec("image = opener.openImage(id)");
            this.r.exec("numImages = image.getStackSize()");
            this.numImages = (Integer)this.r.getVar("numImages");
        } else {
            if (this.noJai) {
                throw new BadFormException(NO_JAI);
            }
            try {
                this.r.setVar("tiff", "tiff");
                this.r.setVar("file", new File(id));
                this.r.exec("id = ImageCodec.createImageDecoder(tiff, file, null)");
                this.numImages = (Integer)this.r.exec("id.getNumPages()");
            }
            catch (VisADException exc) {
                throw new BadFormException(exc.getMessage());
            }
        }
        this.currentId = id;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to TIFF, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file out_file");
            System.out.println("To test read a TIFF file, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            TiffForm form = new TiffForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            TiffForm form = new TiffForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

