/*
 * Decompiled with CFR 0.152.
 */
package visad.data.text;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import visad.Data;
import visad.DateTime;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.in.ArithProg;
import visad.data.units.Parser;
import visad.jmet.DumpType;

public class TextAdapter {
    private FlatField ff = null;
    private Field field = null;
    private boolean debug = false;
    private String DELIM;
    private final String COMMA = ",";
    private final String SEMICOLON = ";";
    private final String TAB = "\t";
    private final String BLANK = " ";
    private boolean DOQUOTE = true;
    private boolean GOTTIME = false;
    String[] hdrNames;
    Unit[] hdrUnits;
    double[] hdrMissingValues;
    String[] hdrMissingStrings;
    String[] hdrFormatStrings;
    int[] hdrIsInterval;
    double[] hdrErrorEstimates;
    double[] rangeErrorEstimates;
    Unit[] rangeUnits;
    Set[] rangeSets;
    double[] domainErrorEstimates;
    Unit[] domainUnits;
    double[] hdrScales;
    double[] hdrOffsets;
    int[][] hdrColumns;
    int[][] values_to_index;

    public TextAdapter(String filename) throws IOException, VisADException {
        FileInputStream is = new FileInputStream(filename);
        this.DELIM = null;
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        this.readit(is, null, null);
    }

    public TextAdapter(String filename, String map, String params) throws IOException, VisADException {
        FileInputStream is = new FileInputStream(filename);
        this.DELIM = null;
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        this.readit(is, map, params);
    }

    public TextAdapter(URL url) throws IOException, VisADException {
        this.DELIM = null;
        String filename = url.getFile();
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        InputStream is = url.openStream();
        this.readit(is, null, null);
    }

    public TextAdapter(URL url, String map, String params) throws IOException, VisADException {
        this.DELIM = null;
        String filename = url.getFile();
        if (filename.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (filename.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (filename.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        InputStream is = url.openStream();
        this.readit(is, map, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void readit(InputStream is, String map, String params) throws IOException, VisADException {
        block198: {
            this.ff = null;
            this.field = null;
            if (this.debug) {
                System.out.println("####   Text Adapter v2.x running");
            }
            bis = new BufferedReader(new InputStreamReader(is));
            maps = null;
            if (map == null) {
                do {
                    if ((t = bis.readLine()) == null) {
                        return;
                    }
                    if (TextAdapter.isText(t)) continue;
                    return;
                } while (t.startsWith("#") || t.startsWith("!") || t.startsWith("%") || t.length() < 1);
                maps = t.trim();
            } else {
                maps = map;
            }
            maps = this.makeMT(maps);
            if (maps == null) {
                throw new BadFormException("TextAdapter: Invalid or missing MathType");
            }
            if (this.debug) {
                System.out.println("Specified MathType = " + maps);
            }
            hdr = null;
            if (params == null) {
                while (true) {
                    if ((hdr = bis.readLine()) == null) {
                        return;
                    }
                    if (!TextAdapter.isText(hdr)) {
                        return;
                    }
                    if (hdr.startsWith("#") || hdr.startsWith("!") || hdr.startsWith("%") || hdr.length() < 1) {
                        continue;
                    }
                    break;
                }
            } else {
                hdr = params;
            }
            hdrDelim = this.DELIM;
            if (this.DELIM == null) {
                if (hdr.indexOf(" ") != -1) {
                    hdrDelim = " ";
                }
                if (hdr.indexOf(",") != -1) {
                    hdrDelim = ",";
                }
                if (hdr.indexOf(";") != -1) {
                    hdrDelim = ";";
                }
                if (hdr.indexOf("\t") != -1) {
                    hdrDelim = "\t";
                }
                if (this.debug) {
                    System.out.println("Using header delimiter = " + hdrDelim.getBytes()[0]);
                }
            }
            sthdr = new StringTokenizer(hdr, hdrDelim);
            nhdr = sthdr.countTokens();
            this.hdrNames = new String[nhdr];
            this.hdrUnits = new Unit[nhdr];
            this.hdrMissingValues = new double[nhdr];
            this.hdrMissingStrings = new String[nhdr];
            this.hdrFormatStrings = new String[nhdr];
            this.hdrIsInterval = new int[nhdr];
            this.hdrErrorEstimates = new double[nhdr];
            this.hdrScales = new double[nhdr];
            this.hdrOffsets = new double[nhdr];
            this.hdrColumns = new int[2][nhdr];
            i = 0;
            while (i < nhdr) {
                block200: {
                    block199: {
                        name = sthdr.nextToken().trim();
                        hdrUnitString = null;
                        this.hdrMissingValues[i] = NaN;
                        this.hdrMissingStrings[i] = null;
                        this.hdrFormatStrings[i] = null;
                        this.hdrIsInterval[i] = 0;
                        this.hdrScales[i] = 1.0;
                        this.hdrOffsets[i] = 0.0;
                        this.hdrErrorEstimates[i] = 0.0;
                        this.hdrColumns[0][i] = -1;
                        m = name.indexOf("[");
                        if (m != -1) break block199;
                        this.hdrNames[i] = name;
                        hdrUnitString = null;
                        break block200;
                    }
                    m2 = name.indexOf("]");
                    if (m2 == -1) {
                        throw new VisADException("TextAdapter: Bad [descriptor] named in:" + name);
                    }
                    this.hdrNames[i] = m2 >= name.length() ? name.substring(0, m).trim() : (name.substring(0, m) + name.substring(m2 + 1)).trim();
                    cl = name.substring(m + 1, m2).trim();
                    stcl = new StringTokenizer(cl, " ");
                    ncl = stcl.countTokens();
                    if (ncl != 1 || cl.indexOf("=") != -1) ** GOTO lbl144
                    hdrUnitString = cl;
                    break block200;
lbl-1000:
                    // 1 sources

                    {
                        s = stcl.nextToken().trim();
                        sts = new StringTokenizer(s, "=");
                        if (sts.countTokens() != 2) {
                            throw new VisADException("TextAdapter: Invalid clause in: " + s);
                        }
                        tok = sts.nextToken().trim();
                        val = sts.nextToken();
                        if (val.startsWith("\"")) {
                            if (val.endsWith("\"")) {
                                val = v2 = val.substring(1, val.length() - 1);
                            } else {
                                try {
                                    v2 = stcl.nextToken("\"");
                                    stcl.nextToken(" ");
                                    val = v3 = val.substring(1) + v2;
                                }
                                catch (NoSuchElementException nse2) {
                                    val = "";
                                }
                            }
                        }
                        if (this.debug) {
                            System.out.println("####   tok = " + tok + " val = '" + val + "'");
                        }
                        if (tok.toLowerCase().startsWith("unit")) {
                            hdrUnitString = val;
                            continue;
                        }
                        if (tok.toLowerCase().startsWith("mis")) {
                            this.hdrMissingStrings[i] = val.trim();
                            try {
                                this.hdrMissingValues[i] = Double.parseDouble(val);
                            }
                            catch (NumberFormatException me) {
                                this.hdrMissingValues[i] = NaN;
                            }
                            continue;
                        }
                        if (tok.toLowerCase().startsWith("int")) {
                            this.hdrIsInterval[i] = -1;
                            if (val.toLowerCase().startsWith("t")) {
                                this.hdrIsInterval[i] = 1;
                            }
                            if (val.toLowerCase().startsWith("f")) {
                                this.hdrIsInterval[i] = 0;
                            }
                            if (this.hdrIsInterval[i] != -1) continue;
                            throw new VisADException("TextAdapter: Value of 'interval' must be 'true' or 'false'");
                        }
                        if (tok.toLowerCase().startsWith("err")) {
                            this.hdrErrorEstimates[i] = Double.parseDouble(val);
                            continue;
                        }
                        if (tok.toLowerCase().startsWith("sca")) {
                            this.hdrScales[i] = Double.parseDouble(val);
                            continue;
                        }
                        if (tok.toLowerCase().startsWith("off")) {
                            this.hdrOffsets[i] = Double.parseDouble(val);
                            continue;
                        }
                        if (tok.toLowerCase().startsWith("pos")) {
                            stp = new StringTokenizer(val, ":");
                            if (stp.countTokens() != 2) {
                                throw new VisADException("TextAdapter: invalid Position parameter in:" + s);
                            }
                            this.hdrColumns[0][i] = Integer.parseInt(stp.nextToken().trim());
                            this.hdrColumns[1][i] = Integer.parseInt(stp.nextToken().trim());
                            continue;
                        }
                        if (tok.toLowerCase().startsWith("fmt")) {
                            this.hdrFormatStrings[i] = val.trim();
                            continue;
                        }
                        throw new VisADException("TextAdapter: invalid token name: " + s);
lbl144:
                        // 10 sources

                        ** while (stcl.hasMoreTokens())
                    }
                }
                if (this.debug) {
                    System.out.println("hdr name = " + this.hdrNames[i] + " units=" + hdrUnitString + " miss=" + this.hdrMissingValues[i] + " interval=" + this.hdrIsInterval[i] + " errorest=" + this.hdrErrorEstimates[i] + " scale=" + this.hdrScales[i] + " offset=" + this.hdrOffsets[i] + " pos=" + this.hdrColumns[0][i] + ":" + this.hdrColumns[1][i]);
                }
                u = null;
                if (hdrUnitString != null && !hdrUnitString.trim().equalsIgnoreCase("null")) {
                    try {
                        u = Parser.parse(hdrUnitString.trim());
                    }
                    catch (Exception ue) {
                        try {
                            u = Parser.parse(hdrUnitString.trim().replace(' ', '_'));
                        }
                        catch (Exception ue2) {
                            System.out.println("Unit name problem:" + ue + " with: " + hdrUnitString);
                            u = null;
                        }
                    }
                }
                if (this.debug) {
                    System.out.println("####   assigned Unit as u=" + u);
                }
                if ((rttemp = this.hdrNames[i].trim()).indexOf("(Text)") == -1) {
                    parenIndex = rttemp.indexOf("(");
                    if (parenIndex < 0) {
                        parenIndex = rttemp.indexOf("[");
                    }
                    if (parenIndex < 0) {
                        parenIndex = rttemp.indexOf("{");
                    }
                    if (parenIndex < 0) {
                        parenIndex = rttemp.indexOf(" ");
                    }
                    if ((rt = RealType.getRealType(rtname = parenIndex < 0 ? rttemp.trim() : rttemp.substring(0, parenIndex), u, null, this.hdrIsInterval[i])) == null) {
                        if (this.debug) {
                            System.out.println("####   rt was returned as null");
                        }
                        if (u != null) {
                            System.out.println("####  Could not make RealType using specified Unit (" + hdrUnitString + ") for parameter name: " + rtname);
                        }
                        rt = RealType.getRealType(rtname);
                    }
                    if (rt.equals(RealType.Time)) {
                        this.GOTTIME = true;
                        if (this.debug) {
                            System.out.println("####  found a visad.RealType.Time component");
                        }
                    } else {
                        this.GOTTIME = false;
                    }
                    if (u == null) {
                        u = rt.getDefaultUnit();
                    }
                    if (this.debug) {
                        System.out.println("####  retrieve units from RealType = " + u);
                    }
                }
                this.hdrUnits[i] = u;
                ++i;
            }
            mt = null;
            try {
                mt = MathType.stringToType(maps);
            }
            catch (Exception mte) {
                System.out.println("####  Exception: " + mte);
                throw new VisADException("TextAdapter: MathType badly formed or missing: " + maps);
            }
            if (this.debug) {
                System.out.println(mt);
                new DumpType();
                DumpType.dumpMathType(mt, System.out);
            }
            domainNames = null;
            rangeNames = null;
            numDom = 0;
            numRng = 0;
            if (mt instanceof FunctionType) {
                domType = ((FunctionType)mt).getDomain();
                numDom = domType.getDimension();
                domainNames = new String[numDom];
                i = 0;
                while (i < numDom) {
                    comp = domType.getComponent(i);
                    domainNames[i] = ((RealType)comp).toString().trim();
                    if (this.debug) {
                        System.out.println("dom " + i + " = " + domainNames[i]);
                    }
                    ++i;
                }
                rngType = (TupleType)((FunctionType)mt).getRange();
                numRng = rngType.getDimension();
                rangeNames = new String[numRng];
                this.rangeSets = new Set[numRng];
                i = 0;
                while (i < numRng) {
                    comp = rngType.getComponent(i);
                    rangeNames[i] = comp.toString().trim();
                    if (this.debug) {
                        System.out.println("range " + i + " = " + rangeNames[i]);
                    }
                    if (comp instanceof RealType) {
                        this.rangeSets[i] = ((RealType)comp).getDefaultSet();
                        if (this.rangeSets[i] == null) {
                            this.rangeSets[i] = comp.equals(RealType.Time) ? new DoubleSet(new SetType(comp)) : new FloatSet(new SetType(comp));
                        }
                    } else {
                        this.rangeSets[i] = null;
                    }
                    if (this.debug) {
                        System.out.println("####  rangeSet = " + this.rangeSets[i]);
                    }
                    ++i;
                }
            } else {
                throw new VisADException("TextAdapter: Math Type is not a simple FunctionType");
            }
            domainPointer = new int[numDom];
            domainRanges = new double[3][numDom];
            gotDomainRanges = new boolean[numDom];
            this.domainErrorEstimates = new double[numDom];
            this.domainUnits = new Unit[numDom];
            this.rangeErrorEstimates = new double[numRng];
            this.rangeUnits = new Unit[numRng];
            countDomain = 0;
            i = 0;
            while (i < numDom) {
                domainPointer[i] = -1;
                gotDomainRanges[i] = false;
                this.domainErrorEstimates[i] = NaN;
                this.domainUnits[i] = null;
                ++i;
            }
            rangePointer = new int[numRng];
            countRange = 0;
            i = 0;
            while (i < numRng) {
                rangePointer[i] = -1;
                this.rangeErrorEstimates[i] = NaN;
                this.rangeUnits[i] = null;
                ++i;
            }
            countValues = -1;
            this.values_to_index = new int[3][nhdr];
            i = 0;
            while (i < nhdr) {
                this.values_to_index[0][i] = -1;
                this.values_to_index[1][i] = -1;
                this.values_to_index[2][i] = -1;
                ++countValues;
                name = this.hdrNames[i];
                gotName = false;
                test_name = name;
                n = test_name.indexOf("(");
                if (n != -1 && test_name.indexOf("(Text)") == -1) {
                    test_name = name.substring(0, n).trim();
                    --countValues;
                    --countDomain;
                }
                k = 0;
                while (k < numDom) {
                    if (test_name.equals(domainNames[k])) {
                        domainPointer[k] = countValues;
                        this.domainErrorEstimates[k] = this.hdrErrorEstimates[i];
                        this.domainUnits[k] = this.hdrUnits[i];
                        gotName = true;
                        ++countDomain;
                        if (n != -1) {
                            try {
                                ss = name.substring(n + 1, name.length() - 1);
                                sct = new StringTokenizer(ss, ":");
                                first = sct.nextToken().trim();
                                second = sct.nextToken().trim();
                                third = "1";
                                if (sct.hasMoreTokens()) {
                                    third = sct.nextToken().trim();
                                }
                                domainRanges[0][k] = Double.parseDouble(first);
                                domainRanges[1][k] = Double.parseDouble(second);
                                domainRanges[2][k] = Double.parseDouble(third);
                                gotDomainRanges[k] = true;
                                break;
                            }
                            catch (Exception ef) {
                                throw new VisADException("TextAdapter: Error while interpreting min:max values for domain " + name);
                            }
                        }
                        if (countValues <= -1) break;
                        this.values_to_index[0][countValues] = k;
                        this.values_to_index[2][countValues] = i;
                        break;
                    }
                    ++k;
                }
                if (!gotName) {
                    k = 0;
                    while (k < numRng) {
                        if (name.equals(rangeNames[k])) {
                            rangePointer[k] = countValues;
                            this.rangeErrorEstimates[k] = this.hdrErrorEstimates[i];
                            this.rangeUnits[k] = this.hdrUnits[i];
                            ++countRange;
                            this.values_to_index[1][countValues] = k;
                            this.values_to_index[2][countValues] = i;
                            gotName = true;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            if (this.debug) {
                System.out.println("countDom/numDom=" + countDomain + " " + numDom);
                System.out.println("countRange/numRng=" + countRange + " " + numRng);
                System.out.println("Domain info:");
                i = 0;
                while (i < numDom) {
                    System.out.println("Dom name / index = " + domainNames[i] + "  " + domainPointer[i]);
                    if (gotDomainRanges[i]) {
                        System.out.println("    ..." + domainRanges[0][i] + "  " + domainRanges[1][i] + "    " + domainRanges[2][i]);
                    }
                    ++i;
                }
                System.out.println("Range info:");
                i = 0;
                while (i < numRng) {
                    System.out.println("Rng name / index / error est = " + rangeNames[i] + "  " + rangePointer[i] + "  " + this.rangeErrorEstimates[i] + " " + this.rangeUnits[i]);
                    ++i;
                }
                System.out.println("values_to_index pointers = ");
                i = 0;
                while (i < nhdr) {
                    System.out.println(" inx / value = " + i + " " + this.values_to_index[0][i] + "    " + this.values_to_index[1][i] + " " + this.values_to_index[2][i]);
                    ++i;
                }
            }
            domainValues = new ArrayList<double[]>();
            rangeValues = new ArrayList<double[]>();
            tupleValues = new ArrayList<Tuple>();
            tuple = null;
            dataDelim = this.DELIM;
            isRaster = false;
            numElements = 1;
            if (countRange == 1 && numRng == 1 && numDom == 2 && countDomain < 2) {
                isRaster = true;
            }
            while (true) {
                s = bis.readLine();
                if (this.debug) {
                    System.out.println("read:" + s);
                }
                if (s == null) break;
                if (!TextAdapter.isText(s)) {
                    return;
                }
                if (s.startsWith("#") || s.startsWith("!") || s.startsWith("%") || s.length() < 1) continue;
                if (dataDelim == null) {
                    if (s.indexOf(" ") != -1) {
                        dataDelim = " ";
                    }
                    if (s.indexOf(",") != -1) {
                        dataDelim = ",";
                    }
                    if (s.indexOf(";") != -1) {
                        dataDelim = ";";
                    }
                    if (s.indexOf("\t") != -1) {
                        dataDelim = "\t";
                    }
                    if (this.debug) {
                        System.out.println("Using data delimiter = " + dataDelim.getBytes()[0]);
                    }
                }
                if ((n = (st = new StringTokenizer(s, dataDelim)).countTokens()) < 1) continue;
                dValues = new double[numDom];
                rValues = null;
                tValues = null;
                if (isRaster) {
                    if (this.debug) {
                        System.out.println("probably a raster...");
                    }
                    gotFirst = false;
                    rvaluePointer = 0;
                    irange = 0;
                    i = 0;
                    while (i < n) {
                        sa = st.nextToken().trim();
                        if (i >= nhdr) {
                            if (!gotFirst) {
                                throw new VisADException("TextAdapter: Cannot find first raster value");
                            }
                            rValues[++rvaluePointer] = this.getVal(sa, irange);
                        } else {
                            if (this.values_to_index[0][i] != -1) {
                                dValues[this.values_to_index[0][i]] = this.getVal(sa, i);
                            }
                            if (gotFirst) {
                                rValues[++rvaluePointer] = this.getVal(sa, irange);
                            } else if (this.values_to_index[1][i] != -1) {
                                rValues = new double[n - i];
                                irange = i;
                                rValues[rvaluePointer] = this.getVal(sa, irange);
                                gotFirst = true;
                            }
                        }
                        ++i;
                    }
                } else {
                    tValues = new Data[numRng];
                    if (this.debug) {
                        System.out.println("probably not a raster...");
                    }
                    rValues = new double[numRng];
                    if (n > nhdr) {
                        n = nhdr;
                    }
                    i = 0;
                    while (i < n) {
                        sa = st.nextToken().trim();
                        if (this.values_to_index[0][i] != -1) {
                            dValues[this.values_to_index[0][i]] = this.getVal(sa, i);
                        } else if (this.values_to_index[1][i] != -1) {
                            thisMT = rngType.getComponent(this.values_to_index[1][i]);
                            if (thisMT instanceof TextType) {
                                if (sa.startsWith("\"")) {
                                    if (sa.endsWith("\"")) {
                                        sThisText = sa2 = sa.substring(1, sa.length() - 1);
                                    } else {
                                        try {
                                            sa2 = st.nextToken("\"");
                                            sThisText = sa.substring(1) + sa2;
                                        }
                                        catch (NoSuchElementException nse) {
                                            sThisText = "";
                                        }
                                    }
                                    if (this.debug) {
                                        System.out.println("####   Text value='" + sThisText + "'");
                                    }
                                } else {
                                    sThisText = sa;
                                }
                                try {
                                    tValues[this.values_to_index[1][i]] = new Text((TextType)thisMT, sThisText);
                                    if (this.debug) {
                                        System.out.println("tValues[" + this.values_to_index[1][i] + "] = " + tValues[this.values_to_index[1][i]]);
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println(" Exception converting " + thisMT + " to TextType " + e);
                                }
                            } else {
                                rValues[this.values_to_index[1][i]] = this.getVal(sa, i);
                                try {
                                    tValues[this.values_to_index[1][i]] = new Real((RealType)thisMT, this.getVal(sa, i), this.hdrUnits[i]);
                                    if (this.debug) {
                                        System.out.println("tValues[" + this.values_to_index[1][i] + "] = " + tValues[this.values_to_index[1][i]]);
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println(" Exception converting " + thisMT + " " + e);
                                }
                            }
                        }
                        ++i;
                    }
                }
                try {
                    if (tValues != null) {
                        tuple = new Tuple(tValues);
                    }
                }
                catch (TypeException te) {
                    tuple = null;
                }
                domainValues.add(dValues);
                rangeValues.add(rValues);
                if (tuple != null) {
                    tupleValues.add(tuple);
                }
                if (!isRaster) continue;
                numElements = rValues.length;
            }
            numSamples = rangeValues.size();
            if (this.debug) {
                try {
                    System.out.println("domain size = " + domainValues.size());
                    dt = (double[])domainValues.get(1);
                    System.out.println("domain.array[0] = " + dt[0]);
                    System.out.println("range size = " + rangeValues.size());
                    System.out.println("# samples = " + numSamples);
                }
                catch (Exception er) {
                    System.out.println("out range");
                }
            }
            lset = new Linear1DSet[numDom];
            keepConstant = false;
            numVal = numRng;
            if (numDom == 1) {
                numVal = numSamples;
            }
            if (numDom == 2 && numRng == 1 && numElements > 1) {
                numVal = numElements;
            }
            if (numDom > 2 && numRng == 1 && numElements == 1) {
                numVal = numSamples / (2 * numDom);
                keepConstant = true;
            }
            i = 0;
            while (i < numDom) {
                if (gotDomainRanges[i]) {
                    lset[i] = new Linear1DSet(domType.getComponent(i), domainRanges[0][i], domainRanges[1][i], numVal);
                    if (this.debug) {
                        System.out.println("lset from domain = " + lset[i]);
                    }
                } else if (domainPointer[i] == -1) {
                    lset[i] = new Linear1DSet(0.0, numVal - 1, numVal);
                    if (this.debug) {
                        System.out.println("lset from range = " + lset[i]);
                    }
                } else {
                    lset[i] = null;
                }
                if (!keepConstant) {
                    numVal = numSamples;
                }
                ++i;
            }
            domain /* !! */  = null;
            if (numDom == 1) {
                domain /* !! */  = lset[0] == null ? this.createAppropriate1DDomain(domType, numSamples, domainValues) : lset[0];
            } else if (numDom == 2) {
                if (lset[0] != null && lset[1] != null) {
                    domain /* !! */  = new Linear2DSet((MathType)domType, lset);
                } else {
                    samples = new float[numDom][numSamples];
                    k = 0;
                    while (k < numDom) {
                        samples[k] = lset[k] == null ? this.getDomSamples(k, numSamples, domainValues)[0] : lset[k].getSamples()[0];
                        ++k;
                    }
                    domain /* !! */  = new Irregular2DSet((MathType)domType, samples);
                }
            } else if (numDom == 3) {
                if (lset[0] != null && lset[1] != null && lset[2] != null) {
                    domain /* !! */  = new Linear3DSet((MathType)domType, lset);
                } else {
                    samples = new float[numDom][numSamples];
                    k = 0;
                    while (k < numDom) {
                        samples[k] = lset[k] == null ? this.getDomSamples(k, numSamples, domainValues)[0] : lset[k].getSamples()[0];
                        ++k;
                    }
                    domain /* !! */  = new Irregular3DSet((MathType)domType, samples);
                }
            } else {
                allLinear = true;
                k = 0;
                while (k < numDom) {
                    if (lset[k] == null) {
                        allLinear = false;
                    }
                    ++k;
                }
                if (allLinear) {
                    if (this.debug) {
                        System.out.println("####   Making LinearNDset");
                    }
                    domain /* !! */  = new LinearNDSet((MathType)domType, lset);
                } else {
                    if (this.debug) {
                        System.out.println("####   Making IrregularSet");
                    }
                    samples = new float[numDom][numSamples];
                    k = 0;
                    while (k < numDom) {
                        samples[k] = lset[k] == null ? this.getDomSamples(k, numSamples, domainValues)[0] : lset[k].getSamples()[0];
                        ++k;
                    }
                    domain /* !! */  = new IrregularSet((MathType)domType, samples);
                }
            }
            try {
                this.ff = new FlatField((FunctionType)mt, domain /* !! */ , null, null, this.rangeSets, this.rangeUnits);
            }
            catch (FieldException fe) {
                this.field = new FieldImpl((FunctionType)mt, domain /* !! */ );
            }
            catch (UnitException fe) {
                System.out.println("####  Problem with Units; attempting to make Field anyway");
                this.field = new FieldImpl((FunctionType)mt, domain /* !! */ );
            }
            if (this.debug) {
                if (this.ff != null) {
                    System.out.println("ff.Length " + this.ff.getLength());
                    System.out.println("ff.getType " + this.ff.getType());
                }
                if (this.field != null) {
                    System.out.println("field.Length " + this.field.getLength());
                    System.out.println("field.getType " + this.field.getType());
                }
                System.out.println("domain = " + domain /* !! */ );
                System.out.println("size of a = " + numRng + " x " + numSamples * numElements);
            }
            a = new double[numRng][numSamples * numElements];
            at = new Tuple[numSamples];
            if (isRaster) {
                samPointer = 0;
                i = 0;
                while (i < numSamples) {
                    rs = (double[])rangeValues.get(i);
                    j = 0;
                    while (j < numElements) {
                        a[0][samPointer] = rs[j];
                        ++samPointer;
                        ++j;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < numSamples) {
                    rs = (double[])rangeValues.get(i);
                    j = 0;
                    while (j < numRng) {
                        a[j][i] = rs[j];
                        ++j;
                    }
                    if (!tupleValues.isEmpty()) {
                        at[i] = (Tuple)tupleValues.get(i);
                    }
                    ++i;
                }
            }
            if (this.debug) {
                System.out.println("about to field.setSamples");
            }
            try {
                if (this.ff != null) {
                    if (this.debug) {
                        System.out.println("####   ff is not null");
                    }
                    this.ff.setSamples(a, false);
                    this.field = this.ff;
                } else {
                    if (this.debug) {
                        System.out.println("####   ff is null..use FieldImpl");
                    }
                    this.field.setSamples(at, false);
                }
            }
            catch (Exception ffe) {
                ffe.printStackTrace();
            }
            es = new ErrorEstimate[numRng];
            i = 0;
            while (i < numRng) {
                es[i] = new ErrorEstimate(a[i], this.rangeErrorEstimates[i], this.rangeUnits[i]);
                ++i;
            }
            try {
                ((FlatField)this.field).setRangeErrors(es);
            }
            catch (FieldException fe) {
                if (this.debug) {
                    System.out.println("caught " + fe);
                }
            }
            catch (ClassCastException cce) {
                if (!this.debug) break block198;
                System.out.println("caught " + cce);
            }
        }
        if (this.debug) {
            new DumpType();
            DumpType.dumpDataType(this.field, System.out);
            System.out.println("field = " + this.field);
        }
        bis.close();
    }

    private String makeMT(String s) {
        String t2;
        int k = s.indexOf("->");
        if (k < 0) {
            System.out.println("TextAdapter: invalid MathType form; -> required");
            return null;
        }
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < s.length()) {
            String r = s.substring(i, i + 1);
            if (!(r.equals(" ") || r.equals("\t") || r.equals("\n"))) {
                sb.append(r);
            }
            ++i;
        }
        String t = sb.toString();
        if (t.charAt((k = t.indexOf("->")) - 1) != ')') {
            t = t.charAt(k + 2) != '(' ? (t2 = "(" + t.substring(0, k) + ")->(" + t.substring(k + 2) + ")") : (t2 = "(" + t.substring(0, k) + ")" + t.substring(k));
        } else if (t.charAt(k + 2) != '(') {
            t = t2 = t.substring(0, k + 2) + "(" + t.substring(k + 2) + ")";
        }
        if (!t.startsWith("((")) {
            t = t2 = "(" + t + ")";
        }
        return t;
    }

    private static final boolean isText(String s) {
        int len;
        int n = len = s == null ? -1 : s.length();
        if (len <= 0) {
            return true;
        }
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static DateTime makeDateTimeFromString(String string, String format) throws ParseException {
        DateTime dt = null;
        try {
            dt = DateTime.createDateTime(string, format);
        }
        catch (VisADException e) {
            // empty catch block
        }
        if (dt == null) {
            throw new ParseException("Couldn't parse visad.DateTime from \"" + string + "\"", -1);
        }
        return dt;
    }

    double getVal(String s, int k) {
        int i = this.values_to_index[2][k];
        if (i < 0 || s == null || s.length() < 1 || s.equals(this.hdrMissingStrings[i])) {
            return Double.NaN;
        }
        if (this.hdrFormatStrings[i] == null) {
            try {
                double v = Double.parseDouble(s);
                if (v == this.hdrMissingValues[i]) {
                    return Double.NaN;
                }
                v = v * this.hdrScales[i] + this.hdrOffsets[i];
                return v;
            }
            catch (NumberFormatException ne) {
                System.out.println("Invalid number format for " + s);
            }
        } else {
            try {
                DateTime dt = TextAdapter.makeDateTimeFromString(s, this.hdrFormatStrings[i]);
                return dt.getReal().getValue();
            }
            catch (ParseException pe) {
                System.out.println("Invalid number/time format for " + s);
            }
        }
        return Double.NaN;
    }

    float[][] getDomSamples(int comp, int numDomValues, ArrayList domValues) {
        float[][] a = new float[1][numDomValues];
        int i = 0;
        while (i < numDomValues) {
            double[] d = (double[])domValues.get(i);
            a[0][i] = (float)d[comp];
            ++i;
        }
        return a;
    }

    public Field getData() {
        return this.field;
    }

    private Set createAppropriate1DDomain(MathType type, int numSamples, ArrayList domValues) throws VisADException {
        ArithProg arithProg;
        int i;
        boolean ascending;
        if (0 == numSamples) {
            return null;
        }
        double[][] values = new double[1][numSamples];
        int i2 = 0;
        while (i2 < numSamples) {
            double[] d = (double[])domValues.get(i2);
            values[0][i2] = d[0];
            ++i2;
        }
        boolean ordered = true;
        boolean bl = ascending = values[0][numSamples - 1] > values[0][0];
        if (ascending) {
            i = 1;
            while (i < numSamples) {
                if (values[0][i] < values[0][i - 1]) {
                    ordered = false;
                    break;
                }
                ++i;
            }
        } else {
            i = 1;
            while (i < numSamples) {
                if (values[0][i] > values[0][i - 1]) {
                    ordered = false;
                    break;
                }
                ++i;
            }
        }
        SampledSet set = null;
        set = ordered ? ((arithProg = new ArithProg()).accumulate(values[0]) ? new Linear1DSet(type, values[0][0], values[0][numSamples - 1], numSamples) : new Gridded1DDoubleSet(type, values, numSamples)) : new Irregular1DSet(type, Set.doubleToFloat(values));
        return set;
    }
}

