/*
 * Decompiled with CFR 0.152.
 */
package visad.data.qt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class QTForm
extends Form
implements FormFileInformer,
FormBlockReader,
FormProgressInformer {
    private static final String[] SUFFIXES = new String[]{"mov"};
    private static final String NO_QT_MSG = "You need to install QuickTime for Java from http://www.apple.com/quicktime/";
    private static final boolean MAC_OS_X = System.getProperty("os.name").equals("Mac OS X");
    private static int num = 0;
    private static boolean noQT = false;
    private static final URL[] PATHS = QTForm.constructPaths();
    private static final ReflectedUniverse R = QTForm.constructUniverse();
    private String currentId;
    private int numImages;
    private int timeStep;
    private Image image;
    private boolean needsRedrawing;
    private int frameRate;
    private double percent;

    private static URL[] constructPaths() {
        URL[] paths = null;
        try {
            paths = new URL[]{new URL("file:/WinNT/System32/QTJava.zip"), new URL("file:/Windows/System32/QTJava.zip"), new URL("file:/Windows/System/QTJava.zip"), new URL("file:/System/Library/Java/Extensions/QTJava.zip")};
        }
        catch (MalformedURLException exc) {}
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReflectedUniverse constructUniverse() {
        boolean needClose = false;
        ReflectedUniverse r = new ReflectedUniverse(PATHS);
        r.exec("import quicktime.QTSession");
        r.exec("QTSession.open()");
        needClose = true;
        if (MAC_OS_X) {
            r.exec("import quicktime.app.view.QTImageProducer");
            r.exec("import quicktime.app.view.MoviePlayer");
            r.exec("import quicktime.std.movies.TimeInfo");
        } else {
            r.exec("import quicktime.app.display.QTCanvas");
            r.exec("import quicktime.app.image.ImageUtil");
            r.exec("import quicktime.app.image.JImagePainter");
            r.exec("import quicktime.app.image.QTImageDrawer");
            r.exec("import quicktime.app.image.QTImageProducer");
            r.exec("import quicktime.app.image.Redrawable");
            r.exec("import quicktime.app.players.MoviePlayer");
        }
        r.exec("import quicktime.io.OpenMovieFile");
        r.exec("import quicktime.io.QTFile");
        r.exec("import quicktime.qd.Pict");
        r.exec("import quicktime.qd.QDDimension");
        r.exec("import quicktime.qd.QDGraphics");
        r.exec("import quicktime.qd.QDRect");
        r.exec("import quicktime.std.StdQTConstants");
        r.exec("import quicktime.std.image.CodecComponent");
        r.exec("import quicktime.std.image.CompressedFrameInfo");
        r.exec("import quicktime.std.image.CSequence");
        r.exec("import quicktime.std.image.ImageDescription");
        r.exec("import quicktime.std.image.QTImage");
        r.exec("import quicktime.std.movies.Movie");
        r.exec("import quicktime.std.movies.Track");
        r.exec("import quicktime.std.movies.media.VideoMedia");
        r.exec("import quicktime.util.QTHandle");
        r.exec("import quicktime.util.RawEncodedImage");
        Object var4_2 = null;
        if (!needClose) return r;
        try {
            r.exec("QTSession.close()");
            return r;
        }
        catch (Throwable t2) {}
        return r;
        {
            catch (Throwable t) {
                noQT = true;
                Object var4_3 = null;
                if (!needClose) return r;
                try {
                    r.exec("QTSession.close()");
                    return r;
                }
                catch (Throwable t2) {}
                return r;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!needClose) throw throwable;
            try {
                r.exec("QTSession.close()");
                throw throwable;
            }
            catch (Throwable t2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public QTForm() {
        super("QTForm" + num++);
        this.setFrameRate(10);
    }

    public boolean isThisType(String name) {
        if (noQT) {
            return false;
        }
        int i = 0;
        while (i < SUFFIXES.length) {
            if (name.toLowerCase().endsWith(SUFFIXES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[SUFFIXES.length];
        System.arraycopy(SUFFIXES, 0, s, 0, SUFFIXES.length);
        return s;
    }

    public boolean canDoQT() {
        return !noQT;
    }

    public void setFrameRate(int fps) {
        this.frameRate = 600 / fps;
    }

    public int getFrameRate() {
        return 600 / this.frameRate;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        if (MAC_OS_X) {
            throw new BadFormException("QuickTime movie saving on Mac OS X is not supported.");
        }
        if (noQT) {
            throw new BadFormException(NO_QT_MSG);
        }
        try {
            FlatField[] fields = DataUtility.getImageFields(data);
            int numFrames = fields.length;
            Gridded2DSet set = (Gridded2DSet)fields[0].getDomainSet();
            int[] lengths = set.getLengths();
            int kWidth = lengths[0];
            int kHeight = lengths[1];
            R.setVar("numFrames", numFrames);
            R.setVar("kWidth", kWidth);
            R.setVar("kHeight", kHeight);
            R.exec("QTSession.open()");
            R.setVar("oneHalf", 0.5f);
            Component canv = (Component)R.exec("canv = new QTCanvas(QTCanvas.kInitialSize, oneHalf, oneHalf)");
            JFrame frame = new JFrame();
            JPanel pane = new JPanel();
            frame.setContentPane(pane);
            pane.add("Center", canv);
            BufferedImage buffer = new BufferedImage(kWidth, kHeight, 1);
            R.setVar("buffer", buffer);
            R.exec("ip = new JImagePainter(buffer)");
            Dimension dim = new Dimension(kWidth, kHeight);
            R.setVar("dim", dim);
            R.exec("qid = new QTImageDrawer(ip, dim, Redrawable.kMultiFrame)");
            R.setVar("true", true);
            R.exec("qid.setRedrawing(true)");
            R.exec("canv.setClient(qid, true)");
            frame.pack();
            File file = new File(id);
            R.setVar("path", file.getAbsolutePath());
            R.exec("f = new QTFile(path)");
            Integer i1 = (Integer)R.getVar("StdQTConstants.createMovieFileDeleteCurFile");
            Integer i2 = (Integer)R.getVar("StdQTConstants.createMovieFileDontCreateResFile");
            R.setVar("flags", i1 | i2);
            R.exec("theMovie = Movie.createMovieFile(f, StdQTConstants.kMoviePlayer, flags)");
            int kNoVolume = 0;
            R.setVar("kNoVolume", kNoVolume);
            R.setVar("kVidTimeScale", 600);
            R.setVar("fkWidth", (float)kWidth);
            R.setVar("fkHeight", (float)kHeight);
            R.setVar("fkNoVolume", (float)kNoVolume);
            R.exec("vidTrack = theMovie.addTrack(fkWidth, fkHeight, fkNoVolume)");
            R.exec("vidMedia = new VideoMedia(vidTrack, kVidTimeScale)");
            R.exec("vidMedia.beginEdits()");
            R.exec("rect = new QDRect(kWidth, kHeight)");
            R.exec("gw = new QDGraphics(rect)");
            R.exec("pixmap = gw.getPixMap()");
            R.exec("pixsize = pixmap.getPixelSize()");
            R.exec("size = QTImage.getMaxCompressionSize(gw, rect, pixsize, StdQTConstants.codecNormalQuality, StdQTConstants.kAnimationCodecType, CodecComponent.anyCodec)");
            R.exec("imageHandle = new QTHandle(size, true)");
            R.exec("imageHandle.lock()");
            R.exec("compressedImage = RawEncodedImage.fromQTHandle(imageHandle)");
            R.setVar("zero", 0);
            R.exec("seq = new CSequence(gw, rect, pixsize, StdQTConstants.kAnimationCodecType, CodecComponent.bestFidelityCodec, StdQTConstants.codecNormalQuality, StdQTConstants.codecNormalQuality, numFrames, null, zero)");
            R.exec("desc = seq.getDescription()");
            this.setCurrentFrame(0, buffer, fields);
            R.exec("qid.redraw(null)");
            R.exec("qid.setGWorld(gw)");
            R.exec("qid.setDisplayBounds(rect)");
            int curSample = 0;
            while (curSample < numFrames) {
                this.setCurrentFrame(curSample, buffer, fields);
                R.exec("qid.redraw(null)");
                R.exec("info = seq.compressFrame(gw, rect, StdQTConstants.codecFlagUpdatePrevious, compressedImage)");
                Integer sim = (Integer)R.exec("info.getSimilarity()");
                if (sim == 0) {
                    R.setVar("keyFrame", 0);
                } else {
                    R.setVar("keyFrame", R.getVar("StdQTConstants.mediaSampleNotSync"));
                }
                R.exec("dataSize = info.getDataSize()");
                R.setVar("one", 1);
                R.setVar("frameRate", this.frameRate);
                R.exec("vidMedia.addSample(imageHandle, zero, dataSize, frameRate, desc, one, keyFrame)");
                ++curSample;
            }
            R.exec("port = canv.getPort()");
            R.exec("qid.setGWorld(port)");
            R.exec("qid.redraw(null)");
            R.exec("vidMedia.endEdits()");
            R.setVar("kTrackStart", 0);
            R.setVar("kMediaTime", 0);
            R.setVar("kMediaRate", 1.0f);
            R.exec("duration = vidMedia.getDuration()");
            R.exec("vidTrack.insertMedia(kTrackStart, kMediaTime, duration, kMediaRate)");
            R.exec("outStream = OpenMovieFile.asWrite(f)");
            R.exec("name = f.getName()");
            R.exec("theMovie.addResource(outStream, StdQTConstants.movieInDataForkResID, name)");
            R.exec("outStream.close()");
            R.exec("QTSession.close()");
        }
        catch (Exception exc) {
            R.exec("QTSession.close()");
            throw new BadFormException("Save movie failed: " + exc.getMessage());
        }
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("QTForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        if (noQT) {
            throw new BadFormException(NO_QT_MSG);
        }
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType time = RealType.getRealType("time");
            FunctionType timeFunction = new FunctionType(time, fields[0].getType());
            Integer1DSet timeSet = new Integer1DSet(nImages);
            FieldImpl timeField = new FieldImpl(timeFunction, timeSet);
            timeField.setSamples(fields, false);
            data = timeField;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("QTForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        if (block_number < 0 || block_number >= this.numImages) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        if (noQT) {
            throw new BadFormException(NO_QT_MSG);
        }
        R.setVar("time", this.timeStep * block_number);
        R.exec("moviePlayer.setTime(time)");
        if (this.needsRedrawing) {
            R.exec("qtip.redraw(null)");
        }
        R.exec("qtip.updateConsumers(null)");
        return DataUtility.makeField(this.image);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.numImages;
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.currentId == null) {
            return;
        }
        try {
            R.exec("openMovieFile.close()");
            R.exec("QTSession.close()");
        }
        catch (Exception e) {
            R.exec("QTSession.close()");
            throw new BadFormException("Close movie failed: " + e.getMessage());
        }
        this.currentId = null;
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private void setCurrentFrame(int frame, BufferedImage buffer, FlatField[] fields) {
        Image img = DataUtility.extractImage(fields[frame], false);
        if (img != null) {
            Graphics g = buffer.getGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
        }
    }

    private void initFile(String id) throws BadFormException, IOException, VisADException {
        if (noQT) {
            throw new BadFormException(NO_QT_MSG);
        }
        this.close();
        try {
            Integer w;
            R.exec("QTSession.open()");
            File file = new File(id);
            R.setVar("path", file.getAbsolutePath());
            R.exec("qtf = new QTFile(path)");
            R.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
            R.exec("m = Movie.fromFile(openMovieFile)");
            int numTracks = (Integer)R.exec("m.getTrackCount()");
            int trackMostLikely = 0;
            int trackNum = 0;
            while (++trackNum <= numTracks && trackMostLikely == 0) {
                R.setVar("trackNum", trackNum);
                R.exec("imageTrack = m.getTrack(trackNum)");
                R.exec("d = imageTrack.getSize()");
                w = (Integer)R.exec("d.getWidth()");
                if (w <= 0) continue;
                trackMostLikely = trackNum;
            }
            R.setVar("trackMostLikely", trackMostLikely);
            R.exec("imageTrack = m.getTrack(trackMostLikely)");
            R.exec("d = imageTrack.getSize()");
            w = (Integer)R.exec("d.getWidth()");
            Integer h = (Integer)R.exec("d.getHeight()");
            R.exec("moviePlayer = new MoviePlayer(m)");
            R.setVar("dim", new Dimension(w, h));
            ImageProducer qtip = (ImageProducer)R.exec("qtip = new QTImageProducer(moviePlayer, dim)");
            this.image = Toolkit.getDefaultToolkit().createImage(qtip);
            this.needsRedrawing = (Boolean)R.exec("qtip.isRedrawing()");
            int maxTime = (Integer)R.exec("m.getDuration()");
            if (MAC_OS_X) {
                R.setVar("zero", 0);
                R.setVar("one", 1.0f);
                R.exec("timeInfo = new TimeInfo(zero, zero)");
                R.exec("moviePlayer.setTime(zero)");
                this.numImages = 0;
                int time = 0;
                do {
                    ++this.numImages;
                    R.exec("timeInfo = imageTrack.getNextInterestingTime(StdQTConstants.nextTimeMediaSample, timeInfo.time, one)");
                } while ((time = ((Integer)R.getVar("timeInfo.time")).intValue()) >= 0);
            } else {
                R.exec("seq = ImageUtil.createSequence(imageTrack)");
                this.numImages = (Integer)R.exec("seq.size()");
            }
            this.timeStep = maxTime / this.numImages;
        }
        catch (Exception e) {
            R.exec("QTSession.close()");
            throw new BadFormException("Open movie failed: " + e.getMessage());
        }
        this.currentId = id;
    }

    public static ReflectedUniverse getUniverse() {
        return R;
    }

    public static synchronized FlatField pictToField(byte[] bytes) throws VisADException {
        try {
            return DataUtility.makeField(QTForm.pictToImage(bytes));
        }
        catch (IOException exc) {
            return null;
        }
    }

    public static Dimension getPictDimensions(byte[] bytes) throws VisADException {
        if (noQT) {
            throw new BadFormException(NO_QT_MSG);
        }
        try {
            R.exec("QTSession.open()");
            R.setVar("bytes", bytes);
            R.exec("pict = new Pict(bytes)");
            R.exec("box = pict.getPictFrame()");
            int width = (Integer)R.exec("box.getWidth()");
            int height = (Integer)R.exec("box.getHeight()");
            R.exec("QTSession.close()");
            return new Dimension(width, height);
        }
        catch (Exception e) {
            R.exec("QTSession.close()");
            throw new BadFormException("PICT height determination failed: " + e.getMessage());
        }
    }

    public static Image pictToImage(byte[] bytes) throws VisADException {
        if (noQT) {
            throw new BadFormException(NO_QT_MSG);
        }
        try {
            R.exec("QTSession.open()");
            R.setVar("bytes", bytes);
            R.exec("pict = new Pict(bytes)");
            R.exec("box = pict.getPictFrame()");
            int width = (Integer)R.exec("box.getWidth()");
            int height = (Integer)R.exec("box.getHeight()");
            R.exec("g = new QDGraphics(box)");
            R.exec("pict.draw(g, box)");
            R.exec("pixMap = g.getPixMap()");
            R.exec("rei = pixMap.getPixelData()");
            int rowBytes = (Integer)R.exec("pixMap.getRowBytes()");
            int intsPerRow = rowBytes / 4;
            int pixLen = intsPerRow * height;
            R.setVar("pixLen", pixLen);
            int[] pixels = new int[pixLen];
            R.setVar("pixels", pixels);
            R.setVar("zero", new Integer(0));
            R.exec("rei.copyToArray(zero, pixels, zero, pixLen)");
            int bitsPerSample = 32;
            int redMask = 0xFF0000;
            int greenMask = 65280;
            int blueMask = 255;
            int alphaMask = 0;
            DirectColorModel colorModel = new DirectColorModel(bitsPerSample, redMask, greenMask, blueMask, alphaMask);
            R.exec("QTSession.close()");
            return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, (ColorModel)colorModel, pixels, 0, intsPerRow));
        }
        catch (Exception e) {
            R.exec("QTSession.close()");
            throw new BadFormException("PICT extraction failed: " + e.getMessage());
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to QuickTime, run:");
            System.out.println("  java visad.data.qt.QTForm in_file out_file");
            System.out.println("To test read a QuickTime file, run:");
            System.out.println("  java visad.data.qt.QTForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            QTForm form = new QTForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            QTForm form = new QTForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
    }
}

