/*
 * Decompiled with CFR 0.152.
 */
package visad.data.qt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.qt.QTForm;

public class PictForm
extends Form
implements FormBlockReader,
FormFileInformer {
    private static final String[] SUFFIXES = new String[]{"pict"};
    private static int num = 0;

    public PictForm() {
        super("PictForm" + num++);
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new BadFormException("PictForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("PictForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        File file = new File(id);
        int len = (int)file.length() - 512;
        byte[] bytes = new byte[len];
        FileInputStream fin = new FileInputStream(file);
        fin.skip(512L);
        int read = 0;
        int left = len;
        while (left > 0) {
            int r = fin.read(bytes, read, left);
            read += r;
            left -= r;
        }
        fin.close();
        return QTForm.pictToField(bytes);
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("PictForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (block_number != 0) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        return this.open(id);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        return 1;
    }

    public void close() throws BadFormException, IOException, VisADException {
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < SUFFIXES.length) {
            if (name.toLowerCase().endsWith(SUFFIXES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[SUFFIXES.length];
        System.arraycopy(SUFFIXES, 0, s, 0, SUFFIXES.length);
        return s;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length != 1) {
            System.out.println("To test read a PICT image, run:");
            System.out.println("  java visad.data.qt.PictForm in_file");
            System.exit(2);
        }
        PictForm form = new PictForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType().prettyString());
    }
}

