/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.DataImpl;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TupleType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.VirtualData;

public class VirtualTuple
extends VirtualData {
    private DataFactory dataFactory = DataFactory.instance();
    private final Vector components;
    private MathType mathType = null;
    private boolean isDirty = true;

    public VirtualTuple() {
        this(0);
    }

    private VirtualTuple(int n) {
        this.components = new Vector(n);
    }

    public VirtualTuple(VirtualData data) {
        this(1);
        this.add(data);
    }

    public VirtualTuple(VirtualData[] datas) {
        this(datas.length);
        int i = 0;
        while (i < datas.length) {
            this.add(datas[i]);
            ++i;
        }
    }

    public int size() {
        return this.components.size();
    }

    public synchronized void add(VirtualData data) {
        this.components.add(data);
        this.isDirty = true;
    }

    public MathType getType() throws VisADException {
        if (this.isDirty) {
            int componentCount = this.size();
            if (componentCount == 0) {
                this.mathType = null;
            } else if (componentCount == 1) {
                this.mathType = ((VirtualData)this.components.get(0)).getType();
            } else {
                MathType[] types = new MathType[componentCount];
                boolean allRealTypes = true;
                int i = 0;
                while (i < componentCount) {
                    types[i] = ((VirtualData)this.components.get(i)).getType();
                    if (!(types[i] instanceof RealType)) {
                        allRealTypes = false;
                    }
                    ++i;
                }
                if (!allRealTypes) {
                    this.mathType = new TupleType(types);
                } else {
                    RealType[] realTypes = new RealType[componentCount];
                    int i2 = 0;
                    while (i2 < componentCount) {
                        realTypes[i2] = (RealType)types[i2];
                        ++i2;
                    }
                    this.mathType = new RealTupleType(realTypes);
                }
            }
            this.isDirty = false;
        }
        return this.mathType;
    }

    public VirtualData get(int index) throws ArrayIndexOutOfBoundsException {
        return (VirtualData)this.components.get(index);
    }

    public synchronized void replace(int index, VirtualData data) throws ArrayIndexOutOfBoundsException {
        this.components.set(index, data);
        this.isDirty = true;
    }

    public DataImpl getData(Context context) throws VisADException, RemoteException, IOException {
        return this.getDataFactory().newData(context, this);
    }

    public synchronized void clear() {
        this.components.clear();
        this.mathType = null;
        this.isDirty = true;
    }

    public synchronized Object clone() {
        int n = this.size();
        VirtualTuple clone = new VirtualTuple(n);
        int i = 0;
        while (i < n) {
            clone.add((VirtualData)this.get(i).clone());
            ++i;
        }
        return clone;
    }

    public void setDataFactory(DataFactory factory) {
        this.dataFactory = factory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

