/*
 * Decompiled with CFR 0.152.
 */
package visad.data.gis;

import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import visad.CachingCoordinateSystem;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.LinearLatLonSet;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.georef.LatLonTuple;
import visad.georef.UTMCoordinate;
import visad.util.ReflectedUniverse;

public class UsgsDemAdapter {
    private static final int SW = 0;
    private static final int NW = 1;
    private static final int NE = 2;
    private static final int SE = 3;
    private static final int GEOGRAPHIC = 0;
    private static final int UTM = 1;
    private static final int STATE = 2;
    private String tempString;
    private int numPoints = 0;
    private BufferedReader in;
    private int pos;
    private static final int BLOCK_SIZE = 1024;
    private char[] array = new char[1024];
    private static final int RADIANS = 0;
    private static final int FEET = 1;
    private static final int METERS = 2;
    private static final int ARCSECONDS = 3;
    private static RealType EASTING = UTMCoordinate.EASTING;
    private static RealType NORTHING = UTMCoordinate.NORTHING;
    private static Unit[] measureUnits = new Unit[4];
    private String fileName;
    private String freeFormatText;
    private String originCode;
    private int level;
    private int referenceSystem;
    private int zone;
    private int groundMeasure;
    private int elevationMeasure;
    private RealTuple[] corner = new RealTuple[4];
    private float minElevation;
    private float maxElevation;
    private float rotationAngle = 0.0f;
    private float minX = Float.MAX_VALUE;
    private float maxX = Float.MIN_VALUE;
    private float minY = Float.MAX_VALUE;
    private float maxY = Float.MIN_VALUE;
    private float elevationRange;
    private float xRange;
    private float yRange;
    private int elevationAccuracy;
    private float xResolution;
    private float yResolution;
    private float zResolution;
    private int numRows;
    private int numColumns;
    private int maxRows;
    private float[][] rawCoords;
    private int verticalDatum;
    private int horizontalDatum;
    private Linear2DSet domainSet;
    private FlatField data;
    private boolean canDoGeotransform = true;
    private ReflectedUniverse reflectUni;

    public UsgsDemAdapter() {
        try {
            this.reflectUni = new ReflectedUniverse();
            this.reflectUni.exec("import ucar.visad.UTMCoordinateSystem");
            this.reflectUni.exec("import geotransform.ellipsoids.Ellipsoid");
        }
        catch (VisADException exc) {
            this.canDoGeotransform = false;
        }
    }

    public UsgsDemAdapter(String filename) throws IOException, VisADException {
        try {
            this.reflectUni = new ReflectedUniverse();
            this.reflectUni.exec("import ucar.visad.UTMCoordinateSystem");
            this.reflectUni.exec("import geotransform.ellipsoids.Ellipsoid");
        }
        catch (VisADException exc) {
            this.canDoGeotransform = false;
        }
        if (filename != null) {
            this.load(filename);
        }
    }

    public void load(String filename) throws IOException, VisADException {
        this.numPoints = 0;
        this.data = null;
        this.domainSet = null;
        try {
            this.in = filename.endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename)))) : new BufferedReader(new FileReader(filename));
        }
        catch (Exception e) {
            throw new IOException("Couldn't open file: " + filename);
        }
        this.processRecordTypeA();
        int j = 0;
        while (j < this.numColumns) {
            this.processRecordTypeB();
            ++j;
        }
        this.elevationRange = this.maxElevation - this.minElevation;
        this.xRange = this.maxX - this.minX;
        this.yRange = this.maxY - this.minY;
    }

    private void processRecordTypeA() throws IOException, VisADException {
        this.pos = 1;
        this.fileName = this.getString(40);
        this.freeFormatText = this.getString(40);
        this.skip(29);
        this.skip(26);
        this.skip(1);
        this.skip(1);
        this.skip(3);
        this.originCode = this.getString(4);
        this.level = this.parseInt(6);
        this.skip(6);
        this.referenceSystem = this.parseInt(6);
        if (this.referenceSystem != 0 && this.referenceSystem != 1) {
            throw new VisADException("Unimplemented reference system " + this.referenceSystem);
        }
        this.zone = this.parseInt(6);
        this.skip(360);
        this.groundMeasure = this.parseInt(6);
        this.elevationMeasure = this.parseInt(6);
        this.skip(6);
        this.corner[0] = this.parseCoordinate();
        this.corner[1] = this.parseCoordinate();
        this.corner[2] = this.parseCoordinate();
        this.corner[3] = this.parseCoordinate();
        this.minElevation = this.parseFloat(24);
        this.maxElevation = this.parseFloat(24);
        this.rotationAngle = this.parseFloat(24);
        this.elevationAccuracy = this.parseInt(6);
        this.xResolution = this.parseFloat(12);
        this.yResolution = this.parseFloat(12);
        this.zResolution = this.parseFloat(12);
        this.numRows = this.parseInt(6);
        if (this.numRows != 1) {
            throw new VisADException("Can't handle " + this.numRows + " rows");
        }
        this.numColumns = this.parseInt(6);
        this.skip(24);
        try {
            this.verticalDatum = this.parseInt(2);
            this.horizontalDatum = this.parseInt(2);
        }
        catch (NumberFormatException nfe) {
            this.verticalDatum = 2;
            this.horizontalDatum = this.referenceSystem == 1 ? 1 : 2;
        }
        this.skip(1024 - this.pos + 1);
        this.rawCoords = this.referenceSystem == 0 ? new float[3][this.numColumns * 1201] : new float[3][this.numColumns * 2000];
    }

    private void processRecordTypeB() throws IOException, VisADException {
        this.pos = 1;
        int row = this.parseInt(6);
        int column = this.parseInt(6) - 1;
        int m = this.parseInt(6);
        int n = this.parseInt(6);
        float Xgo = this.parseFloat(24);
        float Ygo = this.parseFloat(24);
        float localElevation = this.parseFloat(24);
        float min = this.parseFloat(24);
        float max = this.parseFloat(24);
        if (m > this.maxRows) {
            this.maxRows = m;
        }
        float costheta = (float)Math.cos(this.rotationAngle);
        float sintheta = (float)Math.sin(this.rotationAngle);
        int j = 0;
        while (j < m) {
            int i = 0;
            while (i < n) {
                float Xp = (float)i * this.xResolution;
                float Yp = (float)j * this.yResolution;
                float Xgp = Xgo + Xp * costheta + Yp * sintheta;
                float Ygp = Ygo + Xp * sintheta + Yp * costheta;
                float elevation = (float)this.parseInt() * this.zResolution + localElevation;
                this.minX = Math.min(Xgp, this.minX);
                this.maxX = Math.max(Xgp, this.maxX);
                this.minY = Math.min(Ygp, this.minY);
                this.maxY = Math.max(Ygp, this.maxY);
                this.minElevation = Math.min(this.minElevation, elevation);
                this.maxElevation = Math.max(this.maxElevation, elevation);
                this.rawCoords[0][this.numPoints] = Xgp;
                this.rawCoords[1][this.numPoints] = Ygp;
                this.rawCoords[2][this.numPoints] = elevation;
                ++this.numPoints;
                ++i;
            }
            ++j;
        }
        this.skip(1024 - this.pos % 1024 + 1);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.printElement("File name", this.fileName));
        s.append(this.printElement("Free Format Text", this.freeFormatText));
        s.append(this.printElement("Origin code", this.originCode));
        s.append(this.printElement("Level code", this.level));
        s.append(this.printElement("Reference system code", this.referenceSystem));
        s.append(this.printElement("Reference system zone code", this.zone));
        s.append(this.printElement("Ground measurement units", measureUnits[this.groundMeasure]));
        s.append(this.printElement("Elev. measurement units", measureUnits[this.elevationMeasure]));
        s.append(this.printElement("SW corner", this.corner[0]));
        s.append(this.printElement("NW corner", this.corner[1]));
        s.append(this.printElement("NE corner", this.corner[2]));
        s.append(this.printElement("SE corner", this.corner[3]));
        s.append(this.printElement("Min x", this.minX));
        s.append(this.printElement("Max x", this.maxX));
        s.append(this.printElement("Min y", this.minY));
        s.append(this.printElement("Max y", this.maxY));
        s.append(this.printElement("Min elevation", this.minElevation));
        s.append(this.printElement("Max elevation", this.maxElevation));
        s.append(this.printElement("Elevation accuracy code", this.elevationAccuracy));
        s.append(this.printElement("X resolution", this.xResolution));
        s.append(this.printElement("Y resolution", this.yResolution));
        s.append(this.printElement("Z resolution", this.zResolution));
        s.append(this.printElement("Columns of profiles", this.numColumns));
        s.append(this.printElement("horizontal units", this.horizontalDatum));
        s.append(this.printElement("vertical units", this.verticalDatum));
        s.append(this.printElement("Max m in columns", this.maxRows));
        s.append(this.printElement("Total data", this.numPoints));
        return s.toString();
    }

    private void skip(int length) throws IOException {
        try {
            this.in.skip(length);
        }
        catch (IOException e) {
            throw new IOException("Could not skip " + length + " characters");
        }
        this.pos += length;
    }

    private String getString(int length) throws IOException {
        if (length > 1024) {
            throw new IOException("Attempt to read more than 1024 bytes from file");
        }
        try {
            this.in.read(this.array, 0, length);
        }
        catch (IOException e) {
            throw new IOException("Couldn't read string from file");
        }
        this.pos += length;
        return new String(this.array, 0, length).trim();
    }

    private int parseInt(int digits) throws IOException {
        if (digits > 1024) {
            throw new IOException("Attempt to read more than 1024 bytes from file");
        }
        try {
            this.in.read(this.array, 0, digits);
        }
        catch (IOException e) {
            throw new IOException("Couldn't read integer from file");
        }
        this.pos += digits;
        return Integer.parseInt(new String(this.array, 0, digits).trim());
    }

    private int parseInt() throws IOException {
        this.tempString = "";
        try {
            char c;
            do {
                c = (char)this.in.read();
                ++this.pos;
            } while (Character.isWhitespace(c));
            this.tempString = this.tempString + c;
            do {
                c = (char)this.in.read();
                ++this.pos;
                this.tempString = this.tempString + c;
            } while (!Character.isWhitespace(c));
        }
        catch (IOException e) {
            throw new IOException("Couldn't read integer from file");
        }
        this.tempString = this.tempString.substring(0, this.tempString.length() - 1);
        return Integer.parseInt(this.tempString);
    }

    private float parseFloat(int digits) throws IOException {
        if (digits > 1024) {
            throw new IOException("Attempt to read more than 1024 bytes from file");
        }
        try {
            this.in.read(this.array, 0, digits);
        }
        catch (IOException e) {
            throw new IOException("Couldn't read integer from file");
        }
        this.pos += digits;
        return this.translateReal(new String(this.array, 0, digits).trim());
    }

    private float translateReal(String real) {
        int plus = real.indexOf(43);
        if (plus <= 0) {
            return 0.0f;
        }
        int exp = Integer.parseInt(real.substring(plus + 1, plus + 3));
        this.tempString = real.charAt(0) != '-' ? real.charAt(0) + real.substring(2, exp + 2) + "." + real.substring(exp + 2, plus - 1) : real.substring(0, 2) + real.substring(3, exp + 3) + "." + real.substring(exp + 2, plus - 1);
        return Float.parseFloat(this.tempString);
    }

    private RealTuple parseCoordinate() throws IOException, VisADException {
        if (this.referenceSystem == 0) {
            float lon = this.parseFloat(24);
            return new LatLonTuple(this.parseFloat(24), lon);
        }
        if (this.referenceSystem == 1) {
            return new UTMCoordinate(this.parseFloat(24), this.parseFloat(24), this.zone);
        }
        throw new VisADException("Can't handle referenceSystem " + this.referenceSystem);
    }

    private String printElement(String title, Object value) {
        return UsgsDemAdapter.padRight(title, 30) + ": " + value + "\n";
    }

    private String printElement(String title, int value) {
        return this.printElement(title, new Integer(value));
    }

    private String printElement(String title, float value) {
        return this.printElement(title, new Float(value));
    }

    public static String padRight(Object obj, int i) {
        char filler = ' ';
        String s = new String(obj.toString());
        int j = s.length();
        StringBuffer buf = new StringBuffer(s);
        int k = 0;
        while (k < i - j) {
            buf.append(filler);
            ++k;
        }
        return buf.toString();
    }

    private Linear2DSet makeDomainSet() throws VisADException {
        RealTupleType rtt = null;
        Unit[] units = null;
        switch (this.groundMeasure) {
            case 0: {
                units = new Unit[]{measureUnits[0], measureUnits[0]};
                break;
            }
            case 1: {
                units = new Unit[]{measureUnits[1], measureUnits[1]};
                break;
            }
            case 2: {
                units = new Unit[]{measureUnits[2], measureUnits[2]};
                break;
            }
            case 3: {
                units = new Unit[]{measureUnits[3], measureUnits[3]};
            }
        }
        if (this.referenceSystem == 1) {
            CoordinateSystem cs = null;
            if (this.canDoGeotransform) {
                try {
                    switch (this.horizontalDatum) {
                        case 1: {
                            this.reflectUni.setVar("ellipsoid", this.reflectUni.getVar("UTMCoordinateSystem.CC"));
                            break;
                        }
                        case 2: {
                            this.reflectUni.setVar("ellipsoid", this.reflectUni.getVar("UTMCoordinateSystem.WD"));
                            break;
                        }
                        case 3: {
                            this.reflectUni.setVar("ellipsoid", this.reflectUni.getVar("UTMCoordinateSystem.WE"));
                            break;
                        }
                        case 4: {
                            this.reflectUni.setVar("ellipsoid", this.reflectUni.getVar("UTMCoordinateSystem.RF"));
                            break;
                        }
                        default: {
                            this.reflectUni.setVar("ellipsoid", this.reflectUni.getVar("UTMCoordinateSystem.RF"));
                        }
                    }
                    this.reflectUni.setVar("bounds", new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY));
                    this.reflectUni.setVar("zone", this.zone);
                    this.reflectUni.setVar("north", true);
                    cs = (CoordinateSystem)this.reflectUni.exec("cs = new UTMCoordinateSystem(ellipsoid, zone, north, bounds)");
                    cs = new CachingCoordinateSystem(cs);
                }
                catch (VisADException ve) {
                    System.err.println("ucar.visad.UTMCoordinateSystem not found for UTM->lat/lon conversion" + ve);
                    cs = null;
                }
                rtt = new RealTupleType(EASTING, NORTHING, cs, null);
            }
        } else {
            rtt = RealTupleType.SpatialEarth2DTuple;
        }
        this.domainSet = this.referenceSystem == 1 ? new Linear2DSet(rtt, this.minX, this.minX + this.xResolution * (float)(this.numColumns - 1), this.numColumns, this.minY, this.maxY, (int)(this.yRange / this.yResolution) + 1, null, units, null, true) : new LinearLatLonSet(rtt, this.minX, this.minX + this.xResolution * (float)(this.numColumns - 1), this.numColumns, this.minY, this.minY + this.yResolution * (float)(this.maxRows - 1), this.maxRows, null, units, null, true);
        return this.domainSet;
    }

    private FlatField makeFlatField() throws VisADException {
        this.makeDomainSet();
        float[][] altitudes = new float[1][this.domainSet.getLength()];
        Arrays.fill(altitudes[0], Float.NaN);
        FunctionType ft = new FunctionType(((SetType)this.domainSet.getType()).getDomain(), RealType.Altitude);
        FlatField ff = new FlatField(ft, (Set)this.domainSet, (CoordinateSystem)null, (Set[])null, new Unit[]{measureUnits[this.elevationMeasure]});
        Object coord = null;
        boolean index = false;
        int[] indices = this.domainSet.valueToIndex(new float[][]{this.rawCoords[0], this.rawCoords[1]});
        int i = 0;
        while (i < this.numPoints) {
            altitudes[0][indices[i]] = this.rawCoords[2][i];
            ++i;
        }
        try {
            ff.setSamples(altitudes, false);
        }
        catch (RemoteException re) {
            // empty catch block
        }
        this.data = ff;
        return this.data;
    }

    public FieldImpl getData() throws VisADException {
        return this.data == null ? this.makeFlatField() : this.data;
    }

    public Gridded2DSet getDomain() throws VisADException {
        return this.domainSet == null ? this.makeDomainSet() : this.domainSet;
    }

    static {
        UsgsDemAdapter.measureUnits[0] = CommonUnit.radian;
        UsgsDemAdapter.measureUnits[2] = CommonUnit.meter;
        try {
            UsgsDemAdapter.measureUnits[1] = Parser.parse("foot");
            UsgsDemAdapter.measureUnits[3] = Parser.parse("arcseconds");
        }
        catch (Exception e) {}
    }
}

