/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Real;
import visad.RealType;
import visad.SimpleSet;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.AttributeAdapterFactory;
import visad.data.dods.ByteValuator;
import visad.data.dods.Float32Valuator;
import visad.data.dods.Float64Valuator;
import visad.data.dods.Int16Valuator;
import visad.data.dods.Int32Valuator;
import visad.data.dods.UByteValuator;
import visad.data.dods.UInt16Valuator;
import visad.data.dods.UInt32Valuator;
import visad.data.in.OffsetUnpacker;
import visad.data.in.ScaleAndOffsetUnpacker;
import visad.data.in.ScaleUnpacker;
import visad.data.in.ValueRanger;
import visad.data.in.ValueUnpacker;
import visad.data.in.ValueVetter;

public abstract class Valuator {
    protected final ValueVetter vetter;
    protected final ValueUnpacker unpacker;
    protected final ValueRanger ranger;

    protected Valuator(AttributeTable table) throws BadFormException, VisADException, RemoteException {
        this.vetter = Valuator.valueVetter(table);
        this.unpacker = Valuator.valueUnpacker(table);
        this.ranger = Valuator.valueRanger(table);
    }

    public static Valuator valuator(AttributeTable table, int type) throws BadFormException, VisADException, RemoteException {
        Valuator valuator;
        switch (type) {
            case 3: {
                valuator = Valuator.valueRanger(table).getMin() >= 0.0 ? UByteValuator.valuator(table) : ByteValuator.valuator(table);
                break;
            }
            case 8: {
                valuator = Float32Valuator.valuator(table);
                break;
            }
            case 9: {
                valuator = Float64Valuator.valuator(table);
                break;
            }
            case 4: {
                valuator = Int16Valuator.valuator(table);
                break;
            }
            case 6: {
                valuator = Int32Valuator.valuator(table);
                break;
            }
            case 5: {
                valuator = UInt16Valuator.valuator(table);
                break;
            }
            case 7: {
                valuator = UInt32Valuator.valuator(table);
                break;
            }
            default: {
                throw new BadFormException("Valuator.valuator(AttributeTable,int): Unknown variable type: " + type);
            }
        }
        return valuator;
    }

    public abstract SimpleSet getRepresentationalSet(RealType var1) throws VisADException;

    public float process(float value) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(value)));
    }

    public float[] process(float[] values) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(values)));
    }

    public double process(double value) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(value)));
    }

    public double[] process(double[] values) {
        return this.ranger.process(this.unpacker.process(this.vetter.process(values)));
    }

    protected static double decode(String name, AttributeTable table, int index) throws BadFormException, VisADException, RemoteException {
        double value = Double.NaN;
        Attribute attr = table.getAttribute(name);
        if (attr != null) {
            DataImpl data = AttributeAdapterFactory.attributeAdapterFactory().attributeAdapter(name, attr).data(false);
            if (data instanceof Real && index == 0) {
                value = ((Real)data).getValue();
            } else if (data instanceof Gridded1DDoubleSet) {
                value = ((Gridded1DSet)data).indexToDouble(new int[]{index})[0][0];
            } else if (data instanceof Gridded1DSet) {
                value = ((Gridded1DSet)data).indexToValue(new int[]{index})[0][0];
            } else {
                System.err.println("ValueProcessor.decode(String,AttributeTable,int): Attribute \"" + name + "\" has non-numeric type: " + attr.getTypeString());
            }
        }
        return value;
    }

    public static ValueVetter valueVetter(AttributeTable table) throws BadFormException, VisADException, RemoteException {
        double fill = Double.NaN;
        double missing = Double.NaN;
        if (table != null) {
            fill = Valuator.decode("_FillValue", table, 0);
            missing = Valuator.decode("missing_value", table, 0);
        }
        return ValueVetter.valueVetter(new double[]{fill, missing});
    }

    public static ValueUnpacker valueUnpacker(AttributeTable table) throws BadFormException, VisADException, RemoteException {
        ValueUnpacker unpacker;
        if (table == null) {
            unpacker = ValueUnpacker.valueUnpacker();
        } else {
            double scale = Valuator.decode("scale_factor", table, 0);
            double offset = Valuator.decode("add_offset", table, 0);
            unpacker = scale == scale && scale != 1.0 && offset == offset && offset != 0.0 ? ScaleAndOffsetUnpacker.scaleAndOffsetUnpacker(scale, offset) : (scale == scale && scale != 1.0 ? ScaleUnpacker.scaleUnpacker(scale) : (offset == offset && offset != 0.0 ? OffsetUnpacker.offsetUnpacker(offset) : ValueUnpacker.valueUnpacker()));
        }
        return unpacker;
    }

    public static ValueRanger valueRanger(AttributeTable table) throws BadFormException, VisADException, RemoteException {
        double lower = Double.NEGATIVE_INFINITY;
        double upper = Double.POSITIVE_INFINITY;
        if (table != null) {
            if (table.getAttribute("valid_range") == null) {
                lower = Valuator.decode("valid_min", table, 0);
                upper = Valuator.decode("valid_max", table, 0);
            } else {
                lower = Valuator.decode("valid_range", table, 0);
                upper = Valuator.decode("valid_range", table, 1);
            }
        }
        return ValueRanger.valueRanger(lower, upper);
    }
}

