/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.data.MetadataReader;
import visad.data.tiff.BitBuffer;
import visad.data.tiff.TiffTools;

public class ZeissForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer,
MetadataReader {
    private static int formCount = 0;
    private static RealTupleType domainTuple;
    private static FunctionType funcRowColPix;
    private static FunctionType funcRowColRGB;
    private String currentId;
    private RandomAccessFile r;
    private int[] dimensions;
    private Linear2DSet pixelSet;
    private int[] offsets;
    private int maxChannels;
    private int[] actualImages;
    private double percent;

    public ZeissForm() {
        super("ZeissForm" + formCount++);
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("ZeissForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("ZeissForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        throw new BadFormException("ZeissForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int blockNumber) throws BadFormException, IOException, VisADException {
        int current;
        int i;
        byte[] byteArray;
        if (id != this.currentId) {
            this.initFile(id);
        }
        Hashtable ifdEntries = TiffTools.getIFDHash(this.r, this.actualImages[blockNumber]);
        Vector entryData = (Vector)ifdEntries.get(new Integer(273));
        int stripOffsetCount = (Integer)entryData.get(1);
        int stripOffsets = (Integer)entryData.get(2);
        entryData = (Vector)ifdEntries.get(new Integer(279));
        int stripBytes = (Integer)entryData.get(2);
        int[][] stripInfo = new int[stripOffsetCount][2];
        int total = 0;
        if (stripOffsetCount == 1) {
            stripInfo[0][0] = stripOffsets;
            stripInfo[0][1] = stripBytes;
            total = stripBytes;
        } else {
            this.r.seek(stripOffsets);
            byteArray = new byte[4];
            int i2 = 0;
            while (i2 < stripOffsetCount) {
                this.r.read(byteArray);
                stripInfo[i2][0] = ZeissForm.batoi(byteArray);
                ++i2;
            }
            this.r.seek(stripBytes);
            i = 0;
            while (i < stripOffsetCount) {
                this.r.read(byteArray);
                stripInfo[i][1] = current = ZeissForm.batoi(byteArray);
                total += current;
                ++i;
            }
        }
        byte[] imageData = new byte[total];
        current = 0;
        i = 0;
        while (i < stripOffsetCount) {
            this.r.seek(stripInfo[i][0]);
            byteArray = new byte[stripInfo[i][1]];
            this.r.read(byteArray);
            if (TiffTools.getIFDValue(ifdEntries, 259) == 5) {
                byteArray = TiffTools.lzwUncompress(byteArray);
            }
            System.arraycopy(byteArray, 0, imageData, current, byteArray.length);
            current += byteArray.length;
            ++i;
        }
        entryData = (Vector)ifdEntries.get(new Integer(262));
        int photoint = (Integer)entryData.get(2);
        current = 0;
        FlatField frameField = null;
        if (photoint == 2) {
            int[] bitsPerSample = TiffTools.getIFDArray(this.r, (Vector)ifdEntries.get(new Integer(258)));
            BitBuffer bb = new BitBuffer(new ByteArrayInputStream(imageData));
            float[][] flatSamples = new float[bitsPerSample.length][this.dimensions[0] * this.dimensions[1]];
            if (TiffTools.getIFDValue(ifdEntries, 317) == 2) {
                int currentByte = 0;
                int c = 0;
                while (c < bitsPerSample.length) {
                    int y = 0;
                    while (y < this.dimensions[1]) {
                        int currentVal = 0;
                        int x = 0;
                        while (x < this.dimensions[0]) {
                            if (bitsPerSample[c] > 0) {
                                currentVal += imageData[currentByte];
                                if ((currentVal %= 256) < 0) {
                                    currentVal += 256;
                                }
                                flatSamples[c][x + y * this.dimensions[0]] = currentVal;
                                ++currentByte;
                            } else {
                                flatSamples[c][x + y * this.dimensions[0]] = 0.0f;
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++c;
                }
            } else {
                int c = 0;
                while (c < bitsPerSample.length) {
                    int y = 0;
                    while (y < this.dimensions[1]) {
                        int x = 0;
                        while (x < this.dimensions[0]) {
                            flatSamples[c][x + y * this.dimensions[0]] = bb.getBits(bitsPerSample[c]);
                            ++x;
                        }
                        ++y;
                    }
                    ++c;
                }
            }
            frameField = new FlatField(funcRowColRGB, this.pixelSet);
            frameField.setSamples(flatSamples);
        } else if (photoint == 1) {
            int bitsPerSample = TiffTools.getIFDValue(ifdEntries, 258);
            BitBuffer bb = new BitBuffer(new ByteArrayInputStream(imageData));
            float[][] flatSamples = new float[1][this.dimensions[0] * this.dimensions[1]];
            if (TiffTools.getIFDValue(ifdEntries, 317) == 2) {
                int currentByte = 0;
                int y = 0;
                while (y < this.dimensions[1]) {
                    int currentVal = 0;
                    int x = 0;
                    while (x < this.dimensions[0]) {
                        currentVal += imageData[currentByte];
                        if ((currentVal %= 256) < 0) {
                            currentVal += 256;
                        }
                        flatSamples[0][x + y * this.dimensions[0]] = currentVal;
                        ++currentByte;
                        ++x;
                    }
                    ++y;
                }
            } else {
                int y = 0;
                while (y < this.dimensions[1]) {
                    int x = 0;
                    while (x < this.dimensions[0]) {
                        flatSamples[0][x + y * this.dimensions[0]] = bb.getBits(bitsPerSample);
                        ++x;
                    }
                    ++y;
                }
            }
            if (this.maxChannels == 1) {
                frameField = new FlatField(funcRowColPix, this.pixelSet);
                frameField.setSamples(flatSamples, false);
            } else {
                float[][] flatSamp = new float[3][];
                flatSamp[1] = flatSamp[2] = flatSamples[0];
                flatSamp[0] = flatSamp[2];
                frameField = new FlatField(funcRowColRGB, this.pixelSet);
                frameField.setSamples(flatSamp, false);
            }
        } else {
            throw new BadFormException("Invalid Photometric Interpretation");
        }
        return frameField;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (id != this.currentId) {
            this.initFile(id);
        }
        return this.dimensions[2];
    }

    public void close() {
        try {
            if (this.r == null) {
                return;
            }
            this.r.close();
            this.r = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isThisType(String name) {
        return name.toLowerCase().endsWith(".lsm");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block[0] != 73) {
            return false;
        }
        if (block[1] != 73) {
            return false;
        }
        if (block[2] != 42) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        int ifdlocation = ZeissForm.batoi(new byte[]{block[4], block[5], block[6], block[7]});
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = ZeissForm.batoi(new byte[]{block[ifdlocation], block[ifdlocation + 1]});
        int i = 0;
        while (i < ifdnumber) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return true;
            }
            int ifdtag = ZeissForm.batoi(new byte[]{block[ifdlocation + 2 + i * 12], block[ifdlocation + 3 + i * 12]});
            if (ifdtag == 33412) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"lsm"};
    }

    public double getPercentComplete() {
        return this.percent;
    }

    public Hashtable getMetadata(String id) throws BadFormException, IOException, VisADException {
        if (id != this.currentId) {
            this.initFile(id);
        }
        return new Hashtable();
    }

    public Object getMetadataValue(String id, String field) throws BadFormException, IOException, VisADException {
        Hashtable h = this.getMetadata(id);
        try {
            return h.get(field);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private void initFile(String id) throws IOException, VisADException, BadFormException {
        this.r = new RandomAccessFile(id, "r");
        this.currentId = id;
        this.dimensions = TiffTools.getTIFFDimensions(this.r);
        this.pixelSet = new Linear2DSet((MathType)domainTuple, 0.0, (double)(this.dimensions[0] - 1), this.dimensions[0], this.dimensions[1] - 1, 0.0, this.dimensions[1]);
        Hashtable temp = new Hashtable();
        this.maxChannels = 0;
        this.actualImages = new int[this.dimensions[2]];
        int imageNum = 0;
        int i = 0;
        while (i < this.dimensions[2]) {
            temp = TiffTools.getIFDHash(this.r, i);
            if (TiffTools.getIFDValue(temp, 254) == 0) {
                this.actualImages[imageNum] = i;
                ++imageNum;
            }
            int[] tempArray = TiffTools.getIFDArray(this.r, (Vector)temp.get(new Integer(258)));
            int comp = TiffTools.getIFDValue(temp, 259);
            if (comp != 1) {
                // empty if block
            }
            if (tempArray.length > this.maxChannels) {
                this.maxChannels = tempArray.length;
            }
            ++i;
        }
        this.dimensions[2] = imageNum;
    }

    private static int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << i * 8;
            ++i;
        }
        return total;
    }

    public static void main(String[] args) throws VisADException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read a Zeiss LSM file, run:");
            System.out.println("  java visad.data.bio.ZeissForm in_file");
            System.exit(2);
        }
        ZeissForm form = new ZeissForm();
        System.out.print("Reading " + args[0] + " metadata ");
        Hashtable meta = form.getMetadata(args[0]);
        System.out.println("[done]");
        System.out.println();
        Enumeration e = meta.keys();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        Object[] keys = new String[v.size()];
        v.copyInto(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            System.out.println((String)keys[i] + ": " + meta.get(keys[i]));
            ++i;
        }
        System.out.println();
        System.out.print("Reading " + args[0] + " pixel data ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType());
        System.exit(0);
    }

    static {
        try {
            RealType column = RealType.getRealType("ImageElement");
            RealType row = RealType.getRealType("ImageLine");
            domainTuple = new RealTupleType(column, row);
            RealType pixel = RealType.getRealType("intensity");
            funcRowColPix = new FunctionType(domainTuple, pixel);
            RealType red = RealType.getRealType("Red");
            RealType green = RealType.getRealType("Green");
            RealType blue = RealType.getRealType("Blue");
            RealType[] rgb = new RealType[]{red, green, blue};
            RealTupleType rgbPixelData = new RealTupleType(rgb);
            funcRowColRGB = new FunctionType(domainTuple, rgbPixelData);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
    }
}

