/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;

public class ZVIForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer {
    private static final byte[] ZVI_SIG = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private static final byte[] ZVI_MAGIC_BLOCK_1 = new byte[]{65, 0, 16};
    private static final byte[] ZVI_MAGIC_BLOCK_2 = new byte[]{65, 0, -128};
    private static final byte[] ZVI_MAGIC_BLOCK_3 = new byte[]{32, 0, 16};
    private static final int BUFFER_SIZE = 8192;
    private static final String WHINING = "Sorry, ZVI support is still preliminary. It will be improved as time permits.";
    private static final boolean DEBUG = false;
    private static int formCount = 0;
    private String currentId;
    private RandomAccessFile in;
    private Vector blockList;
    private double percent;

    public ZVIForm() {
        super("ZVIForm" + formCount++);
    }

    public void save(String id, Data data, boolean replace) throws UnimplementedException {
        throw new UnimplementedException("ZVIForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("ZVIForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        throw new BadFormException("ZVIForm.open(URL)");
    }

    public DataImpl open(String id, int blockNumber) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        if (blockNumber < 0 || blockNumber >= this.blockList.size()) {
            throw new BadFormException("Invalid image number: " + blockNumber);
        }
        ZVIBlock zviBlock = (ZVIBlock)this.blockList.elementAt(blockNumber);
        return zviBlock.readImage(this.in);
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.blockList.size();
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.currentId == null) {
            return;
        }
        this.in.close();
        this.currentId = null;
        this.in = null;
    }

    public boolean isThisType(String name) {
        return name.toLowerCase().endsWith(".zvi");
    }

    public boolean isThisType(byte[] block) {
        if (block == null) {
            return false;
        }
        int len = block.length < ZVI_SIG.length ? block.length : ZVI_SIG.length;
        int i = 0;
        while (i < len) {
            if (block[i] != ZVI_SIG[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"zvi"};
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private static int batoi(byte[] b) {
        int len = b.length > 4 ? 4 : b.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            int q = b[i] < 0 ? b[i] + 256 : b[i];
            int shift = 8 * i;
            total += q << shift;
            ++i;
        }
        return total;
    }

    private static int readInt(RandomAccessFile fin) throws IOException {
        byte[] b = new byte[4];
        fin.readFully(b);
        return ZVIForm.batoi(b);
    }

    private static long findBlock(RandomAccessFile in, byte[] block, long start) throws IOException {
        int len;
        long filePos = start;
        long fileSize = in.length();
        byte[] buf = new byte[8192];
        long spot = -1L;
        int step = 0;
        boolean found = false;
        in.seek(start);
        while ((len = (int)(fileSize - filePos)) >= 0) {
            if (len > buf.length) {
                len = buf.length;
            }
            in.readFully(buf, 0, len);
            int i = 0;
            while (i < len) {
                if (buf[i] == block[step]) {
                    if (step == 0) {
                        spot = filePos + (long)i;
                    }
                    if (++step == block.length) {
                        found = true;
                        break;
                    }
                } else {
                    spot = -1L;
                    step = 0;
                }
                ++i;
            }
            if (found || len < buf.length) break;
            filePos += (long)len;
        }
        if (spot >= 0L) {
            in.seek(spot + (long)block.length);
        }
        return spot;
    }

    private void initFile(String id) throws IOException, VisADException {
        long header;
        this.close();
        this.currentId = id;
        this.in = new RandomAccessFile(id, "r");
        long pos = 0L;
        this.blockList = new Vector();
        int numZ = 0;
        int numC = 0;
        int numT = 0;
        while ((header = ZVIForm.findBlock(this.in, ZVI_MAGIC_BLOCK_1, pos)) >= 0L) {
            pos = header + (long)ZVI_MAGIC_BLOCK_1.length;
            this.in.skipBytes(19);
            pos += 19L;
            byte[] b = new byte[ZVI_MAGIC_BLOCK_2.length];
            this.in.readFully(b);
            boolean ok = true;
            int i = 0;
            while (i < b.length) {
                if (b[i] != ZVI_MAGIC_BLOCK_2[i]) {
                    ok = false;
                    break;
                }
                ++pos;
                ++i;
            }
            if (!ok) continue;
            b = new byte[11];
            this.in.readFully(b);
            int i2 = 0;
            while (i2 < b.length) {
                if (b[i2] != 0) {
                    ok = false;
                    break;
                }
                ++pos;
                ++i2;
            }
            if (!ok) continue;
            int theZ = ZVIForm.readInt(this.in);
            int theC = ZVIForm.readInt(this.in);
            int theT = ZVIForm.readInt(this.in);
            pos += 12L;
            b = new byte[108];
            this.in.readFully(b);
            int i3 = 0;
            while (i3 < b.length) {
                if (b[i3] != 0) {
                    ok = false;
                    break;
                }
                ++pos;
                ++i3;
            }
            if (!ok) continue;
            long magic3 = ZVIForm.findBlock(this.in, ZVI_MAGIC_BLOCK_3, pos);
            if (magic3 < 0L) {
                throw new BadFormException("Error parsing image header. Sorry, ZVI support is still preliminary. It will be improved as time permits.");
            }
            pos = magic3 + (long)ZVI_MAGIC_BLOCK_3.length;
            int width = ZVIForm.readInt(this.in);
            int height = ZVIForm.readInt(this.in);
            int alwaysOne = ZVIForm.readInt(this.in);
            int bytesPerPixel = ZVIForm.readInt(this.in);
            int pixelType = ZVIForm.readInt(this.in);
            int bitDepth = ZVIForm.readInt(this.in);
            ZVIBlock zviBlock = new ZVIBlock(theZ, theC, theT, width, height, alwaysOne, bytesPerPixel, pixelType, bitDepth, pos += 24L);
            if (theZ >= numZ) {
                numZ = theZ + 1;
            }
            if (theC >= numC) {
                numC = theC + 1;
            }
            if (theT >= numT) {
                numT = theT + 1;
            }
            this.blockList.add(zviBlock);
            pos += (long)(width * height * bytesPerPixel);
        }
        if (this.blockList.isEmpty()) {
            throw new BadFormException("No image data found. Sorry, ZVI support is still preliminary. It will be improved as time permits.");
        }
        if (numZ * numC * numT != this.blockList.size()) {
            System.err.println("Warning: image counts do not match. Sorry, ZVI support is still preliminary. It will be improved as time permits.");
        }
    }

    public static void main(String[] args) throws VisADException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read a Zeiss ZVI file, run:");
            System.out.println("  java visad.data.bio.ZVIForm in_file");
            System.exit(2);
        }
        ZVIForm form = new ZVIForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType());
        System.exit(0);
    }

    private class ZVIBlock {
        private int theZ;
        private int theC;
        private int theT;
        private int width;
        private int height;
        private int alwaysOne;
        private int bytesPerPixel;
        private int pixelType;
        private int bitDepth;
        private long imagePos;
        private int numPixels;
        private int imageSize;
        private int numChannels;
        private int bytesPerChannel;

        public ZVIBlock(int theZ, int theC, int theT, int width, int height, int alwaysOne, int bytesPerPixel, int pixelType, int bitDepth, long imagePos) {
            this.theZ = theZ;
            this.theC = theC;
            this.theT = theT;
            this.width = width;
            this.height = height;
            this.alwaysOne = alwaysOne;
            this.bytesPerPixel = bytesPerPixel;
            this.pixelType = pixelType;
            this.bitDepth = bitDepth;
            this.imagePos = imagePos;
            this.numPixels = width * height;
            this.imageSize = this.numPixels * bytesPerPixel;
            int n = this.numChannels = pixelType == 1 ? 3 : 1;
            if (bytesPerPixel % this.numChannels != 0) {
                System.err.println("Warning: incompatible bytesPerPixel (" + bytesPerPixel + ") and numChannels (" + this.numChannels + "). Assuming grayscale data. " + ZVIForm.WHINING);
                this.numChannels = 1;
            }
            this.bytesPerChannel = bytesPerPixel / this.numChannels;
        }

        public FlatField readImage(RandomAccessFile in) throws IOException, VisADException {
            RealType[] rtypes;
            long fileSize = in.length();
            if (this.imagePos + (long)this.imageSize > fileSize) {
                throw new BadFormException("File is not big enough to contain the pixels (width=" + this.width + "; height=" + this.height + "; bytesPerPixel=" + this.bytesPerPixel + "; imagePos=" + this.imagePos + "; fileSize=" + fileSize + "). " + ZVIForm.WHINING);
            }
            byte[] imageBytes = new byte[this.imageSize];
            in.seek(this.imagePos);
            in.readFully(imageBytes);
            int index = 0;
            float[][] samples = new float[this.numChannels][this.numPixels];
            int i = 0;
            while (i < this.numPixels) {
                int c = this.numChannels - 1;
                while (c >= 0) {
                    byte[] b = new byte[this.bytesPerChannel];
                    System.arraycopy(imageBytes, index, b, 0, this.bytesPerChannel);
                    index += this.bytesPerChannel;
                    samples[c][i] = ZVIForm.batoi(b);
                    --c;
                }
                ++i;
            }
            RealType xtype = RealType.getRealType("ImageElement");
            RealType ytype = RealType.getRealType("ImageLine");
            RealTupleType xy = new RealTupleType(xtype, ytype);
            if (this.numChannels == 1) {
                rtypes = new RealType[]{RealType.getRealType("value")};
            } else if (this.numChannels == 3) {
                rtypes = new RealType[]{RealType.getRealType("Red"), RealType.getRealType("Green"), RealType.getRealType("Blue")};
            } else {
                rtypes = new RealType[this.numChannels];
                int i2 = 0;
                while (i2 < this.numChannels) {
                    rtypes[i2] = RealType.getRealType("value" + (i2 + 1));
                    ++i2;
                }
            }
            RealTupleType range = new RealTupleType(rtypes);
            FunctionType ftype = new FunctionType(xy, range);
            Integer2DSet fset = new Integer2DSet((MathType)xy, this.width, this.height);
            FlatField ff = new FlatField(ftype, fset);
            ff.setSamples(samples, false);
            return ff;
        }

        public String toString() {
            return "Image header block:\n  theZ = " + this.theZ + "\n" + "  theC = " + this.theC + "\n" + "  theT = " + this.theT + "\n" + "  width = " + this.width + "\n" + "  height = " + this.height + "\n" + "  alwaysOne = " + this.alwaysOne + "\n" + "  bytesPerPixel = " + this.bytesPerPixel + "\n" + "  pixelType = " + this.pixelType + "\n" + "  bitDepth = " + this.bitDepth;
        }
    }
}

