/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.data.qt.QTForm;

public class OpenlabForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer {
    private static int formCount = 0;
    private static RealTupleType domainTuple;
    private static FunctionType funcRowColPix;
    private static FunctionType funcRowColRGB;
    private String currentId;
    private RandomAccessFile r;
    private int numBlocks;
    private int[] offsets;
    private int[] imageType;
    private boolean isColor;
    private double percent;

    public OpenlabForm() {
        super("OpenlabForm" + formCount++);
    }

    public boolean isThisType(String name) {
        long len = new File(name).length();
        int count = len < 16384L ? (int)len : 16384;
        byte[] buf = new byte[count];
        try {
            FileInputStream fin = new FileInputStream(name);
            int read = 0;
            while (read < count) {
                read += fin.read(buf, read, count - read);
            }
            fin.close();
            return this.isThisType(buf);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 0 && block[1] == 0 && block[2] == -1 && block[3] == -1 && block[4] == 105 && block[5] == 109 && block[6] == 112 && block[7] == 114;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"liff", "lif"};
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("OpenlabForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("OpenlabForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = Double.NaN;
        return data;
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        throw new BadFormException("OpenlabForm.open(URL)");
    }

    public synchronized DataImpl open(String id, int blockNumber) throws BadFormException, IOException, VisADException {
        if (id != this.currentId) {
            this.initFile(id);
        }
        this.r.seek(this.offsets[blockNumber] + 12);
        byte[] toRead = new byte[4];
        this.r.read(toRead);
        int blockSize = OpenlabForm.batoi(toRead);
        toRead = new byte[1];
        this.r.read(toRead);
        if (toRead[0] == 1) {
            this.r.skipBytes(128);
        }
        this.r.skipBytes(169);
        toRead = new byte[blockSize];
        int read = 0;
        int left = blockSize;
        while (left > 0) {
            int i = this.r.read(toRead, read, left);
            read += i;
            left -= i;
        }
        byte[] pixelData = new byte[blockSize];
        int pixPos = 0;
        Dimension dim = QTForm.getPictDimensions(toRead);
        int length = toRead.length;
        int totalBlocks = -1;
        int expectedBlock = 0;
        int pos = 0;
        int imagePos = 0;
        int imagesize = dim.width * dim.height;
        float[][] flatSamples = new float[1][imagesize];
        Linear2DSet pixelSet = new Linear2DSet((MathType)domainTuple, 0.0, (double)(dim.width - 1), dim.width, dim.height - 1, 0.0, dim.height);
        FlatField frameField = new FlatField(funcRowColPix, pixelSet);
        while (expectedBlock != totalBlocks) {
            byte[] temp;
            int num;
            boolean skipflag = false;
            while (pos + 7 < length && (toRead[pos] != 73 || toRead[pos + 1] != 86 || toRead[pos + 2] != 69 || toRead[pos + 3] != 65 || toRead[pos + 4] != 100 || toRead[pos + 5] != 98 || toRead[pos + 6] != 112 || toRead[pos + 7] != 113)) {
                ++pos;
            }
            if (pos + 32 > length) {
                if (expectedBlock == 0 && this.imageType[blockNumber] < 9) {
                    try {
                        return QTForm.pictToField(toRead);
                    }
                    catch (Exception e) {
                        throw new BadFormException("No iPic comment block found");
                    }
                }
                throw new BadFormException("Expected iPic comment block not found");
            }
            if ((num = OpenlabForm.batoi(temp = new byte[]{toRead[pos += 8], toRead[pos + 1], toRead[pos + 2], toRead[pos + 3]})) != expectedBlock) {
                throw new BadFormException("Expected iPic block not found");
            }
            ++expectedBlock;
            temp = new byte[]{toRead[pos + 4], toRead[pos + 5], toRead[pos + 6], toRead[pos + 7]};
            if (totalBlocks == -1) {
                totalBlocks = OpenlabForm.batoi(temp);
            } else if (OpenlabForm.batoi(temp) != totalBlocks) {
                throw new BadFormException("Unexpected totalBlocks number read");
            }
            temp = new byte[]{toRead[pos += 16], toRead[pos + 1], toRead[pos + 2], toRead[pos + 3]};
            int size = OpenlabForm.batoi(temp);
            int blockEnd = (pos += 8) + size;
            System.arraycopy(toRead, pos, pixelData, pixPos, size);
            pixPos += size;
        }
        int pixelValue = 0;
        pos = 0;
        while (true) {
            if (pos + 1 >= pixelData.length) {
                throw new BadFormException("Malformed LIFF data");
            }
            pixelValue = pixelData[pos] < 0 ? 256 + pixelData[pos] : pixelData[pos] << 8;
            flatSamples[0][imagePos] = pixelValue += pixelData[pos + 1] < 0 ? 256 + pixelData[pos + 1] : pixelData[pos + 1];
            if (++imagePos == imagesize) {
                if (this.isColor) {
                    float[][] flatSamp = new float[3][];
                    flatSamp[1] = flatSamp[2] = flatSamples[0];
                    flatSamp[0] = flatSamp[2];
                    frameField = new FlatField(funcRowColRGB, pixelSet);
                    frameField.setSamples(flatSamp, false);
                    return frameField;
                }
                frameField = new FlatField(funcRowColPix, pixelSet);
                frameField.setSamples(flatSamples, false);
                return frameField;
            }
            pos += 2;
        }
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (id != this.currentId) {
            this.initFile(id);
        }
        return this.numBlocks;
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private static int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << (len - 1 - i) * 8;
            ++i;
        }
        return total;
    }

    private void initFile(String id) throws IOException, VisADException, BadFormException {
        this.r = new RandomAccessFile(id, "r");
        this.currentId = id;
        this.isColor = false;
        byte[] toRead = new byte[4];
        Vector<Integer> v = new Vector<Integer>();
        this.r.seek(16L);
        this.r.read(toRead);
        int nextOffset = OpenlabForm.batoi(toRead);
        while (nextOffset != 0) {
            this.r.seek(nextOffset + 4);
            this.r.read(toRead);
            int nextOffsetTemp = OpenlabForm.batoi(toRead);
            this.r.read(toRead);
            if (new String(toRead).equals("PICT")) {
                v.add(new Integer(nextOffset));
            }
            if (nextOffset == nextOffsetTemp) break;
            nextOffset = nextOffsetTemp;
        }
        this.numBlocks = v.size();
        this.offsets = new int[this.numBlocks];
        int i = 0;
        while (i < this.numBlocks) {
            this.offsets[i] = (Integer)v.get(i);
            ++i;
        }
        toRead = new byte[2];
        this.imageType = new int[this.numBlocks];
        int i2 = 0;
        while (i2 < this.numBlocks) {
            this.r.seek(this.offsets[i2]);
            this.r.skipBytes(40);
            this.r.read(toRead);
            this.imageType[i2] = OpenlabForm.batoi(toRead);
            if (this.imageType[i2] < 9) {
                this.isColor = true;
            }
            ++i2;
        }
    }

    public static void main(String[] args) throws VisADException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read an Openlab LIFF file, run:");
            System.out.println("  java visad.data.bio.OpenlabForm in_file");
            System.exit(2);
        }
        OpenlabForm form = new OpenlabForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType());
        System.exit(0);
    }

    static {
        try {
            RealType column = RealType.getRealType("ImageElement");
            RealType row = RealType.getRealType("ImageLine");
            domainTuple = new RealTupleType(column, row);
            RealType pixel = RealType.getRealType("intensity");
            funcRowColPix = new FunctionType(domainTuple, pixel);
            RealType red = RealType.getRealType("Red");
            RealType green = RealType.getRealType("Green");
            RealType blue = RealType.getRealType("Blue");
            RealType[] rgb = new RealType[]{red, green, blue};
            RealTupleType rgbPixelData = new RealTupleType(rgb);
            funcRowColRGB = new FunctionType(domainTuple, rgbPixelData);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
    }
}

