/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;

public class FluoviewTiffForm
extends Form
implements FormBlockReader,
FormFileInformer,
FormProgressInformer {
    private static final int BLOCK_CHECK_LEN = 16384;
    private static final int TIFF_MAGIC_NUMBER = 42;
    private static final String FLUOVIEW_MAGIC_STRING = "fluoview";
    private static final int IMPOSSIBLE_IFD = 424242;
    private static int formCount = 0;
    private static RealTupleType domainTuple;
    private static FunctionType funcRowColPix;
    private String currentId;
    private RandomAccessFile readIn;
    private int numBlocks;
    private Linear2DSet pixelSet;
    private double percent;

    public FluoviewTiffForm() {
        super("FluoviewTiffForm" + formCount++);
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("FluoviewTiffForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("FluoviewTiffForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType index = RealType.getRealType("index");
            FunctionType indexFunction = new FunctionType(index, fields[0].getType());
            Integer1DSet indexSet = new Integer1DSet(nImages);
            FieldImpl indexField = new FieldImpl(indexFunction, indexSet);
            indexField.setSamples(fields, false);
            data = indexField;
        }
        this.close();
        this.percent = Double.NaN;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new UnimplementedException("FluoviewTiffForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int blockNumber) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        FlatField frameField = new FlatField(funcRowColPix, this.pixelSet);
        float[][] samples = new float[][]{this.getFrame(blockNumber + 1)};
        frameField.setSamples(samples);
        return frameField;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.currentId)) {
            this.initFile(id);
        }
        return this.numBlocks;
    }

    public void close() {
        try {
            this.readIn.close();
        }
        catch (Exception e) {}
    }

    public boolean isThisType(String name) {
        if (!name.toLowerCase().endsWith(".tif") && !name.toLowerCase().endsWith(".tiff")) {
            return false;
        }
        long len = new File(name).length();
        int size = len < 16384L ? (int)len : 16384;
        byte[] buf = new byte[size];
        try {
            FileInputStream fin = new FileInputStream(name);
            int r = 0;
            while (r < size) {
                r += fin.read(buf, r, size - r);
            }
            fin.close();
            return this.isThisType(buf);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3 || block[2] != 42) {
            return false;
        }
        String test = new String(block);
        return (test = test.toLowerCase()).indexOf(FLUOVIEW_MAGIC_STRING) != -1;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"tif", "tiff"};
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private static int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << i * 8;
            ++i;
        }
        return total;
    }

    private void initFile(String id) throws IOException, VisADException, BadFormException {
        this.readIn = new RandomAccessFile(id, "r");
        this.currentId = id;
        int[] dimensions = this.getFTIFFDimensions();
        this.numBlocks = dimensions[2];
        this.pixelSet = new Linear2DSet((MathType)domainTuple, 0.0, (double)(dimensions[0] - 1), dimensions[0], dimensions[1] - 1, 0.0, dimensions[1]);
    }

    private Hashtable getIFDHash(int framecount) throws IOException {
        int numEntries;
        byte[] byteArray = new byte[4];
        this.readIn.seek(4L);
        this.readIn.read(byteArray);
        int nextOffset = FluoviewTiffForm.batoi(byteArray);
        Hashtable<Integer, Serializable> ifdEntries = new Hashtable<Integer, Serializable>();
        int frames = 1;
        while (nextOffset != 0 && frames != framecount) {
            ++frames;
            this.readIn.seek(nextOffset);
            byteArray = new byte[2];
            this.readIn.read(byteArray);
            numEntries = FluoviewTiffForm.batoi(byteArray);
            this.readIn.skipBytes(12 * numEntries);
            byteArray = new byte[4];
            this.readIn.read(byteArray);
            nextOffset = FluoviewTiffForm.batoi(byteArray);
        }
        this.readIn.seek(nextOffset);
        byteArray = new byte[2];
        this.readIn.read(byteArray);
        numEntries = FluoviewTiffForm.batoi(byteArray);
        int i = 0;
        while (i < numEntries) {
            byteArray = new byte[2];
            this.readIn.read(byteArray);
            Integer entrytag = new Integer(FluoviewTiffForm.batoi(byteArray));
            this.readIn.read(byteArray);
            Integer entrytype = new Integer(FluoviewTiffForm.batoi(byteArray));
            byteArray = new byte[4];
            this.readIn.read(byteArray);
            Integer entrycount = new Integer(FluoviewTiffForm.batoi(byteArray));
            this.readIn.read(byteArray);
            Integer entryOffset = new Integer(FluoviewTiffForm.batoi(byteArray));
            Vector<Integer> entryData = new Vector<Integer>();
            entryData.add(entrytype);
            entryData.add(entrycount);
            entryData.add(entryOffset);
            ifdEntries.put(entrytag, entryData);
            ++i;
        }
        this.readIn.read(byteArray);
        nextOffset = FluoviewTiffForm.batoi(byteArray);
        ifdEntries.put(new Integer(424242), new Integer(nextOffset));
        return ifdEntries;
    }

    private int[] getFTIFFDimensions() throws IOException {
        int frames = 1;
        Hashtable ifdEntries = this.getIFDHash(1);
        int nextOffset = (Integer)ifdEntries.get(new Integer(424242));
        while (nextOffset != 0) {
            ++frames;
            try {
                this.readIn.seek(nextOffset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] byteArray = new byte[2];
            this.readIn.read(byteArray);
            int numEntries = FluoviewTiffForm.batoi(byteArray);
            this.readIn.skipBytes(12 * numEntries);
            byteArray = new byte[4];
            this.readIn.read(byteArray);
            nextOffset = FluoviewTiffForm.batoi(byteArray);
        }
        Vector entryData = (Vector)ifdEntries.get(new Integer(256));
        Integer width = (Integer)entryData.get(2);
        entryData = (Vector)ifdEntries.get(new Integer(257));
        Integer length = (Integer)entryData.get(2);
        return new int[]{width, length, frames};
    }

    private float[] getFrame(int framecount) throws IOException {
        int current;
        int i;
        byte[] byteArray;
        Hashtable ifdEntries = this.getIFDHash(framecount);
        Vector entryData = (Vector)ifdEntries.get(new Integer(273));
        int stripOffsetCount = (Integer)entryData.get(1);
        int stripOffsets = (Integer)entryData.get(2);
        entryData = (Vector)ifdEntries.get(new Integer(279));
        int stripBytes = (Integer)entryData.get(2);
        int[][] stripInfo = new int[stripOffsetCount][2];
        int total = 0;
        if (stripOffsetCount == 1) {
            stripInfo[0][0] = stripOffsets;
            stripInfo[0][1] = stripBytes;
            total = stripBytes;
        } else {
            this.readIn.seek(stripOffsets);
            byteArray = new byte[4];
            i = 0;
            while (i < stripOffsetCount) {
                this.readIn.read(byteArray);
                stripInfo[i][0] = FluoviewTiffForm.batoi(byteArray);
                ++i;
            }
            this.readIn.seek(stripBytes);
            int i2 = 0;
            while (i2 < stripOffsetCount) {
                this.readIn.read(byteArray);
                stripInfo[i2][1] = current = FluoviewTiffForm.batoi(byteArray);
                total += current;
                ++i2;
            }
        }
        float[] toReturn = new float[total / 2];
        current = 0;
        i = 0;
        while (i < stripOffsetCount) {
            this.readIn.seek(stripInfo[i][0]);
            byteArray = new byte[stripInfo[i][1]];
            this.readIn.read(byteArray);
            int j = 0;
            while (j < byteArray.length) {
                toReturn[current] = (float)(byteArray[j] < 0 ? 256 + byteArray[j] : byteArray[j]) + (float)((byteArray[j + 1] < 0 ? 256 + byteArray[j + 1] : byteArray[j + 1]) << 8);
                ++current;
                j += 2;
            }
            ++i;
        }
        return toReturn;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1) {
            System.out.println("To test read a Fluoview TIFF file, run:");
            System.out.println("  java visad.data.bio.FluoviewTiffForm in_file");
            System.exit(2);
        }
        FluoviewTiffForm form = new FluoviewTiffForm();
        System.out.print("Reading " + args[0] + " ");
        DataImpl data = form.open(args[0]);
        System.out.println("[done]");
        System.out.println("MathType =\n" + data.getType());
        System.exit(0);
    }

    static {
        try {
            RealType column = RealType.getRealType("ImageElement");
            RealType row = RealType.getRealType("ImageLine");
            domainTuple = new RealTupleType(column, row);
            RealType pixel = RealType.getRealType("intensity");
            funcRowColPix = new FunctionType(domainTuple, pixel);
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
    }
}

