/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.DataOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Data;
import visad.DataImpl;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SI;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.bio.BioRadForm;

public class BioRadNote {
    public static final Unit MICRON = SI.meter.pow(-6);
    public static final Unit SECOND = SI.second;
    public static final int NO_INFORMATION = 0;
    public static final int METADATA = 1;
    public static final int HORIZ_UNIT = 2;
    public static final int VERT_UNIT = 3;
    public static final int INVALID_NOTE = -1;
    public static final int NOTE_TYPE_LIVE = 1;
    public static final int NOTE_TYPE_FILE1 = 2;
    public static final int NOTE_TYPE_NUMBER = 3;
    public static final int NOTE_TYPE_USER = 4;
    public static final int NOTE_TYPE_LINE = 5;
    public static final int NOTE_TYPE_COLLECT = 6;
    public static final int NOTE_TYPE_FILE2 = 7;
    public static final int NOTE_TYPE_SCALEBAR = 8;
    public static final int NOTE_TYPE_MERGE = 9;
    public static final int NOTE_TYPE_THRUVIEW = 10;
    public static final int NOTE_TYPE_ARROW = 11;
    public static final int NOTE_TYPE_VARIABLE = 20;
    public static final int NOTE_TYPE_STRUCTURE = 21;
    public static final String[] NOTE_NAMES = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE"};
    public static final int NOTE_STATUS_ALL = 256;
    public static final int NOTE_STATUS_DISPLAY = 512;
    public static final int NOTE_STATUS_POSITION = 1024;
    public static final int AXT_D = 1;
    public static final int AXT_T = 2;
    public static final int AXT_A = 3;
    public static final int AXT_I = 4;
    public static final int AXT_M4 = 5;
    public static final int AXT_R = 6;
    public static final int AXT_LR = 7;
    public static final int AXT_P = 8;
    public static final int AXT_C = 9;
    public static final int AXT_PHOTON = 10;
    public static final int AXT_RGB = 11;
    public static final int AXT_SEQ = 12;
    public static final int AXT_6D = 13;
    public static final int AXT_TC = 14;
    public static final int AXT_S = 15;
    public static final int AXT_LS = 16;
    public static final int AXT_MASK = 255;
    public static final int AXT_XY = 256;
    public static final int AXT_WORD = 512;
    public static final RealType RT_LEVEL = RealType.getRealType("biorad_level");
    public static final RealType RT_NUM = RealType.getRealType("biorad_num");
    public static final RealType RT_STATUS = RealType.getRealType("biorad_status");
    public static final RealType RT_TYPE = RealType.getRealType("biorad_type");
    public static final RealType RT_X = RealType.getRealType("biorad_x");
    public static final RealType RT_Y = RealType.getRealType("biorad_y");
    public static final TextType TT_TEXT = TextType.getTextType("biorad_text");
    public static final TupleType NOTE_TUPLE = BioRadNote.makeNoteTuple();
    protected int level;
    protected int num;
    protected int status;
    protected int type;
    protected int x;
    protected int y;
    protected String text;
    protected Data metadata;
    protected double origin;
    protected double step;
    protected boolean time;

    protected static TupleType makeNoteTuple() {
        try {
            if (RT_LEVEL == null) {
                System.out.println("level is null");
            }
            if (RT_NUM == null) {
                System.out.println("num is null");
            }
            if (RT_STATUS == null) {
                System.out.println("status is null");
            }
            if (RT_TYPE == null) {
                System.out.println("type is null");
            }
            if (RT_X == null) {
                System.out.println("x is null");
            }
            if (RT_Y == null) {
                System.out.println("y is null");
            }
            if (TT_TEXT == null) {
                System.out.println("text is null");
            }
            return new TupleType(new MathType[]{RT_LEVEL, RT_NUM, RT_STATUS, RT_TYPE, RT_X, RT_Y, TT_TEXT});
        }
        catch (VisADException exc) {
            return null;
        }
    }

    public BioRadNote(int level, int num, int status, int type, int x, int y, String text) {
        this.level = level;
        this.num = num;
        this.status = status;
        this.type = type;
        this.x = x;
        this.y = y;
        this.text = text;
    }

    public DataImpl getNoteData() {
        try {
            Data[] d = new DataImpl[]{new Real(RT_LEVEL, (double)this.level), new Real(RT_NUM, (double)this.num), new Real(RT_STATUS, (double)this.status), new Real(RT_TYPE, (double)this.type), new Real(RT_X, (double)this.x), new Real(RT_Y, (double)this.y), new Text(TT_TEXT, this.text)};
            return new Tuple(NOTE_TUPLE, d, false);
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {
        }
        return null;
    }

    public boolean hasUnitInfo() {
        int sp;
        if (this.type == 20 && (sp = this.text.indexOf(" ")) >= 0) {
            String v = this.text.substring(0, sp).trim();
            String value = this.text.substring(sp + 1).trim();
            if (v.equals("AXIS_2") || v.equals("AXIS_3")) {
                return true;
            }
        }
        return false;
    }

    public int analyze() {
        if (this.type == 8) {
            StringTokenizer st = new StringTokenizer(this.text);
            if (st.countTokens() != 4) {
                this.warn();
                return -1;
            }
            String v = st.nextToken();
            String eq = st.nextToken();
            int length = -1;
            int angle = -1;
            try {
                length = Integer.parseInt(st.nextToken());
                angle = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (!v.equals("SCALEBAR") || !eq.equals("=") || length < 0 || angle < 0) {
                this.warn();
                return -1;
            }
            return 0;
        }
        if (this.type == 10) {
            return -1;
        }
        if (this.type == 11) {
            StringTokenizer st = new StringTokenizer(this.text);
            if (st.countTokens() != 6) {
                this.warn();
                return -1;
            }
            String v = st.nextToken();
            String eq = st.nextToken();
            int lx = -1;
            int ly = -1;
            int angle = -1;
            try {
                lx = Integer.parseInt(st.nextToken());
                ly = Integer.parseInt(st.nextToken());
                angle = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            String fillType = st.nextToken();
            if (!v.equals("ARROW") || !eq.equals("=") || lx < 0 || ly < 0 || angle < 0 || !fillType.equals("Fill") && !fillType.equals("Outline")) {
                this.warn(v);
                return -1;
            }
            return 0;
        }
        if (this.type == 20) {
            int sp = this.text.indexOf(" ");
            if (sp < 0) {
                this.warn();
                return -1;
            }
            String v = this.text.substring(0, sp).trim();
            String value = this.text.substring(sp + 1).trim();
            if (v.equals("SCALE_FACTOR") || v.equals("LENS_MAGNIFICATION") || v.equals("RAMP_GAMMA1") || v.equals("RAMP_GAMMA2") || v.equals("RAMP_GAMMA3") || v.equals("RAMP1_MIN") || v.equals("RAMP2_MIN") || v.equals("RAMP3_MIN") || v.equals("RAMP1_MAX") || v.equals("RAMP2_MAX") || v.equals("RAMP3_MAX") || v.equals("PIC_FF_VERSION") || v.equals("Z_CORRECT_FACTOR") || v.equals("AXIS_0") || v.equals("AXIS_1") || v.equals("AXIS_4") || v.equals("AXIS_5") || v.equals("AXIS_6") || v.equals("AXIS_7") || v.equals("AXIS_8") || v.equals("AXIS_9") || v.equals("AXIS_21")) {
                double dv;
                try {
                    dv = Double.parseDouble(value);
                }
                catch (NumberFormatException exc) {
                    this.warn();
                    return -1;
                }
                this.metadata = new Real(RealType.getRealType(v), dv);
                return 1;
            }
            if (v.equals("AXIS_2")) {
                StringTokenizer st = new StringTokenizer(value);
                if (st.countTokens() != 4) {
                    this.warn(v);
                    return -1;
                }
                int ntype = -1;
                int norigin = -1;
                int inc = -1;
                try {
                    ntype = Integer.parseInt(st.nextToken());
                    norigin = Integer.parseInt(st.nextToken());
                    inc = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (ntype < 0 || norigin < 0 || inc < 0) {
                    this.warn(v);
                    return -1;
                }
                String label = st.nextToken();
                if (ntype != 1) {
                    this.warn(v);
                    return -1;
                }
                this.origin = norigin;
                this.step = inc;
                this.time = false;
                return 2;
            }
            if (v.equals("AXIS_3")) {
                StringTokenizer st = new StringTokenizer(value);
                if (st.countTokens() != 4) {
                    this.warn(v);
                    return -1;
                }
                int ntype = -1;
                int norigin = -1;
                int inc = -1;
                try {
                    ntype = Integer.parseInt(st.nextToken());
                    norigin = Integer.parseInt(st.nextToken());
                    inc = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (ntype < 0 || norigin < 0 || inc < 0) {
                    this.warn(v);
                    return -1;
                }
                String label = st.nextToken();
                if (this.type == 1) {
                    this.origin = norigin;
                    this.step = inc;
                    this.time = false;
                    return 3;
                }
                if (this.type == 2) {
                    this.origin = norigin;
                    this.step = inc;
                    this.time = true;
                    return 3;
                }
                this.warn();
                return -1;
            }
            this.warn(v);
            return -1;
        }
        if (this.type == 21) {
            return 0;
        }
        return 0;
    }

    public Data getMetadata() {
        return this.metadata;
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getStep() {
        return this.step;
    }

    public boolean getTime() {
        return this.time;
    }

    public void write(DataOutputStream out, boolean more) throws IOException {
        BioRadForm.writeShort(out, this.level);
        BioRadForm.writeInt(out, more ? 1 : 0);
        BioRadForm.writeShort(out, this.num);
        BioRadForm.writeShort(out, this.status);
        BioRadForm.writeShort(out, this.type);
        BioRadForm.writeShort(out, this.x);
        BioRadForm.writeShort(out, this.y);
        BioRadForm.writeString(out, this.text, 80);
    }

    private void warn() {
        this.warn(null);
    }

    private void warn(String subType) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("level=");
        sb.append(this.level);
        sb.append("; num=");
        sb.append(this.num);
        sb.append("; status=");
        boolean first = true;
        if ((this.status & 0x100) != 0) {
            sb.append("NOTE_STATUS_ALL");
            first = false;
        }
        if ((this.status & 0x200) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("NOTE_STATUS_DISPLAY");
            first = false;
        }
        if ((this.status & 0x400) != 0) {
            if (!first) {
                sb.append("|");
            }
            sb.append("NOTE_STATUS_POSITION");
            first = false;
        }
        if (first) {
            sb.append("NONE");
        }
        sb.append("; type=");
        sb.append(NOTE_NAMES[this.type]);
        sb.append("; x=");
        sb.append(this.x);
        sb.append("; y=");
        sb.append(this.y);
        sb.append("; text=");
        sb.append(this.text == null ? "null" : this.text.trim());
        return sb.toString();
    }

    public static BioRadNote getUnitNote(Unit u, Linear1DSet set, boolean xAxis) {
        double ninc;
        double norigin;
        if (u == null || set == null) {
            return null;
        }
        boolean ntime = u.isConvertible(SECOND);
        if (!ntime && !u.isConvertible(MICRON)) {
            return null;
        }
        int axisType = ntime ? 2 : 1;
        try {
            norigin = u.toThat(set.getFirst(), ntime ? SECOND : MICRON);
            ninc = u.toThat(set.getStep(), ntime ? SECOND : MICRON);
        }
        catch (UnitException exc) {
            return null;
        }
        String label = "Calibration unknown";
        int nlevel = 1;
        int nnum = 0;
        int nstatus = 1280;
        int ntype = 20;
        int nx = 0;
        int ny = 0;
        String ntext = "AXIS_" + (xAxis ? "2" : "3") + " " + axisType + " " + norigin + " " + ninc + " " + label;
        return new BioRadNote(nlevel, nnum, nstatus, ntype, nx, ny, ntext);
    }
}

