/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.Set;
import visad.ShadowType;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADGeometryArray;

public class VisADLineStripArray
extends VisADGeometryArray {
    public int[] stripVertexCounts;
    private static final int TEST = 1;
    private static final float LIMIT = 4.0f;
    private static final float ALPHA = 0.1f;

    public static VisADLineStripArray merge(VisADLineStripArray[] arrays) throws VisADException {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        VisADLineStripArray array = new VisADLineStripArray();
        VisADGeometryArray.merge(arrays, array);
        int n = arrays.length;
        int nstrips = 0;
        int i = 0;
        while (i < n) {
            if (arrays[i] != null) {
                nstrips += arrays[i].stripVertexCounts.length;
            }
            ++i;
        }
        if (nstrips <= 0) {
            return null;
        }
        int[] stripVertexCounts = new int[nstrips];
        nstrips = 0;
        int i2 = 0;
        while (i2 < n) {
            if (arrays[i2] != null) {
                int incnstrips = arrays[i2].stripVertexCounts.length;
                int j = 0;
                while (j < incnstrips) {
                    stripVertexCounts[nstrips + j] = arrays[i2].stripVertexCounts[j];
                    ++j;
                }
                nstrips += incnstrips;
            }
            ++i2;
        }
        array.stripVertexCounts = stripVertexCounts;
        return array;
    }

    public VisADGeometryArray adjustSeam(DataRenderer renderer) throws VisADException {
        CoordinateSystem coord_sys = renderer.getDisplayCoordinateSystem();
        if (coord_sys == null || coord_sys instanceof SphericalCoordinateSystem || this.coordinates == null) {
            return this;
        }
        int len = this.coordinates.length / 3;
        if (len < 6) {
            return this;
        }
        float[][] cs = new float[3][len];
        int j = 0;
        int i = 0;
        while (i < len) {
            cs[0][i] = this.coordinates[j++];
            cs[1][i] = this.coordinates[j++];
            cs[2][i] = this.coordinates[j++];
            ++i;
        }
        float[][] rs = coord_sys.fromReference(Set.copyFloats(cs));
        boolean[] test = new boolean[len];
        if (len < 2) {
            return this;
        }
        float[][] bs = new float[3][len - 1];
        float ALPHA1 = 1.1f;
        int i2 = 0;
        while (i2 < len - 1) {
            bs[0][i2] = ALPHA1 * rs[0][i2] - 0.1f * rs[0][i2 + 1];
            bs[1][i2] = ALPHA1 * rs[1][i2] - 0.1f * rs[1][i2 + 1];
            bs[2][i2] = ALPHA1 * rs[2][i2] - 0.1f * rs[2][i2 + 1];
            ++i2;
        }
        float[][] ds = coord_sys.toReference(bs);
        float IALPHA = 10.0f;
        int last_i = 0;
        int i_svc = 0;
        while (i_svc < this.stripVertexCounts.length) {
            int i3 = last_i;
            while (i3 < last_i + this.stripVertexCounts[i_svc] - 1) {
                float a0 = cs[0][i3 + 1] - cs[0][i3];
                float a1 = cs[1][i3 + 1] - cs[1][i3];
                float a2 = cs[2][i3 + 1] - cs[2][i3];
                float b0 = IALPHA * (cs[0][i3] - ds[0][i3]);
                float b1 = IALPHA * (cs[1][i3] - ds[1][i3]);
                float b2 = IALPHA * (cs[2][i3] - ds[2][i3]);
                float aa = a0 * a0 + a1 * a1 + a2 * a2;
                float bb = b0 * b0 + b1 * b1 + b2 * b2;
                float ab = b0 * a0 + b1 * a1 + b2 * a2;
                float b = ab / bb;
                float c = ab * ab / (aa * bb);
                test[i3] = !(0.5f < b && b < 2.0f && 0.5f < c);
                ++i3;
            }
            last_i += this.stripVertexCounts[i_svc];
            ++i_svc;
        }
        cs = null;
        rs = null;
        float[] lastcoord = null;
        byte[] lastcol = null;
        VisADLineStripArray array = new VisADLineStripArray();
        float[] coords = new float[3 * this.coordinates.length];
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[3 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int[] svcs = new int[this.coordinates.length];
        int svc_index = 0;
        last_i = 0;
        int[] km = new int[]{0, 0};
        j = 0;
        boolean any_split = false;
        int i_svc2 = 0;
        while (i_svc2 < this.stripVertexCounts.length) {
            int accum = 0;
            j = color_length * last_i / 3;
            int i4 = last_i;
            while (i4 < last_i + this.stripVertexCounts[i_svc2] * 3) {
                float[] coord = new float[]{this.coordinates[i4], this.coordinates[i4 + 1], this.coordinates[i4 + 2]};
                byte[] col = null;
                if (color_length == 3) {
                    col = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2]};
                } else if (color_length == 4) {
                    col = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2], this.colors[j + 3]};
                }
                if (++accum == 1) {
                    lastcoord = coord;
                    lastcol = col;
                } else {
                    this.nextPoint(accum, color_length, coords, cols, coord, col, lastcoord, lastcol, km);
                }
                if (i4 != last_i + this.stripVertexCounts[i_svc2] * 3 - 3) {
                    if (test[i4 / 3]) {
                        any_split = true;
                        if (accum >= 2) {
                            svcs[svc_index] = accum;
                            ++svc_index;
                        }
                        accum = 0;
                    }
                    j += color_length;
                }
                i4 += 3;
            }
            if (accum >= 2) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc2] * 3;
            ++i_svc2;
        }
        if (!any_split) {
            return this;
        }
        array.vertexCount = km[0] / 3;
        array.coordinates = new float[km[0]];
        System.arraycopy(coords, 0, array.coordinates, 0, km[0]);
        if (this.colors != null) {
            array.colors = new byte[km[1]];
            System.arraycopy(cols, 0, array.colors, 0, km[1]);
        }
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    public VisADGeometryArray adjustLongitude(DataRenderer renderer) throws VisADException {
        float[] lons = this.getLongitudes(renderer);
        if (lons == null) {
            return this;
        }
        int[] axis = new int[1];
        float[] lon_coords = new float[2];
        float[] lon_range = this.getLongitudeRange(lons, axis, lon_coords);
        if (lon_range[0] != lon_range[0] || lon_range[1] != lon_range[1]) {
            return this;
        }
        float bottom = lon_range[0];
        float top = lon_range[1];
        float low = bottom + 30.0f;
        float hi = top - 30.0f;
        int lon_axis = axis[0];
        float coord_bottom = lon_coords[0];
        float coord_top = lon_coords[1];
        float[] lastcoord = null;
        byte[] lastcol = null;
        VisADLineStripArray array = new VisADLineStripArray();
        float[] coords = new float[3 * this.coordinates.length];
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[3 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int[] svcs = new int[this.coordinates.length];
        int svc_index = 0;
        int last_i = 0;
        int[] km = new int[]{0, 0};
        int j = 0;
        boolean any_split = false;
        int i_svc = 0;
        while (i_svc < this.stripVertexCounts.length) {
            int accum = 0;
            j = color_length * last_i / 3;
            int i = last_i;
            while (i < last_i + this.stripVertexCounts[i_svc] * 3) {
                float[] coord = new float[]{this.coordinates[i], this.coordinates[i + 1], this.coordinates[i + 2]};
                byte[] col = null;
                if (color_length == 3) {
                    col = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2]};
                } else if (color_length == 4) {
                    col = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2], this.colors[j + 3]};
                }
                if (++accum == 1) {
                    lastcoord = coord;
                    lastcol = col;
                } else {
                    this.nextPoint(accum, color_length, coords, cols, coord, col, lastcoord, lastcol, km);
                }
                if (i != last_i + this.stripVertexCounts[i_svc] * 3 - 3) {
                    int i3 = i / 3;
                    if (lons[i3] < low && hi < lons[i3 + 1] || lons[i3 + 1] < low && hi < lons[i3]) {
                        any_split = true;
                        if (lon_axis < 0) {
                            if (accum >= 2) {
                                svcs[svc_index] = accum;
                                ++svc_index;
                            }
                            accum = 0;
                        } else {
                            float coord_second;
                            float coord_first;
                            float b;
                            float a;
                            if (lons[i3] < low) {
                                a = lons[i3] - bottom;
                                b = top - lons[i3 + 1];
                                coord_first = coord_bottom;
                                coord_second = coord_top;
                            } else {
                                a = top - lons[i3];
                                b = lons[i3 + 1] - bottom;
                                coord_first = coord_top;
                                coord_second = coord_bottom;
                            }
                            float alpha = b / (a + b);
                            alpha = alpha != alpha || alpha < 0.0f ? 0.0f : (1.0f < alpha ? 1.0f : alpha);
                            float beta = 1.0f - alpha;
                            coord = new float[]{alpha * this.coordinates[i] + beta * this.coordinates[i + 3], alpha * this.coordinates[i + 1] + beta * this.coordinates[i + 4], alpha * this.coordinates[i + 2] + beta * this.coordinates[i + 5]};
                            coord[lon_axis] = coord_first;
                            col = null;
                            if (color_length == 3) {
                                col = new byte[]{ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j]) + beta * ShadowType.byteToFloat(this.colors[j + 3])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 1]) + beta * ShadowType.byteToFloat(this.colors[j + 4])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 2]) + beta * ShadowType.byteToFloat(this.colors[j + 5]))};
                            } else if (color_length == 4) {
                                col = new byte[]{ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j]) + beta * ShadowType.byteToFloat(this.colors[j + 4])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 1]) + beta * ShadowType.byteToFloat(this.colors[j + 5])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 2]) + beta * ShadowType.byteToFloat(this.colors[j + 6])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 3]) + beta * ShadowType.byteToFloat(this.colors[j + 7]))};
                            }
                            if (++accum == 1) {
                                lastcoord = coord;
                                lastcol = col;
                            } else {
                                this.nextPoint(accum, color_length, coords, cols, coord, col, lastcoord, lastcol, km);
                            }
                            if (accum >= 2) {
                                svcs[svc_index] = accum;
                                ++svc_index;
                            }
                            accum = 0;
                            coord[lon_axis] = coord_second;
                            if (++accum == 1) {
                                lastcoord = coord;
                                lastcol = col;
                            } else {
                                this.nextPoint(accum, color_length, coords, cols, coord, col, lastcoord, lastcol, km);
                            }
                        }
                    }
                    j += color_length;
                }
                i += 3;
            }
            if (accum >= 2) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc] * 3;
            ++i_svc;
        }
        if (!any_split) {
            return this;
        }
        array.vertexCount = km[0] / 3;
        array.coordinates = new float[km[0]];
        System.arraycopy(coords, 0, array.coordinates, 0, km[0]);
        if (this.colors != null) {
            array.colors = new byte[km[1]];
            System.arraycopy(cols, 0, array.colors, 0, km[1]);
        }
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    private void nextPoint(int accum, int color_length, float[] coords, byte[] cols, float[] coord, byte[] col, float[] lastcoord, byte[] lastcol, int[] km) {
        if (accum == 2) {
            coords[km[0]] = lastcoord[0];
            coords[km[0] + 1] = lastcoord[1];
            coords[km[0] + 2] = lastcoord[2];
            km[0] = km[0] + 3;
            if (this.colors != null) {
                cols[km[1]] = lastcol[0];
                cols[km[1] + 1] = lastcol[1];
                cols[km[1] + 2] = lastcol[2];
                km[1] = km[1] + 3;
                if (color_length == 4) {
                    int n = km[1];
                    km[1] = n + 1;
                    cols[n] = lastcol[3];
                }
            }
        }
        coords[km[0]] = coord[0];
        coords[km[0] + 1] = coord[1];
        coords[km[0] + 2] = coord[2];
        km[0] = km[0] + 3;
        if (this.colors != null) {
            cols[km[1]] = col[0];
            cols[km[1] + 1] = col[1];
            cols[km[1] + 2] = col[2];
            km[1] = km[1] + 3;
            if (color_length == 4) {
                int n = km[1];
                km[1] = n + 1;
                cols[n] = col[3];
            }
        }
    }

    public VisADGeometryArray removeMissing() {
        VisADLineStripArray array = new VisADLineStripArray();
        float[] coords = new float[this.coordinates.length];
        int color_length = 3;
        byte[] cols = null;
        if (this.colors != null) {
            cols = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int[] svcs = new int[this.coordinates.length / 4];
        int svc_index = 0;
        int last_i = 0;
        int k = 0;
        int m = 0;
        int j = 0;
        boolean any_missing = false;
        int i_svc = 0;
        while (i_svc < this.stripVertexCounts.length) {
            int accum = 0;
            j = color_length * last_i / 3;
            int i = last_i;
            while (i < last_i + this.stripVertexCounts[i_svc] * 3) {
                if (this.coordinates[i] == this.coordinates[i] && this.coordinates[i + 1] == this.coordinates[i + 1] && this.coordinates[i + 2] == this.coordinates[i + 2]) {
                    if (++accum >= 2) {
                        int iml = i;
                        int jml = j;
                        if (accum == 2) {
                            iml = i - 3;
                            jml = j - color_length;
                        }
                        int jm = jml;
                        int im = iml;
                        while (im <= i) {
                            coords[k] = this.coordinates[im];
                            coords[k + 1] = this.coordinates[im + 1];
                            coords[k + 2] = this.coordinates[im + 2];
                            if (this.colors != null) {
                                cols[m] = this.colors[jm];
                                cols[m + 1] = this.colors[jm + 1];
                                cols[m + 2] = this.colors[jm + 2];
                                m += 3;
                                if (color_length == 4) {
                                    cols[m++] = this.colors[jm + 3];
                                }
                            }
                            k += 3;
                            jm += color_length;
                            im += 3;
                        }
                    }
                } else {
                    any_missing = true;
                    if (accum >= 2) {
                        svcs[svc_index] = accum;
                        ++svc_index;
                    }
                    accum = 0;
                }
                j += color_length;
                i += 3;
            }
            if (accum >= 2) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc] * 3;
            ++i_svc;
        }
        if (!any_missing) {
            return this;
        }
        array.vertexCount = k / 3;
        array.coordinates = new float[k];
        System.arraycopy(coords, 0, array.coordinates, 0, k);
        if (this.colors != null) {
            array.colors = new byte[m];
            System.arraycopy(cols, 0, array.colors, 0, m);
        }
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    public Object clone() {
        VisADLineStripArray array = new VisADLineStripArray();
        this.copy(array);
        if (this.stripVertexCounts != null) {
            array.stripVertexCounts = new int[this.stripVertexCounts.length];
            System.arraycopy(this.stripVertexCounts, 0, array.stripVertexCounts, 0, this.stripVertexCounts.length);
        }
        return array;
    }
}

