/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.CommonUnit;
import visad.ContourControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.EarthVectorType;
import visad.FlowControl;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.Integer2DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.PlotText;
import visad.ProjectionControl;
import visad.RangeControl;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShapeControl;
import visad.SingletonSet;
import visad.Stream2D;
import visad.TextControl;
import visad.TupleType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.util.HersheyFont;

public abstract class ShadowType
implements Serializable {
    public static final int NOTHING_MAPPED = 6;
    public static final int SIMPLE_TUPLE = 5;
    public static final int SIMPLE_ANIMATE_FIELD = 4;
    public static final int SIMPLE_FIELD = 3;
    public static final int NESTED = 2;
    public static final int LEGAL = 1;
    MathType Type;
    transient DataDisplayLink Link;
    transient DisplayImpl display;
    private transient Data data;
    private ShadowType Parent;
    int[] DisplayIndices;
    int[] ValueIndices;
    boolean MultipleSpatialDisplayScalar;
    boolean MultipleDisplayScalar;
    boolean MappedDisplayScalar;
    boolean isTerminal;
    int LevelOfDifficulty;
    boolean isTextureMap;
    boolean curvedTexture;
    boolean isTexture3D;
    boolean isLinearContour3D;
    int Dtype;
    int Rtype;
    static final int D0 = 0;
    static final int D1 = 1;
    static final int D2 = 2;
    static final int D3 = 3;
    static final int D4 = 4;
    static final int Dbad = 5;
    static final int R0 = 0;
    static final int R1 = 1;
    static final int R2 = 2;
    static final int R3 = 3;
    static final int R4 = 4;
    static final int Rbad = 5;
    DisplayTupleType spatialTuple = null;
    int spatialDimension;
    boolean anyContour;
    boolean anyFlow;
    boolean anyShape;
    boolean anyText;
    boolean streamline1;
    boolean streamline2;
    float streamlineDensity1;
    float streamlineDensity2;
    float arrowScale1;
    float arrowScale2;
    float stepFactor1;
    float stepFactor2;
    int[] cnt = new int[]{0};
    ProjectionControl p_cntrl = null;
    ContourControl c_cntrl = null;
    int[] refToComponent;
    ShadowRealTupleType[] componentWithRef;
    int[] componentIndex;
    public static final float METERS_PER_DEGREE = 111137.0f;
    private static final float BACK_SCALE = -0.15f;
    private static final float PERP_SCALE = 0.15f;
    private static final double FONT_SCALE = 0.07;

    public ShadowType(MathType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        this.Type = type;
        this.Link = link;
        this.display = link.getDisplay();
        this.Parent = parent;
        this.data = link.getData();
        this.DisplayIndices = ShadowType.zeroIndices(this.display.getDisplayScalarCount());
        this.ValueIndices = ShadowType.zeroIndices(this.display.getValueArrayLength());
        this.isTerminal = false;
        this.isTextureMap = false;
        this.curvedTexture = false;
        this.isTexture3D = false;
        this.isLinearContour3D = false;
        this.LevelOfDifficulty = 6;
        this.MultipleSpatialDisplayScalar = false;
        this.MultipleDisplayScalar = false;
        this.MappedDisplayScalar = false;
        this.p_cntrl = this.display.getProjectionControl();
    }

    public DataDisplayLink getLink() {
        return this.Link;
    }

    public int getLevelOfDifficulty() {
        return this.LevelOfDifficulty;
    }

    public boolean getIsTerminal() {
        return this.isTerminal;
    }

    public boolean getIsTextureMap() {
        return this.isTextureMap;
    }

    public boolean getCurvedTexture() {
        return this.curvedTexture;
    }

    public boolean getIsTexture3D() {
        return this.isTexture3D;
    }

    public boolean getIsLinearContour3D() {
        return this.isLinearContour3D;
    }

    public int[] getRefToComponent() {
        return this.refToComponent;
    }

    public ShadowRealTupleType[] getComponentWithRef() {
        return this.componentWithRef;
    }

    public int[] getComponentIndex() {
        return this.componentIndex;
    }

    public ShadowRealType[] getComponents(ShadowType type, boolean doRef) throws VisADException {
        ShadowRealType[] reals;
        if (type == null) {
            return null;
        }
        if (doRef) {
            this.refToComponent = null;
            this.componentWithRef = null;
            this.componentIndex = null;
        }
        if (type instanceof ShadowRealType) {
            ShadowRealType[] r = new ShadowRealType[]{(ShadowRealType)type};
            return r;
        }
        if (type instanceof ShadowRealTupleType) {
            ShadowRealTupleType ref;
            int n = ((ShadowRealTupleType)type).getDimension();
            reals = new ShadowRealType[n];
            int i = 0;
            while (i < n) {
                reals[i] = (ShadowRealType)((ShadowRealTupleType)type).getComponent(i);
                ++i;
            }
            if (doRef && (ref = ((ShadowRealTupleType)type).getReference()) != null && ref.getMappedDisplayScalar()) {
                this.refToComponent = new int[1];
                this.componentWithRef = new ShadowRealTupleType[1];
                this.componentIndex = new int[1];
                this.refToComponent[0] = 0;
                this.componentWithRef[0] = (ShadowRealTupleType)type;
                this.componentIndex[0] = 0;
            }
        } else if (type instanceof ShadowTupleType) {
            int m = ((ShadowTupleType)type).getDimension();
            int n = 0;
            int nref = 0;
            int i = 0;
            while (i < m) {
                ShadowType component = ((ShadowTupleType)type).getComponent(i);
                if (component instanceof ShadowRealType) {
                    ++n;
                } else if (component instanceof ShadowRealTupleType) {
                    ShadowRealTupleType ref;
                    n += this.getComponents(component, false).length;
                    if (doRef && (ref = ((ShadowRealTupleType)component).getReference()) != null && ref.getMappedDisplayScalar()) {
                        ++nref;
                    }
                }
                ++i;
            }
            reals = new ShadowRealType[n];
            int j = 0;
            if (nref == 0) {
                doRef = false;
            }
            if (doRef) {
                this.refToComponent = new int[nref];
                this.componentWithRef = new ShadowRealTupleType[nref];
                this.componentIndex = new int[nref];
            }
            int rj = 0;
            int i2 = 0;
            while (i2 < m) {
                ShadowType component = ((ShadowTupleType)type).getComponent(i2);
                if (component instanceof ShadowRealType || component instanceof ShadowRealTupleType) {
                    ShadowRealTupleType ref;
                    if (doRef && component instanceof ShadowRealTupleType && (ref = ((ShadowRealTupleType)component).getReference()) != null && ref.getMappedDisplayScalar()) {
                        this.refToComponent[rj] = j;
                        this.componentWithRef[rj] = (ShadowRealTupleType)component;
                        this.componentIndex[rj] = i2;
                        ++rj;
                    }
                    ShadowRealType[] r = this.getComponents(component, false);
                    int k = 0;
                    while (k < r.length) {
                        reals[j] = r[k];
                        ++j;
                        ++k;
                    }
                }
                ++i2;
            }
        } else {
            reals = null;
        }
        return reals;
    }

    public Data getData() {
        return this.data;
    }

    public ShadowType getAdaptedShadowType() {
        return this;
    }

    static int[] zeroIndices(int length) {
        int[] local_indices = new int[length];
        int i = 0;
        while (i < length) {
            local_indices[i] = 0;
            ++i;
        }
        return local_indices;
    }

    static int[] copyIndices(int[] indices) {
        int[] local_indices = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            local_indices[i] = indices[i];
            ++i;
        }
        return local_indices;
    }

    static int[] addIndices(int[] indices, int[] indices2) throws VisADException {
        if (indices.length != indices2.length) {
            throw new DisplayException("ShadowType.addIndices: lengths don't match");
        }
        int[] local_indices = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            local_indices[i] = indices[i] + indices2[i];
            ++i;
        }
        return local_indices;
    }

    public boolean getAnyContour() {
        return this.anyContour;
    }

    public boolean getAnyFlow() {
        return this.anyFlow;
    }

    public boolean getAnyShape() {
        return this.anyShape;
    }

    public boolean getAnyText() {
        return this.anyText;
    }

    boolean checkNested(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.Animation) || real.equals(Display.SelectValue) || real.equals(Display.SelectRange) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkR4(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.SelectRange) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.IsoContour))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkR3(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.SelectRange) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.IsoContour))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkR1D3(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkColorRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkColorAlphaRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkContourColorAlphaRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            if (display_indices[i] != 0) {
                DisplayRealType real = this.display.getDisplayScalar(i);
                DisplayTupleType tuple = real.getTuple();
                if (!(real.equals(Display.IsoContour) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    boolean checkR2D2(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple)) || tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha) || real.equals(Display.Shape) || real.equals(Display.ShapeScale) || real.equals(Display.Text) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkSpatialOffsetColorAlphaRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || Display.DisplaySpatialOffsetTuple.equals(tuple) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkSpatialColorAlphaRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.Alpha) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkSpatialRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple)) || real.equals(Display.SelectRange))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int checkAnimationOrValue(int[] display_indices) throws RemoteException {
        int count = 0;
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            if (display_indices[i] != 0 && ((real = this.display.getDisplayScalar(i)).equals(Display.Animation) || real.equals(Display.SelectValue))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    boolean anyRange(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            if (display_indices[i] != 0 && (real = this.display.getDisplayScalar(i)).equals(Display.SelectRange)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean checkContour(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            if (display_indices[i] != 0 && (real = this.display.getDisplayScalar(i)).equals(Display.IsoContour)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean checkFlow(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            if (display_indices[i] != 0) {
                DisplayRealType real = this.display.getDisplayScalar(i);
                DisplayTupleType tuple = real.getTuple();
                if (tuple != null && (tuple.equals(Display.DisplayFlow1Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow1Tuple))) {
                    return true;
                }
                if (tuple != null && (tuple.equals(Display.DisplayFlow2Tuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayFlow2Tuple))) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    boolean checkShape(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            if (display_indices[i] != 0 && (real = this.display.getDisplayScalar(i)).equals(Display.Shape)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean checkText(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            if (display_indices[i] != 0 && (real = this.display.getDisplayScalar(i)).equals(Display.Text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean checkColor(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkColorOrAlpha(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType tuple;
            if (!(display_indices[i] == 0 || (tuple = (real = this.display.getDisplayScalar(i)).getTuple()) != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) || real.equals(Display.RGB) || real.equals(Display.RGBA) || real.equals(Display.HSV) || real.equals(Display.CMY) || real.equals(Display.Alpha))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean checkAny(int[] display_indices) throws RemoteException {
        int i = 0;
        while (i < display_indices.length) {
            if (display_indices[i] > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int testIndices(int[] indices, int[] display_indices, int levelOfDifficulty) throws VisADException, RemoteException {
        int i = 0;
        while (i < indices.length) {
            if (indices[i] > 1) {
                ScalarType real = this.display.getScalar(i);
                throw new BadMappingException("RealType " + real.getName() + " occurs more than once: " + "ShadowType.testIndices");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < display_indices.length) {
            DisplayRealType real = this.display.getDisplayScalar(i2);
            if (display_indices[i2] > 0) {
                this.isTerminal = true;
            }
            if (display_indices[i2] > 1 && real.isSingle()) {
                throw new BadMappingException("Single DisplayRealType " + real.getName() + " occurs more than once: " + "ShadowType.testIndices");
            }
            ++i2;
        }
        this.spatialTuple = null;
        this.spatialDimension = 0;
        int i3 = 0;
        while (i3 < display_indices.length) {
            DisplayRealType real;
            DisplayTupleType rtuple;
            if (display_indices[i3] > 0 && (rtuple = (real = this.display.getDisplayScalar(i3)).getTuple()) != null && (rtuple.equals(Display.DisplaySpatialCartesianTuple) || rtuple.getCoordinateSystem() != null && rtuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                if (this.spatialTuple != null && !this.spatialTuple.equals(rtuple)) {
                    throw new BadMappingException("DisplayRealType-s occur from multiple spatial DisplayTupleType-s: ShadowType.testIndices");
                }
                this.spatialTuple = rtuple;
                ++this.spatialDimension;
            }
            ++i3;
        }
        this.LevelOfDifficulty = this.isTerminal ? (levelOfDifficulty == 1 ? 1 : 2) : 6;
        return this.LevelOfDifficulty;
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        this.LevelOfDifficulty = this.testIndices(indices, display_indices, levelOfDifficulty);
        return this.LevelOfDifficulty;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public MathType getType() {
        return this.Type;
    }

    public boolean getMultipleDisplayScalar() {
        return this.MultipleDisplayScalar;
    }

    public boolean getMultipleSpatialDisplayScalar() {
        return this.MultipleSpatialDisplayScalar;
    }

    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public int[] getDisplayIndices() {
        int[] ii = new int[this.DisplayIndices.length];
        int i = 0;
        while (i < this.DisplayIndices.length) {
            ii[i] = this.DisplayIndices[i];
            ++i;
        }
        return ii;
    }

    public int[] getValueIndices() {
        int[] ii = new int[this.ValueIndices.length];
        int i = 0;
        while (i < this.ValueIndices.length) {
            ii[i] = this.ValueIndices[i];
            ++i;
        }
        return ii;
    }

    boolean testTransform() {
        int count = 0;
        int i = 0;
        while (i < this.DisplayIndices.length) {
            DisplayRealType real;
            if (this.DisplayIndices[i] != 0 && ((real = this.display.getDisplayScalar(i)).equals(Display.Animation) || real.equals(Display.SelectValue) || real.equals(Display.SelectRange)) && ++count > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void markTransform(boolean[] isTransform) {
    }

    public static void mapValues(float[][] display_values, double[][] values, ShadowRealType[] reals) throws VisADException {
        int n = values.length;
        if (n != reals.length) {
            throw new DisplayException("lengths don't match " + n + " != " + reals.length + ": " + "ShadowType.mapValues");
        }
        int i = 0;
        while (i < n) {
            Enumeration maps = reals[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                int value_index = map.getValueIndex();
                display_values[value_index] = map.scaleValues(values[i]);
            }
            ++i;
        }
    }

    public static void mapValues(float[][] display_values, float[][] values, ShadowRealType[] reals) throws VisADException {
        int n = values.length;
        if (n != reals.length) {
            throw new DisplayException("lengths don't match: ShadowType.mapValues");
        }
        int i = 0;
        while (i < n) {
            Enumeration maps = reals[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                int value_index = map.getValueIndex();
                display_values[value_index] = map.scaleValues(values[i]);
            }
            ++i;
        }
    }

    public static VisADGeometryArray makePointGeometry(float[][] spatial_values, byte[][] color_values) throws VisADException {
        return ShadowType.makePointGeometry(spatial_values, color_values, false);
    }

    public static VisADGeometryArray makePointGeometry(float[][] spatial_values, byte[][] color_values, boolean compress) throws VisADException {
        if (spatial_values == null) {
            throw new DisplayException("bad spatial_values: ShadowType.makePointGeometry: bad");
        }
        VisADPointArray array = new VisADPointArray();
        if (compress) {
            int len = spatial_values.length;
            int clen = color_values == null ? 0 : color_values.length;
            float[] f = spatial_values[0];
            int flen = f.length;
            int nan = 0;
            int i = 0;
            while (i < flen) {
                if (f[i] != f[i]) {
                    ++nan;
                }
                ++i;
            }
            if (nan > 0) {
                float[][] new_s_values = new float[len][flen - nan];
                byte[][] new_c_values = color_values;
                if (clen > 0) {
                    new_c_values = new byte[clen][flen - nan];
                }
                int c = 0;
                int i2 = 0;
                while (i2 < flen) {
                    if (f[i2] == f[i2]) {
                        int j = 0;
                        while (j < len) {
                            new_s_values[j][c] = spatial_values[j][i2];
                            ++j;
                        }
                        int j2 = 0;
                        while (j2 < clen) {
                            new_c_values[j2][c] = color_values[j2][i2];
                            ++j2;
                        }
                        ++c;
                    }
                    ++i2;
                }
                spatial_values = new_s_values;
                color_values = new_c_values;
            }
        }
        SampledSet.setGeometryArray(array, spatial_values, 3, color_values);
        return array;
    }

    public VisADGeometryArray[] assembleShape(float[][] display_values, int valueArrayLength, int[] valueToMap, Vector MapVector, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, int index, ShadowType shadow_api) throws VisADException, RemoteException {
        if (spatial_values[0] == null) {
            return null;
        }
        int total_length = 0;
        Vector<VisADGeometryArray[]> array_vector = new Vector<VisADGeometryArray[]>();
        float x = spatial_values[0][0];
        float y = spatial_values[1][0];
        float z = spatial_values[2][0];
        byte r = 0;
        byte g = 0;
        byte b = 0;
        byte a = 0;
        int color_length = 0;
        if (color_values != null) {
            color_length = color_values.length;
            r = color_values[0][0];
            g = color_values[1][0];
            b = color_values[2][0];
            if (color_length > 3) {
                a = color_values[3][0];
            }
        }
        float[] scales = null;
        int i = 0;
        while (i < valueArrayLength) {
            int displayScalarIndex;
            DisplayRealType real;
            if (display_values[i] != null && (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i])).equals(Display.ShapeScale)) {
                if (index < 0) {
                    scales = display_values[i];
                    display_values[i] = null;
                } else {
                    scales = display_values[i].length == 1 ? new float[]{display_values[i][0]} : new float[]{display_values[i][index]};
                }
            }
            ++i;
        }
        if (scales == null) {
            int default_index = display.getDisplayScalarIndex(Display.ShapeScale);
            float default_scale = default_values[default_index];
            scales = new float[]{default_scale};
        }
        float[] values = null;
        ShapeControl control = null;
        int j = 0;
        while (j < valueArrayLength) {
            int displayScalarIndex;
            DisplayRealType real;
            if (display_values[j] != null && (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[j])).equals(Display.Shape)) {
                if (index < 0) {
                    values = display_values[j];
                    display_values[j] = null;
                } else {
                    values = display_values[j].length == 1 ? new float[]{display_values[j][0]} : new float[]{display_values[j][index]};
                }
                control = (ShapeControl)((ScalarMap)MapVector.elementAt(valueToMap[j])).getControl();
                if (values != null && control != null) {
                    int len = values.length;
                    if (color_values != null && color_values[0].length > len) {
                        len = color_values[0].length;
                    }
                    if (spatial_values[0].length > len) {
                        len = spatial_values[0].length;
                    }
                    if (scales.length > len) {
                        len = scales.length;
                    }
                    if (values.length < len) {
                        float[] new_values = new float[len];
                        int i2 = 0;
                        while (i2 < len) {
                            new_values[i2] = values[0];
                            ++i2;
                        }
                        values = new_values;
                    }
                    float cscale = control.getScale();
                    VisADGeometryArray[] arrays = control.getShapes(values);
                    int i3 = 0;
                    while (i3 < arrays.length) {
                        VisADGeometryArray array;
                        if (range_select[0] != null) {
                            if (range_select[0].length == 1) {
                                if (!range_select[0][0]) {
                                    arrays[i3] = null;
                                }
                            } else if (!range_select[0][i3]) {
                                arrays[i3] = null;
                            }
                        }
                        if ((array = arrays[i3]) != null) {
                            if (spatial_values[0].length > 1) {
                                x = spatial_values[0][i3];
                                y = spatial_values[1][i3];
                                z = spatial_values[2][i3];
                            }
                            int npts = array.coordinates.length / 3;
                            float scale = scales.length == 1 ? scales[0] : scales[i3];
                            scale *= cscale;
                            int k = 0;
                            while (k < array.coordinates.length) {
                                array.coordinates[k] = x + scale * array.coordinates[k];
                                array.coordinates[k + 1] = y + scale * array.coordinates[k + 1];
                                array.coordinates[k + 2] = z + scale * array.coordinates[k + 2];
                                k += 3;
                            }
                            if (array.colors == null && color_values != null) {
                                array.colors = new byte[color_length * npts];
                                if (color_values[0].length > 1) {
                                    r = color_values[0][i3];
                                    g = color_values[1][i3];
                                    b = color_values[2][i3];
                                    if (color_length > 3) {
                                        a = color_values[3][i3];
                                    }
                                }
                                int k2 = 0;
                                while (k2 < array.colors.length) {
                                    array.colors[k2] = r;
                                    array.colors[k2 + 1] = g;
                                    array.colors[k2 + 2] = b;
                                    if (color_length > 3) {
                                        array.colors[k2 + 3] = a;
                                    }
                                    k2 += color_length;
                                }
                            }
                        }
                        ++i3;
                    }
                    total_length += arrays.length;
                    array_vector.addElement(arrays);
                }
            }
            ++j;
        }
        if (total_length == 0) {
            return null;
        }
        VisADGeometryArray[] total_arrays = new VisADGeometryArray[total_length];
        Enumeration arrayses = array_vector.elements();
        int k = 0;
        while (arrayses.hasMoreElements()) {
            VisADGeometryArray[] arrays = (VisADGeometryArray[])arrayses.nextElement();
            System.arraycopy(arrays, 0, total_arrays, k, arrays.length);
            k += arrays.length;
        }
        DataRenderer renderer = this.getLink().getRenderer();
        int i4 = 0;
        while (i4 < total_length) {
            if (total_arrays[i4] != null) {
                total_arrays[i4] = total_arrays[i4].adjustLongitudeBulk(renderer);
            }
            ++i4;
        }
        return total_arrays;
    }

    public Set assembleSpatial(float[][] spatial_values, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, int[] inherited_values, Set domain_set, boolean allSpatial, boolean set_for_shape, int[] spatialDimensions, boolean[][] range_select, float[][] flow1_values, float[][] flow2_values, float[] flowScale, boolean[] swap, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        int k;
        int i;
        DisplayTupleType spatial_tuple = null;
        int len = 1;
        int spatialDimension = 0;
        int[] tuple_indices = new int[3];
        spatialDimensions[0] = 0;
        spatialDimensions[1] = 0;
        float[][] offset_values = new float[3][];
        boolean[] offset_copy = new boolean[]{false, false, false};
        Unit[] spatial_units = new Unit[]{null, null, null};
        double[] ranges = new double[]{Double.NaN, Double.NaN, Double.NaN};
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        int i2 = 0;
        while (i2 < valueArrayLength) {
            int displayScalarIndex;
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_values[i2] != null && (tuple = (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i2])).getTuple()) != null && (tuple.equals(Display.DisplaySpatialCartesianTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                if (spatial_tuple != null && !spatial_tuple.equals(tuple)) {
                    throw new DisplayException("multiple spatial display tuples: ShadowType.assembleSpatial");
                }
                spatial_tuple = tuple;
                int tuple_index = real.getTupleIndex();
                spatial_value_indices[tuple_index] = i2;
                spatial_values[tuple_index] = display_values[i2];
                len = Math.max(len, display_values[i2].length);
                display_values[i2] = null;
                spatialDimensions[0] = spatialDimensions[0] + 1;
                if (inherited_values[i2] == 0) {
                    tuple_indices[spatialDimension] = tuple_index;
                    ++spatialDimension;
                }
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i2]);
                double[] map_range = map.getRange();
                ranges[tuple_index] = map_range[1] - map_range[0];
                spatial_units[tuple_index] = ((RealType)map.getScalar()).getDefaultUnit();
            }
            ++i2;
        }
        if (spatial_tuple == null) {
            spatial_tuple = Display.DisplaySpatialCartesianTuple;
        }
        if (spatialDimension == 0) {
            spatialDimensions[1] = 0;
        } else if (domain_set == null) {
            spatialDimensions[1] = spatialDimension;
        } else if (!allSpatial) {
            spatialDimensions[1] = spatialDimension;
            if (set_for_shape) {
                RealType[] reals = new RealType[spatialDimension];
                float[][] samples = new float[spatialDimension][];
                int i3 = 0;
                while (i3 < spatialDimension) {
                    reals[i3] = RealType.Generic;
                    samples[i3] = spatial_values[tuple_indices[i3]];
                    ++i3;
                }
                RealTupleType tuple_type = new RealTupleType(reals);
                try {
                    switch (spatialDimension) {
                        case 1: {
                            domain_set = new Irregular1DSet((MathType)tuple_type, (float[][])samples, null, null, null, false);
                            break;
                        }
                        case 2: {
                            domain_set = new Irregular2DSet((MathType)tuple_type, (float[][])samples, null, null, null, null, false);
                            break;
                        }
                        case 3: {
                            domain_set = new Irregular3DSet((MathType)tuple_type, (float[][])samples, null, null, null, null, false);
                        }
                    }
                }
                catch (VisADException e) {
                    domain_set = null;
                }
            } else {
                domain_set = null;
            }
        } else {
            spatialDimensions[1] = domain_set.getManifoldDimension();
        }
        boolean set_needed = domain_set != null && (set_for_shape || spatialDimensions[1] < 3);
        boolean[] missing_checked = new boolean[]{false, false, false};
        int i4 = 0;
        while (i4 < 3) {
            if (spatial_values[i4] == null) {
                spatial_values[i4] = new float[len];
                int default_index = display.getDisplayScalarIndex((DisplayRealType)spatial_tuple.getComponent(i4));
                float default_value = default_values[default_index];
                int j = 0;
                while (j < len) {
                    spatial_values[i4][j] = default_value;
                    ++j;
                }
                missing_checked[i4] = true;
            } else if (spatial_values[i4].length == 1) {
                float v = spatial_values[i4][0];
                missing_checked[i4] = true;
                if (v != v || Float.isInfinite(v)) {
                    range_select[0] = new boolean[1];
                    range_select[0][0] = false;
                    return null;
                }
                if (len > 1) {
                    spatial_values[i4] = new float[len];
                    int j = 0;
                    while (j < len) {
                        spatial_values[i4][j] = v;
                        ++j;
                    }
                }
            }
            ++i4;
        }
        boolean anyFlow = false;
        int[] flen = new int[]{0, 0};
        float[][][] ff_values = new float[][][]{flow1_values, flow2_values};
        int k2 = 0;
        while (k2 < 2) {
            int i5 = 0;
            while (i5 < 3) {
                if (ff_values[k2][i5] != null) {
                    anyFlow = true;
                    flen[k2] = Math.max(flen[k2], ff_values[k2][i5].length);
                }
                ++i5;
            }
            ++k2;
        }
        len = Math.max(len, Math.max(flen[0], flen[1]));
        ShadowType.fillOut(spatial_values, len);
        if (flen[0] > 0) {
            ShadowType.fillOut(flow1_values, len);
        }
        if (flen[1] > 0) {
            ShadowType.fillOut(flow2_values, len);
        }
        boolean spatial_flow = anyFlow;
        int i6 = 0;
        while (i6 < 3) {
            if (ranges[i6] == ranges[i6]) {
                if (spatial_units[i6] == null) {
                    spatial_flow = false;
                    break;
                }
                int j = 0;
                while (j < 3) {
                    if (ranges[j] == ranges[j]) {
                        if (spatial_units[j] == null) {
                            spatial_flow = false;
                            break;
                        }
                        if (!Unit.canConvert(spatial_units[i6], spatial_units[j])) {
                            spatial_flow = false;
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i6;
        }
        if (spatial_flow) {
            double max_range = -1.0;
            int i7 = 0;
            while (i7 < 3) {
                double ar;
                if (ranges[i7] == ranges[i7] && (ar = Math.abs(ranges[i7])) > max_range) {
                    max_range = ar;
                }
                ++i7;
            }
            i = 0;
            while (i < 3) {
                ranges[i] = ranges[i] == ranges[i] ? ranges[i] / max_range : 1.0;
                ++i;
            }
            k = 0;
            while (k < 2) {
                if (!(renderer.getRealVectorTypes(k) instanceof EarthVectorType || ff_values[k][0] == null && ff_values[k][1] == null && ff_values[k][2] == null)) {
                    int j = 0;
                    while (j < len) {
                        float old_speed = 0.0f;
                        float new_speed = 0.0f;
                        int i8 = 0;
                        while (i8 < 3) {
                            if (ff_values[k][i8] != null) {
                                old_speed += ff_values[k][i8][j] * ff_values[k][i8][j];
                                float[] fArray = ff_values[k][i8];
                                int n = j;
                                fArray[n] = (float)((double)fArray[n] * ranges[i8]);
                                new_speed += ff_values[k][i8][j] * ff_values[k][i8][j];
                            }
                            ++i8;
                        }
                        float ratio = (float)Math.sqrt(old_speed / new_speed);
                        int i9 = 0;
                        while (i9 < 3) {
                            if (ff_values[k][i9] != null) {
                                float[] fArray = ff_values[k][i9];
                                int n = j;
                                fArray[n] = fArray[n] * ratio;
                            }
                            ++i9;
                        }
                        ++j;
                    }
                }
                ++k;
            }
        }
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, ranges);
        } else {
            CoordinateSystem coord = spatial_tuple.getCoordinateSystem();
            float[][][] vector_ends = new float[2][][];
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, ranges);
            if (spatial_flow && anyFlow) {
                int k3 = 0;
                while (k3 < 2) {
                    if (!(renderer.getRealVectorTypes(k3) instanceof EarthVectorType) && flen[k3] > 0) {
                        vector_ends[k3] = new float[3][len];
                        i = 0;
                        while (i < 3) {
                            int j;
                            if (ff_values[k3][i] != null) {
                                j = 0;
                                while (j < len) {
                                    vector_ends[k3][i][j] = spatial_values[i][j] + flowScale[k3] * ff_values[k3][i][j];
                                    ++j;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    vector_ends[k3][i][j] = spatial_values[i][j];
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        vector_ends[k3] = coord.toReference(vector_ends[k3]);
                    }
                    ++k3;
                }
            }
            float[][] new_spatial_values = coord.toReference(spatial_values);
            i = 0;
            while (i < 3) {
                spatial_values[i] = new_spatial_values[i];
                ++i;
            }
            if (spatial_flow && anyFlow) {
                k = 0;
                while (k < 2) {
                    if (!(renderer.getRealVectorTypes(k) instanceof EarthVectorType) && flen[k] > 0) {
                        int i10 = 0;
                        while (i10 < 3) {
                            int j = 0;
                            while (j < len) {
                                vector_ends[k][i10][j] = (vector_ends[k][i10][j] - spatial_values[i10][j]) / flowScale[k];
                                ++j;
                            }
                            ff_values[k][i10] = vector_ends[k][i10];
                            ++i10;
                        }
                    }
                    ++k;
                }
            }
            missing_checked = new boolean[]{false, false, false};
        }
        swap[0] = false;
        if (allSpatial && spatialDimensions[1] == 2 && len > 1) {
            float simax = 0.0f;
            float max = -1.0f;
            int imax = -1;
            i = 0;
            while (i < 3) {
                float sdiff = spatial_values[i][1] - spatial_values[i][0];
                float diff = Math.abs(sdiff);
                if (diff > max) {
                    simax = sdiff;
                    max = diff;
                    imax = i;
                }
                ++i;
            }
            int ll = len - 1;
            if (domain_set != null && domain_set instanceof Gridded2DSet && (ll = ((Gridded2DSet)domain_set).getLength(0)) > len - 1) {
                ll = len - 1;
            }
            float sjmax = 0.0f;
            max = -1.0f;
            int jmax = -1;
            int i11 = 0;
            while (i11 < 3) {
                float sdiff;
                float diff;
                if (i11 != imax && (diff = Math.abs(sdiff = spatial_values[i11][ll] - spatial_values[i11][0])) > max) {
                    sjmax = sdiff;
                    max = diff;
                    jmax = i11;
                }
                ++i11;
            }
            if (imax == 0) {
                swap[0] = true;
                swap[1] = simax < 0.0f;
                swap[2] = sjmax < 0.0f;
            } else if (imax == 1) {
                swap[2] = sjmax < 0.0f;
                swap[1] = simax < 0.0f;
            } else if (jmax == 1) {
                swap[0] = true;
                swap[1] = simax < 0.0f;
                swap[2] = sjmax < 0.0f;
            } else {
                swap[2] = sjmax < 0.0f;
                swap[1] = simax < 0.0f;
            }
        }
        int offset_len = len;
        int i12 = 0;
        while (i12 < valueArrayLength) {
            int displayScalarIndex;
            DisplayRealType real;
            DisplayTupleType tuple;
            if (display_values[i12] != null && Display.DisplaySpatialOffsetTuple.equals(tuple = (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i12])).getTuple())) {
                int tuple_index = real.getTupleIndex();
                if (offset_values[tuple_index] == null) {
                    offset_values[tuple_index] = display_values[i12];
                } else {
                    int leno = offset_values[tuple_index].length;
                    int lend = display_values[i12].length;
                    if (leno > lend) {
                        float[] off;
                        if (offset_copy[tuple_index]) {
                            off = offset_values[tuple_index];
                        } else {
                            off = new float[leno];
                            offset_copy[tuple_index] = true;
                        }
                        int j = 0;
                        while (j < leno) {
                            off[j] = offset_values[tuple_index][j] + display_values[i12][0];
                            ++j;
                        }
                        offset_values[tuple_index] = off;
                        off = null;
                    } else if (leno < lend) {
                        float[] off = new float[lend];
                        int j = 0;
                        while (j < lend) {
                            off[j] = offset_values[tuple_index][0] + display_values[i12][j];
                            ++j;
                        }
                        offset_values[tuple_index] = off;
                        off = null;
                        offset_copy[tuple_index] = true;
                    } else {
                        float[] off;
                        if (offset_copy[tuple_index]) {
                            off = offset_values[tuple_index];
                        } else {
                            off = new float[leno];
                            offset_copy[tuple_index] = true;
                        }
                        int j = 0;
                        while (j < leno) {
                            off[j] = offset_values[tuple_index][j] + display_values[i12][j];
                            ++j;
                        }
                        offset_values[tuple_index] = off;
                        off = null;
                    }
                }
                display_values[i12] = null;
                offset_len = Math.max(offset_len, offset_values[tuple_index].length);
            }
            ++i12;
        }
        boolean[] offset_missing_checked = new boolean[]{false, false, false};
        int i13 = 0;
        while (i13 < 3) {
            if (offset_values[i13] == null) {
                float default_value;
                DisplayRealType offset = (DisplayRealType)Display.DisplaySpatialOffsetTuple.getComponent(i13);
                int default_index = display.getDisplayScalarIndex(offset);
                if (0 <= default_index && default_index < default_values.length && (default_value = default_values[default_index]) == default_value) {
                    offset_values[i13] = new float[]{default_value};
                }
                offset_missing_checked[i13] = true;
            } else if (offset_values[i13].length == 1) {
                offset_missing_checked[i13] = true;
                if (offset_values[i13][0] != offset_values[i13][0] || Float.isInfinite(offset_values[i13][0])) {
                    range_select[0] = new boolean[1];
                    range_select[0][0] = false;
                    return null;
                }
            }
            ++i13;
        }
        if (offset_len > len) {
            int i14 = 0;
            while (i14 < 3) {
                float[] s = new float[offset_len];
                int k4 = 0;
                while (k4 < offset_len) {
                    s[k4] = spatial_values[i14][0];
                    ++k4;
                }
                spatial_values[i14] = s;
                s = null;
                ++i14;
            }
            len = offset_len;
        }
        int i15 = 0;
        while (i15 < 3) {
            if (offset_values[i15] != null) {
                int k5;
                int leno = offset_values[i15].length;
                if (leno < len) {
                    k5 = 0;
                    while (k5 < offset_len) {
                        float[] fArray = spatial_values[i15];
                        int n = k5++;
                        fArray[n] = fArray[n] + offset_values[i15][0];
                    }
                } else {
                    k5 = 0;
                    while (k5 < offset_len) {
                        float[] fArray = spatial_values[i15];
                        int n = k5;
                        fArray[n] = fArray[n] + offset_values[i15][k5];
                        ++k5;
                    }
                }
                offset_values[i15] = null;
                boolean bl = missing_checked[i15] = missing_checked[i15] && offset_missing_checked[i15];
            }
            if (!missing_checked[i15]) {
                int j = 0;
                while (j < len) {
                    if (spatial_values[i15][j] != spatial_values[i15][j] || Float.isInfinite(spatial_values[i15][j])) {
                        if (range_select[0] == null) {
                            range_select[0] = new boolean[len];
                            int k6 = 0;
                            while (k6 < len) {
                                range_select[0][k6] = true;
                                ++k6;
                            }
                        } else if (range_select[0].length < len) {
                            boolean[] r = new boolean[len];
                            int k7 = 0;
                            while (k7 < len) {
                                r[k7] = range_select[0][0];
                                ++k7;
                            }
                            range_select[0] = r;
                        }
                        range_select[0][j] = false;
                        spatial_values[i15][j] = Float.NaN;
                    }
                    ++j;
                }
            }
            ++i15;
        }
        if (set_needed) {
            try {
                if (spatialDimension == 0) {
                    double[] values = new double[3];
                    int i16 = 0;
                    while (i16 < 3) {
                        values[i16] = spatial_values[i16][0];
                        ++i16;
                    }
                    RealTuple tuple = new RealTuple(Display.DisplaySpatialCartesianTuple, values);
                    return new SingletonSet(tuple);
                }
                SetType type = new SetType(Display.DisplaySpatialCartesianTuple);
                return shadow_api.makeSpatialSet(domain_set, type, spatial_values);
            }
            catch (VisADException e) {
                return null;
            }
        }
        return null;
    }

    public Set makeSpatialSet(Set domain_set, SetType type, float[][] spatial_values) throws VisADException {
        return domain_set.makeSpatial(type, spatial_values);
    }

    private static void fillOut(float[][] values, int flen) {
        int i = 0;
        while (i < values.length) {
            int len;
            if (values[i] != null && (len = values[i].length) < flen) {
                float[] s = new float[flen];
                float v = values[i][0];
                int k = 0;
                while (k < flen) {
                    s[k] = v;
                    ++k;
                }
                values[i] = s;
            }
            ++i;
        }
    }

    public void assembleFlow(float[][] flow1_values, float[][] flow2_values, float[] flowScale, float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        int[] flen = new int[]{0, 0};
        float[][][] ff_values = new float[][][]{flow1_values, flow2_values};
        DisplayTupleType[] flow_tuple = new DisplayTupleType[]{Display.DisplayFlow1Tuple, Display.DisplayFlow2Tuple};
        DisplayTupleType[] actual_tuple = new DisplayTupleType[]{null, null};
        boolean anyFlow = false;
        int i = 0;
        while (i < valueArrayLength) {
            if (display_values[i] != null) {
                int displayScalarIndex = valueToScalar[i];
                DisplayRealType real = display.getDisplayScalar(displayScalarIndex);
                DisplayTupleType tuple = real.getTuple();
                int k = 0;
                while (k < 2) {
                    if (tuple != null && (tuple.equals(flow_tuple[k]) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(flow_tuple[k]))) {
                        if (actual_tuple[k] != null && !actual_tuple[k].equals(tuple)) {
                            throw new DisplayException("multiple flow " + k + " display tuples: " + "ShadowType.assembleFlow");
                        }
                        actual_tuple[k] = tuple;
                        ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                        FlowControl control = (FlowControl)map.getControl();
                        flowScale[k] = control.getFlowScale();
                        int flow_index = real.getTupleIndex();
                        ff_values[k][flow_index] = display_values[i];
                        flen[k] = Math.max(flen[k], display_values[i].length);
                        display_values[i] = null;
                        anyFlow = true;
                        if (k == 0) {
                            this.streamline1 = control.streamlinesEnabled();
                            this.streamlineDensity1 = control.getStreamlineDensity();
                            this.arrowScale1 = control.getArrowScale();
                            this.stepFactor1 = control.getStepFactor();
                        }
                        if (k == 1) {
                            this.streamline2 = control.streamlinesEnabled();
                            this.streamlineDensity2 = control.getStreamlineDensity();
                            this.arrowScale2 = control.getArrowScale();
                            this.stepFactor2 = control.getStepFactor();
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        int k = 0;
        while (k < 2) {
            boolean[] missing_checked = new boolean[]{false, false, false};
            if (flen[k] > 0) {
                int i2 = 0;
                while (i2 < 3) {
                    if (ff_values[k][i2] == null) {
                        ff_values[k][i2] = new float[flen[k]];
                        int default_index = display.getDisplayScalarIndex((DisplayRealType)flow_tuple[k].getComponent(i2));
                        float default_value = default_values[default_index];
                        int j = 0;
                        while (j < flen[k]) {
                            ff_values[k][i2][j] = default_value;
                            ++j;
                        }
                        missing_checked[i2] = true;
                    } else if (ff_values[k][i2].length == 1) {
                        float v = ff_values[k][i2][0];
                        missing_checked[i2] = true;
                        if (v != v) {
                            range_select[0] = new boolean[1];
                            range_select[0][0] = false;
                            return;
                        }
                        if (flen[k] > 1) {
                            ff_values[k][i2] = new float[flen[k]];
                            int j = 0;
                            while (j < flen[k]) {
                                ff_values[k][i2][j] = v;
                                ++j;
                            }
                        }
                    }
                    ++i2;
                }
            }
            if (actual_tuple[k] != null && !actual_tuple[k].equals(flow_tuple[k])) {
                missing_checked = new boolean[]{false, false, false};
                CoordinateSystem coord = actual_tuple[k].getCoordinateSystem();
                float[][] new_ff_values = coord.toReference(ff_values[k]);
                int i3 = 0;
                while (i3 < 3) {
                    ff_values[k][i3] = new_ff_values[i3];
                    ++i3;
                }
            }
            if (flen[k] > 0) {
                int i4 = 0;
                while (i4 < 3) {
                    if (!missing_checked[i4]) {
                        int j = 0;
                        while (j < flen[k]) {
                            if (ff_values[k][i4][j] != ff_values[k][i4][j]) {
                                if (range_select[0] == null) {
                                    range_select[0] = new boolean[flen[k]];
                                    int m = 0;
                                    while (m < flen[k]) {
                                        range_select[0][m] = true;
                                        ++m;
                                    }
                                } else if (range_select[0].length < flen[k]) {
                                    boolean[] r = new boolean[flen[k]];
                                    int m = 0;
                                    while (m < flen[k]) {
                                        r[m] = range_select[0][0];
                                        ++m;
                                    }
                                    range_select[0] = r;
                                }
                                range_select[0][j] = false;
                                ff_values[k][i4][j] = 0.0f;
                            }
                            ++j;
                        }
                    }
                    ++i4;
                }
            }
            ++k;
        }
    }

    public static float[][] adjustFlowToEarth(int which, float[][] flow_values, float[][] spatial_values, float flowScale, DataRenderer renderer) throws VisADException {
        int j;
        float factor_lat;
        float[][] base_spatial_locs;
        float[][] earth_locs;
        if (!(renderer.getRealVectorTypes(which) instanceof EarthVectorType)) {
            return flow_values;
        }
        int flen = flow_values[0].length;
        float scale = 0.0f;
        int j2 = 0;
        while (j2 < flen) {
            if (Math.abs(flow_values[0][j2]) > scale) {
                scale = Math.abs(flow_values[0][j2]);
            }
            if (Math.abs(flow_values[1][j2]) > scale) {
                scale = Math.abs(flow_values[1][j2]);
            }
            if (Math.abs(flow_values[2][j2]) > scale) {
                scale = Math.abs(flow_values[2][j2]);
            }
            ++j2;
        }
        float inv_scale = 1.0f / scale;
        if (inv_scale != inv_scale) {
            inv_scale = 1.0f;
        }
        if ((earth_locs = renderer.spatialToEarth(spatial_values, base_spatial_locs = new float[3][])) == null) {
            return flow_values;
        }
        int elen = earth_locs.length;
        boolean other_meters = false;
        Unit[] earth_units = renderer.getEarthUnits();
        if (earth_units != null) {
            if (Unit.canConvert(earth_units[0], CommonUnit.radian)) {
                earth_locs[0] = CommonUnit.radian.toThis(earth_locs[0], earth_units[0]);
            }
            if (Unit.canConvert(earth_units[1], CommonUnit.radian)) {
                earth_locs[1] = CommonUnit.radian.toThis(earth_locs[1], earth_units[1]);
            }
            if (elen == 3 && earth_units.length == 3 && Unit.canConvert(earth_units[2], CommonUnit.meter)) {
                other_meters = true;
                earth_locs[2] = CommonUnit.meter.toThis(earth_locs[2], earth_units[2]);
            }
        }
        if (elen == 3) {
            factor_lat = (float)((double)(inv_scale * 1000.0f) * (Math.PI / 180) / 111137.0);
            float factor_vert = inv_scale * 1000.0f;
            j = 0;
            while (j < flen) {
                float[] fArray = earth_locs[2];
                int n = j;
                fArray[n] = fArray[n] + factor_vert * flow_values[2][j];
                float[] fArray2 = earth_locs[1];
                int n2 = j;
                fArray2[n2] = fArray2[n2] + factor_lat * flow_values[0][j] / (float)Math.cos(earth_locs[0][j]);
                float[] fArray3 = earth_locs[0];
                int n3 = j;
                fArray3[n3] = fArray3[n3] + factor_lat * flow_values[1][j];
                ++j;
            }
        } else {
            factor_lat = 1.0E-5f * inv_scale * (0.5f * renderer.getLatLonRange());
            int j3 = 0;
            while (j3 < flen) {
                float[] fArray = earth_locs[1];
                int n = j3;
                fArray[n] = fArray[n] + factor_lat * flow_values[0][j3] / (float)Math.cos(earth_locs[0][j3]);
                float[] fArray4 = earth_locs[0];
                int n4 = j3;
                fArray4[n4] = fArray4[n4] + factor_lat * flow_values[1][j3];
                ++j3;
            }
        }
        if (earth_units != null) {
            if (Unit.canConvert(earth_units[0], CommonUnit.radian)) {
                earth_locs[0] = CommonUnit.radian.toThat(earth_locs[0], earth_units[0]);
            }
            if (Unit.canConvert(earth_units[1], CommonUnit.radian)) {
                earth_locs[1] = CommonUnit.radian.toThat(earth_locs[1], earth_units[1]);
            }
            if (elen == 3 && earth_units.length == 3 && Unit.canConvert(earth_units[2], CommonUnit.meter)) {
                earth_locs[2] = CommonUnit.meter.toThat(earth_locs[2], earth_units[2]);
            }
        }
        if (elen == 3) {
            earth_locs = renderer.earthToSpatial(earth_locs, null, base_spatial_locs);
        } else {
            float factor_vert = 1.0E-5f * inv_scale;
            float[] vert = new float[flen];
            j = 0;
            while (j < flen) {
                vert[j] = factor_vert * flow_values[2][j];
                ++j;
            }
            earth_locs = renderer.earthToSpatial(earth_locs, vert);
            int i = 0;
            while (i < earth_locs.length) {
                if (earth_locs[i] == null) {
                    earth_locs[i] = new float[flen];
                    int j4 = 0;
                    while (j4 < flen) {
                        earth_locs[i][j4] = spatial_values[i][j4];
                        ++j4;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < 3) {
            int j5 = 0;
            while (j5 < flen) {
                float[] fArray = earth_locs[i];
                int n = j5;
                fArray[n] = fArray[n] - spatial_values[i][j5];
                ++j5;
            }
            ++i;
        }
        int j6 = 0;
        while (j6 < flen) {
            float mag = (float)Math.sqrt(flow_values[0][j6] * flow_values[0][j6] + flow_values[1][j6] * flow_values[1][j6] + flow_values[2][j6] * flow_values[2][j6]);
            float new_mag = (float)Math.sqrt(earth_locs[0][j6] * earth_locs[0][j6] + earth_locs[1][j6] * earth_locs[1][j6] + earth_locs[2][j6] * earth_locs[2][j6]);
            float ratio = mag / new_mag;
            flow_values[0][j6] = ratio * earth_locs[0][j6];
            flow_values[1][j6] = ratio * earth_locs[1][j6];
            flow_values[2][j6] = ratio * earth_locs[2][j6];
            ++j6;
        }
        ShadowType.testFlow("adjust", flow_values);
        return flow_values;
    }

    public VisADGeometryArray[] makeStreamline(int which, float[][] flow_values, float flowScale, float[][] spatial_values, Set spatial_set, int spatialManifoldDimension, byte[][] color_values, boolean[][] range_select, int valueArrayLength, int[] valueToMap, Vector MapVector) throws VisADException {
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_set == null) {
            return null;
        }
        if (which == 0 && !this.streamline1) {
            return null;
        }
        if (which == 1 && !this.streamline2) {
            return null;
        }
        if (!(spatial_set instanceof Gridded3DSet)) {
            return null;
        }
        FunctionType ftype = (FunctionType)this.Type;
        RealTupleType rtt = ftype.getFlatRange();
        RealType[] range_reals = rtt.getRealComponents();
        int flow_dim0 = -1;
        int flow_dim1 = -1;
        int cnt_flow_maps = 0;
        int k = 0;
        while (k < range_reals.length) {
            int i = 0;
            while (i < valueArrayLength) {
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                DisplayRealType dreal = map.getDisplayScalar();
                ScalarType scalar = map.getScalar();
                if (scalar.equals(range_reals[k])) {
                    if (dreal.equals(Display.Flow1X) || dreal.equals(Display.Flow2X) || dreal.equals(Display.Flow1Elevation) || dreal.equals(Display.Flow2Elevation)) {
                        if (flow_dim0 == -1) {
                            flow_dim0 = 0;
                        } else {
                            flow_dim0 = 0;
                            flow_dim1 = 1;
                        }
                        ++cnt_flow_maps;
                    }
                    if (dreal.equals(Display.Flow1Y) || dreal.equals(Display.Flow2Y) || dreal.equals(Display.Flow1Azimuth) || dreal.equals(Display.Flow2Azimuth)) {
                        if (flow_dim0 == -1) {
                            flow_dim0 = 1;
                        } else {
                            flow_dim1 = 1;
                        }
                        ++cnt_flow_maps;
                    }
                    if (dreal.equals(Display.Flow1Z) || dreal.equals(Display.Flow2Z) || dreal.equals(Display.Flow1Radial) || dreal.equals(Display.Flow2Radial)) {
                        flow_dim1 = 2;
                        ++cnt_flow_maps;
                    }
                }
                ++i;
            }
            ++k;
        }
        if (cnt_flow_maps > 2) {
            throw new BadMappingException("only one or two ScalarMaps to Flow per data allowed if streamlines enabled");
        }
        if (range_select[0] != null) {
            if (range_select[0].length == 1 && !range_select[0][0]) {
                return null;
            }
            int ii = 0;
            while (ii < range_select[0].length) {
                if (!range_select[0][ii]) {
                    flow_values[0][ii] = Float.NaN;
                    flow_values[1][ii] = Float.NaN;
                    flow_values[2][ii] = Float.NaN;
                }
                ++ii;
            }
        }
        DataRenderer renderer = this.getLink().getRenderer();
        flow_values = ShadowType.adjustFlowToEarth(which, flow_values, spatial_values, flowScale, renderer);
        float density = 1.0f;
        float arrowScale = 1.0f;
        float stepFactor = 2.0f;
        int[] numl = new int[1];
        int[][] n_verts = new int[1][];
        float[][][] vr = new float[1][][];
        float[][][] vc = new float[1][][];
        if (which == 0) {
            density = this.streamlineDensity1;
        }
        if (which == 1) {
            density = this.streamlineDensity2;
        }
        if (which == 0) {
            arrowScale = this.arrowScale1;
        }
        if (which == 1) {
            arrowScale = this.arrowScale2;
        }
        if (which == 0) {
            stepFactor = this.stepFactor1;
        }
        if (which == 1) {
            stepFactor = this.stepFactor2;
        }
        if (spatialManifoldDimension != 2) {
            throw new VisADException("only manifoldDimension==2 supported for streamlimes");
        }
        int nc = ((Gridded3DSet)spatial_set).LengthX;
        int nr = ((Gridded3DSet)spatial_set).LengthY;
        Gridded2DSet gset = new Gridded2DSet((MathType)RealTupleType.Generic2D, new float[][]{spatial_values[flow_dim0], spatial_values[flow_dim1]}, nc, nr);
        Stream2D.stream(flow_values[flow_dim0], flow_values[flow_dim1], nr, nc, density, stepFactor, arrowScale, vr, vc, n_verts, numl, gset);
        VisADGeometryArray[] arrays = new VisADLineArray[numl[0]];
        Integer2DSet grid_set = new Integer2DSet(nc, nr);
        int kk = 0;
        while (kk < arrays.length) {
            arrays[kk] = new VisADLineArray();
            float[][] grid = new float[2][n_verts[0][kk]];
            System.arraycopy(vr[0][kk], 0, grid[1], 0, n_verts[0][kk]);
            System.arraycopy(vc[0][kk], 0, grid[0], 0, n_verts[0][kk]);
            float[][] spatial_set_vals = ((Gridded3DSet)spatial_set).gridToValue(grid);
            byte[][] intrp_color_values = null;
            if (color_values != null) {
                intrp_color_values = new byte[3][n_verts[0][kk]];
                int[] indices = grid_set.valueToIndex(grid);
                int cc = 0;
                while (cc < n_verts[0][kk]) {
                    if (indices[cc] >= 0) {
                        intrp_color_values[0][cc] = color_values[0][indices[cc]];
                        intrp_color_values[1][cc] = color_values[1][indices[cc]];
                        intrp_color_values[2][cc] = color_values[2][indices[cc]];
                    } else {
                        intrp_color_values[0][cc] = -1;
                        intrp_color_values[1][cc] = 0;
                        intrp_color_values[2][cc] = 0;
                    }
                    ++cc;
                }
            }
            Gridded3DSet cfr_ignored_0 = (Gridded3DSet)spatial_set;
            Gridded3DSet.setGeometryArray(arrays[kk], spatial_set_vals, 3, intrp_color_values);
            ++kk;
        }
        return arrays;
    }

    private static void testFlow(String id, float[][] flow_values) {
        int flen = flow_values[0].length;
        int i = 0;
        while (i < flen) {
            if (flow_values[0][i] != flow_values[0][i] || flow_values[1][i] != flow_values[1][i] || flow_values[2][i] != flow_values[2][i] || Float.isInfinite(flow_values[0][i]) || Float.isInfinite(flow_values[1][i]) || Float.isInfinite(flow_values[2][i])) {
                flow_values[0][i] = 0.0f;
                flow_values[1][i] = 0.0f;
                flow_values[2][i] = 0.0f;
            }
            ++i;
        }
    }

    public VisADGeometryArray[] makeFlow(int which, float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        VisADLineArray array = new VisADLineArray();
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            int j = 0;
            while (j < range_select[0].length) {
                if (range_select[0][j]) {
                    ++rlen;
                }
                ++j;
            }
        }
        if (rlen == 0) {
            return null;
        }
        DataRenderer renderer = this.getLink().getRenderer();
        flow_values = ShadowType.adjustFlowToEarth(which, flow_values, spatial_values, flowScale, renderer);
        array.vertexCount = 6 * rlen;
        float[] coordinates = new float[18 * rlen];
        int m = 0;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float a0 = 0.0f;
        float a1 = 0.0f;
        float a2 = 0.0f;
        float b0 = 0.0f;
        float b1 = 0.0f;
        float b2 = 0.0f;
        int j = 0;
        while (j < len) {
            if (range_select[0] == null || range_select[0][j]) {
                if (flen == 1) {
                    f0 = flowScale * flow_values[0][0];
                    f1 = flowScale * flow_values[1][0];
                    f2 = flowScale * flow_values[2][0];
                } else {
                    f0 = flowScale * flow_values[0][j];
                    f1 = flowScale * flow_values[1][j];
                    f2 = flowScale * flow_values[2][j];
                }
                int k = m;
                coordinates[m++] = spatial_values[0][j];
                coordinates[m++] = spatial_values[1][j];
                coordinates[m++] = spatial_values[2][j];
                int n = m;
                coordinates[m++] = coordinates[k++] + f0;
                coordinates[m++] = coordinates[k++] + f1;
                coordinates[m++] = coordinates[k++] + f2;
                k = n;
                coordinates[m++] = coordinates[n++];
                coordinates[m++] = coordinates[n++];
                coordinates[m++] = coordinates[n++];
                boolean mode2d = this.display.getDisplayRenderer().getMode2D();
                b0 = a0 = -0.15f * f0;
                b1 = a1 = -0.15f * f1;
                b2 = a2 = -0.15f * f2;
                if (mode2d || Math.abs(f2) <= Math.abs(f0) && Math.abs(f2) <= Math.abs(f1)) {
                    a0 += 0.15f * f1;
                    a1 -= 0.15f * f0;
                    b0 -= 0.15f * f1;
                    b1 += 0.15f * f0;
                } else if (Math.abs(f1) <= Math.abs(f0)) {
                    a0 += 0.15f * f2;
                    a2 -= 0.15f * f0;
                    b0 -= 0.15f * f2;
                    b2 += 0.15f * f0;
                } else {
                    a1 += 0.15f * f2;
                    a2 -= 0.15f * f1;
                    b1 -= 0.15f * f2;
                    b2 += 0.15f * f1;
                }
                k = n;
                coordinates[m++] = coordinates[n++] + a0;
                coordinates[m++] = coordinates[n++] + a1;
                coordinates[m++] = coordinates[n++] + a2;
                n = k;
                coordinates[m++] = coordinates[k++];
                coordinates[m++] = coordinates[k++];
                coordinates[m++] = coordinates[k++];
                coordinates[m++] = coordinates[n++] + b0;
                coordinates[m++] = coordinates[n++] + b1;
                coordinates[m++] = coordinates[n++] + b2;
            }
            ++j;
        }
        array.coordinates = coordinates;
        if (color_values != null) {
            byte[] colors = new byte[18 * rlen];
            m = 0;
            float c0 = 0.0f;
            float c1 = 0.0f;
            float c2 = 0.0f;
            int j2 = 0;
            while (j2 < len) {
                if (range_select[0] == null || range_select[0][j2]) {
                    int k1 = m;
                    int k2 = m;
                    int k3 = m;
                    int k4 = m;
                    int k5 = m;
                    colors[m++] = color_values[0][j2];
                    colors[m++] = color_values[1][j2];
                    colors[m++] = color_values[2][j2];
                    colors[m++] = colors[k1++];
                    colors[m++] = colors[k1++];
                    colors[m++] = colors[k1++];
                    colors[m++] = colors[k2++];
                    colors[m++] = colors[k2++];
                    colors[m++] = colors[k2++];
                    colors[m++] = colors[k3++];
                    colors[m++] = colors[k3++];
                    colors[m++] = colors[k3++];
                    colors[m++] = colors[k4++];
                    colors[m++] = colors[k4++];
                    colors[m++] = colors[k4++];
                    colors[m++] = colors[k5++];
                    colors[m++] = colors[k5++];
                    colors[m++] = colors[k5++];
                }
                ++j2;
            }
            array.colors = colors;
        }
        array = (VisADLineArray)array.adjustLongitudeBulk(renderer);
        return new VisADGeometryArray[]{array};
    }

    static void rotateVectors(double[] base, double[] up, double rotationDegrees) {
        double rotation = Math.PI / 180 * rotationDegrees;
        double sinRotation = Math.sin(rotation);
        double cosRotation = Math.cos(rotation);
        double[] newBase = new double[3];
        double[] newUp = new double[3];
        if (rotationDegrees == 0.0) {
            return;
        }
        int i = 0;
        while (i < 3) {
            newBase[i] = cosRotation * base[i] - sinRotation * up[i];
            newUp[i] = sinRotation * base[i] + cosRotation * up[i];
            ++i;
        }
        System.arraycopy(newBase, 0, base, 0, 3);
        System.arraycopy(newUp, 0, up, 0, 3);
    }

    public VisADGeometryArray makeText(String[] text_values, TextControl text_control, float[][] spatial_values, byte[][] color_values, boolean[][] range_select) throws VisADException {
        int n;
        if (text_values == null || text_values.length == 0 || text_control == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        byte r = 0;
        byte g = 0;
        byte b = 0;
        if (color_values != null) {
            r = color_values[0][0];
            g = color_values[1][0];
            b = color_values[2][0];
        }
        if ((n = text_values.length) > spatial_values[0].length) {
            n = spatial_values[0].length;
        }
        VisADGeometryArray[] as = new VisADGeometryArray[n];
        TextControl.Justification justification = text_control.getJustification();
        TextControl.Justification verticalJustification = text_control.getVerticalJustification();
        double size = text_control.getSize();
        Font font = text_control.getFont();
        HersheyFont hfont = text_control.getHersheyFont();
        double rotation = text_control.getRotation();
        double characterRotation = text_control.getCharacterRotation();
        double scale = text_control.getScale();
        double[] offset = text_control.getOffset();
        boolean sphere = text_control.getSphere();
        float[][] spatial_sphere = null;
        if (sphere) {
            spatial_sphere = Display.DisplaySphericalCoordSys.fromReference(spatial_values);
        }
        double[] start = new double[3];
        double[] base = new double[]{size * 0.07, 0.0, 0.0};
        double[] up = new double[]{0.0, size * 0.07, 0.0};
        ShadowType.rotateVectors(base, up, text_control.getRotation());
        int k = 0;
        int i = 0;
        while (i < n) {
            if (range_select[0] == null || range_select[0].length == 1 || range_select[0][i]) {
                int len;
                if (sphere) {
                    int len2;
                    double size_in_radians = size * 0.07 / (double)spatial_sphere[2][i];
                    double size_in_degrees = size_in_radians * 57.29577951308232;
                    double lon_size_in_degrees = size_in_degrees / Math.cos(Math.PI / 180 * (double)spatial_sphere[0][i]);
                    start = new double[]{spatial_sphere[0][i], spatial_sphere[1][i], spatial_sphere[2][i]};
                    base = new double[]{0.0, lon_size_in_degrees, 0.0};
                    up = new double[]{size_in_degrees, 0.0, 0.0};
                    ShadowType.rotateVectors(base, up, text_control.getRotation());
                    as[k] = font != null ? PlotText.render_font(text_values[i], font, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : (hfont != null ? PlotText.render_font(text_values[i], hfont, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : PlotText.render_label(text_values[i], start, base, up, justification, verticalJustification, characterRotation, scale, offset));
                    int n2 = len2 = as[k] == null ? 0 : as[k].coordinates.length;
                    if (len2 > 0) {
                        float[] coordinates = as[k].coordinates;
                        float[][] cs = new float[3][len2 / 3];
                        int m = 0;
                        int j = 0;
                        while (j < len2 / 3) {
                            cs[0][j] = coordinates[m++];
                            cs[1][j] = coordinates[m++];
                            cs[2][j] = coordinates[m++];
                            ++j;
                        }
                        cs = Display.DisplaySphericalCoordSys.toReference(cs);
                        m = 0;
                        int j2 = 0;
                        while (j2 < len2 / 3) {
                            coordinates[m++] = cs[0][j2];
                            coordinates[m++] = cs[1][j2];
                            coordinates[m++] = cs[2][j2];
                            ++j2;
                        }
                        as[k].coordinates = coordinates;
                        if (font != null) {
                            float[] normals = as[k].normals;
                            int j3 = 0;
                            while (j3 < len2) {
                                float c = (float)Math.sqrt(coordinates[j3 + 0] * coordinates[j3 + 0] + coordinates[j3 + 1] * coordinates[j3 + 1] + coordinates[j3 + 2] * coordinates[j3 + 2]);
                                float cinv = c == 0.0f ? 1.0f : 1.0f / c;
                                normals[j3 + 0] = cinv * coordinates[j3 + 0];
                                normals[j3 + 1] = cinv * coordinates[j3 + 1];
                                normals[j3 + 2] = cinv * coordinates[j3 + 2];
                                j3 += 3;
                            }
                            as[k].normals = normals;
                        }
                    }
                } else {
                    start = new double[]{spatial_values[0][i], spatial_values[1][i], spatial_values[2][i]};
                    as[k] = font != null ? PlotText.render_font(text_values[i], font, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : (hfont != null ? PlotText.render_font(text_values[i], hfont, start, base, up, justification, verticalJustification, characterRotation, scale, offset) : PlotText.render_label(text_values[i], start, base, up, justification, verticalJustification, characterRotation, scale, offset));
                }
                int n3 = len = as[k] == null ? 0 : as[k].coordinates.length;
                if (len > 0 && color_values != null) {
                    if (color_values[0].length > 1) {
                        r = color_values[0][k];
                        g = color_values[1][k];
                        b = color_values[2][k];
                    }
                    byte[] colors = new byte[len];
                    int j = 0;
                    while (j < len) {
                        colors[j] = r;
                        colors[j + 1] = g;
                        colors[j + 2] = b;
                        j += 3;
                    }
                    as[k].colors = colors;
                }
                ++k;
            }
            ++i;
        }
        if (k == 0) {
            return null;
        }
        VisADGeometryArray[] arrays = new VisADGeometryArray[k];
        System.arraycopy(as, 0, arrays, 0, k);
        VisADGeometryArray array = null;
        DataRenderer renderer = this.getLink().getRenderer();
        int i2 = 0;
        while (i2 < k) {
            if (arrays[i2] != null) {
                arrays[i2] = arrays[i2].adjustLongitudeBulk(renderer);
                if (array == null) {
                    array = (VisADGeometryArray)arrays[i2].clone();
                }
            }
            ++i2;
        }
        if (array != null) {
            VisADGeometryArray.merge(arrays, array);
        }
        return array;
    }

    public byte[][] assembleColor(float[][] display_values, int valueArrayLength, int[] valueToScalar, DisplayImpl display, float[] default_values, boolean[][] range_select, boolean[] single_missing, ShadowType shadow_api) throws VisADException, RemoteException {
        float[][] rgba_values = new float[4][];
        float[] rgba_value_counts = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float[] rgba_singles = new float[4];
        float[] rgba_single_counts = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        Object tuple_values = new float[3][];
        float[] tuple_value_counts = new float[]{0.0f, 0.0f, 0.0f};
        float[] tuple_singles = new float[3];
        float[] tuple_single_counts = new float[]{0.0f, 0.0f, 0.0f};
        boolean[] mark = new boolean[valueArrayLength];
        int i = 0;
        while (i < valueArrayLength) {
            mark[i] = false;
            ++i;
        }
        while (true) {
            TupleType color_tuple = null;
            int i2 = 0;
            while (i2 < valueArrayLength) {
                float[] values = display_values[i2];
                if (values != null && !mark[i2]) {
                    int len = values.length;
                    int displayScalarIndex = valueToScalar[i2];
                    DisplayRealType real = display.getDisplayScalar(displayScalarIndex);
                    DisplayTupleType tuple = real.getTuple();
                    if (tuple != null && (tuple.equals(Display.DisplayRGBTuple) || tuple.getCoordinateSystem() != null && tuple.getCoordinateSystem().getReference().equals(Display.DisplayRGBTuple)) && (color_tuple == null || color_tuple.equals(tuple))) {
                        if (color_tuple == null) {
                            color_tuple = tuple;
                            int j = 0;
                            while (j < 3) {
                                tuple_singles[j] = 0.0f;
                                tuple_single_counts[j] = 0.0f;
                                tuple_values[j] = null;
                                tuple_value_counts[j] = 0.0f;
                                ++j;
                            }
                        }
                        int index = real.getTupleIndex();
                        if (len == 1) {
                            int n = index;
                            tuple_singles[n] = tuple_singles[n] + values[0];
                            int n2 = index;
                            tuple_single_counts[n2] = tuple_single_counts[n2] + 1.0f;
                        } else {
                            ShadowType.singleComposite(index, tuple_values, tuple_value_counts, values);
                        }
                        display_values[i2] = null;
                        mark[i2] = true;
                    }
                }
                ++i2;
            }
            if (color_tuple == null) break;
            ShadowType.colorSum(3, tuple_values, tuple_value_counts, tuple_singles, tuple_single_counts, display, color_tuple, default_values);
            if (!color_tuple.equals(Display.DisplayRGBTuple)) {
                ShadowType.equalizeAndDefault(tuple_values, display, (DisplayTupleType)color_tuple, default_values);
                CoordinateSystem coord = ((RealTupleType)color_tuple).getCoordinateSystem();
                tuple_values = coord.toReference((float[][])tuple_values);
            }
            ShadowType.colorComposite(rgba_values, rgba_value_counts, tuple_values);
        }
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        int i3 = 0;
        while (i3 < valueArrayLength) {
            float[] values = display_values[i3];
            if (values != null && !mark[i3]) {
                int index;
                float[][] color_values;
                int len = values.length;
                int displayScalarIndex = valueToScalar[i3];
                DisplayRealType real = display.getDisplayScalar(displayScalarIndex);
                if (real.equals(Display.RGB) || real.equals(Display.HSV) || real.equals(Display.CMY)) {
                    ColorControl control = (ColorControl)((ScalarMap)MapVector.elementAt(valueToMap[i3])).getControl();
                    color_values = control.lookupValues(values);
                    if (real.equals(Display.HSV)) {
                        color_values = Display.DisplayHSVCoordSys.toReference(color_values);
                    } else if (real.equals(Display.CMY)) {
                        color_values = Display.DisplayCMYCoordSys.toReference(color_values);
                    } else if (!real.equals(Display.RGB)) {
                        throw new DisplayException("unrecognized color CoordinateSsystem: ShadowType.assembleColor");
                    }
                    if (len == 1) {
                        index = 0;
                        while (index < 3) {
                            int n = index;
                            rgba_singles[n] = rgba_singles[n] + color_values[index][0];
                            int n3 = index++;
                            rgba_single_counts[n3] = rgba_single_counts[n3] + 1.0f;
                        }
                    } else {
                        ShadowType.colorComposite(rgba_values, rgba_value_counts, color_values);
                    }
                    display_values[i3] = null;
                }
                if (real.equals(Display.RGBA)) {
                    ColorAlphaControl control = (ColorAlphaControl)((ScalarMap)MapVector.elementAt(valueToMap[i3])).getControl();
                    color_values = control.lookupValues(values);
                    if (len == 1) {
                        index = 0;
                        while (index < 4) {
                            int n = index;
                            rgba_singles[n] = rgba_singles[n] + color_values[index][0];
                            int n4 = index++;
                            rgba_single_counts[n4] = rgba_single_counts[n4] + 1.0f;
                        }
                    } else {
                        ShadowType.colorComposite(rgba_values, rgba_value_counts, color_values);
                        index = 0;
                        while (index < 4) {
                            ShadowType.singleComposite(index, rgba_values, rgba_value_counts, color_values[index]);
                            color_values[index] = null;
                            ++index;
                        }
                    }
                    display_values[i3] = null;
                }
                if (real.equals(Display.Alpha)) {
                    if (len == 1) {
                        rgba_singles[3] = rgba_singles[3] + values[0];
                        rgba_single_counts[3] = rgba_single_counts[3] + 1.0f;
                    } else {
                        ShadowType.singleComposite(3, rgba_values, rgba_value_counts, values);
                    }
                    display_values[i3] = null;
                }
            }
            ++i3;
        }
        if (rgba_values[0] == null && rgba_values[1] == null && rgba_values[2] == null && rgba_values[3] == null) {
            int index = 0;
            while (index < 4) {
                rgba_values[index] = new float[1];
                if (rgba_single_counts[index] > 0.0f) {
                    rgba_values[index][0] = rgba_singles[index] / rgba_single_counts[index];
                } else {
                    int default_index = ShadowType.getDefaultColorIndex(display, index);
                    rgba_values[index][0] = default_values[default_index];
                }
                ++index;
            }
        } else {
            ShadowType.colorSum(4, rgba_values, rgba_value_counts, rgba_singles, rgba_single_counts, display, Display.DisplayRGBTuple, default_values);
            ShadowType.equalizeAndDefault(rgba_values, display, Display.DisplayRGBTuple, default_values);
        }
        int big_len = rgba_values[0].length;
        int i4 = 0;
        while (i4 < 4) {
            int len = rgba_values[i4].length;
            int j = 0;
            while (j < len) {
                if (rgba_values[i4][j] != rgba_values[i4][j]) {
                    int k;
                    if (range_select[0] == null) {
                        range_select[0] = new boolean[big_len];
                        k = 0;
                        while (k < big_len) {
                            range_select[0][k] = true;
                            ++k;
                        }
                    }
                    if (len > 1) {
                        range_select[0][j] = false;
                        rgba_values[i4][j] = 0.0f;
                    } else {
                        k = 0;
                        while (k < big_len) {
                            range_select[0][k] = false;
                            ++k;
                        }
                        rgba_values[i4][j] = 0.0f;
                        single_missing[i4] = true;
                    }
                }
                ++j;
            }
            ++i4;
        }
        byte[][] b = new byte[rgba_values.length][];
        int i5 = 0;
        while (i5 < rgba_values.length) {
            if (rgba_values[i5] != null) {
                int len = rgba_values[i5].length;
                b[i5] = new byte[len];
                int j = 0;
                while (j < len) {
                    int k = (int)((double)rgba_values[i5][j] * 255.0);
                    k = k < 0 ? 0 : (k > 255 ? 255 : k);
                    b[i5][j] = (byte)(k < 128 ? k : k - 256);
                    ++j;
                }
            }
            ++i5;
        }
        return b;
    }

    public static final float byteToFloat(byte b) {
        return b < 0 ? ((float)b + 256.0f) / 255.0f : (float)b / 255.0f;
    }

    public static final byte floatToByte(float f) {
        int k = (int)((double)f * 255.0);
        return (byte)(k < 0 ? 0 : (k > 255 ? -1 : (k < 128 ? k : k - 256)));
    }

    static void colorSum(int nindex, float[][] tuple_values, float[] tuple_value_counts, float[] tuple_singles, float[] tuple_single_counts, DisplayImpl display, DisplayTupleType tuple, float[] default_values) throws VisADException {
        int index = nindex - 1;
        while (index >= 0) {
            if (tuple_values[index] == null) {
                if (tuple_single_counts[index] > 0.0f) {
                    tuple_values[index] = new float[1];
                    tuple_values[index][0] = tuple_singles[index];
                    tuple_value_counts[index] = tuple_single_counts[index];
                }
            } else {
                int colorMode = (int)default_values[display.getDisplayScalarIndex(Display.ColorMode)];
                int cm = colorMode >= 0 ? colorMode : display.getGraphicsModeControl().getColorMode();
                float inv_count = cm == 1 ? 1.0f : 1.0f / (tuple_value_counts[index] + tuple_single_counts[index]);
                int j = 0;
                while (j < tuple_values[index].length) {
                    tuple_values[index][j] = inv_count * (tuple_values[index][j] + tuple_singles[index]);
                    ++j;
                }
            }
            --index;
        }
    }

    public static int getDefaultColorIndex(DisplayImpl display, int index) {
        return index == 0 ? display.getDisplayScalarIndex(Display.Red) : (index == 1 ? display.getDisplayScalarIndex(Display.Green) : (index == 2 ? display.getDisplayScalarIndex(Display.Blue) : display.getDisplayScalarIndex(Display.Alpha)));
    }

    static void equalizeAndDefault(float[][] tuple_values, DisplayImpl display, DisplayTupleType tuple, float[] default_values) throws VisADException {
        int nindex = tuple_values.length;
        int index = 0;
        while (index < nindex) {
            if (tuple_values[index] == null) {
                tuple_values[index] = new float[1];
                int default_index = index < 3 ? display.getDisplayScalarIndex((DisplayRealType)tuple.getComponent(index)) : display.getDisplayScalarIndex(Display.Alpha);
                tuple_values[index][0] = default_values[default_index];
            }
            ++index;
        }
        int len = 1;
        int index2 = 0;
        while (index2 < nindex) {
            len = Math.max(len, tuple_values[index2].length);
            ++index2;
        }
        int index3 = 0;
        while (index3 < 3) {
            int t_len = tuple_values[index3].length;
            if (len > t_len) {
                if (t_len != 1) {
                    throw new DisplayException("bad length: ShadowType.equalizeAndDefault");
                }
                float[] t = new float[len];
                float v = tuple_values[index3][0];
                int i = 0;
                while (i < len) {
                    t[i] = v;
                    ++i;
                }
                tuple_values[index3] = t;
            }
            ++index3;
        }
    }

    static void colorComposite(float[][] rgba_values, float[] rgba_value_counts, float[][] tuple_values) throws VisADException {
        int index = 0;
        while (index < 3) {
            ShadowType.singleComposite(index, rgba_values, rgba_value_counts, tuple_values[index]);
            tuple_values[index] = null;
            ++index;
        }
    }

    static void singleComposite(int index, float[][] rgba_values, float[] rgba_value_counts, float[] values) throws VisADException {
        if (values == null) {
            return;
        }
        if (rgba_values[index] == null) {
            rgba_values[index] = values;
            rgba_value_counts[index] = 1.0f;
        } else {
            int n = index;
            rgba_value_counts[n] = rgba_value_counts[n] + 1.0f;
            int rgba_len = rgba_values[index].length;
            int values_len = values.length;
            if (rgba_len == values_len) {
                int j = 0;
                while (j < rgba_len) {
                    float[] fArray = rgba_values[index];
                    int n2 = j;
                    fArray[n2] = fArray[n2] + values[j];
                    ++j;
                }
            } else if (values_len == 1) {
                int j = 0;
                while (j < rgba_len) {
                    float[] fArray = rgba_values[index];
                    int n3 = j++;
                    fArray[n3] = fArray[n3] + values[0];
                }
            } else if (rgba_len == 1) {
                int j = 0;
                while (j < rgba_len) {
                    int n4 = j++;
                    values[n4] = values[n4] + rgba_values[index][0];
                }
                rgba_values[index] = values;
            } else {
                throw new DisplayException("bad length: ShadowType.singleComposite");
            }
        }
    }

    public boolean[][] assembleSelect(float[][] display_values, int domain_length, int valueArrayLength, int[] valueToScalar, DisplayImpl display, ShadowType shadow_api) throws VisADException {
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        boolean[][] range_select = new boolean[1][];
        boolean anySelect = false;
        int i = 0;
        while (i < valueArrayLength) {
            int displayScalarIndex;
            DisplayRealType real;
            float[] values = display_values[i];
            if (values != null && (real = display.getDisplayScalar(displayScalarIndex = valueToScalar[i])).equals(Display.SelectRange)) {
                int j;
                if (range_select[0] == null) {
                    range_select[0] = new boolean[domain_length];
                    int j2 = 0;
                    while (j2 < domain_length) {
                        range_select[0][j2] = true;
                        ++j2;
                    }
                }
                RangeControl control = (RangeControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
                float[] range = control.getRange();
                if (values.length == 1) {
                    if (values[0] < range[0] || range[1] < values[0]) {
                        j = 0;
                        while (j < domain_length) {
                            range_select[0][j] = false;
                            ++j;
                        }
                        anySelect = true;
                    }
                } else {
                    j = 0;
                    while (j < values.length) {
                        if (values[j] < range[0] || range[1] < values[j]) {
                            range_select[0][j] = false;
                            anySelect = true;
                        }
                        ++j;
                    }
                }
                display_values[i] = null;
            }
            ++i;
        }
        if (range_select[0] != null && !anySelect) {
            range_select[0] = null;
        }
        return range_select;
    }

    public boolean terminalTupleOrScalar(Object group, float[][] display_values, String text_value, TextControl text_control, int valueArrayLength, int[] valueToScalar, float[] default_values, int[] inherited_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        GraphicsModeControl mode = (GraphicsModeControl)this.display.getGraphicsModeControl().clone();
        float pointSize = default_values[this.display.getDisplayScalarIndex(Display.PointSize)];
        mode.setPointSize(pointSize, true);
        float lineWidth = default_values[this.display.getDisplayScalarIndex(Display.LineWidth)];
        mode.setLineWidth(lineWidth, true);
        int lineStyle = (int)default_values[this.display.getDisplayScalarIndex(Display.LineStyle)];
        mode.setLineStyle(lineStyle, true);
        float polygonOffset = default_values[this.display.getDisplayScalarIndex(Display.PolygonOffset)];
        mode.setPolygonOffset(polygonOffset, true);
        float polygonOffsetFactor = default_values[this.display.getDisplayScalarIndex(Display.PolygonOffsetFactor)];
        mode.setPolygonOffsetFactor(polygonOffsetFactor, true);
        float[][] flow1_values = new float[3][];
        float[][] flow2_values = new float[3][];
        float[] flowScale = new float[2];
        boolean[][] range_select = new boolean[1][];
        shadow_api.assembleFlow(flow1_values, flow2_values, flowScale, display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, renderer, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        boolean[] swap = new boolean[]{false, false, false};
        int[] spatialDimensions = new int[2];
        float[][] spatial_values = new float[3][];
        shadow_api.assembleSpatial(spatial_values, display_values, valueArrayLength, valueToScalar, this.display, default_values, inherited_values, null, false, false, spatialDimensions, range_select, flow1_values, flow2_values, flowScale, swap, renderer, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        boolean[] single_missing = new boolean[]{false, false, false, false};
        byte[][] color_values = shadow_api.assembleColor(display_values, valueArrayLength, valueToScalar, this.display, default_values, range_select, single_missing, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        int LevelOfDifficulty = this.getLevelOfDifficulty();
        if (LevelOfDifficulty == 5) {
            int i;
            VisADGeometryArray array;
            Vector MapVector;
            if (single_missing[0] || single_missing[1] || single_missing[2]) {
                return false;
            }
            float[] constant_color = new float[]{ShadowType.byteToFloat(color_values[0][0]), ShadowType.byteToFloat(color_values[1][0]), ShadowType.byteToFloat(color_values[2][0])};
            float constant_alpha = Float.NaN;
            boolean anyShapeCreated = false;
            int[] valueToMap = this.display.getValueToMap();
            VisADGeometryArray[] arrays = shadow_api.assembleShape(display_values, valueArrayLength, valueToMap, MapVector = this.display.getMapVector(), valueToScalar, this.display, default_values, inherited_values, spatial_values, color_values, range_select, -1, shadow_api);
            if (arrays != null) {
                int i2 = 0;
                while (i2 < arrays.length) {
                    array = arrays[i2];
                    if (array != null) {
                        shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                    }
                    ++i2;
                }
                anyShapeCreated = true;
            }
            boolean anyTextCreated = false;
            if (text_value != null && text_control != null) {
                String[] text_values = new String[]{text_value};
                array = shadow_api.makeText(text_values, text_control, spatial_values, color_values, range_select);
                shadow_api.addTextToGroup(group, array, mode, constant_alpha, constant_color);
                anyTextCreated = true;
            }
            boolean anyFlowCreated = false;
            arrays = shadow_api.makeFlow(0, flow1_values, flowScale[0], spatial_values, color_values, range_select);
            if (arrays != null) {
                i = 0;
                while (i < arrays.length) {
                    if (arrays[i] != null) {
                        shadow_api.addToGroup(group, arrays[i], mode, constant_alpha, constant_color);
                    }
                    ++i;
                }
                anyFlowCreated = true;
            }
            if ((arrays = shadow_api.makeFlow(1, flow2_values, flowScale[1], spatial_values, color_values, range_select)) != null) {
                i = 0;
                while (i < arrays.length) {
                    if (arrays[i] != null) {
                        shadow_api.addToGroup(group, arrays[i], mode, constant_alpha, constant_color);
                    }
                    ++i;
                }
                anyFlowCreated = true;
            }
            if (!(anyFlowCreated || anyTextCreated || anyShapeCreated || (array = ShadowType.makePointGeometry(spatial_values, null)) == null || array.vertexCount <= 0)) {
                shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
            }
            if (renderer.getIsDirectManipulation()) {
                renderer.setSpatialValues(spatial_values);
            }
            return false;
        }
        throw new UnimplementedException("terminal LEGAL unimplemented: ShadowType.terminalTupleOrReal");
    }

    public boolean makeContour(int valueArrayLength, int[] valueToScalar, float[][] display_values, int[] inherited_values, Vector MapVector, int[] valueToMap, int domain_length, boolean[][] range_select, int spatialManifoldDimension, Set spatial_set, byte[][] color_values, boolean indexed, Object group, GraphicsModeControl mode, boolean[] swap, float constant_alpha, float[] constant_color, ShadowType shadow_api) throws VisADException {
        int i;
        boolean anyContourCreated = false;
        DataRenderer renderer = this.getLink().getRenderer();
        double[] matrix = this.p_cntrl.getMatrix();
        double scale = Double.NaN;
        MouseBehavior mouse = this.display.getMouseBehavior();
        if (mouse != null) {
            double[] rot_a = new double[3];
            double[] trans_a = new double[3];
            double[] scale_a = new double[1];
            mouse.instance_unmake_matrix(rot_a, scale_a, trans_a, matrix);
            scale = scale_a[0];
        }
        boolean isLinearContour3D = this.getIsLinearContour3D() && spatial_set instanceof Linear3DSet;
        ScalarMap[] spatial_maps = new ScalarMap[]{null, null, null};
        int[] permute = new int[]{-1, -1, -1};
        if (isLinearContour3D) {
            RealType[] reals = ((SetType)spatial_set.getType()).getDomain().getRealComponents();
            i = 0;
            while (i < valueArrayLength) {
                ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                ScalarType sc = map.getScalar();
                RealType real = sc instanceof RealType ? (RealType)sc : null;
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType tuple = dreal.getTuple();
                if (tuple != null && tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                    int tuple_index = dreal.getTupleIndex();
                    int j = 0;
                    while (j < reals.length) {
                        if (real.equals(reals[j])) {
                            permute[j] = tuple_index;
                            spatial_maps[j] = map;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Object arrays = null;
        i = 0;
        while (i < valueArrayLength) {
            int displayScalarIndex = valueToScalar[i];
            DisplayRealType real = this.display.getDisplayScalar(displayScalarIndex);
            if (real.equals(Display.IsoContour) && display_values[i] != null && display_values[i].length == domain_length && inherited_values[i] == 0) {
                ContourControl control;
                VisADGeometryArray array = null;
                this.c_cntrl = control = (ContourControl)((ScalarMap)MapVector.elementAt(valueToMap[i])).getControl();
                boolean[] bvalues = new boolean[2];
                float[] fvalues = new float[5];
                control.getMainContours(bvalues, fvalues);
                double init_scale = ContourControl.getInitScale();
                if (scale != scale) {
                    scale = init_scale;
                }
                double scale_ratio = scale / init_scale;
                double label_size = control.getLabelSize();
                if (spatialManifoldDimension == 3 || spatialManifoldDimension == 2) {
                    anyContourCreated = true;
                }
                if (bvalues[0]) {
                    if (range_select[0] != null) {
                        int len = range_select[0].length;
                        if (len == 1 || display_values[i].length == 1) break;
                        int dlen = display_values[i].length;
                        float[] temp = display_values[i];
                        display_values[i] = new float[dlen];
                        System.arraycopy(temp, 0, display_values[i], 0, dlen);
                        int j = 0;
                        while (j < len) {
                            if (!range_select[0][j]) {
                                display_values[i][j] = Float.NaN;
                            }
                            ++j;
                        }
                    }
                    if (spatialManifoldDimension == 3) {
                        if (fvalues[0] == fvalues[0] && spatial_set != null) {
                            array = isLinearContour3D ? ((Linear3DSet)spatial_set).makeLinearIsoSurface(fvalues[0], display_values[i], color_values, indexed, spatial_maps, permute) : spatial_set.makeIsoSurface(fvalues[0], display_values[i], color_values, indexed);
                            if (array != null) {
                                try {
                                    array = array.adjustLongitude(renderer);
                                    array = array.adjustSeam(renderer);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            shadow_api.addToGroup(group, array, mode, constant_alpha, constant_color);
                            array = null;
                        }
                    } else if (spatialManifoldDimension == 2 && spatial_set != null) {
                        float[][][] f_array;
                        VisADGeometryArray[][] array_s;
                        control.setAutoScaleLabels(true);
                        float[] lowhibase = new float[3];
                        boolean[] dashes = new boolean[]{false};
                        float[] levs = control.getLevels(lowhibase, dashes);
                        boolean fill = control.contourFilled();
                        ScalarMap[] smap = new ScalarMap[1];
                        if (fill) {
                            ScalarType sc = ((ScalarMap)MapVector.elementAt(valueToMap[i])).getScalar();
                            int kk = 0;
                            while (kk < MapVector.size()) {
                                ScalarMap sm = (ScalarMap)MapVector.elementAt(kk);
                                if (sm != null && sm.getScalar().equals(sc) && (sm.getDisplayScalar().equals(Display.RGB) || sm.getDisplayScalar().equals(Display.RGBA))) {
                                    smap[0] = sm;
                                }
                                ++kk;
                            }
                            if (smap[0] == null) {
                                throw new DisplayException("IsoContour color-fill is enabled, so " + sc + " must also be mapped to Display.RGB");
                            }
                        }
                        if ((array_s = spatial_set.makeIsoLines(levs, lowhibase[0], lowhibase[1], lowhibase[2], display_values[i], color_values, swap, dashes[0], fill, smap, scale_ratio, label_size, f_array = new float[1][][])) != null) {
                            if (!fill) {
                                int j = 0;
                                while (j < 2) {
                                    if (array_s[j][0] != null) {
                                        try {
                                            array_s[j][0] = ((VisADLineArray)array_s[j][0]).adjustLongitude(renderer);
                                            array_s[j][0] = ((VisADLineArray)array_s[j][0]).adjustSeam(renderer);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    ++j;
                                }
                                if (array_s.length > 2 && array_s[2] != null) {
                                    int k = 0;
                                    while (k < array_s[2].length / 2) {
                                        try {
                                            array_s[2][k * 2] = array_s[2][k * 2].adjustLongitude(renderer);
                                            array_s[2][k * 2] = array_s[2][k * 2].adjustSeam(renderer);
                                            array_s[2][k * 2 + 1] = array_s[2][k * 2 + 1].adjustLongitude(renderer);
                                            array_s[2][k * 2 + 1] = array_s[2][k * 2 + 1].adjustSeam(renderer);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        ++k;
                                    }
                                }
                                if (array_s.length > 3 && array_s[3] != null) {
                                    int k = 0;
                                    while (k < array_s[3].length / 4) {
                                        try {
                                            array_s[3][k * 4] = array_s[3][k * 4].adjustLongitude(renderer);
                                            array_s[3][k * 4] = array_s[3][k * 4].adjustSeam(renderer);
                                            array_s[3][k * 4 + 1] = array_s[3][k * 4 + 1].adjustLongitude(renderer);
                                            array_s[3][k * 4 + 1] = array_s[3][k * 4 + 1].adjustSeam(renderer);
                                            array_s[3][k * 4 + 2] = array_s[3][k * 4 + 2].adjustLongitude(renderer);
                                            array_s[3][k * 4 + 2] = array_s[3][k * 4 + 2].adjustSeam(renderer);
                                            array_s[3][k * 4 + 3] = array_s[3][k * 4 + 3].adjustLongitude(renderer);
                                            array_s[3][k * 4 + 3] = array_s[3][k * 4 + 3].adjustSeam(renderer);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        ++k;
                                    }
                                }
                            }
                            if (array_s.length > 0 && array_s[0][0] != null && array_s[0][0].vertexCount > 0) {
                                shadow_api.addToGroup(group, array_s[0][0], mode, constant_alpha, constant_color);
                                array_s[0][0] = null;
                                if (!fill) {
                                    if (bvalues[1] && array_s[2] != null) {
                                        shadow_api.addLabelsToGroup(group, array_s, mode, control, this.p_cntrl, this.cnt, constant_alpha, constant_color, f_array);
                                        array_s[2] = null;
                                    } else if (!bvalues[1] && array_s[1] != null) {
                                        array = array_s[1][0];
                                        shadow_api.addToGroup(group, array_s[1][0], mode, constant_alpha, constant_color);
                                        array_s[1][0] = null;
                                    }
                                }
                                array_s = null;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return anyContourCreated;
    }

    public int textureWidth(int data_width) {
        return data_width;
    }

    public int textureHeight(int data_height) {
        return data_height;
    }

    public int textureDepth(int data_depth) {
        return data_depth;
    }

    public void adjustZ(float[] coordinates) {
    }

    public void setTexCoords(float[] texCoords, float ratiow, float ratioh) {
    }

    public float[] setTex3DCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        return null;
    }

    public float[] setTexStackCoords(int length, int axis, float ratiow, float ratioh, float ratiod) {
        return null;
    }

    public Vector getTextMaps(int i, int[] textIndices) {
        return new Vector();
    }

    public boolean addToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        return false;
    }

    public void addLabelsToGroup(Object group, VisADGeometryArray[][] arrays, GraphicsModeControl mode, ContourControl control, ProjectionControl p_cntrl, int[] cnt, float constant_alpha, float[] contstant_color, float[][][] f_array) throws VisADException {
    }

    public boolean addTextToGroup(Object group, VisADGeometryArray array, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        return this.addToGroup(group, array, mode, constant_alpha, constant_color);
    }

    public void textureToGroup(Object group, VisADGeometryArray array, BufferedImage image, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height) throws VisADException {
    }

    public void texture3DToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] images, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
    }

    public void textureStackToGroup(Object group, VisADGeometryArray arrayX, VisADGeometryArray arrayY, VisADGeometryArray arrayZ, VisADGeometryArray arrayXrev, VisADGeometryArray arrayYrev, VisADGeometryArray arrayZrev, BufferedImage[] imagesX, BufferedImage[] imagesY, BufferedImage[] imagesZ, GraphicsModeControl mode, float constant_alpha, float[] constant_color, int texture_width, int texture_height, int texture_depth, DataRenderer renderer) throws VisADException {
    }

    public Object makeSwitch() {
        return null;
    }

    public Object makeBranch() {
        return null;
    }

    public void addToGroup(Object group, Object branch) throws VisADException {
    }

    public void addToSwitch(Object swit, Object branch) throws VisADException {
    }

    public void addSwitch(Object group, Object swit, Control control, Set domain_set, DataRenderer renderer) throws VisADException {
    }

    public boolean recurseRange(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return false;
    }

    public boolean recurseComponent(int i, Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        return false;
    }

    public boolean wantIndexed() {
        return false;
    }

    public TextControl getParentTextControl() {
        return null;
    }

    public String getParentText() {
        return null;
    }

    public void setText(String text, TextControl control) {
    }

    public boolean allowCurvedTexture() {
        return true;
    }

    public boolean allowConstantColorSurfaces() {
        return true;
    }

    public boolean allowLinearContour() {
        return true;
    }

    public String toString() {
        return this.getClass() + " for \n  " + this.Type.toString();
    }
}

