/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.MathType;
import visad.ScalarMap;
import visad.ShadowScalarType;
import visad.ShadowType;
import visad.Text;
import visad.TextControl;
import visad.VisADException;

public class ShadowTextType
extends ShadowScalarType {
    public ShadowTextType(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        Vector maps;
        if (data.isMissing()) {
            return false;
        }
        if (this.LevelOfDifficulty == 6) {
            return false;
        }
        if (!(data instanceof Text)) {
            throw new DisplayException("data must be Text: ShadowTextType.doTransform");
        }
        int valueArrayLength = this.display.getValueArrayLength();
        int[] valueToScalar = this.display.getValueToScalar();
        int[] valueToMap = this.display.getValueToMap();
        Vector MapVector = this.display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = this.getInheritedValues();
        int i = 0;
        while (i < valueArrayLength) {
            if (inherited_values[i] > 0) {
                display_values[i] = new float[1];
                display_values[i][0] = value_array[i];
            }
            ++i;
        }
        boolean[][] range_select = shadow_api.assembleSelect(display_values, 1, valueArrayLength, valueToScalar, this.display, shadow_api);
        if (range_select[0] != null && !range_select[0][0]) {
            return false;
        }
        String text_value = shadow_api.getParentText();
        TextControl text_control = shadow_api.getParentTextControl();
        boolean anyText = this.getAnyText();
        if (anyText && text_value == null && !(maps = this.getSelectedMapVector()).isEmpty()) {
            text_value = ((Text)data).getValue();
            ScalarMap map = (ScalarMap)maps.firstElement();
            text_control = (TextControl)map.getControl();
        }
        if (this.getIsTerminal()) {
            return this.terminalTupleOrScalar(group, display_values, text_value, text_control, valueArrayLength, valueToScalar, default_values, inherited_values, renderer, shadow_api);
        }
        return false;
    }
}

