/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.BadMappingException;
import visad.DataDisplayLink;
import visad.DisplayTupleType;
import visad.MathType;
import visad.RealTupleType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.VisADException;

public class ShadowRealTupleType
extends ShadowTupleType {
    private ShadowRealTupleType Reference;
    private boolean allSpatial = true;
    private boolean allSpatialReference = false;
    private DisplayTupleType DisplaySpatialTuple = null;
    private boolean spatialReference = false;
    private int[] permutation;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ShadowRealTupleType(MathType t, DataDisplayLink link, ShadowType parent, ShadowType[] tcs, ShadowType adapter) throws VisADException, RemoteException {
        super(t, link, parent, tcs);
        DisplayTupleType tuple;
        int j = 0;
        while (j < this.tupleComponents.length) {
            ShadowRealType real = (ShadowRealType)this.tupleComponents[j];
            this.MappedDisplayScalar |= real.getMappedDisplayScalar();
            tuple = real.getDisplaySpatialTuple();
            int[] index = real.getDisplaySpatialTupleIndex();
            if (tuple != null) {
                if (this.DisplaySpatialTuple != null) {
                    if (!tuple.equals(this.DisplaySpatialTuple)) throw new BadMappingException("mapped to multiple spatial DisplayTupleType-s: ShadowRealTupleType");
                    int k = 0;
                    while (k < 3 && index[k] >= 0) {
                        if (this.permutation[index[k]] >= 0) {
                            this.allSpatial = false;
                        } else {
                            this.permutation[index[k]] = j;
                        }
                        ++k;
                    }
                } else {
                    this.DisplaySpatialTuple = tuple;
                    this.permutation = new int[tuple.getDimension()];
                    int i = 0;
                    while (i < tuple.getDimension()) {
                        this.permutation[i] = -1;
                        ++i;
                    }
                    int k = 0;
                    while (k < 3 && index[k] >= 0) {
                        this.permutation[index[k]] = j;
                        ++k;
                    }
                }
            } else {
                this.allSpatial = false;
            }
            ++j;
        }
        if (((RealTupleType)this.Type).getCoordinateSystem() != null) {
            RealTupleType ref = ((RealTupleType)this.Type).getCoordinateSystem().getReference();
            this.Reference = (ShadowRealTupleType)ref.buildShadowType(this.Link, adapter).getAdaptedShadowType();
            tuple = this.Reference.getDisplaySpatialTuple();
            this.DisplayIndices = ShadowType.addIndices(this.DisplayIndices, this.Reference.getDisplayIndices());
            this.ValueIndices = ShadowType.addIndices(this.ValueIndices, this.Reference.getValueIndices());
            if (tuple != null) {
                if (this.DisplaySpatialTuple != null) {
                    if (!this.DisplaySpatialTuple.equals(tuple)) {
                        throw new BadMappingException("mapped to multiple spatial DisplayTupleType-s (through CoordinateSystem.Reference): ShadowRealTupleType");
                    }
                    this.allSpatial = false;
                } else {
                    this.DisplaySpatialTuple = tuple;
                    this.spatialReference = true;
                    this.allSpatialReference = this.allSpatial = this.Reference.getAllSpatial();
                    this.permutation = this.Reference.getPermutation();
                }
            }
            this.MultipleDisplayScalar |= this.MappedDisplayScalar && this.Reference.getMappedDisplayScalar() || this.Reference.getMultipleDisplayScalar();
            this.MappedDisplayScalar |= this.Reference.getMappedDisplayScalar();
            return;
        } else {
            this.Reference = null;
        }
    }

    public int[] getPermutation() {
        int[] ii = new int[this.permutation.length];
        int i = 0;
        while (i < this.permutation.length) {
            ii[i] = this.permutation[i];
            ++i;
        }
        return ii;
    }

    public boolean getAllSpatial() {
        return this.allSpatial;
    }

    public DisplayTupleType getDisplaySpatialTuple() {
        return this.DisplaySpatialTuple;
    }

    public boolean getMappedDisplayScalar() {
        return this.MappedDisplayScalar;
    }

    public boolean getSpatialReference() {
        return this.spatialReference;
    }

    public ShadowRealTupleType getReference() {
        return this.Reference;
    }
}

