/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.SimpleSet;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class List1DDoubleSet
extends SimpleSet {
    double[] data;

    public List1DDoubleSet(double[] d, MathType type, CoordinateSystem coord_sys, Unit[] units) throws VisADException {
        super(type, coord_sys, units, null);
        if (this.DomainDimension != 1) {
            throw new SetException("List1DDoubleSet: type must be 1-D");
        }
        this.data = d;
        this.Length = d.length;
    }

    public boolean isMissing() {
        return this.data == null;
    }

    public float[][] indexToValue(int[] indices) throws VisADException {
        int length = indices.length;
        float[][] value = new float[1][length];
        int i = 0;
        while (i < length) {
            if (indices[i] < 0 || indices[i] >= this.Length) {
                int k = 0;
                while (k < this.DomainDimension) {
                    value[k][i] = Float.NaN;
                    ++k;
                }
            } else {
                value[0][i] = (float)this.data[indices[i]];
            }
            ++i;
        }
        return value;
    }

    public double[][] indexToDouble(int[] indices) throws VisADException {
        int length = indices.length;
        double[][] value = new double[1][length];
        int i = 0;
        while (i < length) {
            if (indices[i] < 0 || indices[i] >= this.Length) {
                int k = 0;
                while (k < this.DomainDimension) {
                    value[k][i] = Double.NaN;
                    ++k;
                }
            } else {
                value[0][i] = this.data[indices[i]];
            }
            ++i;
        }
        return value;
    }

    public int[] valueToIndex(float[][] values) throws VisADException {
        throw new UnimplementedException("List1DDoubleSet.valueToIndex");
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        throw new UnimplementedException("List1DDoubleSet.valueToInterpx");
    }

    public boolean equals(Object set) {
        if (!(set instanceof List1DDoubleSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        if (this.Length != ((Set)set).Length) {
            return false;
        }
        int i = 0;
        while (i < this.Length) {
            if (Double.doubleToLongBits(this.data[i]) != Double.doubleToLongBits(((List1DDoubleSet)set).data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.Length;
            int i = 0;
            while (i < this.Length) {
                this.hashCode ^= new Double(this.data[i]).hashCode();
                ++i;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new List1DDoubleSet(this.data, type, this.DomainCoordinateSystem, this.SetUnits);
    }

    public String longString(String pre) {
        return pre + this.getClass().getName() + ": Dimension = 1" + " Length = " + this.data.length + "\n";
    }
}

