/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Linear1DSet
extends Gridded1DSet
implements LinearSet {
    private double First;
    private double Last;
    private double Step;
    private double Invstep;
    private boolean cacheSamples;

    public Linear1DSet(double first, double last, int length) throws VisADException {
        this((MathType)RealType.Generic, first, last, length, null, null, null);
    }

    public Linear1DSet(MathType type, double first, double last, int length) throws VisADException {
        this(type, first, last, length, null, null, null);
    }

    public Linear1DSet(MathType type, double first, double last, int length, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, first, last, length, coord_sys, units, errors, false);
    }

    public Linear1DSet(MathType type, double first, double last, int length, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, (float[][])null, length, coord_sys, units, errors);
        if (this.DomainDimension != 1) {
            throw new SetException("Linear1DSet: DomainDimension must be 1, not " + this.DomainDimension);
        }
        this.First = first;
        this.Last = last;
        this.Length = length;
        if (this.Length < 1) {
            throw new SetException("Linear1DSet: number of samples (" + this.Length + " must be greater than 0");
        }
        this.Step = this.Length < 2 ? 1.0 : (this.Last - this.First) / (double)(this.Length - 1);
        this.Invstep = 1.0 / this.Step;
        this.LowX = (float)Math.min(this.First, this.First + this.Step * (double)(this.Length - 1));
        this.HiX = (float)Math.max(this.First, this.First + this.Step * (double)(this.Length - 1));
        this.Low[0] = this.LowX;
        this.Hi[0] = this.HiX;
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
        this.cacheSamples = cache;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        float[][] values = new float[1][length];
        int i = 0;
        while (i < length) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? (float)(this.First + (double)index[i] * this.Step) : Float.NaN;
            ++i;
        }
        return values;
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        double[][] values = new double[1][length];
        int i = 0;
        while (i < length) {
            values[0][i] = 0 <= index[i] && index[i] < this.Length ? this.First + (double)index[i] * this.Step : Double.NaN;
            ++i;
        }
        return values;
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Linear1DSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double l = -0.5;
        double h = (double)this.Length - 0.5;
        int i = 0;
        while (i < length) {
            double di = 0.5 + (value[0][i] - this.First) * this.Invstep;
            index[i] = 0.0 < di && di < (double)this.Length ? (int)di : -1;
            ++i;
        }
        return index;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != 1) {
            throw new SetException("Linear1DSet.gridToValue: grid dimension should be 1, not " + grid.length);
        }
        int length = grid[0].length;
        float[][] value = new float[1][length];
        float[] value0 = value[0];
        float[] grid0 = grid[0];
        float l = -0.5f;
        float h = (float)this.Length - 0.5f;
        int i = 0;
        while (i < length) {
            float g = grid0[i];
            value0[i] = (float)(l < g && g < h ? this.First + (double)g * this.Step : Double.NaN);
            ++i;
        }
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length != 1) {
            throw new SetException("Linear1DSet.valueToGrid: value dimension should be 1, not " + value.length);
        }
        int length = value[0].length;
        float[][] grid = new float[1][length];
        float[] grid0 = grid[0];
        float[] value0 = value[0];
        float h = (float)(this.First + ((double)this.Length - 0.5) * this.Step);
        float l = (float)(this.First - 0.5 * this.Step);
        if (h < l) {
            float temp = l;
            l = h;
            h = temp;
        }
        int i = 0;
        while (i < length) {
            float v = value0[i];
            grid0[i] = (float)(l < v && v < h ? ((double)v - this.First) * this.Invstep : Double.NaN);
            ++i;
        }
        return grid;
    }

    public double getFirst() {
        return this.First;
    }

    public double getLast() {
        return this.Last;
    }

    public double getStep() {
        return this.Step;
    }

    public double getInvstep() {
        return this.Invstep;
    }

    public boolean isMissing() {
        return false;
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        double[][] samples = new double[1][this.Length];
        int i = 0;
        while (i < this.Length) {
            samples[0][i] = this.First + (double)i * this.Step;
            ++i;
        }
        return samples;
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        if (this.Samples != null) {
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        float[][] samples = this.makeSamples();
        if (this.cacheSamples) {
            this.Samples = samples;
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        return samples;
    }

    private float[][] makeSamples() throws VisADException {
        float[][] samples = new float[1][this.Length];
        int i = 0;
        while (i < this.Length) {
            samples[0][i] = (float)(this.First + (double)i * this.Step);
            ++i;
        }
        return samples;
    }

    public boolean equals(Object set) {
        boolean flag;
        if (!(set instanceof Linear1DSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            flag = this.First == ((Linear1DSet)set).getFirst() && this.Last == ((Linear1DSet)set).getLast() && this.Length == ((Linear1DSet)set).getLength();
        }
        catch (VisADException e) {
            return false;
        }
        return flag;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ new Double(this.First).hashCode() ^ new Double(this.Last).hashCode() ^ this.Length;
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int i) {
        if (i == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Invalid component index " + i);
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new Linear1DSet(type, this.First, this.Last, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.cacheSamples);
    }

    public String longString(String pre) throws VisADException {
        return pre + "Linear1DSet: Length = " + this.Length + " Range = " + this.First + " to " + this.Last + "\n";
    }
}

