/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded3DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADException;

public class Gridded3DDoubleSet
extends Gridded3DSet
implements GriddedDoubleSet {
    double[] Low = new double[3];
    double[] Hi = new double[3];
    double LowX;
    double HiX;
    double LowY;
    double HiY;
    double LowZ;
    double HiZ;
    double[][] Samples;
    private int gx = -1;
    private int gy = -1;
    private int gz = -1;

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, int lengthZ) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, lengthZ, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, lengthZ, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, lengthZ, coord_sys, units, errors, copy);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, lengthY, coord_sys, units, errors, copy);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ) throws VisADException {
        this(type, samples, lengthX, lengthY, lengthZ, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, lengthZ, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, int lengthZ, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, null, lengthX, lengthY, lengthZ, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.LengthZ = this.Lengths[2];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1 && this.Lengths[2] > 1) {
            int i = 0;
            while (i < this.Length) {
                if (this.Samples[0][i] != this.Samples[0][i]) {
                    throw new SetException("Gridded3DDoubleSet: samples values may not be missing");
                }
                ++i;
            }
            double[] t000 = new double[3];
            double[] t100 = new double[3];
            double[] t010 = new double[3];
            double[] t001 = new double[3];
            double[] t110 = new double[3];
            double[] t101 = new double[3];
            double[] t011 = new double[3];
            double[] t111 = new double[3];
            int v = 0;
            while (v < 3) {
                t000[v] = this.Samples[v][0];
                t100[v] = this.Samples[v][1];
                t010[v] = this.Samples[v][this.LengthX];
                t001[v] = this.Samples[v][this.LengthY * this.LengthX];
                t110[v] = this.Samples[v][this.LengthX + 1];
                t101[v] = this.Samples[v][this.LengthY * this.LengthX + 1];
                t011[v] = this.Samples[v][(this.LengthY + 1) * this.LengthX];
                t111[v] = this.Samples[v][(this.LengthY + 1) * this.LengthX + 1];
                ++v;
            }
            this.Pos = ((t100[1] - t000[1]) * (t101[2] - t100[2]) - (t100[2] - t000[2]) * (t101[1] - t100[1])) * (t110[0] - t100[0]) + ((t100[2] - t000[2]) * (t101[0] - t100[0]) - (t100[0] - t000[0]) * (t101[2] - t100[2])) * (t110[1] - t100[1]) + ((t100[0] - t000[0]) * (t101[1] - t100[1]) - (t100[1] - t000[1]) * (t101[0] - t100[0])) * (t110[2] - t100[2]) > 0.0;
            int k = 0;
            while (k < this.LengthZ - 1) {
                int j = 0;
                while (j < this.LengthY - 1) {
                    int i2 = 0;
                    while (i2 < this.LengthX - 1) {
                        double[] v000 = new double[3];
                        double[] v100 = new double[3];
                        double[] v010 = new double[3];
                        double[] v001 = new double[3];
                        double[] v110 = new double[3];
                        double[] v101 = new double[3];
                        double[] v011 = new double[3];
                        double[] v111 = new double[3];
                        int v2 = 0;
                        while (v2 < 3) {
                            int zadd = this.LengthY * this.LengthX;
                            int base = k * zadd + j * this.LengthX + i2;
                            v000[v2] = this.Samples[v2][base];
                            v100[v2] = this.Samples[v2][base + 1];
                            v010[v2] = this.Samples[v2][base + this.LengthX];
                            v001[v2] = this.Samples[v2][base + zadd];
                            v110[v2] = this.Samples[v2][base + this.LengthX + 1];
                            v101[v2] = this.Samples[v2][base + zadd + 1];
                            v011[v2] = this.Samples[v2][base + zadd + this.LengthX];
                            v111[v2] = this.Samples[v2][base + zadd + this.LengthX + 1];
                            ++v2;
                        }
                        if (((v100[1] - v000[1]) * (v101[2] - v100[2]) - (v100[2] - v000[2]) * (v101[1] - v100[1])) * (v110[0] - v100[0]) + ((v100[2] - v000[2]) * (v101[0] - v100[0]) - (v100[0] - v000[0]) * (v101[2] - v100[2])) * (v110[1] - v100[1]) + ((v100[0] - v000[0]) * (v101[1] - v100[1]) - (v100[1] - v000[1]) * (v101[0] - v100[0])) * (v110[2] - v100[2]) > 0.0 != this.Pos || ((v101[1] - v100[1]) * (v001[2] - v101[2]) - (v101[2] - v100[2]) * (v001[1] - v101[1])) * (v111[0] - v101[0]) + ((v101[2] - v100[2]) * (v001[0] - v101[0]) - (v101[0] - v100[0]) * (v001[2] - v101[2])) * (v111[1] - v101[1]) + ((v101[0] - v100[0]) * (v001[1] - v101[1]) - (v101[1] - v100[1]) * (v001[0] - v101[0])) * (v111[2] - v101[2]) > 0.0 != this.Pos || ((v001[1] - v101[1]) * (v000[2] - v001[2]) - (v001[2] - v101[2]) * (v000[1] - v001[1])) * (v011[0] - v001[0]) + ((v001[2] - v101[2]) * (v000[0] - v001[0]) - (v001[0] - v101[0]) * (v000[2] - v001[2])) * (v011[1] - v001[1]) + ((v001[0] - v101[0]) * (v000[1] - v001[1]) - (v001[1] - v101[1]) * (v000[0] - v001[0])) * (v011[2] - v001[2]) > 0.0 != this.Pos || ((v000[1] - v001[1]) * (v100[2] - v000[2]) - (v000[2] - v001[2]) * (v100[1] - v000[1])) * (v010[0] - v000[0]) + ((v000[2] - v001[2]) * (v100[0] - v000[0]) - (v000[0] - v001[0]) * (v100[2] - v000[2])) * (v010[1] - v000[1]) + ((v000[0] - v001[0]) * (v100[1] - v000[1]) - (v000[1] - v001[1]) * (v100[0] - v000[0])) * (v010[2] - v000[2]) > 0.0 != this.Pos || ((v110[1] - v111[1]) * (v010[2] - v110[2]) - (v110[2] - v111[2]) * (v010[1] - v110[1])) * (v100[0] - v110[0]) + ((v110[2] - v111[2]) * (v010[0] - v110[0]) - (v110[0] - v111[0]) * (v010[2] - v110[2])) * (v100[1] - v110[1]) + ((v110[0] - v111[0]) * (v010[1] - v110[1]) - (v110[1] - v111[1]) * (v010[0] - v110[0])) * (v100[2] - v110[2]) > 0.0 != this.Pos || ((v111[1] - v011[1]) * (v110[2] - v111[2]) - (v111[2] - v011[2]) * (v110[1] - v111[1])) * (v101[0] - v111[0]) + ((v111[2] - v011[2]) * (v110[0] - v111[0]) - (v111[0] - v011[0]) * (v110[2] - v111[2])) * (v101[1] - v111[1]) + ((v111[0] - v011[0]) * (v110[1] - v111[1]) - (v111[1] - v011[1]) * (v110[0] - v111[0])) * (v101[2] - v111[2]) > 0.0 != this.Pos || ((v011[1] - v010[1]) * (v111[2] - v011[2]) - (v011[2] - v010[2]) * (v111[1] - v011[1])) * (v001[0] - v011[0]) + ((v011[2] - v010[2]) * (v111[0] - v011[0]) - (v011[0] - v010[0]) * (v111[2] - v011[2])) * (v001[1] - v011[1]) + ((v011[0] - v010[0]) * (v111[1] - v011[1]) - (v011[1] - v010[1]) * (v111[0] - v011[0])) * (v001[2] - v011[2]) > 0.0 != this.Pos || ((v010[1] - v110[1]) * (v011[2] - v010[2]) - (v010[2] - v110[2]) * (v011[1] - v010[1])) * (v000[0] - v010[0]) + ((v010[2] - v110[2]) * (v011[0] - v010[0]) - (v010[0] - v110[0]) * (v011[2] - v010[2])) * (v000[1] - v010[1]) + ((v010[0] - v110[0]) * (v011[1] - v010[1]) - (v010[1] - v110[1]) * (v011[0] - v010[0])) * (v000[2] - v010[2]) > 0.0 != this.Pos) {
                            throw new SetException("Gridded3DDoubleSet: samples do not form a valid grid (" + i2 + "," + j + "," + k + ")");
                        }
                        ++i2;
                    }
                    ++j;
                }
                ++k;
            }
        }
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY) throws VisADException {
        this(type, samples, lengthX, lengthY, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, lengthY, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, int lengthY, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, null, lengthX, lengthY, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true);
    }

    public Gridded3DDoubleSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        super(type, null, lengthX, coord_sys, units, errors, copy);
        if (samples == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(samples, copy);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(index));
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(value));
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(grid)));
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(value)));
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        int len = weights.length;
        double[][] w = new double[len][];
        this.doubleToInterp(Set.floatToDouble(value), indices, w);
        int i = 0;
        while (i < len) {
            if (w[i] != null) {
                weights[i] = new float[w[i].length];
                int j = 0;
                while (j < w[i].length) {
                    weights[i][j] = (float)w[i][j];
                    ++j;
                }
            }
            ++i;
        }
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        return copy ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        if (this.Samples == null) {
            double[][] grid = new double[this.ManifoldDimension][length];
            int i = 0;
            while (i < length) {
                int indexZ;
                int indexY;
                int indexX;
                if (0 <= index[i] && index[i] < this.Length) {
                    indexX = index[i] % this.LengthX;
                    int k = index[i] / this.LengthX;
                    indexY = k % this.LengthY;
                    indexZ = k / this.LengthY;
                } else {
                    indexX = -1;
                    indexY = -1;
                    indexZ = -1;
                }
                grid[0][i] = indexX;
                grid[1][i] = indexY;
                grid[2][i] = indexZ;
                ++i;
            }
            return this.gridToDouble(grid);
        }
        double[][] values = new double[3][length];
        int i = 0;
        while (i < length) {
            if (0 <= index[i] && index[i] < this.Length) {
                values[0][i] = this.Samples[0][index[i]];
                values[1][i] = this.Samples[1][index[i]];
                values[2][i] = this.Samples[2][index[i]];
            } else {
                values[0][i] = Double.NaN;
                values[1][i] = Double.NaN;
                values[2][i] = Double.NaN;
            }
            ++i;
        }
        return values;
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        double[][] grid = this.doubleToGrid(value);
        double[] grid0 = grid[0];
        double[] grid1 = grid[1];
        double[] grid2 = grid[2];
        int i = 0;
        while (i < length) {
            double g0 = grid0[i];
            double g1 = grid1[i];
            double g2 = grid2[i];
            index[i] = g0 != g0 || g1 != g1 || g2 != g2 ? -1 : (int)(g0 + 0.5) + this.LengthX * ((int)(g1 + 0.5) + this.LengthY * (int)(g2 + 0.5));
            ++i;
        }
        return index;
    }

    public double[][] gridToDouble(double[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension == 3) {
            return this.gridToDouble3D(grid);
        }
        if (this.ManifoldDimension == 2) {
            return this.gridToDouble2D(grid);
        }
        throw new SetException("Gridded3DDoubleSet.gridToDouble: ManifoldDimension must be 2 or 3");
    }

    private double[][] gridToDouble2D(double[][] grid) throws VisADException {
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        double[][] value = new double[3][length];
        int i = 0;
        while (i < length) {
            double gx = grid[0][i];
            double gy = grid[1][i];
            if (gx < -0.5 || gy < -0.5 || gx > (double)this.LengthX - 0.5 || gy > (double)this.LengthY - 0.5) {
                value[2][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[0][i] = Double.NaN;
            } else if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                value[1][i] = this.Samples[1][0];
                value[2][i] = this.Samples[2][0];
            } else {
                int j;
                int igx = (int)gx;
                int igy = (int)gy;
                if (igx < 0) {
                    igx = 0;
                }
                if (igx > this.LengthX - 2) {
                    igx = this.LengthX - 2;
                }
                if (igy < 0) {
                    igy = 0;
                }
                if (igy > this.LengthY - 2) {
                    igy = this.LengthY - 2;
                }
                int[][] s = new int[][]{{this.LengthX * igy + igx, this.LengthX * (igy + 1) + igx}, {this.LengthX * igy + igx + 1, this.LengthX * (igy + 1) + igx + 1}};
                if (gx + gy - (double)igx - (double)igy - 1.0 <= 0.0) {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = this.Samples[j][s[0][0]] + (gx - (double)igx) * (this.Samples[j][s[1][0]] - this.Samples[j][s[0][0]]) + (gy - (double)igy) * (this.Samples[j][s[0][1]] - this.Samples[j][s[0][0]]);
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = this.Samples[j][s[1][1]] + ((double)(1 + igx) - gx) * (this.Samples[j][s[0][1]] - this.Samples[j][s[1][1]]) + ((double)(1 + igy) - gy) * (this.Samples[j][s[1][0]] - this.Samples[j][s[1][1]]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return value;
    }

    private double[][] gridToDouble3D(double[][] grid) throws VisADException {
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2)) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int length = Math.min(grid[0].length, grid[1].length);
        length = Math.min(length, grid[2].length);
        double[][] value = new double[3][length];
        int i = 0;
        while (i < length) {
            double gx = grid[0][i];
            double gy = grid[1][i];
            double gz = grid[2][i];
            if (gx < -0.5 || gy < -0.5 || gz < -0.5 || gx > (double)this.LengthX - 0.5 || gy > (double)this.LengthY - 0.5 || gz > (double)this.LengthZ - 0.5) {
                value[2][i] = Double.NaN;
                value[1][i] = Double.NaN;
                value[0][i] = Double.NaN;
            } else if (this.Length == 1) {
                value[0][i] = this.Samples[0][0];
                value[1][i] = this.Samples[1][0];
                value[2][i] = this.Samples[2][0];
            } else {
                int j;
                boolean test4;
                double u;
                double t;
                double s;
                boolean evencube;
                int igx = gx < 0.0 ? 0 : (gx > (double)(this.LengthX - 2) ? this.LengthX - 2 : (int)gx);
                int igy = gy < 0.0 ? 0 : (gy > (double)(this.LengthY - 2) ? this.LengthY - 2 : (int)gy);
                int igz = gz < 0.0 ? 0 : (gz > (double)(this.LengthZ - 2) ? this.LengthZ - 2 : (int)gz);
                boolean bl = evencube = (igx + igy + igz) % 2 == 0;
                if (evencube) {
                    s = gx - (double)igx;
                    t = gy - (double)igy;
                    u = gz - (double)igz;
                } else {
                    s = (double)(1 + igx) - gx;
                    t = (double)(1 + igy) - gy;
                    u = (double)(1 + igz) - gz;
                }
                int zadd = this.LengthY * this.LengthX;
                int base = igz * zadd + igy * this.LengthX + igx;
                int ai = base + zadd;
                int bi = base + zadd + 1;
                int ci = base + zadd + this.LengthX + 1;
                int di = base + zadd + this.LengthX;
                int ei = base;
                int fi = base + 1;
                int gi = base + this.LengthX + 1;
                int hi = base + this.LengthX;
                double[] A = new double[3];
                double[] B = new double[3];
                double[] C = new double[3];
                double[] D = new double[3];
                double[] E = new double[3];
                double[] F = new double[3];
                double[] G = new double[3];
                double[] H = new double[3];
                if (evencube) {
                    A[0] = this.Samples[0][ai];
                    A[1] = this.Samples[1][ai];
                    A[2] = this.Samples[2][ai];
                    B[0] = this.Samples[0][bi];
                    B[1] = this.Samples[1][bi];
                    B[2] = this.Samples[2][bi];
                    C[0] = this.Samples[0][ci];
                    C[1] = this.Samples[1][ci];
                    C[2] = this.Samples[2][ci];
                    D[0] = this.Samples[0][di];
                    D[1] = this.Samples[1][di];
                    D[2] = this.Samples[2][di];
                    E[0] = this.Samples[0][ei];
                    E[1] = this.Samples[1][ei];
                    E[2] = this.Samples[2][ei];
                    F[0] = this.Samples[0][fi];
                    F[1] = this.Samples[1][fi];
                    F[2] = this.Samples[2][fi];
                    G[0] = this.Samples[0][gi];
                    G[1] = this.Samples[1][gi];
                    G[2] = this.Samples[2][gi];
                    H[0] = this.Samples[0][hi];
                    H[1] = this.Samples[1][hi];
                    H[2] = this.Samples[2][hi];
                } else {
                    G[0] = this.Samples[0][ai];
                    G[1] = this.Samples[1][ai];
                    G[2] = this.Samples[2][ai];
                    H[0] = this.Samples[0][bi];
                    H[1] = this.Samples[1][bi];
                    H[2] = this.Samples[2][bi];
                    E[0] = this.Samples[0][ci];
                    E[1] = this.Samples[1][ci];
                    E[2] = this.Samples[2][ci];
                    F[0] = this.Samples[0][di];
                    F[1] = this.Samples[1][di];
                    F[2] = this.Samples[2][di];
                    C[0] = this.Samples[0][ei];
                    C[1] = this.Samples[1][ei];
                    C[2] = this.Samples[2][ei];
                    D[0] = this.Samples[0][fi];
                    D[1] = this.Samples[1][fi];
                    D[2] = this.Samples[2][fi];
                    A[0] = this.Samples[0][gi];
                    A[1] = this.Samples[1][gi];
                    A[2] = this.Samples[2][gi];
                    B[0] = this.Samples[0][hi];
                    B[1] = this.Samples[1][hi];
                    B[2] = this.Samples[2][hi];
                }
                boolean test1 = 1.0 - s - t - u >= 0.0;
                boolean test2 = s - t + u - 1.0 >= 0.0;
                boolean test3 = t - s + u - 1.0 >= 0.0;
                boolean bl2 = test4 = s + t - u - 1.0 >= 0.0;
                if (gx < 0.0 || gx > (double)(this.LengthX - 1) || gy < 0.0 || gy > (double)(this.LengthY - 1) || gz < 0.0 || gz > (double)(this.LengthZ - 1)) {
                    boolean LZ = false;
                    boolean LY = false;
                    boolean LX = false;
                    boolean MZ = false;
                    boolean MY = false;
                    boolean MX = false;
                    boolean OZ = false;
                    boolean OY = false;
                    boolean OX = false;
                    if (igx == 0) {
                        OX = true;
                    }
                    if (igy == 0) {
                        OY = true;
                    }
                    if (igz == 0) {
                        OZ = true;
                    }
                    if (igx == this.LengthX - 2) {
                        LX = true;
                    }
                    if (igy == this.LengthY - 2) {
                        LY = true;
                    }
                    if (igz == this.LengthZ - 2) {
                        LZ = true;
                    }
                    if (!OX && !LX) {
                        MX = true;
                    }
                    if (!OY && !LY) {
                        MY = true;
                    }
                    if (!OZ && !LZ) {
                        MZ = true;
                    }
                    test4 = false;
                    test3 = false;
                    test2 = false;
                    test1 = false;
                    if (evencube) {
                        if (!(LX || LY || LZ)) {
                            test1 = true;
                        } else if (LX && OY && MZ || MX && OY && LZ || LX && MY && LZ || LX && OY && LZ || MX && MY && LZ || LX && MY && MZ) {
                            test2 = true;
                        } else if (OX && LY && MZ || OX && MY && LZ || MX && LY && LZ || OX && LY && LZ || MX && LY && MZ) {
                            test3 = true;
                        } else if (MX && LY && OZ || LX && MY && OZ || LX && LY && MZ || LX && LY && OZ) {
                            test4 = true;
                        }
                    } else if (!(OX || OY || OZ)) {
                        test1 = true;
                    } else if (OX && MY && OZ || MX && LY && OZ || OX && LY && MZ || OX && LY && OZ || MX && MY && OZ || OX && MY && MZ) {
                        test2 = true;
                    } else if (LX && MY && OZ || MX && OY && OZ || LX && OY && MZ || LX && OY && OZ || MX && OY && MZ) {
                        test3 = true;
                    } else if (OX && OY && MZ || OX && MY && OZ || MX && OY && LZ || OX && OY && LZ) {
                        test4 = true;
                    }
                }
                if (test1) {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = E[j] + s * (F[j] - E[j]) + t * (H[j] - E[j]) + u * (A[j] - E[j]);
                        ++j;
                    }
                } else if (test2) {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = B[j] + (1.0 - s) * (A[j] - B[j]) + t * (C[j] - B[j]) + (1.0 - u) * (F[j] - B[j]);
                        ++j;
                    }
                } else if (test3) {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = D[j] + s * (C[j] - D[j]) + (1.0 - t) * (A[j] - D[j]) + (1.0 - u) * (H[j] - D[j]);
                        ++j;
                    }
                } else if (test4) {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = G[j] + (1.0 - s) * (H[j] - G[j]) + (1.0 - t) * (F[j] - G[j]) + u * (C[j] - G[j]);
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < 3) {
                        value[j][i] = (H[j] + F[j] + A[j] - C[j]) / 2.0 + s * (C[j] + F[j] - H[j] - A[j]) / 2.0 + t * (C[j] - F[j] + H[j] - A[j]) / 2.0 + u * (C[j] - F[j] - H[j] + A[j]) / 2.0;
                        ++j;
                    }
                }
            }
            ++i;
        }
        return value;
    }

    public double[][] doubleToGrid(double[][] value) throws VisADException {
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 3) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: ManifoldDimension must be 3");
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2)) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        int length = Math.min(value[0].length, value[1].length);
        length = Math.min(length, value[2].length);
        double[][] grid = new double[this.ManifoldDimension][length];
        if (this.gx < 0 || this.gx >= this.LengthX || this.gy < 0 || this.gy >= this.LengthY || this.gz < 0 || this.gz >= this.LengthZ) {
            this.gx = (this.LengthX - 1) / 2;
            this.gy = (this.LengthY - 1) / 2;
            this.gz = (this.LengthZ - 1) / 2;
        }
        int i = 0;
        while (i < length) {
            if (this.Length == 1) {
                if (Double.isNaN(value[0][i]) || Double.isNaN(value[1][i]) || Double.isNaN(value[2][i])) {
                    grid[2][i] = Double.NaN;
                    grid[1][i] = Double.NaN;
                    grid[0][i] = Double.NaN;
                } else {
                    grid[0][i] = 0.0;
                    grid[1][i] = 0.0;
                    grid[2][i] = 0.0;
                }
            } else {
                boolean offgrid = false;
                if (i != 0 && grid[0][i - 1] != grid[0][i - 1]) {
                    this.gx = (this.LengthX - 1) / 2;
                    this.gy = (this.LengthY - 1) / 2;
                    this.gz = (this.LengthZ - 1) / 2;
                }
                int tetnum = 5;
                grid[2][i] = Double.NaN;
                grid[1][i] = Double.NaN;
                grid[0][i] = Double.NaN;
                int itnum = 0;
                while (itnum < 2 * (this.LengthX + this.LengthY + this.LengthZ)) {
                    double u;
                    double t;
                    double ad2;
                    double ad1;
                    double ad0;
                    double d2;
                    double d1;
                    double d0;
                    boolean test3;
                    boolean test2;
                    boolean test1;
                    double tval3;
                    double tval2;
                    double tval1;
                    boolean evencube = (this.gx + this.gy + this.gz) % 2 == 0;
                    int zadd = this.LengthY * this.LengthX;
                    int base = this.gz * zadd + this.gy * this.LengthX + this.gx;
                    int ai = base + zadd;
                    int bi = base + zadd + 1;
                    int ci = base + zadd + this.LengthX + 1;
                    int di = base + zadd + this.LengthX;
                    int ei = base;
                    int fi = base + 1;
                    int gi = base + this.LengthX + 1;
                    int hi = base + this.LengthX;
                    double[] A = new double[3];
                    double[] B = new double[3];
                    double[] C = new double[3];
                    double[] D = new double[3];
                    double[] E = new double[3];
                    double[] F = new double[3];
                    double[] G = new double[3];
                    double[] H = new double[3];
                    if (evencube) {
                        A[0] = this.Samples[0][ai];
                        A[1] = this.Samples[1][ai];
                        A[2] = this.Samples[2][ai];
                        B[0] = this.Samples[0][bi];
                        B[1] = this.Samples[1][bi];
                        B[2] = this.Samples[2][bi];
                        C[0] = this.Samples[0][ci];
                        C[1] = this.Samples[1][ci];
                        C[2] = this.Samples[2][ci];
                        D[0] = this.Samples[0][di];
                        D[1] = this.Samples[1][di];
                        D[2] = this.Samples[2][di];
                        E[0] = this.Samples[0][ei];
                        E[1] = this.Samples[1][ei];
                        E[2] = this.Samples[2][ei];
                        F[0] = this.Samples[0][fi];
                        F[1] = this.Samples[1][fi];
                        F[2] = this.Samples[2][fi];
                        G[0] = this.Samples[0][gi];
                        G[1] = this.Samples[1][gi];
                        G[2] = this.Samples[2][gi];
                        H[0] = this.Samples[0][hi];
                        H[1] = this.Samples[1][hi];
                        H[2] = this.Samples[2][hi];
                    } else {
                        G[0] = this.Samples[0][ai];
                        G[1] = this.Samples[1][ai];
                        G[2] = this.Samples[2][ai];
                        H[0] = this.Samples[0][bi];
                        H[1] = this.Samples[1][bi];
                        H[2] = this.Samples[2][bi];
                        E[0] = this.Samples[0][ci];
                        E[1] = this.Samples[1][ci];
                        E[2] = this.Samples[2][ci];
                        F[0] = this.Samples[0][di];
                        F[1] = this.Samples[1][di];
                        F[2] = this.Samples[2][di];
                        C[0] = this.Samples[0][ei];
                        C[1] = this.Samples[1][ei];
                        C[2] = this.Samples[2][ei];
                        D[0] = this.Samples[0][fi];
                        D[1] = this.Samples[1][fi];
                        D[2] = this.Samples[2][fi];
                        A[0] = this.Samples[0][gi];
                        A[1] = this.Samples[1][gi];
                        A[2] = this.Samples[2][gi];
                        B[0] = this.Samples[0][hi];
                        B[1] = this.Samples[1][hi];
                        B[2] = this.Samples[2][hi];
                    }
                    int ogx = this.gx;
                    int ogy = this.gy;
                    int ogz = this.gz;
                    if (tetnum == 1) {
                        int updown;
                        tval1 = ((E[1] - A[1]) * (F[2] - E[2]) - (E[2] - A[2]) * (F[1] - E[1])) * (value[0][i] - E[0]) + ((E[2] - A[2]) * (F[0] - E[0]) - (E[0] - A[0]) * (F[2] - E[2])) * (value[1][i] - E[1]) + ((E[0] - A[0]) * (F[1] - E[1]) - (E[1] - A[1]) * (F[0] - E[0])) * (value[2][i] - E[2]);
                        tval2 = ((E[1] - H[1]) * (A[2] - E[2]) - (E[2] - H[2]) * (A[1] - E[1])) * (value[0][i] - E[0]) + ((E[2] - H[2]) * (A[0] - E[0]) - (E[0] - H[0]) * (A[2] - E[2])) * (value[1][i] - E[1]) + ((E[0] - H[0]) * (A[1] - E[1]) - (E[1] - H[1]) * (A[0] - E[0])) * (value[2][i] - E[2]);
                        tval3 = ((E[1] - F[1]) * (H[2] - E[2]) - (E[2] - F[2]) * (H[1] - E[1])) * (value[0][i] - E[0]) + ((E[2] - F[2]) * (H[0] - E[0]) - (E[0] - F[0]) * (H[2] - E[2])) * (value[1][i] - E[1]) + ((E[0] - F[0]) * (H[1] - E[1]) - (E[1] - F[1]) * (H[0] - E[0])) * (value[2][i] - E[2]);
                        boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                        boolean bl2 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                        test3 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos;
                        int n = updown = evencube ? -1 : 1;
                        if (!test1) {
                            this.gy += updown;
                        }
                        if (!test2) {
                            this.gx += updown;
                        }
                        if (!test3) {
                            this.gz += updown;
                        }
                        tetnum = 5;
                        if (this.gx < 0) {
                            this.gx = 0;
                        }
                        if (this.gy < 0) {
                            this.gy = 0;
                        }
                        if (this.gz < 0) {
                            this.gz = 0;
                        }
                        if (this.gx > this.LengthX - 2) {
                            this.gx = this.LengthX - 2;
                        }
                        if (this.gy > this.LengthY - 2) {
                            this.gy = this.LengthY - 2;
                        }
                        if (this.gz > this.LengthZ - 2) {
                            this.gz = this.LengthZ - 2;
                        }
                        if (!(this.gx != ogx || this.gy != ogy || this.gz != ogz || test1 && test2 && test3 || offgrid)) {
                            offgrid = true;
                        } else if (this.gx == ogx && this.gy == ogy && this.gz == ogz || offgrid) {
                            double t2;
                            double s;
                            double[] M = new double[3];
                            double[] N = new double[3];
                            double[] O = new double[3];
                            double[] P = new double[3];
                            double[] X = new double[3];
                            double[] Y = new double[3];
                            int j = 0;
                            while (j < 3) {
                                M[j] = (F[j] - E[j]) * (A[(j + 1) % 3] - E[(j + 1) % 3]) - (F[(j + 1) % 3] - E[(j + 1) % 3]) * (A[j] - E[j]);
                                N[j] = (H[j] - E[j]) * (A[(j + 1) % 3] - E[(j + 1) % 3]) - (H[(j + 1) % 3] - E[(j + 1) % 3]) * (A[j] - E[j]);
                                O[j] = (F[(j + 1) % 3] - E[(j + 1) % 3]) * (A[(j + 2) % 3] - E[(j + 2) % 3]) - (F[(j + 2) % 3] - E[(j + 2) % 3]) * (A[(j + 1) % 3] - E[(j + 1) % 3]);
                                P[j] = (H[(j + 1) % 3] - E[(j + 1) % 3]) * (A[(j + 2) % 3] - E[(j + 2) % 3]) - (H[(j + 2) % 3] - E[(j + 2) % 3]) * (A[(j + 1) % 3] - E[(j + 1) % 3]);
                                X[j] = value[(j + 2) % 3][i] * (A[(j + 1) % 3] - E[(j + 1) % 3]) - value[(j + 1) % 3][i] * (A[(j + 2) % 3] - E[(j + 2) % 3]) + E[(j + 1) % 3] * A[(j + 2) % 3] - E[(j + 2) % 3] * A[(j + 1) % 3];
                                Y[j] = value[j][i] * (A[(j + 1) % 3] - E[(j + 1) % 3]) - value[(j + 1) % 3][i] * (A[j] - E[j]) + E[(j + 1) % 3] * A[j] - E[j] * A[(j + 1) % 3];
                                ++j;
                            }
                            double d02 = M[0] * P[0] - N[0] * O[0];
                            double d12 = M[1] * P[1] - N[1] * O[1];
                            double d22 = M[2] * P[2] - N[2] * O[2];
                            double ad02 = Math.abs(d02);
                            double ad12 = Math.abs(d12);
                            double ad22 = Math.abs(d22);
                            if (ad02 > ad12 && ad02 > ad22) {
                                s = (N[0] * X[0] + P[0] * Y[0]) / d02;
                                t2 = -(M[0] * X[0] + O[0] * Y[0]) / d02;
                            } else if (ad12 > ad22) {
                                s = (N[1] * X[1] + P[1] * Y[1]) / d12;
                                t2 = -(M[1] * X[1] + O[1] * Y[1]) / d12;
                            } else {
                                s = (N[2] * X[2] + P[2] * Y[2]) / d22;
                                t2 = -(M[2] * X[2] + O[2] * Y[2]) / d22;
                            }
                            d02 = A[0] - E[0];
                            d12 = A[1] - E[1];
                            d22 = A[2] - E[2];
                            ad02 = Math.abs(d02);
                            ad12 = Math.abs(d12);
                            ad22 = Math.abs(d22);
                            double u2 = ad02 > ad12 && ad02 > ad22 ? (value[0][i] - E[0] - s * (F[0] - E[0]) - t2 * (H[0] - E[0])) / d02 : (ad12 > ad22 ? (value[1][i] - E[1] - s * (F[1] - E[1]) - t2 * (H[1] - E[1])) / d12 : (value[2][i] - E[2] - s * (F[2] - E[2]) - t2 * (H[2] - E[2])) / d22);
                            if (evencube) {
                                grid[0][i] = (double)this.gx + s;
                                grid[1][i] = (double)this.gy + t2;
                                grid[2][i] = (double)this.gz + u2;
                                break;
                            }
                            grid[0][i] = (double)(this.gx + 1) - s;
                            grid[1][i] = (double)(this.gy + 1) - t2;
                            grid[2][i] = (double)(this.gz + 1) - u2;
                            break;
                        }
                    } else if (tetnum == 2) {
                        tval1 = ((B[1] - C[1]) * (F[2] - B[2]) - (B[2] - C[2]) * (F[1] - B[1])) * (value[0][i] - B[0]) + ((B[2] - C[2]) * (F[0] - B[0]) - (B[0] - C[0]) * (F[2] - B[2])) * (value[1][i] - B[1]) + ((B[0] - C[0]) * (F[1] - B[1]) - (B[1] - C[1]) * (F[0] - B[0])) * (value[2][i] - B[2]);
                        tval2 = ((B[1] - A[1]) * (C[2] - B[2]) - (B[2] - A[2]) * (C[1] - B[1])) * (value[0][i] - B[0]) + ((B[2] - A[2]) * (C[0] - B[0]) - (B[0] - A[0]) * (C[2] - B[2])) * (value[1][i] - B[1]) + ((B[0] - A[0]) * (C[1] - B[1]) - (B[1] - A[1]) * (C[0] - B[0])) * (value[2][i] - B[2]);
                        tval3 = ((B[1] - F[1]) * (A[2] - B[2]) - (B[2] - F[2]) * (A[1] - B[1])) * (value[0][i] - B[0]) + ((B[2] - F[2]) * (A[0] - B[0]) - (B[0] - F[0]) * (A[2] - B[2])) * (value[1][i] - B[1]) + ((B[0] - F[0]) * (A[1] - B[1]) - (B[1] - F[1]) * (A[0] - B[0])) * (value[2][i] - B[2]);
                        boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                        boolean bl3 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                        boolean bl4 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                        if (!test1 && evencube) {
                            ++this.gx;
                        }
                        if (!test1 && !evencube) {
                            --this.gx;
                        }
                        if (!test2 && evencube) {
                            ++this.gz;
                        }
                        if (!test2 && !evencube) {
                            --this.gz;
                        }
                        if (!test3 && evencube) {
                            --this.gy;
                        }
                        if (!test3 && !evencube) {
                            ++this.gy;
                        }
                        tetnum = 5;
                        if (this.gx < 0) {
                            this.gx = 0;
                        }
                        if (this.gy < 0) {
                            this.gy = 0;
                        }
                        if (this.gz < 0) {
                            this.gz = 0;
                        }
                        if (this.gx > this.LengthX - 2) {
                            this.gx = this.LengthX - 2;
                        }
                        if (this.gy > this.LengthY - 2) {
                            this.gy = this.LengthY - 2;
                        }
                        if (this.gz > this.LengthZ - 2) {
                            this.gz = this.LengthZ - 2;
                        }
                        if (!(this.gx != ogx || this.gy != ogy || this.gz != ogz || test1 && test2 && test3 || offgrid)) {
                            offgrid = true;
                        } else if (this.gx == ogx && this.gy == ogy && this.gz == ogz || offgrid) {
                            double s;
                            double[] M = new double[3];
                            double[] N = new double[3];
                            double[] O = new double[3];
                            double[] P = new double[3];
                            double[] X = new double[3];
                            double[] Y = new double[3];
                            int j = 0;
                            while (j < 3) {
                                M[j] = (A[j] - B[j]) * (F[(j + 1) % 3] - B[(j + 1) % 3]) - (A[(j + 1) % 3] - B[(j + 1) % 3]) * (F[j] - B[j]);
                                N[j] = (C[j] - B[j]) * (F[(j + 1) % 3] - B[(j + 1) % 3]) - (C[(j + 1) % 3] - B[(j + 1) % 3]) * (F[j] - B[j]);
                                O[j] = (A[(j + 1) % 3] - B[(j + 1) % 3]) * (F[(j + 2) % 3] - B[(j + 2) % 3]) - (A[(j + 2) % 3] - B[(j + 2) % 3]) * (F[(j + 1) % 3] - B[(j + 1) % 3]);
                                P[j] = (C[(j + 1) % 3] - B[(j + 1) % 3]) * (F[(j + 2) % 3] - B[(j + 2) % 3]) - (C[(j + 2) % 3] - B[(j + 2) % 3]) * (F[(j + 1) % 3] - B[(j + 1) % 3]);
                                X[j] = value[(j + 2) % 3][i] * (F[(j + 1) % 3] - B[(j + 1) % 3]) - value[(j + 1) % 3][i] * (F[(j + 2) % 3] - B[(j + 2) % 3]) + B[(j + 1) % 3] * F[(j + 2) % 3] - B[(j + 2) % 3] * F[(j + 1) % 3];
                                Y[j] = value[j][i] * (F[(j + 1) % 3] - B[(j + 1) % 3]) - value[1][i] * (F[j] - B[j]) + B[(j + 1) % 3] * F[j] - B[j] * F[(j + 1) % 3];
                                ++j;
                            }
                            d0 = M[0] * P[0] - N[0] * O[0];
                            d1 = M[1] * P[1] - N[1] * O[1];
                            d2 = M[2] * P[2] - N[2] * O[2];
                            ad0 = Math.abs(d0);
                            ad1 = Math.abs(d1);
                            ad2 = Math.abs(d2);
                            if (ad0 > ad1 && ad0 > ad2) {
                                s = 1.0 - (N[0] * X[0] + P[0] * Y[0]) / d0;
                                t = -(M[0] * X[0] + O[0] * Y[0]) / d0;
                            } else if (ad1 > ad2) {
                                s = 1.0 - (N[1] * X[1] + P[1] * Y[1]) / d1;
                                t = -(M[1] * X[1] + O[1] * Y[1]) / d1;
                            } else {
                                s = 1.0 - (N[2] * X[2] + P[2] * Y[2]) / d2;
                                t = -(M[2] * X[2] + O[2] * Y[2]) / d2;
                            }
                            d0 = F[0] - B[0];
                            d1 = F[1] - B[1];
                            d2 = F[2] - B[2];
                            ad0 = Math.abs(d0);
                            ad1 = Math.abs(d1);
                            ad2 = Math.abs(d2);
                            u = ad0 > ad1 && ad0 > ad2 ? 1.0 - (value[0][i] - B[0] - (1.0 - s) * (A[0] - B[0]) - t * (C[0] - B[0])) / d0 : (ad1 > ad2 ? 1.0 - (value[1][i] - B[1] - (1.0 - s) * (A[1] - B[1]) - t * (C[1] - B[1])) / d1 : 1.0 - (value[2][i] - B[2] - (1.0 - s) * (A[2] - B[2]) - t * (C[2] - B[2])) / d2);
                            if (evencube) {
                                grid[0][i] = (double)this.gx + s;
                                grid[1][i] = (double)this.gy + t;
                                grid[2][i] = (double)this.gz + u;
                                break;
                            }
                            grid[0][i] = (double)(this.gx + 1) - s;
                            grid[1][i] = (double)(this.gy + 1) - t;
                            grid[2][i] = (double)(this.gz + 1) - u;
                            break;
                        }
                    } else if (tetnum == 3) {
                        tval1 = ((D[1] - A[1]) * (H[2] - D[2]) - (D[2] - A[2]) * (H[1] - D[1])) * (value[0][i] - D[0]) + ((D[2] - A[2]) * (H[0] - D[0]) - (D[0] - A[0]) * (H[2] - D[2])) * (value[1][i] - D[1]) + ((D[0] - A[0]) * (H[1] - D[1]) - (D[1] - A[1]) * (H[0] - D[0])) * (value[2][i] - D[2]);
                        tval2 = ((D[1] - C[1]) * (A[2] - D[2]) - (D[2] - C[2]) * (A[1] - D[1])) * (value[0][i] - D[0]) + ((D[2] - C[2]) * (A[0] - D[0]) - (D[0] - C[0]) * (A[2] - D[2])) * (value[1][i] - D[1]) + ((D[0] - C[0]) * (A[1] - D[1]) - (D[1] - C[1]) * (A[0] - D[0])) * (value[2][i] - D[2]);
                        tval3 = ((D[1] - H[1]) * (C[2] - D[2]) - (D[2] - H[2]) * (C[1] - D[1])) * (value[0][i] - D[0]) + ((D[2] - H[2]) * (C[0] - D[0]) - (D[0] - H[0]) * (C[2] - D[2])) * (value[1][i] - D[1]) + ((D[0] - H[0]) * (C[1] - D[1]) - (D[1] - H[1]) * (C[0] - D[0])) * (value[2][i] - D[2]);
                        boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                        boolean bl5 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                        boolean bl6 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                        if (!test1 && evencube) {
                            --this.gx;
                        }
                        if (!test1 && !evencube) {
                            ++this.gx;
                        }
                        if (!test2 && evencube) {
                            ++this.gz;
                        }
                        if (!test2 && !evencube) {
                            --this.gz;
                        }
                        if (!test3 && evencube) {
                            ++this.gy;
                        }
                        if (!test3 && !evencube) {
                            --this.gy;
                        }
                        tetnum = 5;
                        if (this.gx < 0) {
                            this.gx = 0;
                        }
                        if (this.gy < 0) {
                            this.gy = 0;
                        }
                        if (this.gz < 0) {
                            this.gz = 0;
                        }
                        if (this.gx > this.LengthX - 2) {
                            this.gx = this.LengthX - 2;
                        }
                        if (this.gy > this.LengthY - 2) {
                            this.gy = this.LengthY - 2;
                        }
                        if (this.gz > this.LengthZ - 2) {
                            this.gz = this.LengthZ - 2;
                        }
                        if (!(this.gx != ogx || this.gy != ogy || this.gz != ogz || test1 && test2 && test3 || offgrid)) {
                            offgrid = true;
                        } else if (this.gx == ogx && this.gy == ogy && this.gz == ogz || offgrid) {
                            double s;
                            double[] M = new double[3];
                            double[] N = new double[3];
                            double[] O = new double[3];
                            double[] P = new double[3];
                            double[] X = new double[3];
                            double[] Y = new double[3];
                            int j = 0;
                            while (j < 3) {
                                M[j] = (C[j] - D[j]) * (H[(j + 1) % 3] - D[(j + 1) % 3]) - (C[(j + 1) % 3] - D[(j + 1) % 3]) * (H[j] - D[j]);
                                N[j] = (A[j] - D[j]) * (H[(j + 1) % 3] - D[(j + 1) % 3]) - (A[(j + 1) % 3] - D[(j + 1) % 3]) * (H[j] - D[j]);
                                O[j] = (C[(j + 1) % 3] - D[(j + 1) % 3]) * (H[(j + 2) % 3] - D[(j + 2) % 3]) - (C[(j + 2) % 3] - D[(j + 2) % 3]) * (H[(j + 1) % 3] - D[(j + 1) % 3]);
                                P[j] = (A[(j + 1) % 3] - D[(j + 1) % 3]) * (H[(j + 2) % 3] - D[(j + 2) % 3]) - (A[(j + 2) % 3] - D[(j + 2) % 3]) * (H[(j + 1) % 3] - D[(j + 1) % 3]);
                                X[j] = value[(j + 2) % 3][i] * (H[(j + 1) % 3] - D[(j + 1) % 3]) - value[(j + 1) % 3][i] * (H[(j + 2) % 3] - D[(j + 2) % 3]) + D[(j + 1) % 3] * H[(j + 2) % 3] - D[(j + 2) % 3] * H[(j + 1) % 3];
                                Y[j] = value[j][i] * (H[(j + 1) % 3] - D[(j + 1) % 3]) - value[(j + 1) % 3][i] * (H[j] - D[j]) + D[(j + 1) % 3] * H[j] - D[j] * H[(j + 1) % 3];
                                ++j;
                            }
                            d0 = M[0] * P[0] - N[0] * O[0];
                            d1 = M[1] * P[1] - N[1] * O[1];
                            d2 = M[2] * P[2] - N[2] * O[2];
                            ad0 = Math.abs(d0);
                            ad1 = Math.abs(d1);
                            ad2 = Math.abs(d2);
                            if (ad0 > ad1 && ad0 > ad2) {
                                s = (N[0] * X[0] + P[0] * Y[0]) / d0;
                                t = 1.0 + (M[0] * X[0] + O[0] * Y[0]) / d0;
                            } else if (ad1 > ad2) {
                                s = (N[1] * X[1] + P[1] * Y[1]) / d1;
                                t = 1.0 + (M[1] * X[1] + O[1] * Y[1]) / d1;
                            } else {
                                s = (N[2] * X[2] + P[2] * Y[2]) / d2;
                                t = 1.0 + (M[2] * X[2] + O[2] * Y[2]) / d2;
                            }
                            d0 = H[0] - D[0];
                            d1 = H[1] - D[1];
                            d2 = H[2] - D[2];
                            ad0 = Math.abs(d0);
                            ad1 = Math.abs(d1);
                            ad2 = Math.abs(d2);
                            u = ad0 > ad1 && ad0 > ad2 ? 1.0 - (value[0][i] - D[0] - s * (C[0] - D[0]) - (1.0 - t) * (A[0] - D[0])) / d0 : (ad1 > ad2 ? 1.0 - (value[1][i] - D[1] - s * (C[1] - D[1]) - (1.0 - t) * (A[1] - D[1])) / d1 : 1.0 - (value[2][i] - D[2] - s * (C[2] - D[2]) - (1.0 - t) * (A[2] - D[2])) / d2);
                            if (evencube) {
                                grid[0][i] = (double)this.gx + s;
                                grid[1][i] = (double)this.gy + t;
                                grid[2][i] = (double)this.gz + u;
                                break;
                            }
                            grid[0][i] = (double)(this.gx + 1) - s;
                            grid[1][i] = (double)(this.gy + 1) - t;
                            grid[2][i] = (double)(this.gz + 1) - u;
                            break;
                        }
                    } else if (tetnum == 4) {
                        tval1 = ((G[1] - C[1]) * (H[2] - G[2]) - (G[2] - C[2]) * (H[1] - G[1])) * (value[0][i] - G[0]) + ((G[2] - C[2]) * (H[0] - G[0]) - (G[0] - C[0]) * (H[2] - G[2])) * (value[1][i] - G[1]) + ((G[0] - C[0]) * (H[1] - G[1]) - (G[1] - C[1]) * (H[0] - G[0])) * (value[2][i] - G[2]);
                        tval2 = ((G[1] - F[1]) * (C[2] - G[2]) - (G[2] - F[2]) * (C[1] - G[1])) * (value[0][i] - G[0]) + ((G[2] - F[2]) * (C[0] - G[0]) - (G[0] - F[0]) * (C[2] - G[2])) * (value[1][i] - G[1]) + ((G[0] - F[0]) * (C[1] - G[1]) - (G[1] - F[1]) * (C[0] - G[0])) * (value[2][i] - G[2]);
                        tval3 = ((G[1] - H[1]) * (F[2] - G[2]) - (G[2] - H[2]) * (F[1] - G[1])) * (value[0][i] - G[0]) + ((G[2] - H[2]) * (F[0] - G[0]) - (G[0] - H[0]) * (F[2] - G[2])) * (value[1][i] - G[1]) + ((G[0] - H[0]) * (F[1] - G[1]) - (G[1] - H[1]) * (F[0] - G[0])) * (value[2][i] - G[2]);
                        boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                        boolean bl7 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                        boolean bl8 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                        if (!test1 && evencube) {
                            ++this.gy;
                        }
                        if (!test1 && !evencube) {
                            --this.gy;
                        }
                        if (!test2 && evencube) {
                            ++this.gx;
                        }
                        if (!test2 && !evencube) {
                            --this.gx;
                        }
                        if (!test3 && evencube) {
                            --this.gz;
                        }
                        if (!test3 && !evencube) {
                            ++this.gz;
                        }
                        tetnum = 5;
                        if (this.gx < 0) {
                            this.gx = 0;
                        }
                        if (this.gy < 0) {
                            this.gy = 0;
                        }
                        if (this.gz < 0) {
                            this.gz = 0;
                        }
                        if (this.gx > this.LengthX - 2) {
                            this.gx = this.LengthX - 2;
                        }
                        if (this.gy > this.LengthY - 2) {
                            this.gy = this.LengthY - 2;
                        }
                        if (this.gz > this.LengthZ - 2) {
                            this.gz = this.LengthZ - 2;
                        }
                        if (!(this.gx != ogx || this.gy != ogy || this.gz != ogz || test1 && test2 && test3 || offgrid)) {
                            offgrid = true;
                        } else if (this.gx == ogx && this.gy == ogy && this.gz == ogz || offgrid) {
                            double s;
                            double[] M = new double[3];
                            double[] N = new double[3];
                            double[] O = new double[3];
                            double[] P = new double[3];
                            double[] X = new double[3];
                            double[] Y = new double[3];
                            int j = 0;
                            while (j < 3) {
                                M[j] = (H[j] - G[j]) * (C[(j + 1) % 3] - G[(j + 1) % 3]) - (H[(j + 1) % 3] - G[(j + 1) % 3]) * (C[j] - G[j]);
                                N[j] = (F[j] - G[j]) * (C[(j + 1) % 3] - G[(j + 1) % 3]) - (F[(j + 1) % 3] - G[(j + 1) % 3]) * (C[j] - G[j]);
                                O[j] = (H[(j + 1) % 3] - G[(j + 1) % 3]) * (C[(j + 2) % 3] - G[(j + 2) % 3]) - (H[(j + 2) % 3] - G[(j + 2) % 3]) * (C[(j + 1) % 3] - G[(j + 1) % 3]);
                                P[j] = (F[(j + 1) % 3] - G[(j + 1) % 3]) * (C[(j + 2) % 3] - G[(j + 2) % 3]) - (F[(j + 2) % 3] - G[(j + 2) % 3]) * (C[(j + 1) % 3] - G[(j + 1) % 3]);
                                X[j] = value[(j + 2) % 3][i] * (C[(j + 1) % 3] - G[(j + 1) % 3]) - value[(j + 1) % 3][i] * (C[(j + 2) % 3] - G[(j + 2) % 3]) + G[(j + 1) % 3] * C[(j + 2) % 3] - G[(j + 2) % 3] * C[(j + 1) % 3];
                                Y[j] = value[j][i] * (C[(j + 1) % 3] - G[(j + 1) % 3]) - value[(j + 1) % 3][i] * (C[j] - G[j]) + G[(j + 1) % 3] * C[j] - G[j] * C[(j + 1) % 3];
                                ++j;
                            }
                            d0 = M[0] * P[0] - N[0] * O[0];
                            d1 = M[1] * P[1] - N[1] * O[1];
                            d2 = M[2] * P[2] - N[2] * O[2];
                            ad0 = Math.abs(d0);
                            ad1 = Math.abs(d1);
                            ad2 = Math.abs(d2);
                            if (ad0 > ad1 && ad0 > ad2) {
                                s = 1.0 - (N[0] * X[0] + P[0] * Y[0]) / d0;
                                t = 1.0 + (M[0] * X[0] + O[0] * Y[0]) / d0;
                            } else if (ad1 > ad2) {
                                s = 1.0 - (N[1] * X[1] + P[1] * Y[1]) / d1;
                                t = 1.0 + (M[1] * X[1] + O[1] * Y[1]) / d1;
                            } else {
                                s = 1.0 - (N[2] * X[2] + P[2] * Y[2]) / d2;
                                t = 1.0 + (M[2] * X[2] + O[2] * Y[2]) / d2;
                            }
                            d0 = C[0] - G[0];
                            d1 = C[1] - G[1];
                            d2 = C[2] - G[2];
                            ad0 = Math.abs(d0);
                            ad1 = Math.abs(d1);
                            ad2 = Math.abs(d2);
                            u = ad0 > ad1 && ad0 > ad2 ? (value[0][i] - G[0] - (1.0 - s) * (H[0] - G[0]) - (1.0 - t) * (F[0] - G[0])) / d0 : (ad1 > ad2 ? (value[1][i] - G[1] - (1.0 - s) * (H[1] - G[1]) - (1.0 - t) * (F[1] - G[1])) / d1 : (value[2][i] - G[2] - (1.0 - s) * (H[2] - G[2]) - (1.0 - t) * (F[2] - G[2])) / d2);
                            if (evencube) {
                                grid[0][i] = (double)this.gx + s;
                                grid[1][i] = (double)this.gy + t;
                                grid[2][i] = (double)this.gz + u;
                                break;
                            }
                            grid[0][i] = (double)(this.gx + 1) - s;
                            grid[1][i] = (double)(this.gy + 1) - t;
                            grid[2][i] = (double)(this.gz + 1) - u;
                            break;
                        }
                    } else {
                        boolean test4;
                        tval1 = ((F[1] - H[1]) * (A[2] - F[2]) - (F[2] - H[2]) * (A[1] - F[1])) * (value[0][i] - F[0]) + ((F[2] - H[2]) * (A[0] - F[0]) - (F[0] - H[0]) * (A[2] - F[2])) * (value[1][i] - F[1]) + ((F[0] - H[0]) * (A[1] - F[1]) - (F[1] - H[1]) * (A[0] - F[0])) * (value[2][i] - F[2]);
                        tval2 = ((C[1] - F[1]) * (A[2] - C[2]) - (C[2] - F[2]) * (A[1] - C[1])) * (value[0][i] - C[0]) + ((C[2] - F[2]) * (A[0] - C[0]) - (C[0] - F[0]) * (A[2] - C[2])) * (value[1][i] - C[1]) + ((C[0] - F[0]) * (A[1] - C[1]) - (C[1] - F[1]) * (A[0] - C[0])) * (value[2][i] - C[2]);
                        tval3 = ((C[1] - A[1]) * (H[2] - C[2]) - (C[2] - A[2]) * (H[1] - C[1])) * (value[0][i] - C[0]) + ((C[2] - A[2]) * (H[0] - C[0]) - (C[0] - A[0]) * (H[2] - C[2])) * (value[1][i] - C[1]) + ((C[0] - A[0]) * (H[1] - C[1]) - (C[1] - A[1]) * (H[0] - C[0])) * (value[2][i] - C[2]);
                        double tval4 = ((F[1] - C[1]) * (H[2] - F[2]) - (F[2] - C[2]) * (H[1] - F[1])) * (value[0][i] - F[0]) + ((F[2] - C[2]) * (H[0] - F[0]) - (F[0] - C[0]) * (H[2] - F[2])) * (value[1][i] - F[1]) + ((F[0] - C[0]) * (H[1] - F[1]) - (F[1] - C[1]) * (H[0] - F[0])) * (value[2][i] - F[2]);
                        boolean bl = tval1 == 0.0 || tval1 > 0.0 == !evencube ^ this.Pos ? true : (test1 = false);
                        boolean bl9 = tval2 == 0.0 || tval2 > 0.0 == !evencube ^ this.Pos ? true : (test2 = false);
                        boolean bl10 = tval3 == 0.0 || tval3 > 0.0 == !evencube ^ this.Pos ? true : (test3 = false);
                        boolean bl11 = tval4 == 0.0 || tval4 > 0.0 == !evencube ^ this.Pos ? true : (test4 = false);
                        if (!test1 && test2 && test3 && test4) {
                            tetnum = 1;
                        }
                        if (test1 && !test2 && test3 && test4) {
                            tetnum = 2;
                        }
                        if (test1 && test2 && !test3 && test4) {
                            tetnum = 3;
                        }
                        if (test1 && test2 && test3 && !test4) {
                            tetnum = 4;
                        }
                        if (!test1 && !test2 && evencube || !test3 && !test4 && !evencube) {
                            --this.gy;
                        }
                        if (!test1 && !test3 && evencube || !test2 && !test4 && !evencube) {
                            --this.gx;
                        }
                        if (!test1 && !test4 && evencube || !test2 && !test3 && !evencube) {
                            --this.gz;
                        }
                        if (!test2 && !test3 && evencube || !test1 && !test4 && !evencube) {
                            ++this.gz;
                        }
                        if (!test2 && !test4 && evencube || !test1 && !test3 && !evencube) {
                            ++this.gx;
                        }
                        if (!test3 && !test4 && evencube || !test1 && !test2 && !evencube) {
                            ++this.gy;
                        }
                        if (this.gx < 0) {
                            this.gx = 0;
                        }
                        if (this.gy < 0) {
                            this.gy = 0;
                        }
                        if (this.gz < 0) {
                            this.gz = 0;
                        }
                        if (this.gx > this.LengthX - 2) {
                            this.gx = this.LengthX - 2;
                        }
                        if (this.gy > this.LengthY - 2) {
                            this.gy = this.LengthY - 2;
                        }
                        if (this.gz > this.LengthZ - 2) {
                            this.gz = this.LengthZ - 2;
                        }
                        if (!((this.gx != ogx || this.gy != ogy || this.gz != ogz || test1 && test2 && test3 && test4 || tetnum != 5) && !offgrid)) {
                            offgrid = true;
                            boolean LZ = false;
                            boolean LY = false;
                            boolean LX = false;
                            boolean MZ = false;
                            boolean MY = false;
                            boolean MX = false;
                            boolean OZ = false;
                            boolean OY = false;
                            boolean OX = false;
                            if (this.gx == 0) {
                                OX = true;
                            }
                            if (this.gy == 0) {
                                OY = true;
                            }
                            if (this.gz == 0) {
                                OZ = true;
                            }
                            if (this.gx == this.LengthX - 2) {
                                LX = true;
                            }
                            if (this.gy == this.LengthY - 2) {
                                LY = true;
                            }
                            if (this.gz == this.LengthZ - 2) {
                                LZ = true;
                            }
                            if (!OX && !LX) {
                                MX = true;
                            }
                            if (!OY && !LY) {
                                MY = true;
                            }
                            if (!OZ && !LZ) {
                                MZ = true;
                            }
                            test4 = false;
                            test3 = false;
                            test2 = false;
                            test1 = false;
                            if (evencube) {
                                if (!(LX || LY || LZ)) {
                                    tetnum = 1;
                                } else if (LX && OY && MZ || MX && OY && LZ || LX && MY && LZ || LX && OY && LZ || MX && MY && LZ || LX && MY && MZ) {
                                    tetnum = 2;
                                } else if (OX && LY && MZ || OX && MY && LZ || MX && LY && LZ || OX && LY && LZ || MX && LY && MZ) {
                                    tetnum = 3;
                                } else if (MX && LY && OZ || LX && MY && OZ || LX && LY && MZ || LX && LY && OZ) {
                                    tetnum = 4;
                                }
                            } else if (!(OX || OY || OZ)) {
                                tetnum = 1;
                            } else if (OX && MY && OZ || MX && LY && OZ || OX && LY && MZ || OX && LY && OZ || MX && MY && OZ || OX && MY && MZ) {
                                tetnum = 2;
                            } else if (LX && MY && OZ || MX && OY && OZ || LX && OY && MZ || LX && OY && OZ || MX && OY && MZ) {
                                tetnum = 3;
                            } else if (OX && OY && MZ || OX && MY && OZ || MX && OY && LZ || OX && OY && LZ) {
                                tetnum = 4;
                            }
                        }
                        if (this.gx == ogx && this.gy == ogy && this.gz == ogz && tetnum == 5) {
                            double t3;
                            double s;
                            double[] Q = new double[3];
                            int j = 0;
                            while (j < 3) {
                                Q[j] = (H[j] + F[j] + A[j] - C[j]) / 2.0;
                                ++j;
                            }
                            double[] M = new double[3];
                            double[] N = new double[3];
                            double[] O = new double[3];
                            double[] P = new double[3];
                            double[] X = new double[3];
                            double[] Y = new double[3];
                            int j2 = 0;
                            while (j2 < 3) {
                                M[j2] = (F[j2] - Q[j2]) * (A[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) - (F[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) * (A[j2] - Q[j2]);
                                N[j2] = (H[j2] - Q[j2]) * (A[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) - (H[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) * (A[j2] - Q[j2]);
                                O[j2] = (F[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) * (A[(j2 + 2) % 3] - Q[(j2 + 2) % 3]) - (F[(j2 + 2) % 3] - Q[(j2 + 2) % 3]) * (A[(j2 + 1) % 3] - Q[(j2 + 1) % 3]);
                                P[j2] = (H[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) * (A[(j2 + 2) % 3] - Q[(j2 + 2) % 3]) - (H[(j2 + 2) % 3] - Q[(j2 + 2) % 3]) * (A[(j2 + 1) % 3] - Q[(j2 + 1) % 3]);
                                X[j2] = value[(j2 + 2) % 3][i] * (A[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) - value[(j2 + 1) % 3][i] * (A[(j2 + 2) % 3] - Q[(j2 + 2) % 3]) + Q[(j2 + 1) % 3] * A[(j2 + 2) % 3] - Q[(j2 + 2) % 3] * A[(j2 + 1) % 3];
                                Y[j2] = value[j2][i] * (A[(j2 + 1) % 3] - Q[(j2 + 1) % 3]) - value[(j2 + 1) % 3][i] * (A[j2] - Q[j2]) + Q[(j2 + 1) % 3] * A[j2] - Q[j2] * A[(j2 + 1) % 3];
                                ++j2;
                            }
                            double d03 = M[0] * P[0] - N[0] * O[0];
                            double d13 = M[1] * P[1] - N[1] * O[1];
                            double d23 = M[2] * P[2] - N[2] * O[2];
                            double ad03 = Math.abs(d03);
                            double ad13 = Math.abs(d13);
                            double ad23 = Math.abs(d23);
                            if (ad03 > ad13 && ad03 > ad23) {
                                s = (N[0] * X[0] + P[0] * Y[0]) / d03;
                                t3 = -(M[0] * X[0] + O[0] * Y[0]) / d03;
                            } else if (ad13 > ad23) {
                                s = (N[1] * X[1] + P[1] * Y[1]) / d13;
                                t3 = -(M[1] * X[1] + O[1] * Y[1]) / d13;
                            } else {
                                s = (N[2] * X[2] + P[2] * Y[2]) / d23;
                                t3 = -(M[2] * X[2] + O[2] * Y[2]) / d23;
                            }
                            d03 = A[0] - Q[0];
                            d13 = A[1] - Q[1];
                            d23 = A[2] - Q[2];
                            ad03 = Math.abs(d03);
                            ad13 = Math.abs(d13);
                            ad23 = Math.abs(d23);
                            double u3 = ad03 > ad13 && ad03 > ad23 ? (value[0][i] - Q[0] - s * (F[0] - Q[0]) - t3 * (H[0] - Q[0])) / d03 : (ad13 > ad23 ? (value[1][i] - Q[1] - s * (F[1] - Q[1]) - t3 * (H[1] - Q[1])) / d13 : (value[2][i] - Q[2] - s * (F[2] - Q[2]) - t3 * (H[2] - Q[2])) / d23);
                            if (evencube) {
                                grid[0][i] = (double)this.gx + s;
                                grid[1][i] = (double)this.gy + t3;
                                grid[2][i] = (double)this.gz + u3;
                                break;
                            }
                            grid[0][i] = (double)(this.gx + 1) - s;
                            grid[1][i] = (double)(this.gy + 1) - t3;
                            grid[2][i] = (double)(this.gz + 1) - u3;
                            break;
                        }
                    }
                    ++itnum;
                }
                if (grid[0][i] <= -0.5 || grid[0][i] >= (double)this.LengthX - 0.5 || grid[1][i] <= -0.5 || grid[1][i] >= (double)this.LengthY - 0.5 || grid[2][i] <= -0.5 || grid[2][i] >= (double)this.LengthZ - 0.5) {
                    grid[2][i] = Double.NaN;
                    grid[1][i] = Double.NaN;
                    grid[0][i] = Double.NaN;
                }
            }
            ++i;
        }
        return grid;
    }

    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        if (indices.length != length) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: indices length " + indices.length + " doesn't match value[0] length " + value[0].length);
        }
        if (weights.length != length) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: weights length " + weights.length + " doesn't match value[0] length " + value[0].length);
        }
        double[][] grid = this.doubleToGrid(value);
        int[] l = new int[this.ManifoldDimension];
        double[] c = new double[this.ManifoldDimension];
        int[] off = new int[this.ManifoldDimension];
        off[0] = 1;
        int j = 1;
        while (j < this.ManifoldDimension) {
            off[j] = off[j - 1] * this.Lengths[j - 1];
            ++j;
        }
        int i = 0;
        while (i < length) {
            double[] cs;
            int[] is;
            int base;
            int length_is = 1;
            if (Double.isNaN(grid[this.ManifoldDimension - 1][i])) {
                base = -1;
            } else {
                l[this.ManifoldDimension - 1] = (int)(grid[this.ManifoldDimension - 1][i] + 0.5);
                if (l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n = this.ManifoldDimension - 1;
                    l[n] = l[n] - 1;
                }
                c[this.ManifoldDimension - 1] = grid[this.ManifoldDimension - 1][i] - (double)l[this.ManifoldDimension - 1];
                if (!(l[this.ManifoldDimension - 1] == 0 && c[this.ManifoldDimension - 1] <= 0.0 || l[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && c[this.ManifoldDimension - 1] >= 0.0)) {
                    length_is *= 2;
                }
                base = l[this.ManifoldDimension - 1];
            }
            j = this.ManifoldDimension - 2;
            while (j >= 0 && base >= 0) {
                if (Double.isNaN(grid[j][i])) {
                    base = -1;
                } else {
                    l[j] = (int)(grid[j][i] + 0.5);
                    if (l[j] == this.Lengths[j]) {
                        int n = j;
                        l[n] = l[n] - 1;
                    }
                    c[j] = grid[j][i] - (double)l[j];
                    if (!(l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0)) {
                        length_is *= 2;
                    }
                    base = l[j] + this.Lengths[j] * base;
                }
                --j;
            }
            if (base < 0) {
                is = null;
                cs = null;
            } else {
                is = new int[length_is];
                cs = new double[length_is];
                is[0] = base;
                cs[0] = 1.0;
                int lis = 1;
                j = 0;
                while (j < this.ManifoldDimension) {
                    if (!(l[j] == 0 && c[j] <= 0.0 || l[j] == this.Lengths[j] - 1 && c[j] >= 0.0)) {
                        double b;
                        double a;
                        int isoff;
                        if (c[j] >= 0.0) {
                            isoff = off[j];
                            a = 1.0 - c[j];
                            b = c[j];
                        } else {
                            isoff = -off[j];
                            a = 1.0 + c[j];
                            b = -c[j];
                        }
                        int k = 0;
                        while (k < lis) {
                            is[k + lis] = is[k] + isoff;
                            cs[k + lis] = cs[k] * b;
                            int n = k++;
                            cs[n] = cs[n] * a;
                        }
                        lis *= 2;
                    }
                    ++j;
                }
            }
            indices[i] = is;
            weights[i] = cs;
            ++i;
        }
    }

    void init_doubles(double[][] samples, boolean copy) throws VisADException {
        if (samples.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.init_doubles: samples dimension " + samples.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = samples[0].length;
        } else if (this.Length != samples[0].length) {
            throw new SetException("Gridded3DDoubleSet.init_doubles: samples[0] length " + samples[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = copy ? new double[this.DomainDimension][this.Length] : samples;
        int j = 0;
        while (j < this.DomainDimension) {
            if (samples[j].length != this.Length) {
                throw new SetException("Gridded3DDoubleSet.init_doubles: samples[" + j + "] length " + samples[0].length + " doesn't match expected length " + this.Length);
            }
            double[] samplesJ = samples[j];
            double[] SamplesJ = this.Samples[j];
            if (copy) {
                System.arraycopy(samplesJ, 0, SamplesJ, 0, this.Length);
            }
            this.Low[j] = Double.POSITIVE_INFINITY;
            this.Hi[j] = Double.NEGATIVE_INFINITY;
            double sum = 0.0;
            int i = 0;
            while (i < this.Length) {
                if (SamplesJ[i] == SamplesJ[i] && !Double.isInfinite(SamplesJ[i])) {
                    if (SamplesJ[i] < this.Low[j]) {
                        this.Low[j] = SamplesJ[i];
                    }
                    if (SamplesJ[i] > this.Hi[j]) {
                        this.Hi[j] = SamplesJ[i];
                    }
                } else {
                    SamplesJ[i] = Double.NaN;
                }
                sum += SamplesJ[i];
                ++i;
            }
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), sum / (double)this.Length, this.Length, this.SetErrors[j].getUnit());
            }
            ((Gridded3DSet)this).Low[j] = (float)this.Low[j];
            ((Gridded3DSet)this).Hi[j] = (float)this.Hi[j];
            ++j;
        }
    }

    public void cram_missing(boolean[] range_select) {
        int n = Math.min(range_select.length, this.Samples[0].length);
        int i = 0;
        while (i < n) {
            if (!range_select[i]) {
                this.Samples[0][i] = Double.NaN;
            }
            ++i;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object set) {
        if (!(set instanceof Gridded3DDoubleSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((Gridded3DDoubleSet)set).getDimension() || this.ManifoldDimension != ((Gridded3DDoubleSet)set).getManifoldDimension() || this.Length != ((Gridded3DDoubleSet)set).getLength()) {
                return false;
            }
            int j = 0;
            while (j < this.ManifoldDimension) {
                if (this.Lengths[j] != ((Gridded3DDoubleSet)set).getLength(j)) {
                    return false;
                }
                ++j;
            }
            double[][] samples = ((Gridded3DDoubleSet)set).getDoubles(false);
            if (this.Samples != null && samples != null) {
                j = 0;
                while (j < this.DomainDimension) {
                    int i = 0;
                    while (i < this.Length) {
                        if (this.Samples[j][i] != samples[j][i]) {
                            this.addNotEqualsCache((Set)set);
                            return false;
                        }
                        ++i;
                    }
                    ++j;
                }
            } else {
                double[][] this_samples = this.getDoubles(false);
                if (this_samples == null) {
                    if (samples != null) {
                        return false;
                    }
                } else {
                    if (samples == null) {
                        return false;
                    }
                    j = 0;
                    while (j < this.DomainDimension) {
                        int i = 0;
                        while (i < this.Length) {
                            if (this_samples[j][i] != samples[j][i]) {
                                this.addNotEqualsCache((Set)set);
                                return false;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    public Object clone() {
        Gridded3DDoubleSet clone = (Gridded3DDoubleSet)super.clone();
        if (this.Samples != null) {
            clone.Samples = (double[][])this.Samples.clone();
            int i = 0;
            while (i < this.Samples.length) {
                clone.Samples[i] = (double[])this.Samples[i].clone();
                ++i;
            }
        }
        return clone;
    }

    public Object cloneButType(MathType type) throws VisADException {
        if (this.ManifoldDimension == 3) {
            return new Gridded3DDoubleSet(type, this.Samples, this.LengthX, this.LengthY, this.LengthZ, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        if (this.ManifoldDimension == 2) {
            return new Gridded3DDoubleSet(type, this.Samples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Gridded3DDoubleSet(type, this.Samples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }
}

