/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class EarthVectorType
extends RealVectorType {
    public EarthVectorType(RealType[] types) throws VisADException {
        this(types, null);
    }

    public EarthVectorType(RealType[] types, CoordinateSystem coord_sys) throws VisADException {
        super(types, coord_sys);
        if (types.length != 2 && types.length != 3) {
            throw new TypeException("EarthVectorType must be 2-D or 3-D: " + types.length);
        }
        int i = 0;
        while (i < types.length) {
            if (!Unit.canConvert(CommonUnit.meterPerSecond, types[i].getDefaultUnit())) {
                throw new TypeException("EarthVectorType components must be convertable with meter / second: " + types[i].getDefaultUnit());
            }
            ++i;
        }
    }

    public EarthVectorType(RealType a) throws VisADException {
        super(a);
    }

    public EarthVectorType(RealType a, RealType b) throws VisADException {
        super(a, b);
    }

    public EarthVectorType(RealType a, RealType b, RealType c) throws VisADException {
        super(a, b, c);
    }

    public EarthVectorType(RealType a, RealType b, RealType c, RealType d) throws VisADException {
        super(a, b, c, d);
    }

    public double[][] transformVectors(RealTupleType out, CoordinateSystem coord_out, Unit[] units_out, ErrorEstimate[] loc_errors_out, RealTupleType in, CoordinateSystem coord_in, Unit[] units_in, CoordinateSystem coord_vector, ErrorEstimate[] errors_in, ErrorEstimate[] errors_out, double[][] inloc, double[][] outloc, double[][] value) throws VisADException, RemoteException {
        return value;
    }
}

